/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.refactoring.classes.membersManager;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.NotNullPredicate;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyPsiFacade;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyFunctionBuilder;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import com.jetbrains.python.refactoring.classes.membersManager.MembersManager;
import com.jetbrains.python.refactoring.classes.membersManager.NamePredicate;
import com.jetbrains.python.refactoring.classes.membersManager.NamelessFilter;
import com.jetbrains.python.refactoring.classes.membersManager.PyMemberInfo;
import com.jetbrains.python.refactoring.classes.membersManager.PyRecursiveElementVisitorWithResult;
import com.jetbrains.python.refactoring.classes.membersManager.a;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MethodsManager
extends MembersManager<PyFunction> {
    private static final String[] c;
    public static final String ABC_META_PACKAGE = "abc";
    private static final NoPropertiesPredicate d;
    private static final long e;

    MethodsManager() {
        super(PyFunction.class);
    }

    @Override
    public boolean hasConflict(@NotNull PyFunction member, @NotNull PyClass aClass) {
        if (member == null) {
            MethodsManager.b(0);
        }
        if (aClass == null) {
            MethodsManager.b(1);
        }
        return NamePredicate.hasElementWithSameName((NavigationItem)member, Arrays.asList(aClass.getMethods()));
    }

    @Override
    @NotNull
    protected Collection<PyElement> getDependencies(@NotNull MultiMap<PyClass, PyElement> usedElements) {
        if (usedElements == null) {
            MethodsManager.b(2);
        }
        List<PyElement> list2 = Collections.emptyList();
        if (list2 == null) {
            MethodsManager.b(3);
        }
        return list2;
    }

    @Override
    @NotNull
    protected MultiMap<PyClass, PyElement> getDependencies(@NotNull PyElement member) {
        if (member == null) {
            MethodsManager.b(4);
        }
        MyPyRecursiveElementVisitor myPyRecursiveElementVisitor = new MyPyRecursiveElementVisitor(null);
        member.accept(myPyRecursiveElementVisitor);
        MultiMap multiMap = myPyRecursiveElementVisitor.myResult;
        if (multiMap == null) {
            MethodsManager.b(5);
        }
        return multiMap;
    }

    @Override
    @NotNull
    protected List<? extends PyElement> getMembersCouldBeMoved(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            MethodsManager.b(6);
        }
        ImmutableList immutableList = FluentIterable.from(Arrays.asList(pyClass.getMethods())).filter(new NamelessFilter()).filter((Predicate)d).toList();
        if (immutableList == null) {
            MethodsManager.b(7);
        }
        return immutableList;
    }

    @Override
    protected Collection<PyElement> moveMembers(@NotNull PyClass from, @NotNull Collection<PyMemberInfo<PyFunction>> members, PyClass ... to) {
        if (from == null) {
            MethodsManager.b(8);
        }
        if (members == null) {
            MethodsManager.b(9);
        }
        if (to == null) {
            MethodsManager.b(10);
        }
        Collection collection = MethodsManager.fetchElements(Collections2.filter(members, (Predicate)new AbstractFilter(false, null)));
        Collection<PyFunction> collection2 = MethodsManager.fetchElements(Collections2.filter(members, (Predicate)new AbstractFilter(true, null)));
        MethodsManager.a(collection2, to);
        return MethodsManager.moveMethods(from, collection, true, to);
    }

    private static void a(Collection<PyFunction> collection, PyClass ... project) {
        long l2 = e ^ 0x223A880E7F48L;
        HashSet<PsiFile> hashSet = new HashSet<PsiFile>();
        HashSet<Project> hashSet2 = new HashSet<Project>();
        for (PyFunction stubBasedPsiElement : collection) {
            for (Object object : project) {
                PyFunctionBuilder pyFunctionBuilder = PyFunctionBuilder.copySignature(stubBasedPsiElement, c);
                pyFunctionBuilder.decorate("abstractmethod");
                PyClassRefactoringUtil.addMethods((PyClass)object, false, pyFunctionBuilder.buildFunction());
                hashSet2.add((Project)object);
            }
        }
        for (PyClass pyClass : hashSet2) {
            Object object;
            Project project2 = pyClass.getProject();
            PsiFile psiFile = pyClass.getContainingFile();
            PyClass pyClass2 = PyPsiFacade.getInstance(project2).createClassByQName("abc.ABCMeta", (PsiElement)pyClass);
            object = TypeEvalContext.userInitiated(project2, psiFile);
            if (pyClass2 == null || !PyClassRefactoringUtil.addMetaClassIfNotExist(pyClass, pyClass2, (TypeEvalContext)object)) continue;
            hashSet.add(psiFile);
        }
        for (PsiFile psiFile : hashSet) {
            AddImportHelper.addOrUpdateFromImportStatement(psiFile, ABC_META_PACKAGE, "abstractmethod", null, AddImportHelper.ImportPriority.BUILTIN, null);
            PyClassRefactoringUtil.optimizeImports(psiFile);
        }
    }

    static List<PyElement> moveMethods(PyClass from, Collection<? extends PyFunction> methodsToMove, boolean skipIfExist, PyClass ... to) {
        ArrayList<PyElement> arrayList = new ArrayList<PyElement>();
        for (PyClass pyClass : to) {
            ArrayList<PyFunction> arrayList2 = new ArrayList<PyFunction>(methodsToMove.size());
            for (PyFunction pyFunction : methodsToMove) {
                PyFunction pyFunction2 = (PyFunction)pyFunction.copy();
                arrayList2.add(pyFunction2);
            }
            arrayList.addAll(PyClassRefactoringUtil.copyMethods(arrayList2, pyClass, skipIfExist));
        }
        MethodsManager.deleteElements(methodsToMove);
        return arrayList;
    }

    @Override
    @NotNull
    public PyMemberInfo<PyFunction> apply(@NotNull PyFunction pyFunction) {
        long l2 = e ^ 0x3D30FB94CD76L;
        if (pyFunction == null) {
            MethodsManager.b(11);
        }
        PyUtil.MethodFlags methodFlags = PyUtil.MethodFlags.of(pyFunction);
        assert (methodFlags != null) : "No flags return while element is function " + pyFunction;
        boolean bl2 = methodFlags.isStaticMethod() || methodFlags.isClassMethod();
        PyMemberInfo<PyFunction> pyMemberInfo = new PyMemberInfo<PyFunction>(pyFunction, bl2, MethodsManager.b(pyFunction), MethodsManager.c(pyFunction), this, MethodsManager.a(pyFunction));
        if (pyMemberInfo == null) {
            MethodsManager.b(12);
        }
        return pyMemberInfo;
    }

    private static boolean a(@NotNull PyFunction pyFunction) {
        long l2 = e ^ 0x709B443D1FDCL;
        if (pyFunction == null) {
            MethodsManager.b(13);
        }
        if (PyUtil.isInit(pyFunction)) {
            return false;
        }
        PyUtil.MethodFlags methodFlags = PyUtil.MethodFlags.of(pyFunction);
        assert (methodFlags != null) : "Function should be called on method!";
        boolean bl2 = LanguageLevel.forElement(pyFunction).isPy3K();
        return methodFlags.isInstanceMethod() || bl2;
    }

    @Nullable
    private static Boolean c(PyFunction pyFunction) {
        long l2 = e ^ 0x77411C3FF47BL;
        PyClass pyClass = PyUtil.getContainingClassOrSelf(pyFunction);
        assert (pyClass != null) : "Refactoring called on function, not method: " + pyFunction;
        for (PyClass pyClass2 : pyClass.getSuperClasses(null)) {
            PyFunction pyFunction2 = pyClass2.findMethodByName(pyFunction.getName(), true, null);
            if (pyFunction2 == null) continue;
            return true;
        }
        return null;
    }

    @NotNull
    private static String b(@NotNull PyFunction pyFunction) {
        PyParameter[] pyParameterArray;
        long l2 = e ^ 0x246756B7BF68L;
        if (pyFunction == null) {
            MethodsManager.b(14);
        }
        StringBuilder stringBuilder = new StringBuilder(pyFunction.getName());
        stringBuilder.append('(');
        for (PyParameter pyParameter : pyParameterArray = pyFunction.getParameterList().getParameters()) {
            stringBuilder.append(pyParameter.getName());
            if (pyParameterArray.length <= 1 || pyParameter == pyParameterArray[pyParameterArray.length - 1]) continue;
            stringBuilder.append(", ");
        }
        stringBuilder.append(')');
        String string = stringBuilder.toString();
        if (string == null) {
            MethodsManager.b(15);
        }
        return string;
    }

    static {
        e = com.jetbrains.python.psi.c.a(-389322313286428252L, 7198848805165164174L, MethodHandles.lookup().lookupClass()).a(103022050692849L);
        long l2 = e ^ 0x7D07003013C4L;
        c = new String[]{"property", "classmethod", "staticmethod"};
        d = new NoPropertiesPredicate(null);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x3228658C9547L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usedElements";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "members";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFunction";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getMembersCouldBeMoved";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDisplayMethodName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasConflict";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDependencies";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 15: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getMembersCouldBeMoved";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "moveMembers";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "couldBeAbstract";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildDisplayMethodName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 12: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NoPropertiesPredicate
    implements Predicate<PyFunction> {
        private static final long a = com.jetbrains.python.psi.c.a(-5472755101208041872L, -6293954400138583875L, MethodHandles.lookup().lookupClass()).a(21875541751810L);

        private NoPropertiesPredicate() {
        }

        public boolean apply(@NotNull PyFunction input) {
            if (input == null) {
                NoPropertiesPredicate.a(0);
            }
            return input.getProperty() == null;
        }

        /* synthetic */ NoPropertiesPredicate(a x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x61C584319FB8L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager$NoPropertiesPredicate", "apply"));
        }
    }

    private static class MyPyRecursiveElementVisitor
    extends PyRecursiveElementVisitorWithResult {
        private MyPyRecursiveElementVisitor() {
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyFunction pyFunction;
            PyClass pyClass;
            PsiElement psiElement;
            PsiReference psiReference;
            PyExpression pyExpression = node.getCallee();
            if (pyExpression != null && (psiReference = pyExpression.getReference()) != null && (psiElement = psiReference.resolve()) instanceof PyFunction && (pyClass = (pyFunction = (PyFunction)psiElement).getContainingClass()) != null) {
                if (PyUtil.isInit(pyFunction)) {
                    return;
                }
                this.myResult.putValue((Object)pyClass, (Object)pyFunction);
            }
        }

        /* synthetic */ MyPyRecursiveElementVisitor(a x0) {
            this();
        }
    }

    private static class AbstractFilter
    extends NotNullPredicate<PyMemberInfo<PyFunction>> {
        private final boolean a;
        private static final long c = com.jetbrains.python.psi.c.a(5981838196640040531L, 4390128118308096706L, MethodHandles.lookup().lookupClass()).a(88784192212669L);

        private AbstractFilter(boolean allowAbstractOnly) {
            this.a = allowAbstractOnly;
        }

        @Override
        protected boolean applyNotNull(@NotNull PyMemberInfo<PyFunction> input) {
            if (input == null) {
                AbstractFilter.b(0);
            }
            return input.isToAbstract() == this.a;
        }

        /* synthetic */ AbstractFilter(boolean x0, a x1) {
            this(x0);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = c ^ 0x54341C4763CDL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "com/jetbrains/python/refactoring/classes/membersManager/MethodsManager$AbstractFilter", "applyNotNull"));
        }
    }
}

