/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.base.Preconditions;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionCodeFragment;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyPassStatement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPsiUtils {
    private static final Logger a;
    private static final long b;

    private PyPsiUtils() {
    }

    @NotNull
    protected static <T extends PyElement> T[] nodesToPsi(ASTNode[] nodes, T[] array) {
        PyElement[] pyElementArray = (PyElement[])ArrayUtil.newArray((Class)ArrayUtil.getComponentType((Object[])array), (int)nodes.length);
        for (int i10 = 0; i10 < nodes.length; ++i10) {
            pyElementArray[i10] = (PyElement)nodes[i10].getPsi();
        }
        if (pyElementArray == null) {
            PyPsiUtils.a(0);
        }
        return pyElementArray;
    }

    @Nullable
    public static PsiElement getPrevComma(@NotNull PsiElement element) {
        PsiElement psiElement;
        if (element == null) {
            PyPsiUtils.a(1);
        }
        return (psiElement = PyPsiUtils.getPrevNonWhitespaceSibling(element)) != null && psiElement.getNode().getElementType() == PyTokenTypes.COMMA ? psiElement : null;
    }

    @Nullable
    public static PsiElement getPrevNonWhitespaceSibling(@Nullable PsiElement element) {
        return PsiTreeUtil.skipWhitespacesBackward((PsiElement)element);
    }

    @Nullable
    public static ASTNode getPrevNonWhitespaceSibling(@NotNull ASTNode node) {
        if (node == null) {
            PyPsiUtils.a(2);
        }
        return PyPsiUtils.skipSiblingsBackward(node, TokenSet.WHITE_SPACE);
    }

    @Nullable
    public static PsiElement getPrevNonCommentSibling(@Nullable PsiElement start2, boolean strict) {
        if (!(strict || start2 instanceof PsiWhiteSpace || start2 instanceof PsiComment)) {
            return start2;
        }
        return PsiTreeUtil.skipWhitespacesAndCommentsBackward((PsiElement)start2);
    }

    @Nullable
    public static PsiElement getNextComma(@NotNull PsiElement element) {
        PsiElement psiElement;
        if (element == null) {
            PyPsiUtils.a(3);
        }
        return (psiElement = PyPsiUtils.getNextNonWhitespaceSibling(element)) != null && psiElement.getNode().getElementType() == PyTokenTypes.COMMA ? psiElement : null;
    }

    @Nullable
    public static PsiElement getNextNonWhitespaceSibling(@Nullable PsiElement element) {
        return PsiTreeUtil.skipWhitespacesForward((PsiElement)element);
    }

    @Nullable
    public static PsiElement getNextNonWhitespaceSiblingOnSameLine(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.a(4);
        }
        for (PsiElement psiElement = element.getNextSibling(); psiElement != null; psiElement = psiElement.getNextSibling()) {
            if (!(psiElement instanceof PsiWhiteSpace)) {
                return psiElement;
            }
            if (psiElement.textContains('\n')) break;
        }
        return null;
    }

    @Nullable
    public static ASTNode getNextNonWhitespaceSibling(@NotNull ASTNode after) {
        if (after == null) {
            PyPsiUtils.a(5);
        }
        return PyPsiUtils.skipSiblingsForward(after, TokenSet.WHITE_SPACE);
    }

    @Nullable
    public static PsiElement getNextNonCommentSibling(@Nullable PsiElement start2, boolean strict) {
        if (!(strict || start2 instanceof PsiWhiteSpace || start2 instanceof PsiComment)) {
            return start2;
        }
        return PsiTreeUtil.skipWhitespacesAndCommentsForward((PsiElement)start2);
    }

    @Nullable
    public static PsiElement getNextSignificantLeaf(@Nullable PsiElement element, boolean ignoreComments) {
        while (element != null && StringUtil.isEmptyOrSpaces((String)element.getText()) || ignoreComments && element instanceof PsiComment) {
            element = PsiTreeUtil.nextLeaf((PsiElement)element);
        }
        return element;
    }

    @Nullable
    public static PsiElement getPrevSignificantLeaf(@Nullable PsiElement element, boolean ignoreComments) {
        while (element != null && StringUtil.isEmptyOrSpaces((String)element.getText()) || ignoreComments && element instanceof PsiComment) {
            element = PsiTreeUtil.prevLeaf((PsiElement)element);
        }
        return element;
    }

    @Nullable
    public static PsiElement getAdjacentComma(@NotNull PsiElement element) {
        PsiElement psiElement;
        if (element == null) {
            PyPsiUtils.a(6);
        }
        return (psiElement = PyPsiUtils.getNextComma(element)) != null ? psiElement : PyPsiUtils.getPrevComma(element);
    }

    @Nullable
    public static ASTNode skipSiblingsForward(@Nullable ASTNode node, @NotNull TokenSet types) {
        if (types == null) {
            PyPsiUtils.a(7);
        }
        if (node == null) {
            return null;
        }
        for (ASTNode aSTNode = node.getTreeNext(); aSTNode != null; aSTNode = aSTNode.getTreeNext()) {
            if (types.contains(aSTNode.getElementType())) continue;
            return aSTNode;
        }
        return null;
    }

    @Nullable
    public static ASTNode skipSiblingsBackward(@Nullable ASTNode node, @NotNull TokenSet types) {
        if (types == null) {
            PyPsiUtils.a(8);
        }
        if (node == null) {
            return null;
        }
        for (ASTNode aSTNode = node.getTreePrev(); aSTNode != null; aSTNode = aSTNode.getTreePrev()) {
            if (types.contains(aSTNode.getElementType())) continue;
            return aSTNode;
        }
        return null;
    }

    @Nullable
    public static PsiElement getFirstChildOfType(@NotNull PsiElement element, @NotNull PyElementType type) {
        ASTNode aSTNode;
        if (element == null) {
            PyPsiUtils.a(9);
        }
        if (type == null) {
            PyPsiUtils.a(10);
        }
        return (aSTNode = element.getNode().findChildByType((IElementType)type)) != null ? aSTNode.getPsi() : null;
    }

    @Nullable
    public static PsiElement getChildByFilter(@NotNull PsiElement element, @NotNull TokenSet filter, int number) {
        ASTNode aSTNode;
        if (element == null) {
            PyPsiUtils.a(11);
        }
        if (filter == null) {
            PyPsiUtils.a(12);
        }
        if ((aSTNode = element.getNode()) != null) {
            ASTNode[] aSTNodeArray = aSTNode.getChildren(filter);
            return 0 <= number && number < aSTNodeArray.length ? aSTNodeArray[number].getPsi() : null;
        }
        return null;
    }

    public static void addBeforeInParent(@NotNull PsiElement anchor, PsiElement ... newElements) {
        ASTNode aSTNode;
        if (anchor == null) {
            PyPsiUtils.a(13);
        }
        if (newElements == null) {
            PyPsiUtils.a(14);
        }
        a.assertTrue((aSTNode = anchor.getNode()) != null);
        for (PsiElement psiElement : newElements) {
            aSTNode.getTreeParent().addChild(psiElement.getNode(), aSTNode);
        }
    }

    public static void removeElements(PsiElement ... elements) {
        ASTNode aSTNode;
        if (elements == null) {
            PyPsiUtils.a(15);
        }
        a.assertTrue((aSTNode = elements[0].getParent().getNode()) != null);
        for (PsiElement psiElement : elements) {
            aSTNode.removeChild(psiElement.getNode());
        }
    }

    @Nullable
    public static PsiElement getStatement(@NotNull PsiElement element) {
        PyElement pyElement;
        if (element == null) {
            PyPsiUtils.a(16);
        }
        if ((pyElement = PyPsiUtils.getStatementList(element)) == null) {
            return null;
        }
        return PyPsiUtils.getParentRightBefore(element, (PsiElement)pyElement);
    }

    public static PyElement getStatementList(PsiElement element) {
        return element instanceof PyFile || element instanceof PyStatementList ? (PyElement)element : (PyElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyFile.class, PyStatementList.class});
    }

    @Nullable
    public static PsiElement getParentRightBefore(@NotNull PsiElement element, @NotNull PsiElement superParent) {
        if (element == null) {
            PyPsiUtils.a(17);
        }
        if (superParent == null) {
            PyPsiUtils.a(18);
        }
        return PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)false, psiElement2 -> psiElement2.getParent() == superParent);
    }

    public static int getElementIndentation(PsiElement element) {
        PyElement pyElement = PyPsiUtils.getStatementList(element);
        PsiElement psiElement = PyPsiUtils.getParentRightBefore(element, (PsiElement)pyElement);
        if (psiElement == null) {
            return 0;
        }
        PsiElement psiElement2 = psiElement.getPrevSibling();
        if (psiElement2 == null) {
            psiElement2 = pyElement.getPrevSibling();
        }
        String string = psiElement2 instanceof PsiWhiteSpace ? psiElement2.getText() : "";
        int n2 = string.lastIndexOf("\n");
        return n2 != -1 ? string.length() - n2 - 1 : 0;
    }

    public static void removeRedundantPass(PyStatementList statementList) {
        PyStatement[] pyStatementArray = statementList.getStatements();
        if (pyStatementArray.length > 1) {
            for (PyStatement pyStatement : pyStatementArray) {
                if (!(pyStatement instanceof PyPassStatement)) continue;
                pyStatement.delete();
            }
        }
    }

    public static boolean isMethodContext(PsiElement element) {
        PsiNamedElement psiNamedElement = (PsiNamedElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PyFile.class, PyFunction.class, PyClass.class});
        return psiNamedElement instanceof PyFunction && PsiTreeUtil.getParentOfType((PsiElement)psiNamedElement, (Class[])new Class[]{PyFile.class, PyClass.class}) instanceof PyClass;
    }

    @NotNull
    public static PsiElement getRealContext(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.a(19);
        }
        PyPsiUtils.assertValid(element);
        PsiFile psiFile = element.getContainingFile();
        if (psiFile instanceof PyExpressionCodeFragment) {
            PsiElement psiElement = psiFile.getContext();
            PsiElement psiElement2 = psiElement != null ? psiElement : element;
            if (psiElement2 == null) {
                PyPsiUtils.a(20);
            }
            return psiElement2;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            PyPsiUtils.a(21);
        }
        return psiElement;
    }

    public static void deleteAdjacentCommaWithWhitespaces(@NotNull PsiElement element, @NotNull PsiElement child) {
        PsiElement psiElement;
        if (element == null) {
            PyPsiUtils.a(22);
        }
        if (child == null) {
            PyPsiUtils.a(23);
        }
        if ((psiElement = PyPsiUtils.getAdjacentComma(child)) != null) {
            PsiElement psiElement2 = PyPsiUtils.getNextNonWhitespaceSibling(psiElement);
            PsiElement psiElement3 = psiElement2 == null ? element.getLastChild() : psiElement2.getPrevSibling();
            PsiElement psiElement4 = PyPsiUtils.getPrevNonWhitespaceSibling(psiElement);
            PsiElement psiElement5 = psiElement4 == null ? element.getFirstChild() : psiElement4.getNextSibling();
            element.deleteChildRange(psiElement5, psiElement3);
        }
    }

    @NotNull
    public static List<PsiComment> getPrecedingComments(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.a(24);
        }
        List<PsiComment> list2 = PyPsiUtils.getPrecedingComments(element, true);
        if (list2 == null) {
            PyPsiUtils.a(25);
        }
        return list2;
    }

    @NotNull
    public static List<PsiComment> getPrecedingComments(@NotNull PsiElement element, boolean stopAtBlankLine) {
        if (element == null) {
            PyPsiUtils.a(26);
        }
        ArrayList<PsiComment> arrayList = new ArrayList<PsiComment>();
        while (true) {
            int n2 = 0;
            element = element.getPrevSibling();
            while (element instanceof PsiWhiteSpace) {
                n2 += StringUtil.getLineBreakCount((CharSequence)element.getText());
                element = element.getPrevSibling();
            }
            if (stopAtBlankLine && n2 > 1 || !(element instanceof PsiComment)) break;
            arrayList.add((PsiComment)element);
        }
        Collections.reverse(arrayList);
        ArrayList<PsiComment> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PyPsiUtils.a(27);
        }
        return arrayList2;
    }

    @NotNull
    static <T, U extends PsiElement> List<T> collectStubChildren(@NotNull U e10, @Nullable StubElement<U> stub, final @NotNull IElementType elementType) {
        if (e10 == null) {
            PyPsiUtils.a(28);
        }
        if (elementType == null) {
            PyPsiUtils.a(29);
        }
        final ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        if (stub != null) {
            List list2 = stub.getChildrenStubs();
            for (StubElement stubElement : list2) {
                if (stubElement.getStubType() != elementType) continue;
                arrayList.add(stubElement.getPsi());
            }
        } else {
            e10.acceptChildren((PsiElementVisitor)new TopLevelVisitor(){

                @Override
                protected void checkAddElement(PsiElement node) {
                    if (node.getNode().getElementType() == elementType) {
                        arrayList.add(node);
                    }
                }
            });
        }
        ArrayList<PsiElement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PyPsiUtils.a(30);
        }
        return arrayList2;
    }

    static List<PsiElement> collectAllStubChildren(PsiElement e10, StubElement stub) {
        final ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        if (stub != null) {
            List list2 = stub.getChildrenStubs();
            for (StubElement stubElement : list2) {
                arrayList.add(stubElement.getPsi());
            }
        } else {
            e10.acceptChildren((PsiElementVisitor)new TopLevelVisitor(){

                @Override
                protected void checkAddElement(PsiElement node) {
                    arrayList.add(node);
                }
            });
        }
        return arrayList;
    }

    public static int findArgumentIndex(PyCallExpression call, PsiElement argument) {
        PyExpression[] pyExpressionArray = call.getArguments();
        for (int i10 = 0; i10 < pyExpressionArray.length; ++i10) {
            PyExpression pyExpression = pyExpressionArray[i10];
            if (pyExpression instanceof PyKeywordArgument) {
                pyExpression = ((PyKeywordArgument)pyExpression).getValueExpression();
            }
            if ((pyExpression = PyPsiUtils.flattenParens(pyExpression)) != argument) continue;
            return i10;
        }
        return -1;
    }

    @Nullable
    public static PyTargetExpression getAttribute(@NotNull PyFile file, @NotNull String name) {
        PyTargetExpression pyTargetExpression;
        if (file == null) {
            PyPsiUtils.a(31);
        }
        if (name == null) {
            PyPsiUtils.a(32);
        }
        if ((pyTargetExpression = file.findTopLevelAttribute(name)) == null) {
            for (PyFromImportStatement pyFromImportStatement : file.getFromImports()) {
                PsiElement psiElement;
                PyReferenceExpression pyReferenceExpression = pyFromImportStatement.getImportSource();
                if (pyReferenceExpression == null || !((psiElement = pyReferenceExpression.getReference().resolve()) instanceof PyFile) || psiElement == file) continue;
                return ((PyFile)psiElement).findTopLevelAttribute(name);
            }
        }
        return pyTargetExpression;
    }

    public static List<PyExpression> getAttributeValuesFromFile(@NotNull PyFile file, @NotNull String name) {
        if (file == null) {
            PyPsiUtils.a(33);
        }
        if (name == null) {
            PyPsiUtils.a(34);
        }
        ArrayList<PyExpression> arrayList = new ArrayList<PyExpression>();
        PyTargetExpression pyTargetExpression = file.findTopLevelAttribute(name);
        if (pyTargetExpression != null) {
            PyPsiUtils.sequenceToList(arrayList, pyTargetExpression.findAssignedValue());
        }
        return arrayList;
    }

    public static void sequenceToList(List<? super PyExpression> result, PyExpression value) {
        if ((value = PyPsiUtils.flattenParens(value)) instanceof PySequenceExpression) {
            result.addAll(ContainerUtil.newArrayList((Object[])((PySequenceExpression)value).getElements()));
        } else {
            result.add(value);
        }
    }

    public static List<String> getStringValues(PyExpression[] elements) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PyExpression pyExpression : elements) {
            if (!(pyExpression instanceof PyStringLiteralExpression)) continue;
            arrayList.add(((PyStringLiteralExpression)pyExpression).getStringValue());
        }
        return arrayList;
    }

    @Nullable
    public static PyExpression flattenParens(@Nullable PyExpression expr) {
        while (expr instanceof PyParenthesizedExpression) {
            expr = ((PyParenthesizedExpression)expr).getContainedExpression();
        }
        return expr;
    }

    @Nullable
    public static String strValue(@Nullable PyExpression expression) {
        return expression instanceof PyStringLiteralExpression ? ((PyStringLiteralExpression)expression).getStringValue() : null;
    }

    public static boolean isBefore(@NotNull PsiElement element, @NotNull PsiElement element2) {
        if (element == null) {
            PyPsiUtils.a(35);
        }
        if (element2 == null) {
            PyPsiUtils.a(36);
        }
        return element.getTextOffset() <= element2.getTextOffset();
    }

    @Nullable
    public static QualifiedName asQualifiedName(@Nullable PyExpression expr) {
        return expr instanceof PyQualifiedExpression ? ((PyQualifiedExpression)expr).asQualifiedName() : null;
    }

    @NotNull
    public static PyExpression getFirstQualifier(@NotNull PyQualifiedExpression expr) {
        PyExpression pyExpression;
        if (expr == null) {
            PyPsiUtils.a(37);
        }
        if ((pyExpression = expr.getQualifier()) instanceof PyQualifiedExpression) {
            PyExpression pyExpression2 = PyPsiUtils.getFirstQualifier((PyQualifiedExpression)pyExpression);
            if (pyExpression2 == null) {
                PyPsiUtils.a(38);
            }
            return pyExpression2;
        }
        PyQualifiedExpression pyQualifiedExpression = expr;
        if (pyQualifiedExpression == null) {
            PyPsiUtils.a(39);
        }
        return pyQualifiedExpression;
    }

    @NotNull
    public static String toPath(@Nullable PyQualifiedExpression expr) {
        if (expr != null) {
            QualifiedName qualifiedName = expr.asQualifiedName();
            if (qualifiedName != null) {
                String string = qualifiedName.toString();
                if (string == null) {
                    PyPsiUtils.a(40);
                }
                return string;
            }
            String string = expr.getName();
            if (string != null) {
                String string2 = string;
                if (string2 == null) {
                    PyPsiUtils.a(41);
                }
                return string2;
            }
        }
        if ("" == null) {
            PyPsiUtils.a(42);
        }
        return "";
    }

    @Nullable
    protected static QualifiedName asQualifiedName(@NotNull PyQualifiedExpression expr) {
        if (expr == null) {
            PyPsiUtils.a(43);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        String string = expr.getReferencedName();
        if (string == null) {
            return null;
        }
        linkedList.add(string);
        PyExpression pyExpression = expr.getQualifier();
        while (pyExpression != null) {
            PyReferenceExpression pyReferenceExpression = (PyReferenceExpression)ObjectUtils.tryCast((Object)pyExpression, PyReferenceExpression.class);
            if (pyReferenceExpression == null) {
                return null;
            }
            String string2 = pyReferenceExpression.getReferencedName();
            if (string2 == null) {
                return null;
            }
            linkedList.add(0, string2);
            pyExpression = pyReferenceExpression.getQualifier();
        }
        return QualifiedName.fromComponents(linkedList);
    }

    public static void assertValid(@Nullable PsiElement element) {
        if (element == null) {
            return;
        }
        PsiUtilCore.ensureValid((PsiElement)element);
    }

    public static void assertValid(@NotNull Module module2) {
        long l2 = b ^ 0x4BEE18F2054L;
        if (module2 == null) {
            PyPsiUtils.a(44);
        }
        Preconditions.checkArgument((!module2.isDisposed() ? 1 : 0) != 0, (Object)String.format("Module %s is disposed", module2));
    }

    @Nullable
    public static PsiFileSystemItem getFileSystemItem(@NotNull PsiElement element) {
        if (element == null) {
            PyPsiUtils.a(45);
        }
        if (element instanceof PsiFileSystemItem) {
            return (PsiFileSystemItem)element;
        }
        return element.getContainingFile();
    }

    @Nullable
    public static String getContainingFilePath(@NotNull PsiElement element) {
        VirtualFile virtualFile;
        if (element == null) {
            PyPsiUtils.a(46);
        }
        if ((virtualFile = element instanceof PsiFileSystemItem ? ((PsiFileSystemItem)element).getVirtualFile() : element.getContainingFile().getVirtualFile()) != null) {
            return FileUtil.toSystemDependentName((String)virtualFile.getPath());
        }
        return null;
    }

    public static boolean containsImport(@NotNull PyFile file, @NotNull String source) {
        if (file == null) {
            PyPsiUtils.a(47);
        }
        if (source == null) {
            PyPsiUtils.a(48);
        }
        QualifiedName qualifiedName = QualifiedName.fromDottedString((String)source);
        return Stream.concat(file.getFromImports().stream().map(PyFromImportStatement::getImportSourceQName), file.getImportTargets().stream().map(PyImportElement::getImportedQName)).filter(Objects::nonNull).anyMatch(qualifiedName2 -> qualifiedName2.matchesPrefix(qualifiedName));
    }

    @NotNull
    public static String getElementTextWithoutHostEscaping(@NotNull PsiElement element) {
        InjectedLanguageManager injectedLanguageManager;
        if (element == null) {
            PyPsiUtils.a(49);
        }
        if ((injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element.getProject())).isInjectedFragment(element.getContainingFile())) {
            String string = injectedLanguageManager.getUnescapedText(element);
            if (string == null) {
                PyPsiUtils.a(50);
            }
            return string;
        }
        String string = element.getText();
        if (string == null) {
            PyPsiUtils.a(51);
        }
        return string;
    }

    static {
        b = c.a(-5080526833686027767L, 5550703908523513714L, MethodHandles.lookup().lookupClass()).a(44180170900752L);
        a = Logger.getInstance((String)PyPsiUtils.class.getName());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x78EAAE0350CCL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyPsiUtils";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 9: 
            case 11: 
            case 16: 
            case 17: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 35: 
            case 45: 
            case 46: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElements";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superParent";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 31: 
            case 33: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element2";
                break;
            }
            case 37: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "nodesToPsi";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyPsiUtils";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealContext";
                break;
            }
            case 25: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrecedingComments";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "collectStubChildren";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstQualifier";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "toPath";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementTextWithoutHostEscaping";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getPrevComma";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPrevNonWhitespaceSibling";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getNextComma";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getNextNonWhitespaceSiblingOnSameLine";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNextNonWhitespaceSibling";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdjacentComma";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsForward";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "skipSiblingsBackward";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getFirstChildOfType";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getChildByFilter";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addBeforeInParent";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "removeElements";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getStatement";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getParentRightBefore";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRealContext";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "deleteAdjacentCommaWithWhitespaces";
                break;
            }
            case 24: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPrecedingComments";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "collectStubChildren";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "getAttribute";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValuesFromFile";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isBefore";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getFirstQualifier";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "asQualifiedName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "assertValid";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getFileSystemItem";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFilePath";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "containsImport";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getElementTextWithoutHostEscaping";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class TopLevelVisitor
    extends PyRecursiveElementVisitor {
        private TopLevelVisitor() {
        }

        @Override
        public void visitPyElement(PyElement node) {
            super.visitPyElement(node);
            this.checkAddElement((PsiElement)node);
        }

        @Override
        public void visitPyClass(PyClass node) {
            this.checkAddElement((PsiElement)node);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            this.checkAddElement(node);
        }

        protected abstract void checkAddElement(PsiElement var1);
    }
}

