/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.parsing.ExpressionParsing;
import com.jetbrains.python.parsing.FunctionParsing;
import com.jetbrains.python.parsing.ParsingContext;
import com.jetbrains.python.parsing.StatementParsing;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Parsing {
    protected ParsingContext myContext;
    protected PsiBuilder myBuilder;
    private static final Logger a;
    private static final long i;

    protected Parsing(ParsingContext context) {
        this.myContext = context;
        this.myBuilder = context.getBuilder();
    }

    public ParsingContext getParsingContext() {
        return this.myContext;
    }

    public ExpressionParsing getExpressionParser() {
        return this.getParsingContext().getExpressionParser();
    }

    public StatementParsing getStatementParser() {
        return this.getParsingContext().getStatementParser();
    }

    public FunctionParsing getFunctionParser() {
        return this.getParsingContext().getFunctionParser();
    }

    protected boolean checkMatches(IElementType token, @NotNull String message) {
        if (message == null) {
            Parsing.a(0);
        }
        if (this.myBuilder.getTokenType() == token) {
            this.myBuilder.advanceLexer();
            return true;
        }
        this.myBuilder.error(message);
        return false;
    }

    protected boolean parseIdentifierOrSkip(IElementType ... validSuccessiveTokens) {
        long l2 = i ^ 0x17FE10D51B90L;
        if (validSuccessiveTokens == null) {
            Parsing.a(1);
        }
        if (this.myBuilder.getTokenType() == PyTokenTypes.IDENTIFIER) {
            this.myBuilder.advanceLexer();
            return true;
        }
        PsiBuilder.Marker marker = this.myBuilder.mark();
        if (this.myBuilder.getTokenType() != PyTokenTypes.STATEMENT_BREAK && !this.atAnyOfTokens(validSuccessiveTokens)) {
            this.myBuilder.advanceLexer();
        }
        marker.error(PyBundle.message("PARSE.expected.identifier", new Object[0]));
        return false;
    }

    protected void assertCurrentToken(PyElementType tokenType) {
        a.assertTrue(this.myBuilder.getTokenType() == tokenType);
    }

    protected boolean atToken(@Nullable IElementType tokenType) {
        return this.myBuilder.getTokenType() == tokenType;
    }

    protected boolean atToken(@NotNull IElementType tokenType, @NotNull String tokenText) {
        if (tokenType == null) {
            Parsing.a(2);
        }
        if (tokenText == null) {
            Parsing.a(3);
        }
        return this.myBuilder.getTokenType() == tokenType && tokenText.equals(this.myBuilder.getTokenText());
    }

    protected boolean atAnyOfTokens(IElementType ... tokenTypes) {
        IElementType iElementType = this.myBuilder.getTokenType();
        for (IElementType iElementType2 : tokenTypes) {
            if (iElementType != iElementType2) continue;
            return true;
        }
        return false;
    }

    protected boolean matchToken(IElementType tokenType) {
        if (this.myBuilder.getTokenType() == tokenType) {
            this.myBuilder.advanceLexer();
            return true;
        }
        return false;
    }

    protected void nextToken() {
        this.myBuilder.advanceLexer();
    }

    protected void advanceAsync(boolean falseAsync) {
        long l2 = i ^ 0x3955729EF20EL;
        if (falseAsync) {
            Parsing.advanceError(this.myBuilder, "'async' keyword is not expected here");
        } else {
            this.myBuilder.advanceLexer();
        }
    }

    protected static void advanceIdentifierLike(@NotNull PsiBuilder builder) {
        long l2 = i ^ 0x17458C09501L;
        if (builder == null) {
            Parsing.a(4);
        }
        if (Parsing.a(builder)) {
            String string = builder.getTokenText();
            Parsing.advanceError(builder, "'" + string + "' keyword can't be used as identifier in Python 2");
        } else {
            builder.advanceLexer();
        }
    }

    protected static void advanceError(@NotNull PsiBuilder builder, @NotNull String message) {
        if (builder == null) {
            Parsing.a(5);
        }
        if (message == null) {
            Parsing.a(6);
        }
        PsiBuilder.Marker marker = builder.mark();
        builder.advanceLexer();
        marker.error(message);
    }

    protected static boolean isIdentifier(@NotNull PsiBuilder builder) {
        if (builder == null) {
            Parsing.a(7);
        }
        return builder.getTokenType() == PyTokenTypes.IDENTIFIER || Parsing.a(builder);
    }

    private static boolean a(@NotNull PsiBuilder psiBuilder) {
        if (psiBuilder == null) {
            Parsing.a(8);
        }
        return psiBuilder.getTokenType() == PyTokenTypes.EXEC_KEYWORD || psiBuilder.getTokenType() == PyTokenTypes.PRINT_KEYWORD;
    }

    protected static void buildTokenElement(IElementType type, PsiBuilder builder) {
        PsiBuilder.Marker marker = builder.mark();
        Parsing.advanceIdentifierLike(builder);
        marker.done(type);
    }

    protected IElementType getReferenceType() {
        return PyElementTypes.REFERENCE_EXPRESSION;
    }

    static {
        i = c.a(5640475382460835007L, 6521888188917628875L, MethodHandles.lookup().lookupClass()).a(277532075695339L);
        long l2 = i ^ 0xA09439FC77AL;
        a = Logger.getInstance((String)"#com.jetbrains.python.parsing.Parsing");
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = i ^ 0x45B8587322FDL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validSuccessiveTokens";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenType";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tokenText";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/parsing/Parsing";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkMatches";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "parseIdentifierOrSkip";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "atToken";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "advanceIdentifierLike";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "advanceError";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isIdentifier";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isFalseIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

