/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.ui;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.CatchingConsumer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.packaging.InstalledPackage;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackageManagementServiceEx;
import com.intellij.webcore.packaging.RepoPackage;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.packaging.PyPIPackageCache;
import com.jetbrains.python.packaging.PyPIPackageUtil;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagerUI;
import com.jetbrains.python.packaging.PyPackageService;
import com.jetbrains.python.packaging.PyPackageVersionComparator;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.PyRequirementsKt;
import com.jetbrains.python.packaging.requirement.PyRequirementRelation;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkType;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagementService
extends PackageManagementServiceEx {
    @NotNull
    private static final Pattern a;
    @NonNls
    private static final String d;
    @NonNls
    private static final String c = "</body></html>";
    @NotNull
    private final Project e;
    @NotNull
    protected final Sdk mySdk;
    protected final ExecutorService myExecutorService;
    @NonNls
    private static final String f = "<a href=\"";
    @NonNls
    private static final String b = "</a>";
    private static final long i;

    @NotNull
    private static String b() {
        long l2 = i ^ 0x2BBAA9E4E2B6L;
        int n2 = JBUIScale.scale((int)12);
        int n3 = JBUIScale.scale((int)2);
        int n4 = JBUIScale.scale((int)5);
        String string = String.format("<html><head>    <style type=\"text/css\">        p {            font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx        }    </style></head><body style=\"font-family: Arial,serif; font-size: %dpt; margin: %dpx %dpx;\">", n2, n3, n3, n2, n4, n4);
        if (string == null) {
            PyPackageManagementService.a(0);
        }
        return string;
    }

    public PyPackageManagementService(@NotNull Project project, @NotNull Sdk sdk) {
        long l2 = i ^ 0x52B0DD10EB5EL;
        if (project == null) {
            PyPackageManagementService.a(1);
        }
        if (sdk == null) {
            PyPackageManagementService.a(2);
        }
        this.e = project;
        this.mySdk = sdk;
        this.myExecutorService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"PyPackageManagementService Pool", (int)4);
    }

    @NotNull
    public Sdk getSdk() {
        Sdk sdk = this.mySdk;
        if (sdk == null) {
            PyPackageManagementService.a(3);
        }
        return sdk;
    }

    @NotNull
    public Project getProject() {
        Project project = this.e;
        if (project == null) {
            PyPackageManagementService.a(4);
        }
        return project;
    }

    @Nullable
    public List<String> getAllRepositories() {
        long l2 = i ^ 0x3B08CEF96C08L;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!PyPackageService.getInstance().PYPI_REMOVED.booleanValue()) {
            arrayList.add("https://pypi.python.org/simple");
        }
        arrayList.addAll(PyPackageManagementService.c());
        return arrayList;
    }

    public void addRepository(String repositoryUrl) {
        PyPackageService.getInstance().addRepository(repositoryUrl);
    }

    public void removeRepository(String repositoryUrl) {
        PyPackageService.getInstance().removeRepository(repositoryUrl);
    }

    @NotNull
    public List<RepoPackage> getAllPackages() throws IOException {
        PyPIPackageUtil.INSTANCE.loadPackages();
        PyPIPackageUtil.INSTANCE.loadAdditionalPackages(PyPackageManagementService.c(), false);
        List<RepoPackage> list2 = this.getAllPackagesCached();
        if (list2 == null) {
            PyPackageManagementService.a(5);
        }
        return list2;
    }

    @NotNull
    public List<RepoPackage> reloadAllPackages() throws IOException {
        PyPIPackageUtil.INSTANCE.updatePyPICache();
        PyPIPackageUtil.INSTANCE.loadAdditionalPackages(PyPackageManagementService.c(), true);
        List<RepoPackage> list2 = this.getAllPackagesCached();
        if (list2 == null) {
            PyPackageManagementService.a(6);
        }
        return list2;
    }

    @NotNull
    public List<RepoPackage> getAllPackagesCached() {
        ArrayList<RepoPackage> arrayList = new ArrayList<RepoPackage>();
        if (!PyPackageService.getInstance().PYPI_REMOVED.booleanValue()) {
            arrayList.addAll(PyPackageManagementService.a());
        }
        arrayList.addAll(PyPIPackageUtil.INSTANCE.getAdditionalPackages(PyPackageManagementService.c()));
        ArrayList<RepoPackage> arrayList2 = arrayList;
        if (arrayList2 == null) {
            PyPackageManagementService.a(7);
        }
        return arrayList2;
    }

    @NotNull
    private static List<String> c() {
        List<String> list2 = PyPackageService.getInstance().additionalRepositories;
        if (list2 == null) {
            PyPackageManagementService.a(8);
        }
        return list2;
    }

    @NotNull
    private static List<RepoPackage> a() {
        long l2 = i ^ 0x2DC5CAEE1C4DL;
        boolean bl2 = !PyPackageManagementService.c().isEmpty();
        String string = bl2 ? "https://pypi.python.org/simple" : "";
        List list2 = ContainerUtil.map(PyPIPackageCache.getInstance().getPackageNames(), string2 -> new RepoPackage(string2, string, null));
        if (list2 == null) {
            PyPackageManagementService.a(9);
        }
        return list2;
    }

    public boolean canInstallToUser() {
        return !PythonSdkType.isVirtualEnv(this.mySdk);
    }

    @NotNull
    public String getInstallToUserText() {
        long l2 = i ^ 0x7DA8DAEA15F9L;
        String string = "Install to user's site packages directory";
        if (!PythonSdkType.isRemote(this.mySdk)) {
            string = string + " (" + PySdkUtil.getUserSite() + ")";
        }
        String string2 = string;
        if (string2 == null) {
            PyPackageManagementService.a(10);
        }
        return string2;
    }

    public boolean isInstallToUserSelected() {
        return PyPackageService.getInstance().useUserSite(this.mySdk.getHomePath());
    }

    public void installToUserChanged(boolean newValue) {
        PyPackageService.getInstance().addSdkToUserSite(this.mySdk.getHomePath(), newValue);
    }

    @NotNull
    public Collection<InstalledPackage> getInstalledPackages() throws IOException {
        ArrayList arrayList;
        PyPackageManager pyPackageManager = PyPackageManager.getInstance(this.mySdk);
        try {
            arrayList = Lists.newArrayList(pyPackageManager.refreshAndGetPackages(true));
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
        Collections.sort(arrayList, Comparator.comparing(InstalledPackage::getName));
        ArrayList<InstalledPackage> arrayList2 = new ArrayList<InstalledPackage>(arrayList);
        if (arrayList2 == null) {
            PyPackageManagementService.a(11);
        }
        return arrayList2;
    }

    public void installPackage(@NotNull RepoPackage repoPackage, @Nullable String version, boolean forceUpgrade, @Nullable String extraOptions, final @NotNull PackageManagementService.Listener listener2, boolean installToUser) {
        long l2 = i ^ 0xACDBFD42023L;
        if (repoPackage == null) {
            PyPackageManagementService.a(12);
        }
        if (listener2 == null) {
            PyPackageManagementService.a(13);
        }
        final String string = repoPackage.getName();
        String string2 = PyPIPackageUtil.isPyPIRepository(repoPackage.getRepoUrl()) ? null : repoPackage.getRepoUrl();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (installToUser) {
            arrayList.add("--user");
        }
        if (extraOptions != null) {
            Collections.addAll(arrayList, extraOptions.split(" +"));
        }
        if (!StringUtil.isEmptyOrSpaces((String)string2)) {
            arrayList.add("--index-url");
            arrayList.add(string2);
        }
        if (forceUpgrade) {
            arrayList.add("-U");
        }
        PyRequirement pyRequirement = version == null ? PyRequirementsKt.pyRequirement(string) : PyRequirementsKt.pyRequirement(string, PyRequirementRelation.EQ, version);
        PyPackageManagerUI pyPackageManagerUI = new PyPackageManagerUI(this.e, this.mySdk, new PyPackageManagerUI.Listener(){

            @Override
            public void started() {
                listener2.operationStarted(string);
            }

            @Override
            public void finished(@Nullable List<ExecutionException> exceptions) {
                listener2.operationFinished(string, PyPackageManagementService.toErrorDescription(exceptions, PyPackageManagementService.this.mySdk));
            }
        });
        pyPackageManagerUI.install(Collections.singletonList(pyRequirement), arrayList);
    }

    @Nullable
    public static PackageManagementService.ErrorDescription toErrorDescription(@Nullable List<ExecutionException> exceptions, @Nullable Sdk sdk) {
        if (exceptions != null && !exceptions.isEmpty() && !PyPackageManagementService.a(exceptions)) {
            return PyPackageManagementService.a(exceptions.get(0), sdk);
        }
        return null;
    }

    public void uninstallPackages(@NotNull List<InstalledPackage> installedPackages, final @NotNull PackageManagementService.Listener listener2) {
        if (installedPackages == null) {
            PyPackageManagementService.a(14);
        }
        if (listener2 == null) {
            PyPackageManagementService.a(15);
        }
        final String string = installedPackages.size() == 1 ? installedPackages.get(0).getName() : null;
        PyPackageManagerUI pyPackageManagerUI = new PyPackageManagerUI(this.e, this.mySdk, new PyPackageManagerUI.Listener(){

            @Override
            public void started() {
                listener2.operationStarted(string);
            }

            @Override
            public void finished(List<ExecutionException> exceptions) {
                listener2.operationFinished(string, PyPackageManagementService.toErrorDescription(exceptions, PyPackageManagementService.this.mySdk));
            }
        });
        ArrayList<PyPackage> arrayList = new ArrayList<PyPackage>();
        for (InstalledPackage installedPackage : installedPackages) {
            if (!(installedPackage instanceof PyPackage)) continue;
            arrayList.add((PyPackage)installedPackage);
        }
        pyPackageManagerUI.uninstall(arrayList);
    }

    public void fetchPackageVersions(String packageName, CatchingConsumer<List<String>, Exception> consumer) {
        PyPIPackageUtil.INSTANCE.usePackageReleases(packageName, consumer);
    }

    public void fetchPackageDetails(@NotNull String packageName, final @NotNull CatchingConsumer<String, Exception> consumer) {
        if (packageName == null) {
            PyPackageManagementService.a(16);
        }
        if (consumer == null) {
            PyPackageManagementService.a(17);
        }
        PyPIPackageUtil.INSTANCE.fillPackageDetails(packageName, new CatchingConsumer<PyPIPackageUtil.PackageDetails.Info, Exception>(){

            public void consume(PyPIPackageUtil.PackageDetails.Info details) {
                consumer.consume((Object)PyPackageManagementService.a(details));
            }

            public void consume(Exception e10) {
                consumer.consume((Throwable)e10);
            }
        });
    }

    private static String a(@NotNull PyPIPackageUtil.PackageDetails.Info info) {
        String string;
        String string2;
        String string3;
        String string4;
        long l2 = i ^ 0x267FEF02EDEL;
        if (info == null) {
            PyPackageManagementService.a(18);
        }
        StringBuilder stringBuilder = new StringBuilder(d);
        String string5 = info.getSummary();
        if (StringUtil.isNotEmpty((String)string5)) {
            stringBuilder.append(string5).append("<br/>");
        }
        if (StringUtil.isNotEmpty((String)(string4 = info.getVersion()))) {
            stringBuilder.append("<h4>Version</h4>");
            stringBuilder.append(string4);
        }
        if (StringUtil.isNotEmpty((String)(string3 = info.getAuthor()))) {
            stringBuilder.append("<h4>Author</h4>");
            stringBuilder.append(string3).append("<br/><br/>");
        }
        if (StringUtil.isNotEmpty((String)(string2 = info.getAuthorEmail()))) {
            stringBuilder.append("<br/>");
            stringBuilder.append(PyPackageManagementService.b("mailto:" + string2));
        }
        if (StringUtil.isNotEmpty((String)(string = info.getHomePage()))) {
            stringBuilder.append("<br/>");
            stringBuilder.append(PyPackageManagementService.b(string));
        }
        stringBuilder.append(c);
        return stringBuilder.toString();
    }

    @NotNull
    private static String b(String string) {
        long l2 = i ^ 0x134D6FE96AEDL;
        String string2 = f + string + "\">" + string + b;
        if (string2 == null) {
            PyPackageManagementService.a(19);
        }
        return string2;
    }

    private static boolean a(@NotNull List<ExecutionException> list2) {
        if (list2 == null) {
            PyPackageManagementService.a(20);
        }
        for (ExecutionException executionException : list2) {
            if (!(executionException instanceof RunCanceledByUserException)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static PackageManagementService.ErrorDescription a(@NotNull ExecutionException executionException, @Nullable Sdk sdk) {
        if (executionException == null) {
            PyPackageManagementService.a(21);
        }
        if (executionException instanceof PyExecutionException) {
            PyExecutionException pyExecutionException = (PyExecutionException)executionException;
            String string = PyPackageManagementService.a(pyExecutionException.getStdout());
            String string2 = PyPackageManagementService.a(pyExecutionException.getStderr());
            String string3 = string != null ? string : string2;
            String string4 = string3 != null ? string3 : pyExecutionException.getMessage();
            String string5 = pyExecutionException.getCommand() + " " + StringUtil.join(pyExecutionException.getArgs(), (String)" ");
            PackageManagementService.ErrorDescription errorDescription = new PackageManagementService.ErrorDescription(string4, string5, pyExecutionException.getStdout() + "\n" + pyExecutionException.getStderr(), PyPackageManagementService.a(pyExecutionException, string3, sdk));
            if (errorDescription == null) {
                PyPackageManagementService.a(22);
            }
            return errorDescription;
        }
        PackageManagementService.ErrorDescription errorDescription = PackageManagementService.ErrorDescription.fromMessage((String)executionException.getMessage());
        if (errorDescription == null) {
            PyPackageManagementService.a(23);
        }
        return errorDescription;
    }

    @Nullable
    private static String a(@NotNull PyExecutionException pyExecutionException, @Nullable String string, @Nullable Sdk sdk) {
        long l2 = i ^ 0x470BA143DB41L;
        if (pyExecutionException == null) {
            PyPackageManagementService.a(24);
        }
        if (string != null && StringUtil.containsIgnoreCase((String)string, (String)"SyntaxError")) {
            LanguageLevel languageLevel = PythonSdkType.getLanguageLevelForSdk(sdk);
            return "Make sure that you use a version of Python supported by this package. Currently you are using Python " + (Object)((Object)languageLevel) + ".";
        }
        if (SystemInfo.isLinux && (PyPackageManagementService.a(pyExecutionException, "pyconfig.h") || PyPackageManagementService.a(pyExecutionException, "Python.h"))) {
            return "Make sure that you have installed Python development packages for your operating system.";
        }
        if ("pip".equals(pyExecutionException.getCommand()) && sdk != null) {
            return "Try to run this command from the system terminal. Make sure that you use the correct version of 'pip' installed for your Python interpreter located at '" + sdk.getHomePath() + "'.";
        }
        return null;
    }

    private static boolean a(@NotNull PyExecutionException pyExecutionException, @NotNull String string) {
        if (pyExecutionException == null) {
            PyPackageManagementService.a(25);
        }
        if (string == null) {
            PyPackageManagementService.a(26);
        }
        return StringUtil.containsIgnoreCase((String)pyExecutionException.getStdout(), (String)string) || StringUtil.containsIgnoreCase((String)pyExecutionException.getStderr(), (String)string);
    }

    @Nullable
    private static String a(@NotNull String string) {
        Matcher matcher;
        if (string == null) {
            PyPackageManagementService.a(27);
        }
        if ((matcher = a.matcher(string)).find()) {
            String string2 = matcher.group();
            return string2 != null ? string2.trim() : null;
        }
        return null;
    }

    public void updatePackage(@NotNull InstalledPackage installedPackage, @Nullable String version, @NotNull PackageManagementService.Listener listener2) {
        if (installedPackage == null) {
            PyPackageManagementService.a(28);
        }
        if (listener2 == null) {
            PyPackageManagementService.a(29);
        }
        this.installPackage(new RepoPackage(installedPackage.getName(), null), version, true, null, listener2, false);
    }

    public boolean shouldFetchLatestVersionsForOnlyInstalledPackages() {
        return true;
    }

    public void fetchLatestVersion(@NotNull InstalledPackage pkg, @NotNull CatchingConsumer<String, Exception> consumer) {
        if (pkg == null) {
            PyPackageManagementService.a(30);
        }
        if (consumer == null) {
            PyPackageManagementService.a(31);
        }
        this.myExecutorService.submit(() -> {
            try {
                PyPIPackageUtil.INSTANCE.loadPackages();
                String string = PyPIPackageUtil.INSTANCE.fetchLatestPackageVersion(this.e, pkg.getName());
                consumer.consume((Object)StringUtil.notNullize((String)string));
            }
            catch (IOException iOException) {
                consumer.consume((Throwable)iOException);
            }
        });
    }

    public int compareVersions(@NotNull String version1, @NotNull String version2) {
        if (version1 == null) {
            PyPackageManagementService.a(32);
        }
        if (version2 == null) {
            PyPackageManagementService.a(33);
        }
        return PyPackageVersionComparator.getSTR_COMPARATOR().compare(version1, version2);
    }

    static {
        i = com.jetbrains.python.psi.c.a(-3506241449560048611L, 869736112396142327L, MethodHandles.lookup().lookupClass()).a(50155154161910L);
        long l2 = i ^ 0x420414E08D0AL;
        a = Pattern.compile(".*error:.*", 2);
        d = PyPackageManagementService.b();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = i ^ 0x2C42636EFAD7L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/packaging/ui/PyPackageManagementService";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repoPackage";
                break;
            }
            case 13: 
            case 15: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackages";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 17: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptions";
                break;
            }
            case 21: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "installedPackage";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version1";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version2";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHtmlStylePrefix";
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/packaging/ui/PyPackageManagementService";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdk";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackages";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "reloadAllPackages";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPackagesCached";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalRepositories";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getCachedPyPIPackages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstallToUserText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstalledPackages";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "composeHref";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescription";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "installPackage";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "uninstallPackages";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "fetchPackageDetails";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "formatPackageInfo";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "isCancelled";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createDescription";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findErrorSolution";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "containsInOutput";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findErrorCause";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updatePackage";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "fetchLatestVersion";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "compareVersions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

