/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.icons.AllIcons;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.webcore.packaging.PackageManagementService;
import com.intellij.webcore.packaging.PackagesNotificationPanel;
import com.jetbrains.python.packaging.PyPackage;
import com.jetbrains.python.packaging.PyPackageManager;
import com.jetbrains.python.packaging.PyPackageManagers;
import com.jetbrains.python.packaging.PyPackageUtil;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.ui.PyPackageManagementService;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyPackageManagerUI {
    @NotNull
    private static final Logger b;
    @Nullable
    private final Listener c;
    @NotNull
    private final Project a;
    @NotNull
    private final Sdk d;
    private static final long e;

    public PyPackageManagerUI(@NotNull Project project, @NotNull Sdk sdk, @Nullable Listener listener2) {
        if (project == null) {
            PyPackageManagerUI.a(0);
        }
        if (sdk == null) {
            PyPackageManagerUI.a(1);
        }
        this.a = project;
        this.d = sdk;
        this.c = listener2;
    }

    public void installManagement() {
        ProgressManager.getInstance().run((Task)new InstallManagementTask(this.a, this.d, this.c));
    }

    public void install(@Nullable List<PyRequirement> requirements, @NotNull List<String> extraArgs) {
        if (extraArgs == null) {
            PyPackageManagerUI.a(2);
        }
        ProgressManager.getInstance().run((Task)new InstallTask(this.a, this.d, requirements, extraArgs, this.c));
    }

    public void uninstall(@NotNull List<PyPackage> packages) {
        if (packages == null) {
            PyPackageManagerUI.a(3);
        }
        if (this.a(packages)) {
            return;
        }
        ProgressManager.getInstance().run((Task)new UninstallTask(this.a, this.d, this.c, packages));
    }

    private boolean a(@NotNull List<PyPackage> list2) {
        long l2 = e ^ 0x769EDBAD0A3AL;
        if (list2 == null) {
            PyPackageManagerUI.a(4);
        }
        try {
            Map<String, Set<PyPackage>> map2 = PyPackageManagerUI.a(list2, this.d);
            int[] nArray = new int[]{0};
            if (!map2.isEmpty()) {
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    long l2 = e ^ 0x1C04455BB2F7L;
                    if (map2.size() == 1) {
                        String string = "You are attempting to uninstall ";
                        ArrayList<String> arrayList = new ArrayList<String>();
                        int n2 = 1;
                        for (Map.Entry entry : map2.entrySet()) {
                            Set set = (Set)entry.getValue();
                            n2 = set.size();
                            arrayList.add((String)entry.getKey() + " package which is required for " + StringUtil.join((Iterable)set, (String)", "));
                        }
                        string = string + StringUtil.join(arrayList, (String)"\n");
                        string = string + (n2 == 1 ? " package" : " packages");
                        string = string + "\n\nDo you want to proceed?";
                        nArray[0] = Messages.showYesNoDialog((String)string, (String)"Warning", (Icon)AllIcons.General.BalloonWarning);
                    } else {
                        String string = "You are attempting to uninstall packages which are required for another packages.\n\n";
                        ArrayList<String> arrayList = new ArrayList<String>();
                        for (Map.Entry entry : map2.entrySet()) {
                            arrayList.add((String)entry.getKey() + " -> " + StringUtil.join((Iterable)((Iterable)entry.getValue()), (String)", "));
                        }
                        string = string + StringUtil.join(arrayList, (String)"\n");
                        string = string + "\n\nDo you want to proceed?";
                        nArray[0] = Messages.showYesNoDialog((String)string, (String)"Warning", (Icon)AllIcons.General.BalloonWarning);
                    }
                }, ModalityState.current());
            }
            if (nArray[0] != 0) {
                return true;
            }
        }
        catch (ExecutionException executionException) {
            b.info("Error loading packages dependents: " + executionException.getMessage(), (Throwable)executionException);
        }
        return false;
    }

    private static Map<String, Set<PyPackage>> a(@NotNull List<PyPackage> list2, Sdk sdk) throws ExecutionException {
        if (list2 == null) {
            PyPackageManagerUI.a(5);
        }
        HashMap<String, Set<PyPackage>> hashMap = new HashMap<String, Set<PyPackage>>();
        for (PyPackage pyPackage : list2) {
            Set<PyPackage> set = PyPackageManager.getInstance(sdk).getDependents(pyPackage);
            if (set.isEmpty()) continue;
            for (PyPackage pyPackage2 : set) {
                if (list2.contains((Object)pyPackage2)) continue;
                hashMap.put(pyPackage.getName(), set);
            }
        }
        return hashMap;
    }

    static {
        e = com.jetbrains.python.psi.c.a(1000517554403742146L, -1492140623598622567L, MethodHandles.lookup().lookupClass()).a(36578282395835L);
        b = Logger.getInstance(PyPackageManagerUI.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = e ^ 0x79E3667E56F1L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraArgs";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packages";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "uninstall";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkDependents";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "collectDependents";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UninstallTask
    extends PackagingTask {
        @NotNull
        private final List<PyPackage> b;
        private static final long c = com.jetbrains.python.psi.c.a(2887894759608288972L, -874079716493886162L, MethodHandles.lookup().lookupClass()).a(221032721027410L);

        UninstallTask(@Nullable Project project, @NotNull Sdk sdk, @Nullable Listener listener2, @NotNull List<PyPackage> packages) {
            long l2 = c ^ 0x1B2B4C0AFE4BL;
            if (sdk == null) {
                UninstallTask.b(0);
            }
            if (packages == null) {
                UninstallTask.b(1);
            }
            super(project, sdk, "Uninstalling packages", listener2);
            this.b = packages;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NotNull
        protected List<ExecutionException> runTask(@NotNull ProgressIndicator indicator) {
            List<ExecutionException> list2;
            if (indicator == null) {
                UninstallTask.b(2);
            }
            PyPackageManager pyPackageManager = PyPackageManagers.getInstance().forSdk(this.mySdk);
            indicator.setIndeterminate(true);
            try {
                pyPackageManager.uninstall(this.b);
                List<ExecutionException> list3 = Collections.emptyList();
                list2 = list3;
            }
            catch (ExecutionException executionException) {
                List<ExecutionException> list4 = Collections.singletonList(executionException);
                List<ExecutionException> list5 = list4;
                if (list5 == null) {
                    UninstallTask.b(4);
                }
                return list5;
            }
            finally {
                pyPackageManager.refresh();
            }
            if (list2 == null) {
                UninstallTask.b(3);
            }
            return list2;
        }

        @Override
        @NotNull
        protected String getSuccessTitle() {
            long l2 = c ^ 0x2E835949DABBL;
            if ("Packages uninstalled successfully" == null) {
                UninstallTask.b(5);
            }
            return "Packages uninstalled successfully";
        }

        @Override
        @NotNull
        protected String getSuccessDescription() {
            long l2 = c ^ 0x46396FBFA0C5L;
            String string = StringUtil.join(this.b, pyPackage -> "'" + pyPackage.getName() + "'", (String)", ");
            String string2 = "Uninstalled packages: " + string;
            if (string2 == null) {
                UninstallTask.b(6);
            }
            return string2;
        }

        @Override
        @NotNull
        protected String getFailureTitle() {
            long l2 = c ^ 0x50C5F8C57766L;
            if ("Uninstall packages failed" == null) {
                UninstallTask.b(7);
            }
            return "Uninstall packages failed";
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x217BBE14D522L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "packages";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$UninstallTask";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runTask";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessTitle";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessDescription";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFailureTitle";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runTask";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InstallManagementTask
    extends InstallTask {
        private static final long d = com.jetbrains.python.psi.c.a(-5594867998164796363L, -1560172736339532878L, MethodHandles.lookup().lookupClass()).a(252249612314067L);

        InstallManagementTask(@Nullable Project project, @NotNull Sdk sdk, @Nullable Listener listener2) {
            if (sdk == null) {
                InstallManagementTask.c(0);
            }
            super(project, sdk, Collections.emptyList(), Collections.emptyList(), listener2);
        }

        @Override
        @NotNull
        protected List<ExecutionException> runTask(@NotNull ProgressIndicator indicator) {
            long l2 = d ^ 0x3EB184CF7379L;
            if (indicator == null) {
                InstallManagementTask.c(1);
            }
            ArrayList<ExecutionException> arrayList = new ArrayList<ExecutionException>();
            PyPackageManager pyPackageManager = PyPackageManagers.getInstance().forSdk(this.mySdk);
            indicator.setText("Installing packaging tools...");
            indicator.setIndeterminate(true);
            try {
                pyPackageManager.installManagement();
            }
            catch (ExecutionException executionException) {
                arrayList.add(executionException);
            }
            pyPackageManager.refresh();
            ArrayList<ExecutionException> arrayList2 = arrayList;
            if (arrayList2 == null) {
                InstallManagementTask.c(2);
            }
            return arrayList2;
        }

        @Override
        @NotNull
        protected String getSuccessDescription() {
            long l2 = d ^ 0x780F82E18AEDL;
            if ("Installed Python packaging tools" == null) {
                InstallManagementTask.c(3);
            }
            return "Installed Python packaging tools";
        }

        private static /* synthetic */ void c(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = d ^ 0x1E1553224261L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerUI$InstallManagementTask";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$InstallManagementTask";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runTask";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessDescription";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "runTask";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class InstallTask
    extends PackagingTask {
        @Nullable
        private final List<PyRequirement> c;
        @NotNull
        private final List<String> b;
        private static final long e = com.jetbrains.python.psi.c.a(2154575801330083738L, 3041127223208916131L, MethodHandles.lookup().lookupClass()).a(215539441076330L);

        InstallTask(@Nullable Project project, @NotNull Sdk sdk, @Nullable List<PyRequirement> requirements, @NotNull List<String> extraArgs, @Nullable Listener listener2) {
            long l2 = e ^ 0x5EC7451C5C40L;
            if (sdk == null) {
                InstallTask.b(0);
            }
            if (extraArgs == null) {
                InstallTask.b(1);
            }
            super(project, sdk, "Installing packages", listener2);
            this.c = requirements;
            this.b = extraArgs;
        }

        @Override
        @NotNull
        protected List<ExecutionException> runTask(@NotNull ProgressIndicator indicator) {
            long l2 = e ^ 0x62330B7E9E98L;
            if (indicator == null) {
                InstallTask.b(2);
            }
            ArrayList<ExecutionException> arrayList = new ArrayList<ExecutionException>();
            PyPackageManager pyPackageManager = PyPackageManagers.getInstance().forSdk(this.mySdk);
            if (this.c == null) {
                indicator.setText("Installing packages...");
                indicator.setIndeterminate(true);
                try {
                    pyPackageManager.install(null, this.b);
                }
                catch (RunCanceledByUserException runCanceledByUserException) {
                    arrayList.add((ExecutionException)((Object)runCanceledByUserException));
                }
                catch (ExecutionException executionException) {
                    arrayList.add(executionException);
                }
            } else {
                int n2 = this.c.size();
                for (int i10 = 0; i10 < n2; ++i10) {
                    PyRequirement pyRequirement = this.c.get(i10);
                    indicator.setText(String.format("Installing package '%s'...", pyRequirement.getPresentableText()));
                    if (i10 == 0) {
                        indicator.setIndeterminate(true);
                    } else {
                        indicator.setIndeterminate(false);
                        indicator.setFraction((double)i10 / (double)n2);
                    }
                    try {
                        pyPackageManager.install(Collections.singletonList(pyRequirement), this.b);
                        continue;
                    }
                    catch (RunCanceledByUserException runCanceledByUserException) {
                        arrayList.add((ExecutionException)((Object)runCanceledByUserException));
                        break;
                    }
                    catch (ExecutionException executionException) {
                        arrayList.add(executionException);
                    }
                }
            }
            pyPackageManager.refresh();
            ArrayList<ExecutionException> arrayList2 = arrayList;
            if (arrayList2 == null) {
                InstallTask.b(3);
            }
            return arrayList2;
        }

        @Override
        @NotNull
        protected String getSuccessTitle() {
            long l2 = e ^ 0x4C373BA61D72L;
            if ("Packages installed successfully" == null) {
                InstallTask.b(4);
            }
            return "Packages installed successfully";
        }

        @Override
        @NotNull
        protected String getSuccessDescription() {
            long l2 = e ^ 0x248D0D50670CL;
            String string = this.c != null ? "Installed packages: " + PyPackageUtil.requirementsToString(this.c) : "Installed all requirements";
            if (string == null) {
                InstallTask.b(5);
            }
            return string;
        }

        @Override
        @NotNull
        protected String getFailureTitle() {
            long l2 = e ^ 0x32719A2AB0AFL;
            if ("Install packages failed" == null) {
                InstallTask.b(6);
            }
            return "Install packages failed";
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0x158FEC120B86L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extraArgs";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$InstallTask";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "runTask";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessTitle";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuccessDescription";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFailureTitle";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "runTask";
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static abstract class PackagingTask
    extends Task.Backgroundable {
        private static final String a = "Packaging";
        @NotNull
        protected final Sdk mySdk;
        @Nullable
        protected final Listener myListener;
        private static final long f = com.jetbrains.python.psi.c.a(2550960504190289897L, -4644440673099237976L, MethodHandles.lookup().lookupClass()).a(135985401618386L);

        PackagingTask(@Nullable Project project, @NotNull Sdk sdk, @NotNull String title, @Nullable Listener listener2) {
            if (sdk == null) {
                PackagingTask.a(0);
            }
            if (title == null) {
                PackagingTask.a(1);
            }
            super(project, title);
            this.mySdk = sdk;
            this.myListener = listener2;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                PackagingTask.a(2);
            }
            this.taskStarted(indicator);
            this.taskFinished(this.runTask(indicator));
        }

        @NotNull
        protected abstract List<ExecutionException> runTask(@NotNull ProgressIndicator var1);

        @NotNull
        protected abstract String getSuccessTitle();

        @NotNull
        protected abstract String getSuccessDescription();

        @NotNull
        protected abstract String getFailureTitle();

        protected void taskStarted(@NotNull ProgressIndicator indicator) {
            PackagingNotification[] packagingNotificationArray;
            long l2 = f ^ 0x67E819D1BE4FL;
            if (indicator == null) {
                PackagingTask.a(3);
            }
            for (PackagingNotification packagingNotification : packagingNotificationArray = (PackagingNotification[])NotificationsManager.getNotificationsManager().getNotificationsOfType(PackagingNotification.class, this.getProject())) {
                packagingNotification.expire();
            }
            indicator.setText(this.getTitle() + "...");
            if (this.myListener != null) {
                ApplicationManager.getApplication().invokeLater(() -> this.myListener.started());
            }
        }

        protected void taskFinished(@NotNull List<ExecutionException> exceptions) {
            long l2 = f ^ 0x5330946C7D47L;
            if (exceptions == null) {
                PackagingTask.a(4);
            }
            Ref ref = new Ref(null);
            if (exceptions.isEmpty()) {
                ref.set((Object)new PackagingNotification(a, this.getSuccessTitle(), this.getSuccessDescription(), NotificationType.INFORMATION, null));
            } else {
                final PackageManagementService.ErrorDescription errorDescription = PyPackageManagementService.toErrorDescription(exceptions, this.mySdk);
                if (errorDescription != null) {
                    String string = this.getTitle() + ": error occurred.";
                    NotificationListener notificationListener = new NotificationListener(){
                        private static final long a = com.jetbrains.python.psi.c.a(3531613442265962380L, 8341177762206275218L, MethodHandles.lookup().lookupClass()).a(247446370067935L);

                        public void hyperlinkUpdate(@NotNull Notification notification2, @NotNull HyperlinkEvent event) {
                            if (notification2 == null) {
                                1.a(0);
                            }
                            if (event == null) {
                                1.a(1);
                            }
                            assert (myProject != null);
                            String string = StringUtil.capitalizeWords((String)this.getFailureTitle(), (boolean)true);
                            PackagesNotificationPanel.showError((String)string, (PackageManagementService.ErrorDescription)errorDescription);
                        }

                        private static /* synthetic */ void a(int n2) {
                            Object[] objectArray;
                            long l2 = a ^ 0x437F7CD79B07L;
                            Object[] objectArray2 = new Object[3];
                            switch (n2) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "notification";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "event";
                                    break;
                                }
                            }
                            objectArray[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask$1";
                            objectArray[2] = "hyperlinkUpdate";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    };
                    ref.set((Object)new PackagingNotification(a, this.getFailureTitle(), string + " <a href=\"xxx\">Details...</a>", NotificationType.ERROR, notificationListener));
                }
            }
            ApplicationManager.getApplication().invokeLater(() -> {
                Notification notification2;
                if (this.myListener != null) {
                    this.myListener.finished(exceptions);
                }
                if ((notification2 = (Notification)ref.get()) != null) {
                    notification2.notify(this.myProject);
                }
            });
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = f ^ 0x5C89C418BEF7L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sdk";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "exceptions";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "taskStarted";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "taskFinished";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class PackagingNotification
        extends Notification {
            private static final long a = com.jetbrains.python.psi.c.a(-556943102237939826L, 5682072690987330674L, MethodHandles.lookup().lookupClass()).a(7572033190766L);

            PackagingNotification(@NotNull String groupDisplayId, @NotNull String title, @NotNull String content2, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
                if (groupDisplayId == null) {
                    PackagingNotification.a(0);
                }
                if (title == null) {
                    PackagingNotification.a(1);
                }
                if (content2 == null) {
                    PackagingNotification.a(2);
                }
                if (type == null) {
                    PackagingNotification.a(3);
                }
                super(groupDisplayId, title, content2, type, listener2);
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                long l2 = a ^ 0x2049F387C383L;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "groupDisplayId";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "title";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[0] = "content";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/python/packaging/PyPackageManagerUI$PackagingTask$PackagingNotification";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    public static interface Listener {
        public void started();

        public void finished(List<ExecutionException> var1);
    }
}

