/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.lexer.FlexAdapter;
import com.intellij.lexer.FlexLexer;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.c;
import gnu.trove.TIntStack;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonIndentingProcessor
extends MergingLexerAdapter {
    protected final TIntStack myIndentStack = new TIntStack();
    protected int myBraceLevel;
    protected boolean myLineHasSignificantTokens;
    protected int myLastNewLineIndent = -1;
    private int c = 0;
    protected List<PendingToken> myTokenQueue = new ArrayList<PendingToken>();
    private int d = -1;
    protected boolean myProcessSpecialTokensPending = false;
    private final Stack<String> e = new Stack();
    private static final boolean a = false;
    private final TokenSet b = PythonDialectsTokenSetProvider.INSTANCE.getUnbalancedBracesRecoveryTokens();
    private static final long g = com.jetbrains.python.psi.c.a(7111080467536673005L, 2204701590426301633L, MethodHandles.lookup().lookupClass()).a(71049006758885L);

    public PythonIndentingProcessor(FlexLexer lexer, TokenSet tokens) {
        super((Lexer)new FlexAdapter(lexer), tokens);
    }

    @Nullable
    protected IElementType getBaseTokenType() {
        return super.getTokenType();
    }

    protected int getBaseTokenStart() {
        return super.getTokenStart();
    }

    protected int getBaseTokenEnd() {
        return super.getTokenEnd();
    }

    @NotNull
    private String b() {
        String string = this.getBufferSequence().subSequence(this.getBaseTokenStart(), this.getBaseTokenEnd()).toString();
        if (string == null) {
            PythonIndentingProcessor.b(0);
        }
        return string;
    }

    private boolean a(IElementType iElementType) {
        return this.getBaseTokenType() == iElementType;
    }

    public IElementType getTokenType() {
        if (this.myTokenQueue.size() > 0) {
            return this.myTokenQueue.get(0).getType();
        }
        return super.getTokenType();
    }

    public int getTokenStart() {
        if (this.myTokenQueue.size() > 0) {
            return this.myTokenQueue.get(0).getStart();
        }
        return super.getTokenStart();
    }

    public int getTokenEnd() {
        if (this.myTokenQueue.size() > 0) {
            return this.myTokenQueue.get(0).getEnd();
        }
        return super.getTokenEnd();
    }

    public void advance() {
        if (this.getTokenType() == PyTokenTypes.LINE_BREAK) {
            String string = this.getTokenText();
            int n2 = 0;
            for (int i10 = string.length() - 1; i10 >= 0; --i10) {
                if (string.charAt(i10) == ' ') {
                    ++n2;
                    continue;
                }
                if (string.charAt(i10) != '\t') continue;
                n2 += 8;
            }
            this.c = n2;
        } else if (this.getTokenType() == PyTokenTypes.TAB) {
            this.c += 8;
        }
        if (this.myTokenQueue.size() > 0) {
            this.myTokenQueue.remove(0);
            if (this.myProcessSpecialTokensPending) {
                this.myProcessSpecialTokensPending = false;
                this.processSpecialTokens();
            }
        } else {
            this.advanceBase();
            this.processSpecialTokens();
        }
        this.a();
    }

    protected void advanceBase() {
        super.advance();
        this.checkSignificantTokens();
        this.e();
    }

    private void e() {
        block3: {
            String string;
            String string2;
            block2: {
                string2 = this.b();
                if (!this.a(PyTokenTypes.FSTRING_START)) break block2;
                int n2 = PyStringLiteralUtil.getPrefixLength(string2);
                String string3 = string2.substring(n2);
                assert (!string3.isEmpty());
                this.e.push((Object)string3);
                break block3;
            }
            if (!this.a(PyTokenTypes.FSTRING_END)) break block3;
            while (!this.e.isEmpty() && !(string = (String)this.e.pop()).equals(string2)) {
            }
        }
    }

    protected void pushToken(IElementType type, int start2, int end) {
        this.myTokenQueue.add(new PendingToken(type, start2, end));
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            PythonIndentingProcessor.b(1);
        }
        this.checkStartState(startOffset, initialState);
        super.start(buffer, startOffset, endOffset, initialState);
        this.c();
    }

    protected void checkStartState(int startOffset, int initialState) {
    }

    private void c() {
        this.myIndentStack.clear();
        this.myIndentStack.push(0);
        this.myBraceLevel = 0;
        this.a();
        this.myLineHasSignificantTokens = false;
        this.checkSignificantTokens();
        this.e();
        if (this.a(PyTokenTypes.SPACE)) {
            this.processIndent(0, PyTokenTypes.SPACE);
        }
    }

    private void a() {
        IElementType iElementType = this.getTokenType();
        if (PyTokenTypes.OPEN_BRACES.contains(iElementType)) {
            ++this.myBraceLevel;
        } else if (PyTokenTypes.CLOSE_BRACES.contains(iElementType)) {
            --this.myBraceLevel;
        } else if (this.myBraceLevel != 0 && this.b.contains(iElementType)) {
            int n2;
            this.myBraceLevel = 0;
            int n3 = this.getTokenStart();
            this.pushToken(PyTokenTypes.STATEMENT_BREAK, n3, n3);
            int n4 = this.myIndentStack.size();
            for (int i10 = 0; i10 < n4 - 1 && this.c < (n2 = this.myIndentStack.peek()); ++i10) {
                if (this.myIndentStack.size() <= 1) continue;
                this.myIndentStack.pop();
                this.pushToken(PyTokenTypes.DEDENT, n3, n3);
            }
            this.pushToken(PyTokenTypes.LINE_BREAK, n3, n3);
        }
    }

    protected void checkSignificantTokens() {
        IElementType iElementType = this.getBaseTokenType();
        if (!PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(iElementType) && iElementType != this.getCommentTokenType()) {
            this.myLineHasSignificantTokens = true;
        }
    }

    protected void processSpecialTokens() {
        int n2 = this.getBaseTokenStart();
        if (this.a(PyTokenTypes.LINE_BREAK)) {
            this.processLineBreak(n2);
            if (this.a(this.getCommentTokenType())) {
                this.d = this.myTokenQueue.size() - 1;
                while (this.a(this.getCommentTokenType())) {
                    int n3 = this.getBaseTokenEnd();
                    this.myTokenQueue.add(new PendingCommentToken(this.getBaseTokenType(), this.getBaseTokenStart(), n3, this.myLastNewLineIndent));
                    this.advanceBase();
                    if (this.a(PyTokenTypes.LINE_BREAK)) {
                        this.processLineBreak(this.getBaseTokenStart());
                        continue;
                    }
                    if (this.getBaseTokenType() != null) break;
                    this.a(0, n3);
                }
                this.d = -1;
            }
        } else if (this.a(PyTokenTypes.BACKSLASH)) {
            this.a(n2);
        } else if (this.a(PyTokenTypes.SPACE)) {
            this.d();
        }
    }

    private void d() {
        int n2 = this.getBaseTokenStart();
        int n3 = this.getBaseTokenEnd();
        while (this.getBaseTokenType() == PyTokenTypes.SPACE) {
            n3 = this.getBaseTokenEnd();
            this.advanceBase();
        }
        if (this.getBaseTokenType() == PyTokenTypes.LINE_BREAK) {
            this.processLineBreak(n2);
        } else if (this.getBaseTokenType() == PyTokenTypes.BACKSLASH) {
            this.a(n2);
        } else {
            this.myTokenQueue.add(new PendingToken(PyTokenTypes.SPACE, n2, n3));
        }
    }

    private void a(int n2) {
        PendingToken pendingToken = new PendingToken(this.getBaseTokenType(), n2, this.getBaseTokenEnd());
        this.myTokenQueue.add(pendingToken);
        this.advanceBase();
        while (PyTokenTypes.WHITESPACE.contains(this.getBaseTokenType())) {
            this.f();
            this.advanceBase();
        }
        if (this.getBaseTokenType() == PyTokenTypes.LINE_BREAK) {
            pendingToken.setType(PyTokenTypes.SPACE);
            this.processInsignificantLineBreak(this.getBaseTokenStart(), true);
        }
        this.myProcessSpecialTokensPending = true;
    }

    protected void processLineBreak(int startPos) {
        boolean bl2;
        boolean bl3 = ContainerUtil.and(this.e, string -> string.length() == 3);
        boolean bl4 = !this.e.isEmpty() && bl3;
        boolean bl5 = bl2 = !this.e.isEmpty() && !bl3;
        if (this.myBraceLevel == 0 && !bl4 || bl2) {
            if (this.myLineHasSignificantTokens || bl2) {
                this.pushToken(PyTokenTypes.STATEMENT_BREAK, startPos, startPos);
                this.e.clear();
            }
            this.myLineHasSignificantTokens = false;
            this.advanceBase();
            this.processIndent(startPos, PyTokenTypes.LINE_BREAK);
        } else {
            this.processInsignificantLineBreak(startPos, false);
        }
    }

    protected void processInsignificantLineBreak(int startPos, boolean breakStatementOnLineBreak) {
        int n2 = this.getBaseTokenEnd();
        this.advanceBase();
        while (this.getBaseTokenType() == PyTokenTypes.SPACE || this.getBaseTokenType() == PyTokenTypes.TAB || !breakStatementOnLineBreak && this.getBaseTokenType() == PyTokenTypes.LINE_BREAK) {
            n2 = this.getBaseTokenEnd();
            this.advanceBase();
        }
        this.myTokenQueue.add(new PendingToken(PyTokenTypes.LINE_BREAK, startPos, n2));
        this.myProcessSpecialTokensPending = true;
    }

    protected void processIndent(int whiteSpaceStart, IElementType whitespaceTokenType) {
        int n2;
        int n3;
        int n4 = this.myIndentStack.peek();
        this.myLastNewLineIndent = n3 = this.getNextLineIndent();
        if (this.getBaseTokenType() == this.getCommentTokenType()) {
            n3 = n4;
        }
        int n5 = n2 = this.getBaseTokenType() == null ? super.getBufferEnd() : this.getBaseTokenStart();
        if (n3 > n4) {
            this.myIndentStack.push(n3);
            this.myTokenQueue.add(new PendingToken(whitespaceTokenType, whiteSpaceStart, n2));
            int n6 = this.skipPrecedingCommentsWithIndent(n3, this.myTokenQueue.size() - 1);
            int n7 = n6 == this.myTokenQueue.size() ? n2 : this.myTokenQueue.get(n6).getStart();
            this.myTokenQueue.add(n6, new PendingToken(PyTokenTypes.INDENT, n7, n7));
        } else if (n3 < n4) {
            this.a(n3, whiteSpaceStart);
            this.myTokenQueue.add(new PendingToken(whitespaceTokenType, whiteSpaceStart, n2));
        } else {
            this.myTokenQueue.add(new PendingToken(whitespaceTokenType, whiteSpaceStart, n2));
        }
    }

    private void a(int n2, int n3) {
        int n4;
        int n5 = this.myIndentStack.peek();
        int n6 = n4 = this.d == -1 ? this.myTokenQueue.size() : this.d;
        while (n2 < n5) {
            int n7 = this.myIndentStack.pop();
            n5 = this.myIndentStack.peek();
            int n8 = n3;
            if (n2 > n5) {
                this.myTokenQueue.add(new PendingToken(PyTokenTypes.INCONSISTENT_DEDENT, n3, n3));
                n4 = this.myTokenQueue.size();
            } else {
                n4 = this.skipPrecedingCommentsWithSameIndentOnSuiteClose(n7, n4);
            }
            if (n4 != this.myTokenQueue.size()) {
                n8 = this.myTokenQueue.get(n4).getStart();
            }
            this.myTokenQueue.add(n4, new PendingToken(PyTokenTypes.DEDENT, n8, n8));
            ++n4;
        }
    }

    protected int skipPrecedingCommentsWithIndent(int indent, int index) {
        PendingCommentToken pendingCommentToken;
        boolean bl2 = false;
        while (index > 0 && this.myTokenQueue.get(index - 1) instanceof PendingCommentToken && (pendingCommentToken = (PendingCommentToken)this.myTokenQueue.get(index - 1)).getIndent() == indent) {
            bl2 = true;
            if (--index <= 1 || this.myTokenQueue.get(index - 1).getType() != PyTokenTypes.LINE_BREAK || !(this.myTokenQueue.get(index - 2) instanceof PendingCommentToken)) continue;
            --index;
        }
        return bl2 ? index : this.myTokenQueue.size();
    }

    protected int skipPrecedingCommentsWithSameIndentOnSuiteClose(int indent, int anchorIndex) {
        int n2 = anchorIndex;
        for (int i10 = anchorIndex; i10 < this.myTokenQueue.size(); ++i10) {
            PendingToken pendingToken = this.myTokenQueue.get(i10);
            if (!(pendingToken instanceof PendingCommentToken)) continue;
            if (((PendingCommentToken)pendingToken).getIndent() < indent) break;
            n2 = i10 + 1;
        }
        return n2;
    }

    protected int getNextLineIndent() {
        int n2 = 0;
        while (this.getBaseTokenType() != null && PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(this.getBaseTokenType())) {
            if (this.getBaseTokenType() == PyTokenTypes.TAB) {
                n2 = (n2 / 8 + 1) * 8;
            } else if (this.getBaseTokenType() == PyTokenTypes.SPACE) {
                ++n2;
            } else if (this.getBaseTokenType() == PyTokenTypes.LINE_BREAK) {
                n2 = 0;
            }
            this.advanceBase();
        }
        if (this.getBaseTokenType() == null) {
            return 0;
        }
        return n2;
    }

    private void f() {
        this.myTokenQueue.add(new PendingToken(this.getBaseTokenType(), this.getBaseTokenStart(), this.getBaseTokenEnd()));
    }

    protected IElementType getCommentTokenType() {
        return PyTokenTypes.END_OF_LINE_COMMENT;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x37DA5ED0B2B7L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/lexer/PythonIndentingProcessor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseTokenText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/lexer/PythonIndentingProcessor";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PendingCommentToken
    extends PendingToken {
        private final int d;

        PendingCommentToken(IElementType type, int start2, int end, int indent) {
            super(type, start2, end);
            this.d = indent;
        }

        public int getIndent() {
            return this.d;
        }
    }

    protected static class PendingToken {
        private IElementType c;
        private final int a;
        private final int b;

        public PendingToken(IElementType type, int start2, int end) {
            this.c = type;
            this.a = start2;
            this.b = end;
        }

        public IElementType getType() {
            return this.c;
        }

        public int getStart() {
            return this.a;
        }

        public int getEnd() {
            return this.b;
        }

        public void setType(IElementType type) {
            this.c = type;
        }

        public String toString() {
            return this.c + ":" + this.a + "-" + this.b;
        }
    }
}

