/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.lexer;

import com.intellij.lexer.LexerBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NotNull;

public abstract class PyStringLiteralLexerBase
extends LexerBase {
    protected static final Logger LOG;
    protected final IElementType myOriginalLiteralToken;
    protected CharSequence myBuffer;
    protected int myBufferEnd;
    protected int myStart;
    protected int myEnd;
    protected int myBaseLexerState;
    private boolean a;
    private static final long k;

    public PyStringLiteralLexerBase(IElementType originalLiteralToken) {
        this.myOriginalLiteralToken = originalLiteralToken;
    }

    public final void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            PyStringLiteralLexerBase.a(0);
        }
        this.myBuffer = buffer;
        this.myStart = startOffset;
        this.a = true;
        this.myBufferEnd = endOffset;
        this.myBaseLexerState = initialState;
        this.handleStart(buffer, initialState);
        this.myEnd = this.locateToken(this.myStart);
    }

    protected void handleStart(@NotNull CharSequence buffer, int initialState) {
        if (buffer == null) {
            PyStringLiteralLexerBase.a(1);
        }
    }

    protected abstract boolean isRaw();

    protected abstract boolean isUnicodeMode();

    public IElementType getTokenType() {
        if (this.myStart >= this.myEnd) {
            return null;
        }
        if (this.myBuffer.charAt(this.myStart) != '\\' || this.isRaw() && (!this.isUnicodeMode() || !this.a())) {
            this.a = false;
            return this.myOriginalLiteralToken;
        }
        return this.getEscapeSequenceType();
    }

    @NotNull
    public final IElementType getEscapeSequenceType() {
        if (this.myStart + 1 >= this.myEnd) {
            IElementType iElementType = StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN;
            if (iElementType == null) {
                PyStringLiteralLexerBase.a(2);
            }
            return iElementType;
        }
        char c10 = this.myBuffer.charAt(this.myStart + 1);
        this.a &= c10 == ' ';
        if (c10 == '\n' || c10 == ' ' && (this.a || this.b(this.myStart + 2))) {
            IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            if (iElementType == null) {
                PyStringLiteralLexerBase.a(3);
            }
            return iElementType;
        }
        if (c10 == 'u' || c10 == 'U') {
            if (this.isUnicodeMode()) {
                int n2 = c10 == 'u' ? 4 : 8;
                for (int i10 = this.myStart + 2; i10 < this.myStart + n2 + 2; ++i10) {
                    if (i10 < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i10))) continue;
                    IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                    if (iElementType == null) {
                        PyStringLiteralLexerBase.a(4);
                    }
                    return iElementType;
                }
                IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                if (iElementType == null) {
                    PyStringLiteralLexerBase.a(5);
                }
                return iElementType;
            }
            IElementType iElementType = this.myOriginalLiteralToken;
            if (iElementType == null) {
                PyStringLiteralLexerBase.a(6);
            }
            return iElementType;
        }
        if (c10 == 'x') {
            for (int i11 = this.myStart + 2; i11 < this.myStart + 4; ++i11) {
                if (i11 < this.myEnd && StringUtil.isHexDigit((char)this.myBuffer.charAt(i11))) continue;
                IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                if (iElementType == null) {
                    PyStringLiteralLexerBase.a(7);
                }
                return iElementType;
            }
            IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            if (iElementType == null) {
                PyStringLiteralLexerBase.a(8);
            }
            return iElementType;
        }
        if (c10 == 'N' && this.isUnicodeMode()) {
            int n3 = this.myStart + 2;
            if (n3 >= this.myEnd || this.myBuffer.charAt(n3) != '{') {
                IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                if (iElementType == null) {
                    PyStringLiteralLexerBase.a(9);
                }
                return iElementType;
            }
            ++n3;
            while (n3 < this.myEnd && this.myBuffer.charAt(n3) != '}') {
                ++n3;
            }
            if (n3 >= this.myEnd) {
                IElementType iElementType = StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN;
                if (iElementType == null) {
                    PyStringLiteralLexerBase.a(10);
                }
                return iElementType;
            }
            IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
            if (iElementType == null) {
                PyStringLiteralLexerBase.a(11);
            }
            return iElementType;
        }
        switch (c10) {
            case '\"': 
            case '\'': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '\\': 
            case 'a': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': 
            case 'v': {
                IElementType iElementType = StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN;
                if (iElementType == null) {
                    PyStringLiteralLexerBase.a(12);
                }
                return iElementType;
            }
        }
        IElementType iElementType = this.myOriginalLiteralToken;
        if (iElementType == null) {
            PyStringLiteralLexerBase.a(13);
        }
        return iElementType;
    }

    private boolean a() {
        if (this.myStart + 1 < this.myEnd) {
            char c10 = this.myBuffer.charAt(this.myStart + 1);
            return c10 == 'u' || c10 == 'U';
        }
        return false;
    }

    private boolean b(int n2) {
        for (int i10 = n2; i10 < this.myBufferEnd; i10 += 2) {
            char c10 = this.myBuffer.charAt(i10);
            if (c10 != '\\') {
                return false;
            }
            if (i10 == this.myBufferEnd - 1) {
                return false;
            }
            if (this.myBuffer.charAt(i10 + 1) == ' ') continue;
            return false;
        }
        return true;
    }

    public final int getTokenStart() {
        assert (this.myStart < this.myEnd || this.myStart == this.myEnd && this.myEnd == this.myBufferEnd);
        return this.myStart;
    }

    public final int getTokenEnd() {
        long l2 = k ^ 0x588AECF44F84L;
        if (this.myStart >= this.myEnd && (this.myStart != this.myEnd || this.myEnd != this.myBufferEnd)) {
            LOG.error("myStart=" + this.myStart + " myEnd=" + this.myEnd + " myBufferEnd=" + this.myBufferEnd + " text=" + this.myBuffer.subSequence(this.myStart, this.myBufferEnd));
        }
        return this.myEnd;
    }

    public final int getBufferEnd() {
        return this.myBufferEnd;
    }

    @NotNull
    public final CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBuffer;
        if (charSequence == null) {
            PyStringLiteralLexerBase.a(14);
        }
        return charSequence;
    }

    protected abstract int locateToken(int var1);

    protected final int locateEscapeSequence(int start2) {
        assert (this.myBuffer.charAt(start2) == '\\');
        int n2 = start2;
        ++n2;
        if (this.isRaw()) {
            return n2;
        }
        if (n2 == this.myBufferEnd) {
            return n2;
        }
        if (this.myBuffer.charAt(n2) >= '0' && this.myBuffer.charAt(n2) <= '7') {
            char c10 = this.myBuffer.charAt(n2);
            if (++n2 < this.myBufferEnd && this.myBuffer.charAt(n2) >= '0' && this.myBuffer.charAt(n2) <= '7' && ++n2 < this.myBufferEnd && c10 <= '3' && this.myBuffer.charAt(n2) >= '0' && this.myBuffer.charAt(n2) <= '7') {
                ++n2;
            }
            return n2;
        }
        if (this.myBuffer.charAt(n2) == 'x') {
            ++n2;
            while (n2 < start2 + 4) {
                if (this.isEscapeEnd(n2)) {
                    return n2;
                }
                ++n2;
            }
            return n2;
        }
        if (this.myBuffer.charAt(n2) == 'u' || this.myBuffer.charAt(n2) == 'U') {
            int n3 = this.myBuffer.charAt(n2) == 'u' ? 4 : 8;
            ++n2;
            while (n2 < start2 + n3 + 2) {
                if (this.isEscapeEnd(n2)) {
                    return n2;
                }
                ++n2;
            }
            return n2;
        }
        if (this.myBuffer.charAt(n2) == 'N' && this.isUnicodeMode()) {
            ++n2;
            while (n2 < this.myBufferEnd && this.myBuffer.charAt(n2) != '}' && this.myBuffer.charAt(n2) != '\\') {
                ++n2;
            }
            if (n2 < this.myBufferEnd && this.myBuffer.charAt(n2) == '}') {
                ++n2;
            }
            return n2;
        }
        return n2 + 1;
    }

    protected boolean isEscapeEnd(int offset) {
        return offset == this.myBufferEnd || this.myBuffer.charAt(offset) == '\n' || this.myBuffer.charAt(offset) == '\\';
    }

    public void advance() {
        long l2 = k ^ 0xD12374ECD03L;
        this.myStart = this.myEnd;
        this.myEnd = this.locateToken(this.myStart);
        if (this.myStart >= this.myEnd && (this.myStart != this.myEnd || this.myEnd != this.myBufferEnd)) {
            LOG.warn("Inconsistent: start " + this.myStart + ", end " + this.myEnd + ", buf end " + this.myBufferEnd);
        }
    }

    static {
        k = c.a(7583385712579516808L, 5774915942089969782L, MethodHandles.lookup().lookupClass()).a(60664564293206L);
        long l2 = k ^ 0x130ED1BD1694L;
        LOG = Logger.getInstance((String)"#com.jetbrains.python.lexer.PyStringLiteralLexer");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = k ^ 0x45909065F385L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/lexer/PyStringLiteralLexerBase";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/lexer/PyStringLiteralLexerBase";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapeSequenceType";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getBufferSequence";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "start";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "handleStart";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

