/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.inspections.quickfix.DictCreationQuickFix;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyDictLiteralExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PySubscriptionExpression;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDictCreationInspection
extends PyInspection {
    private static final long a = c.a(-3646809772167161800L, -4736897121721967778L, MethodHandles.lookup().lookupClass()).a(251116017156274L);

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = a ^ 0x2C5BFFC7986CL;
        String string = PyBundle.message("INSP.NAME.dict.creation", new Object[0]);
        if (string == null) {
            PyDictCreationInspection.b(0);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyDictCreationInspection.b(1);
        }
        if (session == null) {
            PyDictCreationInspection.b(2);
        }
        Visitor visitor2 = new Visitor(holder, session);
        if (visitor2 == null) {
            PyDictCreationInspection.b(3);
        }
        return visitor2;
    }

    @Nullable
    public static List<Pair<PyExpression, PyExpression>> getDictTargets(@NotNull PyExpression target, @NotNull String name, @NotNull PyAssignmentStatement assignmentStatement) {
        if (target == null) {
            PyDictCreationInspection.b(4);
        }
        if (name == null) {
            PyDictCreationInspection.b(5);
        }
        if (assignmentStatement == null) {
            PyDictCreationInspection.b(6);
        }
        ArrayList<Pair<PyExpression, PyExpression>> arrayList = new ArrayList<Pair<PyExpression, PyExpression>>();
        for (Pair<PyExpression, PyExpression> pair : assignmentStatement.getTargetsToValuesMapping()) {
            if (pair.first instanceof PySubscriptionExpression) {
                PySubscriptionExpression pySubscriptionExpression = (PySubscriptionExpression)pair.first;
                if (!name.equals(pySubscriptionExpression.getOperand().getName()) || pySubscriptionExpression.getIndexExpression() == null || PyDictCreationInspection.a((PyExpression)pair.second, (PsiElement)target)) continue;
                arrayList.add(pair);
                continue;
            }
            return null;
        }
        return arrayList;
    }

    private static boolean a(@NotNull PyExpression pyExpression, final @NotNull PsiElement psiElement) {
        if (pyExpression == null) {
            PyDictCreationInspection.b(7);
        }
        if (psiElement == null) {
            PyDictCreationInspection.b(8);
        }
        final ArrayList arrayList = new ArrayList();
        pyExpression.accept(new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(PyReferenceExpression node) {
                super.visitPyReferenceExpression(node);
                PsiPolyVariantReference psiPolyVariantReference = node.getReference();
                if (psiPolyVariantReference.isReferenceTo(psiElement)) {
                    arrayList.add(node);
                }
            }
        });
        return !arrayList.isEmpty();
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x639BD88AB64BL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyDictCreationInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "assignmentStatement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyDictCreationInspection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDictTargets";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "referencesTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends PyInspectionVisitor {
        private static final long c = com.jetbrains.python.psi.c.a(4525370099417440053L, 2343629563664779556L, MethodHandles.lookup().lookupClass()).a(280107895292063L);

        Visitor(@Nullable ProblemsHolder holder, @NotNull LocalInspectionToolSession session) {
            if (session == null) {
                Visitor.b(0);
            }
            super(holder, session);
        }

        @Override
        public void visitPyAssignmentStatement(PyAssignmentStatement node) {
            long l2 = c ^ 0x7D60859772FL;
            if (node.getAssignedValue() instanceof PyDictLiteralExpression) {
                if (node.getTargets().length != 1) {
                    return;
                }
                PyExpression pyExpression = node.getTargets()[0];
                String string = pyExpression.getName();
                if (string == null) {
                    return;
                }
                PyStatement pyStatement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)node, PyStatement.class);
                while (pyStatement instanceof PyAssignmentStatement) {
                    PyAssignmentStatement pyAssignmentStatement = (PyAssignmentStatement)pyStatement;
                    List<Pair<PyExpression, PyExpression>> list2 = PyDictCreationInspection.getDictTargets(pyExpression, string, pyAssignmentStatement);
                    if (list2 == null) {
                        return;
                    }
                    if (!list2.isEmpty()) {
                        this.registerProblem((PsiElement)node, "This dictionary creation could be rewritten as a dictionary literal", new DictCreationQuickFix(node));
                        break;
                    }
                    pyStatement = (PyStatement)PsiTreeUtil.getNextSiblingOfType((PsiElement)pyAssignmentStatement, PyStatement.class);
                }
            }
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = c ^ 0x4B550B2C75E1L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/jetbrains/python/inspections/PyDictCreationInspection$Visitor", "<init>"));
        }
    }
}

