/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.google.common.collect.ImmutableList;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.util.ElementsChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.quickfix.PyRenameElementQuickFix;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIfStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTryExceptStatement;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.validation.CompatibilityVisitor;
import com.jetbrains.python.validation.UnsupportedFeaturesUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyCompatibilityInspection
extends PyInspection {
    @NotNull
    public static final List<String> BACKPORTED_PACKAGES;
    public static final List<String> COMPATIBILITY_LIBS;
    public static final int LATEST_INSPECTION_VERSION = 3;
    @NotNull
    public static final List<LanguageLevel> DEFAULT_PYTHON_VERSIONS;
    @NotNull
    public static final List<LanguageLevel> SUPPORTED_LEVELS;
    @NotNull
    private static final List<String> a;
    public JDOMExternalizableStringList ourVersions = new JDOMExternalizableStringList();
    private static final long b;

    public PyCompatibilityInspection() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.ourVersions.addAll(a);
        } else {
            this.ourVersions.addAll((Collection)ContainerUtil.map(DEFAULT_PYTHON_VERSIONS, LanguageLevel::toString));
        }
    }

    @Nullable
    public static PyCompatibilityInspection getInstance(@NotNull PsiElement element) {
        if (element == null) {
            PyCompatibilityInspection.b(0);
        }
        InspectionProfileImpl inspectionProfileImpl = InspectionProjectProfileManager.getInstance((Project)element.getProject()).getCurrentProfile();
        String string = PyCompatibilityInspection.class.getSimpleName();
        return (PyCompatibilityInspection)inspectionProfileImpl.getUnwrappedTool(string, element);
    }

    @Override
    public boolean isEnabledByDefault() {
        return false;
    }

    private List<LanguageLevel> a() {
        ArrayList<LanguageLevel> arrayList = new ArrayList<LanguageLevel>();
        for (String string : this.ourVersions) {
            if (!a.contains(string)) continue;
            LanguageLevel languageLevel = LanguageLevel.fromPythonVersion(string);
            arrayList.add(languageLevel);
        }
        return arrayList;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        long l2 = b ^ 0x41C3172E0DAEL;
        String string = PyBundle.message("INSP.NAME.compatibility", new Object[0]);
        if (string == null) {
            PyCompatibilityInspection.b(1);
        }
        return string;
    }

    public JComponent createOptionsPanel() {
        long l2 = b ^ 0x4407790C1C75L;
        final ElementsChooser elementsChooser = new ElementsChooser(true);
        elementsChooser.setElements(a, false);
        elementsChooser.markElements((Collection)ContainerUtil.filter((Collection)this.ourVersions, a::contains));
        elementsChooser.addElementsMarkListener((ElementsChooser.ElementsMarkListener)new ElementsChooser.ElementsMarkListener<String>(){

            public void elementMarkChanged(String element, boolean isMarked) {
                PyCompatibilityInspection.this.ourVersions.clear();
                PyCompatibilityInspection.this.ourVersions.addAll((Collection)elementsChooser.getMarkedElements());
            }
        });
        JPanel jPanel = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel("Check for compatibility with python versions:");
        jLabel.setLabelFor((Component)elementsChooser);
        jPanel.add((Component)jLabel, "First");
        jPanel.add((Component)elementsChooser);
        return jPanel;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            PyCompatibilityInspection.b(2);
        }
        Visitor visitor2 = new Visitor(holder, this.a());
        if (visitor2 == null) {
            PyCompatibilityInspection.b(3);
        }
        return visitor2;
    }

    static {
        b = c.a(-2769573750989820424L, -5282672600216201742L, MethodHandles.lookup().lookupClass()).a(136504198028330L);
        long l2 = b ^ 0x3B611645BD78L;
        BACKPORTED_PACKAGES = ImmutableList.builder().add((Object)"enum").add((Object)"typing").build();
        COMPATIBILITY_LIBS = Collections.singletonList("six");
        DEFAULT_PYTHON_VERSIONS = ImmutableList.of((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.getLatest()));
        SUPPORTED_LEVELS = ((StreamEx)StreamEx.of((Object[])LanguageLevel.values()).filter(languageLevel -> languageLevel.isPython2() && languageLevel.isAtLeast(LanguageLevel.PYTHON26) || languageLevel.isAtLeast(LanguageLevel.PYTHON34))).toImmutableList();
        a = ContainerUtil.map(SUPPORTED_LEVELS, LanguageLevel::toString);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x216D4E87423BL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/PyCompatibilityInspection";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/PyCompatibilityInspection";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Visitor
    extends CompatibilityVisitor {
        private final ProblemsHolder g;
        private final Set<String> h = Collections.synchronizedSet(new HashSet());
        private final Set<String> f = Collections.synchronizedSet(new HashSet());
        private static final long i = c.a(604525240046323204L, -7514314931767936565L, MethodHandles.lookup().lookupClass()).a(272351862695636L);

        Visitor(ProblemsHolder holder, List<LanguageLevel> versionsToProcess) {
            super(versionsToProcess);
            this.g = holder;
        }

        @Override
        protected void registerProblem(@NotNull PsiElement element, @NotNull TextRange range, @NotNull String message, @Nullable LocalQuickFix quickFix, boolean asError) {
            if (element == null) {
                Visitor.c(0);
            }
            if (range == null) {
                Visitor.c(1);
            }
            if (message == null) {
                Visitor.c(2);
            }
            if (element.getTextLength() == 0) {
                return;
            }
            range = range.shiftRight(-element.getTextRange().getStartOffset());
            if (quickFix != null) {
                this.g.registerProblem(element, range, message, new LocalQuickFix[]{quickFix});
            } else {
                this.g.registerProblem(element, range, message, new LocalQuickFix[0]);
            }
        }

        @Override
        public void visitPyCallExpression(PyCallExpression node) {
            PyTargetExpression pyTargetExpression;
            long l2 = i ^ 0x30208461D975L;
            super.visitPyCallExpression(node);
            PyExpression pyExpression = node.getCallee();
            if (pyExpression != null && this.a(pyExpression)) {
                return;
            }
            PsiElement psiElement = Optional.ofNullable(pyExpression).map(PsiElement::getReference).map(PsiReference::resolve).orElse(null);
            if (psiElement instanceof PyFunction) {
                String string;
                String string2;
                PyFunction pyFunction = (PyFunction)psiElement;
                PyClass pyClass = pyFunction.getContainingClass();
                String string3 = pyFunction.getName();
                String string4 = string2 = pyClass != null && "__init__".equals(string3) ? pyExpression.getText() : string3;
                if (pyClass != null && UnsupportedFeaturesUtil.CLASS_METHODS.containsKey(string = pyClass.getName())) {
                    Map<LanguageLevel, Set<String>> map2 = UnsupportedFeaturesUtil.CLASS_METHODS.get(string);
                    this.registerForAllMatchingVersions(languageLevel -> map2.getOrDefault(languageLevel, Collections.emptySet()).contains(string2), " not have method " + string2, (PsiElement)node);
                }
                if (PyBuiltinCache.getInstance(pyFunction).isBuiltin(pyFunction) && !"print".equals(string2) && !"exec".equals(string2) && !this.h.contains(string2)) {
                    this.registerForAllMatchingVersions(languageLevel -> UnsupportedFeaturesUtil.BUILTINS.get(languageLevel).contains(string2), " not have method " + string2, (PsiElement)node);
                }
            } else if (psiElement instanceof PyTargetExpression && !(pyTargetExpression = (PyTargetExpression)psiElement).isQualified() && "long".equals(pyTargetExpression.getName()) && PyBuiltinCache.getInstance(psiElement).isBuiltin(psiElement)) {
                this.registerForAllMatchingVersions(languageLevel -> {
                    long l2 = i ^ 0x2FEE75A21646L;
                    return UnsupportedFeaturesUtil.BUILTINS.get(languageLevel).contains("long");
                }, " not have type long. Use int instead.", (PsiElement)node);
            }
        }

        @Override
        public void visitPyImportElement(PyImportElement importElement) {
            QualifiedName qualifiedName;
            long l2 = i ^ 0x4B4DEB3F41AAL;
            this.h.add(importElement.getVisibleName());
            PyIfStatement pyIfStatement = (PyIfStatement)PsiTreeUtil.getParentOfType((PsiElement)importElement, PyIfStatement.class);
            if (pyIfStatement != null) {
                return;
            }
            PyTryExceptStatement pyTryExceptStatement = (PyTryExceptStatement)PsiTreeUtil.getParentOfType((PsiElement)importElement, PyTryExceptStatement.class);
            if (pyTryExceptStatement != null) {
                qualifiedName = pyTryExceptStatement.getExceptParts();
                int n2 = ((QualifiedName)qualifiedName).length;
                for (int i10 = 0; i10 < n2; ++i10) {
                    QualifiedName qualifiedName2 = qualifiedName[i10];
                    PyExpression pyExpression = qualifiedName2.getExceptClass();
                    if (pyExpression == null || !pyExpression.getText().equals("ImportError")) continue;
                    return;
                }
            }
            if ((qualifiedName = Visitor.a(importElement)) != null && !qualifiedName.matches(new String[]{"builtins"}) && !qualifiedName.matches(new String[]{"__builtin__"})) {
                if (COMPATIBILITY_LIBS.contains(qualifiedName.getFirstComponent())) {
                    this.f.add(qualifiedName.getLastComponent());
                }
                String string = qualifiedName.toString();
                this.registerForAllMatchingVersions(languageLevel -> UnsupportedFeaturesUtil.MODULES.get(languageLevel).contains(string) && !BACKPORTED_PACKAGES.contains(string), " not have module " + string, (PsiElement)importElement);
            }
        }

        @Nullable
        private static QualifiedName a(@NotNull PyImportElement pyImportElement) {
            QualifiedName qualifiedName;
            if (pyImportElement == null) {
                Visitor.c(3);
            }
            if ((qualifiedName = pyImportElement.getImportedQName()) == null) {
                return null;
            }
            PyStatement pyStatement = pyImportElement.getContainingImportStatement();
            QualifiedName qualifiedName2 = pyStatement instanceof PyFromImportStatement ? ((PyFromImportStatement)pyStatement).getImportSourceQName() : null;
            return qualifiedName2 == null ? qualifiedName : qualifiedName2.append(qualifiedName);
        }

        @Override
        public void visitPyFromImportStatement(PyFromImportStatement node) {
            long l2 = i ^ 0x532B16E7B894L;
            super.visitPyFromImportStatement(node);
            if (node.getRelativeLevel() > 0) {
                return;
            }
            QualifiedName qualifiedName = node.getImportSourceQName();
            PyReferenceExpression pyReferenceExpression = node.getImportSource();
            if (qualifiedName != null && pyReferenceExpression != null) {
                String string = qualifiedName.toString();
                this.registerForAllMatchingVersions(languageLevel -> UnsupportedFeaturesUtil.MODULES.get(languageLevel).contains(string) && !BACKPORTED_PACKAGES.contains(string), " not have module " + qualifiedName, (PsiElement)pyReferenceExpression);
            }
        }

        @Override
        public void visitPyArgumentList(PyArgumentList node) {
            block2: {
                boolean bl2;
                block3: {
                    if (!(node.getParent() instanceof PyClass)) break block2;
                    bl2 = LanguageLevel.forElement((PsiElement)node).isPython2();
                    if (bl2) break block3;
                    if (!this.myVersionsToProcess.stream().anyMatch(LanguageLevel::isPython2)) break block2;
                }
                Arrays.stream(node.getArguments()).filter(PyKeywordArgument.class::isInstance).forEach(pyExpression -> {
                    long l2 = i ^ 0x7C0B8A901B6FL;
                    this.g.registerProblem((PsiElement)pyExpression, "This syntax available only since py3", !bl2 ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.GENERIC_ERROR, new LocalQuickFix[0]);
                });
            }
        }

        @Override
        public void visitPyReferenceExpression(PyReferenceExpression node) {
            long l2 = i ^ 0x5F481C53FC06L;
            super.visitPyElement(node);
            if (this.myVersionsToProcess.stream().anyMatch(LanguageLevel::isPy3K)) {
                PyType pyType;
                TypeEvalContext typeEvalContext;
                PyExpression pyExpression;
                String string = node.getText();
                if ((string.endsWith("iteritems") || string.endsWith("iterkeys") || string.endsWith("itervalues")) && (pyExpression = node.getQualifier()) != null) {
                    typeEvalContext = TypeEvalContext.codeAnalysis(node.getProject(), node.getContainingFile());
                    pyType = typeEvalContext.getType(pyExpression);
                    PyClassType pyClassType = PyBuiltinCache.getInstance((PsiElement)node).getDictType();
                    if (PyTypeChecker.match(pyClassType, pyType, typeEvalContext)) {
                        this.registerProblem((PsiElement)node, "dict.iterkeys(), dict.iteritems() and dict.itervalues() methods are not available in py3");
                    }
                }
                if ("basestring".equals(string) && (pyExpression = node.getReference().resolve()) != null) {
                    typeEvalContext = pyExpression.getContainingFile();
                    if (typeEvalContext != null) {
                        pyType = typeEvalContext.getVirtualFile();
                        if (pyType != null && ProjectRootManager.getInstance((Project)node.getProject()).getFileIndex().isInLibraryClasses((VirtualFile)pyType)) {
                            this.registerProblem((PsiElement)node, "basestring type is not available in py3");
                        }
                    } else {
                        this.registerProblem((PsiElement)node, "basestring type is not available in py3");
                    }
                }
            }
        }

        @Override
        public void visitPyTargetExpression(PyTargetExpression node) {
            super.visitPyTargetExpression(node);
            this.a(node);
        }

        @Override
        public void visitPyClass(PyClass node) {
            super.visitPyClass(node);
            this.a(node);
        }

        @Override
        public void visitPyFunction(PyFunction node) {
            super.visitPyFunction(node);
            this.a(node);
        }

        @Override
        protected boolean registerForLanguageLevel(@NotNull LanguageLevel level) {
            if (level == null) {
                Visitor.c(4);
            }
            return level != LanguageLevel.forElement((PsiElement)this.g.getFile());
        }

        private void a(@NotNull PsiNameIdentifierOwner psiNameIdentifierOwner) {
            PsiElement psiElement;
            long l2 = i ^ 0x61BB95B6841CL;
            if (psiNameIdentifierOwner == null) {
                Visitor.c(5);
            }
            if ((psiElement = psiNameIdentifierOwner.getNameIdentifier()) != null && ArrayUtil.contains((String)psiNameIdentifierOwner.getName(), (String[])new String[]{"await", "async"}) && LanguageLevel.forElement((PsiElement)psiNameIdentifierOwner).isOlderThan(LanguageLevel.PYTHON37)) {
                this.registerForAllMatchingVersions((LanguageLevel languageLevel) -> languageLevel.isAtLeast(LanguageLevel.PYTHON37), " not allow 'async' and 'await' as names", psiElement, (LocalQuickFix)new PyRenameElementQuickFix((PsiElement)psiNameIdentifierOwner));
            }
        }

        private boolean a(@NotNull PyExpression pyExpression) {
            if (pyExpression == null) {
                Visitor.c(6);
            }
            if (pyExpression instanceof PyQualifiedExpression) {
                QualifiedName qualifiedName = ((PyQualifiedExpression)pyExpression).asQualifiedName();
                return qualifiedName != null && this.f.contains(qualifiedName.getFirstComponent());
            }
            return this.f.contains(pyExpression.getName());
        }

        private static /* synthetic */ void c(int n2) {
            Object[] objectArray;
            Object[] objectArray2;
            long l2 = i ^ 0x54376330CA95L;
            Object[] objectArray3 = new Object[3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "range";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importElement";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "level";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "nameIdentifierOwner";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callee";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/python/inspections/PyCompatibilityInspection$Visitor";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerProblem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getImportedFullyQName";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "registerForLanguageLevel";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "warnAsyncAndAwaitAreBecomingKeywordsInPy37";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "importedFromCompatibilityLibs";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

