/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.highlighting;

import com.intellij.lexer.LayeredLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonDialectsTokenSetProvider;
import com.jetbrains.python.lexer.PyFStringLiteralLexer;
import com.jetbrains.python.lexer.PyStringLiteralLexer;
import com.jetbrains.python.lexer.PythonHighlightingLexer;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyHighlighter
extends SyntaxHighlighterBase {
    private final Map<IElementType, TextAttributesKey> a;
    private final LanguageLevel b;
    public static final TextAttributesKey PY_KEYWORD;
    public static final TextAttributesKey PY_BYTE_STRING;
    public static final TextAttributesKey PY_UNICODE_STRING;
    public static final TextAttributesKey PY_NUMBER;
    static final TextAttributesKey PY_OPERATION_SIGN;
    static final TextAttributesKey PY_PARENTHS;
    static final TextAttributesKey PY_BRACKETS;
    static final TextAttributesKey PY_BRACES;
    static final TextAttributesKey PY_COMMA;
    static final TextAttributesKey PY_DOT;
    public static final TextAttributesKey PY_LINE_COMMENT;
    public static final TextAttributesKey PY_DOC_COMMENT;
    public static final TextAttributesKey PY_DOC_COMMENT_TAG;
    public static final TextAttributesKey PY_DECORATOR;
    public static final TextAttributesKey PY_CLASS_DEFINITION;
    public static final TextAttributesKey PY_FUNC_DEFINITION;
    public static final TextAttributesKey PY_PREDEFINED_DEFINITION;
    public static final TextAttributesKey PY_PREDEFINED_USAGE;
    public static final TextAttributesKey PY_BUILTIN_NAME;
    public static final TextAttributesKey PY_PARAMETER;
    public static final TextAttributesKey PY_SELF_PARAMETER;
    public static final TextAttributesKey PY_KEYWORD_ARGUMENT;
    public static final TextAttributesKey PY_FUNCTION_CALL;
    public static final TextAttributesKey PY_METHOD_CALL;
    public static final TextAttributesKey PY_ANNOTATION;
    public static final TextAttributesKey PY_VALID_STRING_ESCAPE;
    public static final TextAttributesKey PY_INVALID_STRING_ESCAPE;
    public static final TextAttributesKey PY_FSTRING_FRAGMENT_BRACES;
    public static final TextAttributesKey PY_FSTRING_FRAGMENT_COLON;
    public static final TextAttributesKey PY_FSTRING_FRAGMENT_TYPE_CONVERSION;
    private static final long c;

    @NotNull
    public Lexer getHighlightingLexer() {
        LayeredLexer layeredLexer = new LayeredLexer((Lexer)this.createHighlightingLexer(this.b));
        layeredLexer.registerLayer((Lexer)new PyStringLiteralLexer(PyTokenTypes.SINGLE_QUOTED_STRING), new IElementType[]{PyTokenTypes.SINGLE_QUOTED_STRING});
        layeredLexer.registerLayer((Lexer)new PyStringLiteralLexer(PyTokenTypes.SINGLE_QUOTED_UNICODE), new IElementType[]{PyTokenTypes.SINGLE_QUOTED_UNICODE});
        layeredLexer.registerLayer((Lexer)new PyStringLiteralLexer(PyTokenTypes.TRIPLE_QUOTED_STRING), new IElementType[]{PyTokenTypes.TRIPLE_QUOTED_STRING});
        layeredLexer.registerLayer((Lexer)new PyStringLiteralLexer(PyTokenTypes.TRIPLE_QUOTED_UNICODE), new IElementType[]{PyTokenTypes.TRIPLE_QUOTED_UNICODE});
        layeredLexer.registerLayer((Lexer)new PyFStringLiteralLexer(), new IElementType[]{PyTokenTypes.FSTRING_TEXT});
        LayeredLexer layeredLexer2 = layeredLexer;
        if (layeredLexer2 == null) {
            PyHighlighter.a(0);
        }
        return layeredLexer2;
    }

    protected PythonHighlightingLexer createHighlightingLexer(LanguageLevel languageLevel) {
        return new PythonHighlightingLexer(this.b);
    }

    public PyHighlighter(LanguageLevel languageLevel) {
        this.b = languageLevel;
        this.a = new HashMap<IElementType, TextAttributesKey>();
        PyHighlighter.fillMap(this.a, (TokenSet)PythonDialectsTokenSetProvider.INSTANCE.getKeywordTokens(), (TextAttributesKey)PY_KEYWORD);
        PyHighlighter.fillMap(this.a, (TokenSet)PyTokenTypes.OPERATIONS, (TextAttributesKey)PY_OPERATION_SIGN);
        this.a.put(PyTokenTypes.INTEGER_LITERAL, PY_NUMBER);
        this.a.put(PyTokenTypes.FLOAT_LITERAL, PY_NUMBER);
        this.a.put(PyTokenTypes.IMAGINARY_LITERAL, PY_NUMBER);
        this.a.put(PyTokenTypes.SINGLE_QUOTED_STRING, PY_BYTE_STRING);
        this.a.put(PyTokenTypes.TRIPLE_QUOTED_STRING, PY_BYTE_STRING);
        this.a.put(PyTokenTypes.SINGLE_QUOTED_UNICODE, PY_UNICODE_STRING);
        this.a.put(PyTokenTypes.TRIPLE_QUOTED_UNICODE, PY_UNICODE_STRING);
        this.a.put(PyTokenTypes.FSTRING_START, PY_UNICODE_STRING);
        this.a.put(PyTokenTypes.FSTRING_END, PY_UNICODE_STRING);
        this.a.put(PyTokenTypes.FSTRING_TEXT, PY_UNICODE_STRING);
        this.a.put(PyTokenTypes.FSTRING_FRAGMENT_TYPE_CONVERSION, PY_FSTRING_FRAGMENT_TYPE_CONVERSION);
        this.a.put(PyTokenTypes.FSTRING_FRAGMENT_FORMAT_START, PY_FSTRING_FRAGMENT_COLON);
        this.a.put(PyTokenTypes.FSTRING_FRAGMENT_START, PY_FSTRING_FRAGMENT_BRACES);
        this.a.put(PyTokenTypes.FSTRING_FRAGMENT_END, PY_FSTRING_FRAGMENT_BRACES);
        this.a.put(PyTokenTypes.DOCSTRING, PY_DOC_COMMENT);
        this.a.put(PyTokenTypes.LPAR, PY_PARENTHS);
        this.a.put(PyTokenTypes.RPAR, PY_PARENTHS);
        this.a.put(PyTokenTypes.LBRACE, PY_BRACES);
        this.a.put(PyTokenTypes.RBRACE, PY_BRACES);
        this.a.put(PyTokenTypes.LBRACKET, PY_BRACKETS);
        this.a.put(PyTokenTypes.RBRACKET, PY_BRACKETS);
        this.a.put(PyTokenTypes.COMMA, PY_COMMA);
        this.a.put(PyTokenTypes.DOT, PY_DOT);
        this.a.put(PyTokenTypes.END_OF_LINE_COMMENT, PY_LINE_COMMENT);
        this.a.put(PyTokenTypes.BAD_CHARACTER, HighlighterColors.BAD_CHARACTER);
        this.a.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, PY_VALID_STRING_ESCAPE);
        this.a.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, PY_INVALID_STRING_ESCAPE);
        this.a.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, PY_INVALID_STRING_ESCAPE);
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = PyHighlighter.pack((TextAttributesKey)this.a.get(tokenType));
        if (textAttributesKeyArray == null) {
            PyHighlighter.a(1);
        }
        return textAttributesKeyArray;
    }

    static {
        c = com.jetbrains.python.psi.c.a(4226461474619208707L, -229356125063481130L, MethodHandles.lookup().lookupClass()).a(160691996883419L);
        long l2 = c ^ 0x72C11311BF5AL;
        PY_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"PY.KEYWORD", (TextAttributesKey)DefaultLanguageHighlighterColors.KEYWORD);
        PY_BYTE_STRING = TextAttributesKey.createTextAttributesKey((String)"PY.STRING.B", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        PY_UNICODE_STRING = TextAttributesKey.createTextAttributesKey((String)"PY.STRING.U", (TextAttributesKey)DefaultLanguageHighlighterColors.STRING);
        PY_NUMBER = TextAttributesKey.createTextAttributesKey((String)"PY.NUMBER", (TextAttributesKey)DefaultLanguageHighlighterColors.NUMBER);
        PY_OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)"PY.OPERATION_SIGN", (TextAttributesKey)DefaultLanguageHighlighterColors.OPERATION_SIGN);
        PY_PARENTHS = TextAttributesKey.createTextAttributesKey((String)"PY.PARENTHS", (TextAttributesKey)DefaultLanguageHighlighterColors.PARENTHESES);
        PY_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"PY.BRACKETS", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACKETS);
        PY_BRACES = TextAttributesKey.createTextAttributesKey((String)"PY.BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.BRACES);
        PY_COMMA = TextAttributesKey.createTextAttributesKey((String)"PY.COMMA", (TextAttributesKey)DefaultLanguageHighlighterColors.COMMA);
        PY_DOT = TextAttributesKey.createTextAttributesKey((String)"PY.DOT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOT);
        PY_LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"PY.LINE_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.LINE_COMMENT);
        PY_DOC_COMMENT = TextAttributesKey.createTextAttributesKey((String)"PY.DOC_COMMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT);
        PY_DOC_COMMENT_TAG = TextAttributesKey.createTextAttributesKey((String)"PY.DOC_COMMENT_TAG", (TextAttributesKey)DefaultLanguageHighlighterColors.DOC_COMMENT_TAG);
        PY_DECORATOR = TextAttributesKey.createTextAttributesKey((String)"PY.DECORATOR", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
        PY_CLASS_DEFINITION = TextAttributesKey.createTextAttributesKey((String)"PY.CLASS_DEFINITION", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
        PY_FUNC_DEFINITION = TextAttributesKey.createTextAttributesKey((String)"PY.FUNC_DEFINITION", (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_DECLARATION);
        PY_PREDEFINED_DEFINITION = TextAttributesKey.createTextAttributesKey((String)"PY.PREDEFINED_DEFINITION", (TextAttributesKey)DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL);
        PY_PREDEFINED_USAGE = TextAttributesKey.createTextAttributesKey((String)"PY.PREDEFINED_USAGE", (TextAttributesKey)DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL);
        PY_BUILTIN_NAME = TextAttributesKey.createTextAttributesKey((String)"PY.BUILTIN_NAME", (TextAttributesKey)DefaultLanguageHighlighterColors.PREDEFINED_SYMBOL);
        PY_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"PY.PARAMETER", (TextAttributesKey)DefaultLanguageHighlighterColors.PARAMETER);
        PY_SELF_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"PY.SELF_PARAMETER", (TextAttributesKey)DefaultLanguageHighlighterColors.PARAMETER);
        PY_KEYWORD_ARGUMENT = TextAttributesKey.createTextAttributesKey((String)"PY.KEYWORD_ARGUMENT", (TextAttributesKey)DefaultLanguageHighlighterColors.PARAMETER);
        PY_FUNCTION_CALL = TextAttributesKey.createTextAttributesKey((String)"PY.FUNCTION_CALL", (TextAttributesKey)DefaultLanguageHighlighterColors.FUNCTION_CALL);
        PY_METHOD_CALL = TextAttributesKey.createTextAttributesKey((String)"PY.METHOD_CALL", (TextAttributesKey)PY_FUNCTION_CALL);
        PY_ANNOTATION = TextAttributesKey.createTextAttributesKey((String)"PY.ANNOTATION", (TextAttributesKey)DefaultLanguageHighlighterColors.IDENTIFIER);
        PY_VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"PY.VALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        PY_INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"PY.INVALID_STRING_ESCAPE", (TextAttributesKey)DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
        PY_FSTRING_FRAGMENT_BRACES = TextAttributesKey.createTextAttributesKey((String)"PY.FSTRING_FRAGMENT_BRACES", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        PY_FSTRING_FRAGMENT_COLON = TextAttributesKey.createTextAttributesKey((String)"PY.FSTRING_FRAGMENT_COLON", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        PY_FSTRING_FRAGMENT_TYPE_CONVERSION = TextAttributesKey.createTextAttributesKey((String)"PY.FSTRING_FRAGMENT_TYPE_CONVERSION", (TextAttributesKey)DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = c ^ 0x355C5564B732L;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/highlighting/PyHighlighter";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightingLexer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

