/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.editorActions.emacs.EmacsProcessingHandler;
import com.intellij.formatting.IndentInfo;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PySequenceExpression;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PyEmacsHandler
implements EmacsProcessingHandler {
    private static final TokenSet a;
    private static final long b;

    @NotNull
    public EmacsProcessingHandler.Result changeIndent(@NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        int n2;
        int n3;
        SelectionModel selectionModel;
        if (project == null) {
            PyEmacsHandler.a(0);
        }
        if (editor2 == null) {
            PyEmacsHandler.a(1);
        }
        if (file == null) {
            PyEmacsHandler.a(2);
        }
        if ((selectionModel = editor2.getSelectionModel()).hasSelection()) {
            EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.CONTINUE;
            if (result == null) {
                PyEmacsHandler.a(3);
            }
            return result;
        }
        Document document = editor2.getDocument();
        if (DocumentUtil.isLineEmpty((Document)document, (int)(n3 = document.getLineNumber(n2 = editor2.getCaretModel().getOffset())))) {
            EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.CONTINUE;
            if (result == null) {
                PyEmacsHandler.a(4);
            }
            return result;
        }
        ChangeIndentContext changeIndentContext = new ChangeIndentContext(project, file, editor2, document, n3);
        int n4 = PyEmacsHandler.b(changeIndentContext, changeIndentContext.targetLine);
        int n5 = PyEmacsHandler.a(changeIndentContext);
        int n6 = changeIndentContext.document.getLineStartOffset(changeIndentContext.targetLine);
        if (n2 - n6 < n4) {
            PyEmacsHandler.a(changeIndentContext, n5);
            EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.STOP;
            if (result == null) {
                PyEmacsHandler.a(5);
            }
            return result;
        }
        switch (PyEmacsHandler.c(changeIndentContext)) {
            case STOP_SUCCESSFUL: {
                EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.STOP;
                if (result == null) {
                    PyEmacsHandler.a(6);
                }
                return result;
            }
            case STOP_UNSUCCESSFUL: {
                EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.CONTINUE;
                if (result == null) {
                    PyEmacsHandler.a(7);
                }
                return result;
            }
        }
        if (PyEmacsHandler.b(changeIndentContext)) {
            EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.STOP;
            if (result == null) {
                PyEmacsHandler.a(8);
            }
            return result;
        }
        EmacsProcessingHandler.Result result = EmacsProcessingHandler.Result.CONTINUE;
        if (result == null) {
            PyEmacsHandler.a(9);
        }
        return result;
    }

    private static int a(@NotNull ChangeIndentContext changeIndentContext) {
        int n2;
        if (changeIndentContext == null) {
            PyEmacsHandler.a(10);
        }
        PsiElement psiElement = changeIndentContext.file.findElementAt(changeIndentContext.editor.getCaretModel().getOffset());
        for (n2 = changeIndentContext.targetLine - 1; n2 >= 0 && DocumentUtil.isLineEmpty((Document)changeIndentContext.document, (int)n2); --n2) {
        }
        if (n2 < 0) {
            return -1;
        }
        int n3 = PyEmacsHandler.b(changeIndentContext, n2);
        int n4 = -1;
        if (PyEmacsHandler.d(changeIndentContext, n2)) {
            n4 = n3 + changeIndentContext.getIndentOptions().INDENT_SIZE;
        } else if (PsiTreeUtil.getParentOfType((PsiElement)psiElement, PySequenceExpression.class) != null && n3 == 0) {
            n4 = changeIndentContext.getIndentOptions().INDENT_SIZE;
        } else if (n3 < PyEmacsHandler.b(changeIndentContext, changeIndentContext.targetLine)) {
            n4 = n3;
        }
        return n4;
    }

    private static ProcessingResult c(@NotNull ChangeIndentContext changeIndentContext) {
        if (changeIndentContext == null) {
            PyEmacsHandler.a(11);
        }
        int n2 = PyEmacsHandler.b(changeIndentContext, changeIndentContext.targetLine);
        List<LineInfo> list2 = PyEmacsHandler.c(changeIndentContext, changeIndentContext.targetLine);
        int n3 = -1;
        for (int i10 = list2.size() - 1; i10 >= 0; --i10) {
            LineInfo lineInfo = list2.get(i10);
            if (lineInfo.indent == n2 && !lineInfo.startsWithCompoundStatement) continue;
            n3 = lineInfo.indent;
            if (!lineInfo.startsWithCompoundStatement) break;
            n3 += changeIndentContext.getIndentOptions().INDENT_SIZE;
            break;
        }
        if (n3 == n2 || n3 < 0) {
            return ProcessingResult.CONTINUE;
        }
        PyEmacsHandler.a(changeIndentContext, n3);
        return ProcessingResult.STOP_SUCCESSFUL;
    }

    private static boolean b(@NotNull ChangeIndentContext changeIndentContext) {
        if (changeIndentContext == null) {
            PyEmacsHandler.a(12);
        }
        if (changeIndentContext.targetLine == 0 || !PyEmacsHandler.a(changeIndentContext.document, 0, changeIndentContext.targetLine)) {
            PyEmacsHandler.a(changeIndentContext, 0);
            return false;
        }
        int n2 = -1;
        for (int i10 = 0; i10 < changeIndentContext.targetLine; ++i10) {
            if (DocumentUtil.isLineEmpty((Document)changeIndentContext.document, (int)i10)) continue;
            int n3 = PyEmacsHandler.b(changeIndentContext, i10);
            if (PyEmacsHandler.d(changeIndentContext, i10)) {
                n2 = n3;
                break;
            }
            if (n2 >= 0) continue;
            n2 = n3;
        }
        if (n2 < 0) {
            return false;
        }
        PyEmacsHandler.a(changeIndentContext, n2);
        return true;
    }

    private static void a(@NotNull ChangeIndentContext changeIndentContext, int n2) {
        if (changeIndentContext == null) {
            PyEmacsHandler.a(13);
        }
        int n3 = changeIndentContext.editor.getCaretModel().getOffset();
        String string = new IndentInfo(0, n2, 0).generateNewWhiteSpace(changeIndentContext.getIndentOptions());
        int n4 = changeIndentContext.document.getLineStartOffset(changeIndentContext.targetLine);
        int n5 = DocumentUtil.getFirstNonSpaceCharOffset((Document)changeIndentContext.document, (int)changeIndentContext.targetLine);
        changeIndentContext.editor.getDocument().replaceString(n4, n5, (CharSequence)string);
        if (n3 >= n4 && n3 < n5) {
            changeIndentContext.editor.getCaretModel().moveToOffset(n4 + string.length());
        }
    }

    private static boolean a(@NotNull Document document, int n2, int n3) {
        if (document == null) {
            PyEmacsHandler.a(14);
        }
        int n4 = document.getLineStartOffset(n2);
        int n5 = document.getLineStartOffset(n3);
        for (int i10 = n4; i10 < n5; ++i10) {
            if (DocumentUtil.isLineEmpty((Document)document, (int)i10)) continue;
            return true;
        }
        return false;
    }

    private static List<LineInfo> c(@NotNull ChangeIndentContext changeIndentContext, int n2) {
        if (changeIndentContext == null) {
            PyEmacsHandler.a(15);
        }
        ArrayList<LineInfo> arrayList = new ArrayList<LineInfo>();
        int n3 = PyEmacsHandler.b(changeIndentContext, n2);
        int n4 = PyEmacsHandler.a(changeIndentContext);
        if (n4 > 0) {
            arrayList.add(new LineInfo(n2, n4, false));
        } else {
            arrayList.add(new LineInfo(n2, n3, false));
        }
        int n5 = Integer.MAX_VALUE;
        for (int i10 = n2 - 1; i10 >= 0 && n5 > n3; --i10) {
            PsiElement psiElement;
            if (DocumentUtil.isLineEmpty((Document)changeIndentContext.document, (int)i10)) continue;
            int n6 = PyEmacsHandler.b(changeIndentContext, i10);
            if (n6 < n3) break;
            if (n6 >= n5 || (psiElement = changeIndentContext.file.findElementAt(changeIndentContext.document.getLineStartOffset(i10) + n6)) == null) continue;
            ASTNode aSTNode = psiElement.getNode();
            arrayList.add(new LineInfo(i10, n6, a.contains(aSTNode.getElementType())));
            n5 = n6;
        }
        return arrayList;
    }

    private static boolean d(@NotNull ChangeIndentContext changeIndentContext, int n2) {
        PsiElement psiElement;
        if (changeIndentContext == null) {
            PyEmacsHandler.a(16);
        }
        if ((psiElement = changeIndentContext.file.findElementAt(changeIndentContext.document.getLineStartOffset(n2) + PyEmacsHandler.b(changeIndentContext, n2))) == null) {
            return false;
        }
        ASTNode aSTNode = psiElement.getNode();
        if (aSTNode == null) {
            return false;
        }
        return a.contains(aSTNode.getElementType());
    }

    private static int b(@NotNull ChangeIndentContext changeIndentContext, int n2) {
        if (changeIndentContext == null) {
            PyEmacsHandler.a(17);
        }
        int n3 = changeIndentContext.document.getLineStartOffset(n2);
        int n4 = changeIndentContext.document.getLineEndOffset(n2);
        int n5 = 0;
        CharSequence charSequence = changeIndentContext.document.getCharsSequence();
        block4: for (int i10 = n3; i10 < n4; ++i10) {
            char c10 = charSequence.charAt(i10);
            switch (c10) {
                case ' ': {
                    ++n5;
                    continue block4;
                }
                case '\t': {
                    n5 += changeIndentContext.getIndentOptions().TAB_SIZE;
                    continue block4;
                }
                default: {
                    return n5;
                }
            }
        }
        return n5;
    }

    static {
        b = c.a(9170037755260182942L, 1148880563985129567L, MethodHandles.lookup().lookupClass()).a(187317345750709L);
        a = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.IF_STATEMENT, PyTokenTypes.IF_KEYWORD, PyTokenTypes.ELIF_KEYWORD, PyTokenTypes.ELSE_KEYWORD, PyElementTypes.WHILE_STATEMENT, PyTokenTypes.WHILE_KEYWORD, PyElementTypes.FOR_STATEMENT, PyTokenTypes.FOR_KEYWORD, PyElementTypes.WITH_STATEMENT, PyTokenTypes.WITH_KEYWORD, PyElementTypes.TRY_EXCEPT_STATEMENT, PyTokenTypes.TRY_KEYWORD, PyTokenTypes.EXCEPT_KEYWORD, PyTokenTypes.FINALLY_KEYWORD, PyElementTypes.FUNCTION_DECLARATION, PyTokenTypes.DEF_KEYWORD, PyElementTypes.CLASS_DECLARATION, PyTokenTypes.CLASS_KEYWORD});
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x3BC9BC535C85L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/editor/PyEmacsHandler";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/editor/PyEmacsHandler";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "changeIndent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "changeIndent";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getSoleIndent";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "tryToIndentToRight";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "tryToIndentToLeft";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "containsNonWhiteSpaceData";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectIndentsGreaterOrEqualToCurrent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isLineStartsWithCompoundStatement";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getLineIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ChangeIndentContext {
        @NotNull
        public final Project project;
        @NotNull
        public final PsiFile file;
        @NotNull
        public final Editor editor;
        @NotNull
        public final Document document;
        public final int targetLine;
        private CommonCodeStyleSettings.IndentOptions a;
        private static final long b = c.a(1796798793394916157L, -5507116774158609080L, MethodHandles.lookup().lookupClass()).a(280163978489401L);

        private ChangeIndentContext(@NotNull Project project, @NotNull PsiFile file, @NotNull Editor editor2, @NotNull Document document, int targetLine) {
            if (project == null) {
                ChangeIndentContext.a(0);
            }
            if (file == null) {
                ChangeIndentContext.a(1);
            }
            if (editor2 == null) {
                ChangeIndentContext.a(2);
            }
            if (document == null) {
                ChangeIndentContext.a(3);
            }
            this.project = project;
            this.file = file;
            this.editor = editor2;
            this.document = document;
            this.targetLine = targetLine;
        }

        public CommonCodeStyleSettings.IndentOptions getIndentOptions() {
            if (this.a == null) {
                this.a = CodeStyle.getIndentOptions((PsiFile)this.file);
            }
            return this.a;
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = b ^ 0x77E16781102BL;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "editor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/editor/PyEmacsHandler$ChangeIndentContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LineInfo {
        public final int line;
        public final int indent;
        public final boolean startsWithCompoundStatement;
        private static final long a = c.a(-5087226435167501825L, 585844584023638387L, MethodHandles.lookup().lookupClass()).a(189647665700796L);

        LineInfo(int line2, int indent, boolean startsWithCompoundStatement) {
            this.line = line2;
            this.indent = indent;
            this.startsWithCompoundStatement = startsWithCompoundStatement;
        }

        public String toString() {
            long l2 = a ^ 0x5591F2DEB50FL;
            return "line=" + this.line + ", indent=" + this.indent + ", compound=" + this.startsWithCompoundStatement;
        }
    }

    private static final class ProcessingResult
    extends Enum<ProcessingResult> {
        public static final /* enum */ ProcessingResult STOP_SUCCESSFUL;
        public static final /* enum */ ProcessingResult STOP_UNSUCCESSFUL;
        public static final /* enum */ ProcessingResult CONTINUE;
        private static final /* synthetic */ ProcessingResult[] a;

        public static ProcessingResult[] values() {
            return (ProcessingResult[])a.clone();
        }

        public static ProcessingResult valueOf(String name) {
            return Enum.valueOf(ProcessingResult.class, name);
        }

        static {
            long l2 = c.a(-5781750412581233693L, 1939817485365422870L, MethodHandles.lookup().lookupClass()).a(83853710861807L) ^ 0x68E65205800FL;
            STOP_SUCCESSFUL = new ProcessingResult();
            STOP_UNSUCCESSFUL = new ProcessingResult();
            CONTINUE = new ProcessingResult();
            a = new ProcessingResult[]{STOP_SUCCESSFUL, STOP_UNSUCCESSFUL, CONTINUE};
        }
    }
}

