/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.editor;

import com.intellij.codeInsight.editorActions.MultiCharQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseQuoteHandler
implements MultiCharQuoteHandler {
    private final char[] b;
    private final TokenSet a;
    private static final long c = com.jetbrains.python.psi.c.a(711711893728791415L, 9169506595369545823L, MethodHandles.lookup().lookupClass()).a(70635969618974L);

    public BaseQuoteHandler(TokenSet tokenSet, char[] autoClosingChars) {
        this.a = tokenSet;
        this.b = autoClosingChars;
        Arrays.sort(this.b);
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        boolean bl2;
        Document document = iterator.getDocument();
        if (document == null) {
            return false;
        }
        CharSequence charSequence = document.getCharsSequence();
        boolean bl3 = offset + 1 >= charSequence.length() || Arrays.binarySearch(this.b, charSequence.charAt(offset + 1)) >= 0;
        boolean bl4 = bl2 = offset + 4 >= charSequence.length() || Arrays.binarySearch(this.b, charSequence.charAt(offset + 4)) >= 0;
        if (bl2 && this.a(iterator, offset)) {
            return true;
        }
        if (bl3) {
            int n2;
            if (this.b(iterator, offset)) {
                return true;
            }
            if (this.getOpeningQuotesTokens().contains(iterator.getTokenType()) && offset - (n2 = iterator.getStart()) <= 3 && BaseQuoteHandler.a(charSequence, n2) == offset) {
                return true;
            }
        }
        return false;
    }

    private boolean a(HighlighterIterator highlighterIterator, int n2) {
        CharSequence charSequence = highlighterIterator.getDocument().getCharsSequence();
        char c10 = charSequence.charAt(n2);
        IElementType iElementType = highlighterIterator.getTokenType();
        if (this.getOpeningQuotesTokens().contains(iElementType) && n2 >= 2 && charSequence.charAt(n2 - 1) == c10 && charSequence.charAt(n2 - 2) == c10 && (n2 < 3 || charSequence.charAt(n2 - 3) != c10)) {
            return BaseQuoteHandler.a(charSequence, highlighterIterator.getStart()) == n2 - 2;
        }
        return false;
    }

    private static int a(CharSequence charSequence, int n2) {
        return PyStringLiteralUtil.getPrefixEndOffset(charSequence, n2);
    }

    public boolean hasNonClosedLiteral(Editor editor2, HighlighterIterator iterator, int offset) {
        IElementType iElementType = iterator.getTokenType();
        if (!this.getOpeningQuotesTokens().contains(iElementType)) {
            return false;
        }
        CharSequence charSequence = iterator.getDocument().getCharsSequence();
        int n2 = iterator.getEnd();
        if (BaseQuoteHandler.a(charSequence, iterator.getStart()) >= n2 - 1) {
            return true;
        }
        char c10 = charSequence.charAt(n2 - 1);
        if (c10 != '\"' && c10 != '\'') {
            return true;
        }
        return n2 >= 3 && c10 == charSequence.charAt(n2 - 2) && charSequence.charAt(n2 - 2) == charSequence.charAt(n2 - 3) && (n2 < 4 || charSequence.charAt(n2 - 4) != c10);
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        IElementType iElementType = iterator.getTokenType();
        if (this.getClosingQuotesTokens().contains(iElementType)) {
            int n2 = iterator.getStart();
            int n3 = iterator.getEnd();
            if (n3 - n2 >= 1 && offset == n3 - 1) {
                char c10;
                Document document = iterator.getDocument();
                if (document == null) {
                    return false;
                }
                CharSequence charSequence = document.getCharsSequence();
                return charSequence.length() <= offset + 1 || Arrays.binarySearch(this.b, c10 = charSequence.charAt(offset + 1)) >= 0;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public CharSequence getClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        if (iterator == null) {
            BaseQuoteHandler.a(0);
        }
        Document document = iterator.getDocument();
        CharSequence charSequence = document.getCharsSequence();
        char c10 = charSequence.charAt(offset - 1);
        boolean bl2 = false;
        if (iterator.getStart() == offset) {
            bl2 = true;
            iterator.retreat();
        }
        try {
            if (this.a(iterator, offset - 1)) {
                String string = StringUtil.repeat((String)String.valueOf(c10), (int)3);
                return string;
            }
            if (this.b(iterator, offset - 1)) {
                String string = String.valueOf(c10);
                return string;
            }
            CharSequence charSequence2 = null;
            return charSequence2;
        }
        finally {
            if (bl2) {
                iterator.advance();
            }
        }
    }

    private boolean b(@NotNull HighlighterIterator highlighterIterator, int n2) {
        if (highlighterIterator == null) {
            BaseQuoteHandler.a(1);
        }
        if (this.getOpeningQuotesTokens().contains(highlighterIterator.getTokenType())) {
            int n3 = highlighterIterator.getStart();
            return n2 == n3;
        }
        return false;
    }

    public boolean isInsideLiteral(HighlighterIterator iterator) {
        return this.getLiteralContentTokens().contains(iterator.getTokenType());
    }

    @NotNull
    protected TokenSet getOpeningQuotesTokens() {
        TokenSet tokenSet = this.a;
        if (tokenSet == null) {
            BaseQuoteHandler.a(2);
        }
        return tokenSet;
    }

    @NotNull
    protected TokenSet getClosingQuotesTokens() {
        TokenSet tokenSet = this.a;
        if (tokenSet == null) {
            BaseQuoteHandler.a(3);
        }
        return tokenSet;
    }

    @NotNull
    protected TokenSet getLiteralContentTokens() {
        TokenSet tokenSet = this.a;
        if (tokenSet == null) {
            BaseQuoteHandler.a(4);
        }
        return tokenSet;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0xBB7007F5732L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iterator";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/editor/BaseQuoteHandler";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/editor/BaseQuoteHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpeningQuotesTokens";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getClosingQuotesTokens";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralContentTokens";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getClosingQuote";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isOpeningSingleQuote";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

