/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.doctest;

import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonIndentingLexer;

public class PyDocstringLexer
extends PythonIndentingLexer {
    static final TokenSet ourIgnoreSet = TokenSet.create((IElementType[])new IElementType[]{PyTokenTypes.DOT, PyTokenTypes.GTGT, PyTokenTypes.GT});

    @Override
    public void advance() {
        if (super.getTokenType() == PyTokenTypes.DOT) {
            this.advanceBase();
            if (super.getTokenType() == PyTokenTypes.DOT) {
                this.advanceBase();
                if (super.getTokenType() == PyTokenTypes.DOT) {
                    super.advance();
                }
            }
        } else if (super.getTokenType() == PyTokenTypes.GTGT) {
            this.advanceBase();
            if (super.getTokenType() == PyTokenTypes.GT) {
                this.advanceBase();
            }
        } else {
            super.advance();
        }
    }

    @Override
    protected int getNextLineIndent() {
        int n2 = super.getNextLineIndent();
        if (!ourIgnoreSet.contains(this.getBaseTokenType())) {
            return n2;
        }
        n2 = 0;
        while (this.getBaseTokenType() != null && ourIgnoreSet.contains(this.getBaseTokenType())) {
            this.advanceBase();
        }
        while (this.getBaseTokenType() != null && (PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(this.getBaseTokenType()) || ourIgnoreSet.contains(this.getBaseTokenType()))) {
            if (this.getBaseTokenType() == PyTokenTypes.TAB) {
                n2 = (n2 / 8 + 1) * 8;
            } else if (this.getBaseTokenType() == PyTokenTypes.SPACE) {
                ++n2;
            } else if (this.getBaseTokenType() == PyTokenTypes.LINE_BREAK) {
                n2 = 0;
                super.getNextLineIndent();
            }
            this.advanceBase();
        }
        if (this.getBaseTokenType() == null) {
            return 0;
        }
        return n2 > 0 ? n2 - 1 : n2;
    }

    @Override
    protected void checkSignificantTokens() {
        IElementType iElementType = this.getBaseTokenType();
        if (!PyTokenTypes.WHITESPACE_OR_LINEBREAK.contains(iElementType) && iElementType != this.getCommentTokenType() && !ourIgnoreSet.contains(iElementType)) {
            this.myLineHasSignificantTokens = true;
        }
    }

    @Override
    protected void checkStartState(int startOffset, int initialState) {
    }
}

