/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyNames;
import com.jetbrains.python.documentation.docstrings.DocStringLineParser;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.toolbox.Substring;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SectionBasedDocString
extends DocStringLineParser
implements StructuredDocString {
    @NonNls
    public static final String RETURNS_SECTION = "returns";
    @NonNls
    public static final String RAISES_SECTION = "raises";
    @NonNls
    public static final String KEYWORD_ARGUMENTS_SECTION = "keyword arguments";
    @NonNls
    public static final String PARAMETERS_SECTION = "parameters";
    @NonNls
    public static final String ATTRIBUTES_SECTION = "attributes";
    @NonNls
    public static final String METHODS_SECTION = "methods";
    @NonNls
    public static final String OTHER_PARAMETERS_SECTION = "other parameters";
    @NonNls
    public static final String YIELDS_SECTION = "yields";
    private static final Pattern a;
    protected static final Map<String, String> SECTION_ALIASES;
    private static final Pattern e;
    public static final Set<String> SECTION_NAMES;
    private final Substring b;
    private final List<Section> c;
    private final List<Substring> d;
    private static final long l;

    @Nullable
    public static String getNormalizedSectionTitle(@NotNull @NonNls String title) {
        if (title == null) {
            SectionBasedDocString.b(0);
        }
        return SECTION_ALIASES.get(StringUtil.toLowerCase((String)title));
    }

    public static boolean isValidSectionTitle(@NotNull @NonNls String title) {
        if (title == null) {
            SectionBasedDocString.b(1);
        }
        return StringUtil.isCapitalized((String)title) && SectionBasedDocString.getNormalizedSectionTitle(title) != null;
    }

    protected SectionBasedDocString(@NotNull Substring text2) {
        int n2;
        if (text2 == null) {
            SectionBasedDocString.b(2);
        }
        super(text2);
        this.c = new ArrayList<Section>();
        this.d = new ArrayList<Substring>();
        List list2 = Collections.emptyList();
        int n3 = n2 = this.consumeEmptyLines(this.parseHeader(0));
        while (n3 < this.getLineCount()) {
            Pair<Section, Integer> pair = this.parseSection(n3);
            if (pair.getFirst() != null) {
                this.c.add((Section)pair.getFirst());
                n3 = (Integer)pair.getSecond();
            } else if (n3 == n2) {
                Pair<List<Substring>, Integer> pair2 = this.a(n3);
                list2 = (List)pair2.getFirst();
                n3 = (Integer)pair2.getSecond();
            } else {
                this.d.add(this.getLine(n3));
                ++n3;
            }
            n3 = this.consumeEmptyLines(n3);
        }
        this.b = list2.isEmpty() ? null : ((Substring)list2.get(0)).union((Substring)list2.get(list2.size() - 1)).trim();
    }

    @NotNull
    private Pair<List<Substring>, Integer> a(int n2) {
        ArrayList<Substring> arrayList = new ArrayList<Substring>();
        while (!this.isEmptyOrDoesNotExist(n2) && !this.isBlockEnd(n2)) {
            arrayList.add(this.getLine(n2));
            ++n2;
        }
        Pair pair = Pair.create(arrayList, (Object)n2);
        if (pair == null) {
            SectionBasedDocString.b(3);
        }
        return pair;
    }

    protected int parseHeader(int startLine) {
        return startLine;
    }

    @NotNull
    protected Pair<Section, Integer> parseSection(int sectionStartLine) {
        Pair<Substring, Integer> pair = this.parseSectionHeader(sectionStartLine);
        if (pair.getFirst() == null) {
            Pair pair2 = Pair.create(null, (Object)sectionStartLine);
            if (pair2 == null) {
                SectionBasedDocString.b(4);
            }
            return pair2;
        }
        String string = SectionBasedDocString.getNormalizedSectionTitle(((Substring)pair.getFirst()).toString());
        if (string == null) {
            Pair pair3 = Pair.create(null, (Object)sectionStartLine);
            if (pair3 == null) {
                SectionBasedDocString.b(5);
            }
            return pair3;
        }
        ArrayList<SectionField> arrayList = new ArrayList<SectionField>();
        int n2 = this.getLineIndentSize(sectionStartLine);
        int n3 = this.consumeEmptyLines((Integer)pair.getSecond());
        while (!this.isSectionBreak(n3, n2)) {
            if (!this.isEmpty(n3)) {
                Pair<SectionField, Integer> pair4 = this.parseSectionField(n3, string, n2);
                if (pair4.getFirst() != null) {
                    arrayList.add((SectionField)pair4.getFirst());
                    n3 = (Integer)pair4.getSecond();
                    continue;
                }
                this.d.add(this.getLine(n3));
            }
            ++n3;
        }
        Pair pair5 = Pair.create((Object)new Section((Substring)pair.getFirst(), arrayList), (Object)n3);
        if (pair5 == null) {
            SectionBasedDocString.b(6);
        }
        return pair5;
    }

    @NotNull
    protected Pair<SectionField, Integer> parseSectionField(int lineNum, @NotNull String normalizedSectionTitle, int sectionIndent) {
        FieldType fieldType;
        if (normalizedSectionTitle == null) {
            SectionBasedDocString.b(7);
        }
        if ((fieldType = this.getFieldType(normalizedSectionTitle)) != null) {
            Pair<SectionField, Integer> pair = this.parseSectionField(lineNum, sectionIndent, fieldType);
            if (pair == null) {
                SectionBasedDocString.b(8);
            }
            return pair;
        }
        Pair<SectionField, Integer> pair = this.parseGenericField(lineNum, sectionIndent);
        if (pair == null) {
            SectionBasedDocString.b(9);
        }
        return pair;
    }

    @Nullable
    protected abstract FieldType getFieldType(@NotNull String var1);

    protected abstract Pair<SectionField, Integer> parseSectionField(int var1, int var2, @NotNull FieldType var3);

    @NotNull
    protected Pair<SectionField, Integer> parseGenericField(int lineNum, int sectionIndent) {
        Pair<List<Substring>, Integer> pair = this.parseIndentedBlock(lineNum, this.getSectionIndentationThreshold(sectionIndent));
        Substring substring = (Substring)ContainerUtil.getFirstItem((List)((List)pair.getFirst()));
        Substring substring2 = (Substring)ContainerUtil.getLastItem((List)((List)pair.getFirst()));
        if (substring != null && substring2 != null) {
            Pair pair2 = Pair.create((Object)new SectionField((Substring)null, null, substring.union(substring2).trim()), (Object)pair.getSecond());
            if (pair2 == null) {
                SectionBasedDocString.b(10);
            }
            return pair2;
        }
        Pair pair3 = Pair.create(null, (Object)pair.getSecond());
        if (pair3 == null) {
            SectionBasedDocString.b(11);
        }
        return pair3;
    }

    @NotNull
    protected abstract Pair<Substring, Integer> parseSectionHeader(int var1);

    protected boolean isSectionStart(int lineNum) {
        Pair<Substring, Integer> pair = this.parseSectionHeader(lineNum);
        return pair.getFirst() != null;
    }

    protected boolean isSectionBreak(int lineNum, int curSectionIndent) {
        return lineNum >= this.getLineCount() || !this.isEmpty(lineNum) && this.getLineIndentSize(lineNum) <= this.getSectionIndentationThreshold(curSectionIndent) || this.isSectionStart(lineNum);
    }

    @NotNull
    protected Pair<List<Substring>, Integer> parseIndentedBlock(int lineNum, int blockIndent) {
        int n2 = this.consumeIndentedBlock(lineNum, blockIndent);
        Pair pair = Pair.create(this.myLines.subList(lineNum, n2), (Object)n2);
        if (pair == null) {
            SectionBasedDocString.b(12);
        }
        return pair;
    }

    protected int getSectionIndentationThreshold(int sectionIndent) {
        return sectionIndent;
    }

    @Override
    protected boolean isBlockEnd(int lineNum) {
        return this.isSectionStart(lineNum);
    }

    protected boolean isValidType(@NotNull String type) {
        if (type == null) {
            SectionBasedDocString.b(13);
        }
        return !type.isEmpty() && !SectionBasedDocString.isPlainText(type);
    }

    protected static boolean isPlainText(@NotNull String type) {
        if (type == null) {
            SectionBasedDocString.b(14);
        }
        return a.matcher(type).find();
    }

    protected boolean isValidName(@NotNull String name) {
        if (name == null) {
            SectionBasedDocString.b(15);
        }
        return PyNames.isIdentifierString(name);
    }

    @NotNull
    protected static List<Substring> splitByFirstColon(@NotNull Substring line2) {
        List<Substring> list2;
        if (line2 == null) {
            SectionBasedDocString.b(16);
        }
        if ((list2 = line2.split(e)).size() > 1) {
            for (Substring substring : list2) {
                int n2 = substring.indexOf(":");
                if (n2 < 0) continue;
                Substring substring2 = new Substring(line2.getSuperString(), line2.getStartOffset(), substring.getStartOffset() + n2);
                Substring substring3 = new Substring(line2.getSuperString(), substring.getStartOffset() + n2 + 1, line2.getEndOffset());
                List<Substring> list3 = Arrays.asList(substring2, substring3);
                if (list3 == null) {
                    SectionBasedDocString.b(17);
                }
                return list3;
            }
            List<Substring> list4 = Collections.singletonList(line2);
            if (list4 == null) {
                SectionBasedDocString.b(18);
            }
            return list4;
        }
        List<Substring> list5 = line2.split(":", 1);
        if (list5 == null) {
            SectionBasedDocString.b(19);
        }
        return list5;
    }

    @NotNull
    public List<Section> getSections() {
        List<Section> list2 = Collections.unmodifiableList(this.c);
        if (list2 == null) {
            SectionBasedDocString.b(20);
        }
        return list2;
    }

    @Override
    public String getSummary() {
        return this.b != null ? this.b.concatTrimmedLines("\n") : "";
    }

    @Override
    @NotNull
    public String getDescription() {
        if ("" == null) {
            SectionBasedDocString.b(21);
        }
        return "";
    }

    @Override
    @NotNull
    public List<String> getParameters() {
        List list2 = ContainerUtil.map(this.getParameterSubstrings(), substring -> substring.toString());
        if (list2 == null) {
            SectionBasedDocString.b(22);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<Substring> getParameterSubstrings() {
        ArrayList<Substring> arrayList = new ArrayList<Substring>();
        for (SectionField sectionField : this.getParameterFields()) {
            ContainerUtil.addAllNotNull(arrayList, sectionField.getNamesAsSubstrings());
        }
        ArrayList<Substring> arrayList2 = arrayList;
        if (arrayList2 == null) {
            SectionBasedDocString.b(23);
        }
        return arrayList2;
    }

    @Override
    @Nullable
    public String getParamType(@Nullable String paramName) {
        Substring substring = this.getParamTypeSubstring(paramName);
        return substring != null ? substring.toString() : null;
    }

    @Override
    @Nullable
    public Substring getParamTypeSubstring(@Nullable String paramName) {
        SectionField sectionField;
        if (paramName != null && (sectionField = this.getFirstFieldForParameter(paramName)) != null) {
            return sectionField.getTypeAsSubstring();
        }
        return null;
    }

    @Override
    @Nullable
    public String getParamDescription(@Nullable String paramName) {
        SectionField sectionField;
        if (paramName != null && (sectionField = this.getFirstFieldForParameter(paramName)) != null) {
            return sectionField.getDescription();
        }
        return null;
    }

    @Nullable
    public SectionField getFirstFieldForParameter(@NotNull String name) {
        if (name == null) {
            SectionBasedDocString.b(24);
        }
        return (SectionField)ContainerUtil.find(this.getParameterFields(), sectionField -> sectionField.getNames().contains(name));
    }

    @NotNull
    public List<SectionField> getParameterFields() {
        ArrayList<SectionField> arrayList = new ArrayList<SectionField>();
        for (Section section : this.getParameterSections()) {
            arrayList.addAll(section.getFields());
        }
        ArrayList<SectionField> arrayList2 = arrayList;
        if (arrayList2 == null) {
            SectionBasedDocString.b(25);
        }
        return arrayList2;
    }

    @NotNull
    public List<Section> getParameterSections() {
        long l2 = l ^ 0xE1A503D7A5L;
        List<Section> list2 = this.getSectionsWithNormalizedTitle(PARAMETERS_SECTION);
        if (list2 == null) {
            SectionBasedDocString.b(26);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<String> getKeywordArguments() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SectionField sectionField : this.getKeywordArgumentFields()) {
            arrayList.addAll(sectionField.getNames());
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            SectionBasedDocString.b(27);
        }
        return arrayList2;
    }

    @Override
    @NotNull
    public List<Substring> getKeywordArgumentSubstrings() {
        ArrayList<Substring> arrayList = new ArrayList<Substring>();
        for (SectionField sectionField : this.getKeywordArgumentFields()) {
            ContainerUtil.addAllNotNull(sectionField.getNamesAsSubstrings(), (Object[])new Substring[0]);
        }
        ArrayList<Substring> arrayList2 = arrayList;
        if (arrayList2 == null) {
            SectionBasedDocString.b(28);
        }
        return arrayList2;
    }

    @Override
    @Nullable
    public String getKeywordArgumentDescription(@Nullable String paramName) {
        SectionField sectionField;
        if (paramName != null && (sectionField = this.a(paramName)) != null) {
            return sectionField.getDescription();
        }
        return null;
    }

    @NotNull
    public List<SectionField> getKeywordArgumentFields() {
        long l2 = l ^ 0x596EB058D61FL;
        ArrayList<SectionField> arrayList = new ArrayList<SectionField>();
        for (Section section : this.getSectionsWithNormalizedTitle(KEYWORD_ARGUMENTS_SECTION)) {
            arrayList.addAll(section.getFields());
        }
        ArrayList<SectionField> arrayList2 = arrayList;
        if (arrayList2 == null) {
            SectionBasedDocString.b(29);
        }
        return arrayList2;
    }

    @Nullable
    private SectionField a(@NotNull String string) {
        if (string == null) {
            SectionBasedDocString.b(30);
        }
        return (SectionField)ContainerUtil.find(this.getKeywordArgumentFields(), sectionField -> sectionField.getNames().contains(string));
    }

    @Override
    @Nullable
    public String getReturnType() {
        Substring substring = this.getReturnTypeSubstring();
        return substring != null ? substring.toString() : null;
    }

    @Override
    @Nullable
    public Substring getReturnTypeSubstring() {
        SectionField sectionField = this.a();
        return sectionField != null ? sectionField.getTypeAsSubstring() : null;
    }

    @Override
    @Nullable
    public String getReturnDescription() {
        SectionField sectionField = this.a();
        return sectionField != null ? sectionField.getDescription() : null;
    }

    @NotNull
    public List<SectionField> getReturnFields() {
        long l2 = l ^ 0x2F5CC3CAF17L;
        ArrayList<SectionField> arrayList = new ArrayList<SectionField>();
        for (Section section : this.getSectionsWithNormalizedTitle(RETURNS_SECTION)) {
            arrayList.addAll(section.getFields());
        }
        ArrayList<SectionField> arrayList2 = arrayList;
        if (arrayList2 == null) {
            SectionBasedDocString.b(31);
        }
        return arrayList2;
    }

    @Nullable
    private SectionField a() {
        return (SectionField)ContainerUtil.getFirstItem(this.getReturnFields());
    }

    @Override
    @NotNull
    public List<String> getRaisedExceptions() {
        List list2 = ContainerUtil.mapNotNull(this.getExceptionFields(), sectionField -> StringUtil.nullize((String)sectionField.getType()));
        if (list2 == null) {
            SectionBasedDocString.b(32);
        }
        return list2;
    }

    @Override
    @Nullable
    public String getRaisedExceptionDescription(@Nullable String exceptionName) {
        SectionField sectionField;
        if (exceptionName != null && (sectionField = this.b(exceptionName)) != null) {
            return sectionField.getDescription();
        }
        return null;
    }

    @NotNull
    public List<SectionField> getExceptionFields() {
        long l2 = l ^ 0x60569E99B087L;
        ArrayList<SectionField> arrayList = new ArrayList<SectionField>();
        for (Section section : this.getSectionsWithNormalizedTitle(RAISES_SECTION)) {
            arrayList.addAll(section.getFields());
        }
        ArrayList<SectionField> arrayList2 = arrayList;
        if (arrayList2 == null) {
            SectionBasedDocString.b(33);
        }
        return arrayList2;
    }

    @Nullable
    private SectionField b(@NotNull String string) {
        if (string == null) {
            SectionBasedDocString.b(34);
        }
        return (SectionField)ContainerUtil.find(this.getExceptionFields(), sectionField -> string.equals(sectionField.getType()));
    }

    @NotNull
    public List<SectionField> getAttributeFields() {
        long l2 = l ^ 0x5A309E6EE607L;
        ArrayList<SectionField> arrayList = new ArrayList<SectionField>();
        for (Section section : this.getSectionsWithNormalizedTitle(ATTRIBUTES_SECTION)) {
            arrayList.addAll(section.getFields());
        }
        ArrayList<SectionField> arrayList2 = arrayList;
        if (arrayList2 == null) {
            SectionBasedDocString.b(35);
        }
        return arrayList2;
    }

    @NotNull
    public List<Section> getSectionsWithNormalizedTitle(@NotNull String title) {
        if (title == null) {
            SectionBasedDocString.b(36);
        }
        List list2 = ContainerUtil.mapNotNull(this.c, section -> section.getNormalizedTitle().equals(SectionBasedDocString.getNormalizedSectionTitle(title)) ? section : null);
        if (list2 == null) {
            SectionBasedDocString.b(37);
        }
        return list2;
    }

    @Nullable
    public Section getFirstSectionWithNormalizedTitle(@NotNull String title) {
        if (title == null) {
            SectionBasedDocString.b(38);
        }
        return (Section)ContainerUtil.getFirstItem(this.getSectionsWithNormalizedTitle(title));
    }

    @Override
    @Nullable
    public String getAttributeDescription() {
        return null;
    }

    @NotNull
    protected static Substring cleanUpName(@NotNull Substring name) {
        int n2;
        if (name == null) {
            SectionBasedDocString.b(39);
        }
        for (n2 = 0; n2 < name.length() && name.charAt(n2) == '*'; ++n2) {
        }
        Substring substring = name.substring(n2).trimLeft();
        if (substring == null) {
            SectionBasedDocString.b(40);
        }
        return substring;
    }

    static {
        l = com.jetbrains.python.psi.c.a(-5510236824492556613L, 8960362982134309810L, MethodHandles.lookup().lookupClass()).a(137407229123923L);
        long l2 = l ^ 0x3ED425DF7569L;
        a = Pattern.compile("\\w+(\\s+\\w+){2}");
        SECTION_ALIASES = ImmutableMap.builder().put((Object)"arguments", (Object)PARAMETERS_SECTION).put((Object)"args", (Object)PARAMETERS_SECTION).put((Object)PARAMETERS_SECTION, (Object)PARAMETERS_SECTION).put((Object)"keyword args", (Object)KEYWORD_ARGUMENTS_SECTION).put((Object)KEYWORD_ARGUMENTS_SECTION, (Object)KEYWORD_ARGUMENTS_SECTION).put((Object)OTHER_PARAMETERS_SECTION, (Object)OTHER_PARAMETERS_SECTION).put((Object)ATTRIBUTES_SECTION, (Object)ATTRIBUTES_SECTION).put((Object)METHODS_SECTION, (Object)METHODS_SECTION).put((Object)"note", (Object)"notes").put((Object)"notes", (Object)"notes").put((Object)"example", (Object)"examples").put((Object)"examples", (Object)"examples").put((Object)"return", (Object)RETURNS_SECTION).put((Object)RETURNS_SECTION, (Object)RETURNS_SECTION).put((Object)"yield", (Object)YIELDS_SECTION).put((Object)YIELDS_SECTION, (Object)YIELDS_SECTION).put((Object)RAISES_SECTION, (Object)RAISES_SECTION).put((Object)"references", (Object)"references").put((Object)"see also", (Object)"see also").put((Object)"warning", (Object)"warnings").put((Object)"warns", (Object)"warnings").put((Object)"warnings", (Object)"warnings").build();
        e = Pattern.compile("(:\\w+:\\S+:`.+?`|:\\S+:`.+?`|`.+?`)");
        SECTION_NAMES = SECTION_ALIASES.keySet();
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = l ^ 0x2B7D1E82681CL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 40: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocString";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "normalizedSectionTitle";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 15: 
            case 24: 
            case 30: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocString";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSummary";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSection";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "parseSectionField";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parseGenericField";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIndentedBlock";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "splitByFirstColon";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSections";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterSubstrings";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterFields";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterSections";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordArguments";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordArgumentSubstrings";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywordArgumentFields";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnFields";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getRaisedExceptions";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getExceptionFields";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeFields";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getSectionsWithNormalizedTitle";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "cleanUpName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedSectionTitle";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidSectionTitle";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 40: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseSectionField";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isValidType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isPlainText";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "isValidName";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "splitByFirstColon";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getFirstFieldForParameter";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFirstFieldForKeywordArgument";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getFirstFieldForException";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getSectionsWithNormalizedTitle";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getFirstSectionWithNormalizedTitle";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "cleanUpName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SectionField {
        private final List<Substring> a;
        private final Substring c;
        private final Substring b;
        private static final long d = com.jetbrains.python.psi.c.a(541576353145830060L, -558640582659566908L, MethodHandles.lookup().lookupClass()).a(172681160069461L);

        public SectionField(@Nullable Substring name, @Nullable Substring type, @Nullable Substring description) {
            this(name == null ? Collections.emptyList() : Collections.singletonList(name), type, description);
        }

        public SectionField(@NotNull List<Substring> names, @Nullable Substring type, @Nullable Substring description) {
            if (names == null) {
                SectionField.a(0);
            }
            this.a = names;
            this.c = type;
            this.b = description;
        }

        @Nullable
        public String getName() {
            return this.a.isEmpty() ? null : this.a.get(0).toString();
        }

        @Nullable
        public Substring getNameAsSubstring() {
            return this.a.isEmpty() ? null : this.a.get(0);
        }

        @NotNull
        public List<Substring> getNamesAsSubstrings() {
            List<Substring> list2 = this.a;
            if (list2 == null) {
                SectionField.a(1);
            }
            return list2;
        }

        @NotNull
        public List<String> getNames() {
            List list2 = ContainerUtil.map(this.a, substring -> substring.toString());
            if (list2 == null) {
                SectionField.a(2);
            }
            return list2;
        }

        @Nullable
        public String getType() {
            return this.c == null ? null : this.c.toString();
        }

        @Nullable
        public Substring getTypeAsSubstring() {
            return this.c;
        }

        @Nullable
        public String getDescription() {
            return this.b == null ? null : PyIndentUtil.removeCommonIndent(this.b.getValue(), true);
        }

        @Nullable
        public Substring getDescriptionAsSubstring() {
            return this.b;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            SectionField sectionField = (SectionField)o2;
            if (this.a != null ? !this.a.equals(sectionField.a) : sectionField.a != null) {
                return false;
            }
            if (this.c != null ? !this.c.equals(sectionField.c) : sectionField.c != null) {
                return false;
            }
            return !(this.b != null ? !this.b.equals(sectionField.b) : sectionField.b != null);
        }

        public int hashCode() {
            int n2 = this.a != null ? this.a.hashCode() : 0;
            n2 = 31 * n2 + (this.c != null ? this.c.hashCode() : 0);
            n2 = 31 * n2 + (this.b != null ? this.b.hashCode() : 0);
            return n2;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = d ^ 0x6A2245696382L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "names";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocString$SectionField";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocString$SectionField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamesAsSubstrings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNames";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Section {
        private final Substring a;
        private final List<SectionField> b;
        private static final long c = com.jetbrains.python.psi.c.a(2766276059201811733L, 910975007836269915L, MethodHandles.lookup().lookupClass()).a(90091672838736L);

        public Section(@NotNull Substring title, @NotNull List<SectionField> fields) {
            if (title == null) {
                Section.a(0);
            }
            if (fields == null) {
                Section.a(1);
            }
            this.a = title;
            this.b = new ArrayList<SectionField>(fields);
        }

        @NotNull
        public Substring getTitleAsSubstring() {
            Substring substring = this.a;
            if (substring == null) {
                Section.a(2);
            }
            return substring;
        }

        @NotNull
        public String getTitle() {
            String string = this.a.toString();
            if (string == null) {
                Section.a(3);
            }
            return string;
        }

        @NotNull
        public String getNormalizedTitle() {
            String string = SectionBasedDocString.getNormalizedSectionTitle(this.getTitle());
            if (string == null) {
                Section.a(4);
            }
            return string;
        }

        @NotNull
        public List<SectionField> getFields() {
            List<SectionField> list2 = Collections.unmodifiableList(this.b);
            if (list2 == null) {
                Section.a(5);
            }
            return list2;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Section section = (Section)o2;
            if (!this.a.equals(section.a)) {
                return false;
            }
            return this.b.equals(section.b);
        }

        public int hashCode() {
            int n2 = this.a.hashCode();
            n2 = 31 * n2 + this.b.hashCode();
            return n2;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x5E4F28CC8AD9L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fields";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocString$Section";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/docstrings/SectionBasedDocString$Section";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitleAsSubstring";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitle";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNormalizedTitle";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFields";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    protected static final class FieldType
    extends Enum<FieldType> {
        public static final /* enum */ FieldType NAME_WITH_OPTIONAL_TYPE;
        public static final /* enum */ FieldType TYPE_WITH_OPTIONAL_NAME;
        public static final /* enum */ FieldType ONLY_TYPE;
        public static final /* enum */ FieldType OPTIONAL_TYPE;
        public static final /* enum */ FieldType ONLY_NAME;
        public final boolean canHaveBothNameAndType;
        public final boolean preferType;
        public final boolean canHaveOnlyDescription;
        private static final /* synthetic */ FieldType[] a;

        public static FieldType[] values() {
            return (FieldType[])a.clone();
        }

        public static FieldType valueOf(String name) {
            return Enum.valueOf(FieldType.class, name);
        }

        private FieldType(boolean canHaveType, boolean preferType, boolean canHaveOnlyDescription) {
            this.canHaveBothNameAndType = canHaveType;
            this.canHaveOnlyDescription = canHaveOnlyDescription;
            this.preferType = preferType;
        }

        static {
            long l2 = com.jetbrains.python.psi.c.a(6628870397032896704L, -2265532843812649849L, MethodHandles.lookup().lookupClass()).a(157648309353340L) ^ 0x6005DE99E7D4L;
            NAME_WITH_OPTIONAL_TYPE = new FieldType(true, false, false);
            TYPE_WITH_OPTIONAL_NAME = new FieldType(true, true, false);
            ONLY_TYPE = new FieldType(false, true, false);
            OPTIONAL_TYPE = new FieldType(false, true, true);
            ONLY_NAME = new FieldType(false, false, false);
            a = new FieldType[]{NAME_WITH_OPTIONAL_TYPE, TYPE_WITH_OPTIONAL_NAME, ONLY_TYPE, OPTIONAL_TYPE, ONLY_NAME};
        }
    }
}

