/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.PyCodeInsightSettings;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.documentation.docstrings.DocStringBuilder;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringUpdater;
import com.jetbrains.python.documentation.docstrings.DocStringUtil;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocString;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.GoogleCodeStyleDocStringUpdater;
import com.jetbrains.python.documentation.docstrings.NumpyDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.NumpyDocStringUpdater;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocString;
import com.jetbrains.python.documentation.docstrings.SectionBasedDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.TagBasedDocString;
import com.jetbrains.python.documentation.docstrings.TagBasedDocStringBuilder;
import com.jetbrains.python.documentation.docstrings.TagBasedDocStringUpdater;
import com.jetbrains.python.documentation.docstrings.b;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyNamedParameter;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyRaiseStatement;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReturnStatement;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.StructuredDocString;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.toolbox.Substring;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyDocstringGenerator {
    public static final String TRIPLE_DOUBLE_QUOTES = "\"\"\"";
    public static final String TRIPLE_SINGLE_QUOTES = "'''";
    private final List<DocstringParam> k;
    private final List<DocstringParam> h;
    private final String g;
    @Nullable
    private final PyDocStringOwner i;
    private final String d;
    private final DocStringFormat a;
    private final PsiElement j;
    private boolean e;
    private boolean b;
    private boolean f;
    private boolean l;
    private String c;
    private static final long m = com.jetbrains.python.psi.c.a(-812756546663876808L, 4294431438079749543L, MethodHandles.lookup().lookupClass()).a(188229417514312L);

    private PyDocstringGenerator(@Nullable PyDocStringOwner docStringOwner, @Nullable String docStringText, @NotNull DocStringFormat format, @NotNull String indentation, @NotNull PsiElement settingsAnchor) {
        if (format == null) {
            PyDocstringGenerator.a(0);
        }
        if (indentation == null) {
            PyDocstringGenerator.a(1);
        }
        if (settingsAnchor == null) {
            PyDocstringGenerator.a(2);
        }
        this.k = Lists.newArrayList();
        this.h = Lists.newArrayList();
        this.e = true;
        this.b = false;
        this.f = false;
        this.l = false;
        this.c = TRIPLE_DOUBLE_QUOTES;
        this.i = docStringOwner;
        this.d = indentation;
        this.a = format;
        this.g = docStringText;
        this.b = this.g == null;
        this.j = settingsAnchor;
    }

    @NotNull
    public static PyDocstringGenerator forDocStringOwner(@NotNull PyDocStringOwner owner) {
        if (owner == null) {
            PyDocstringGenerator.a(3);
        }
        String string = "";
        if (owner instanceof PyStatementListContainer) {
            string = PyIndentUtil.getElementIndent((PsiElement)((PyStatementListContainer)((Object)owner)).getStatementList());
        }
        String string2 = owner.getDocStringExpression() == null ? null : owner.getDocStringExpression().getText();
        PyDocstringGenerator pyDocstringGenerator = new PyDocstringGenerator(owner, string2, DocStringUtil.getConfiguredDocStringFormatOrPlain((PsiElement)owner), string, (PsiElement)owner);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(4);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public static PyDocstringGenerator create(@NotNull DocStringFormat format, @NotNull String indentation, @NotNull PsiElement settingsAnchor) {
        if (format == null) {
            PyDocstringGenerator.a(5);
        }
        if (indentation == null) {
            PyDocstringGenerator.a(6);
        }
        if (settingsAnchor == null) {
            PyDocstringGenerator.a(7);
        }
        PyDocstringGenerator pyDocstringGenerator = new PyDocstringGenerator(null, null, format, indentation, settingsAnchor);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(8);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public static PyDocstringGenerator update(@NotNull PyStringLiteralExpression docString) {
        if (docString == null) {
            PyDocstringGenerator.a(9);
        }
        PyDocstringGenerator pyDocstringGenerator = new PyDocstringGenerator((PyDocStringOwner)PsiTreeUtil.getParentOfType((PsiElement)docString, PyDocStringOwner.class), docString.getText(), DocStringUtil.getConfiguredDocStringFormatOrPlain(docString), PyIndentUtil.getElementIndent(docString), docString);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(10);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public static PyDocstringGenerator update(@NotNull DocStringFormat format, @NotNull String indentation, @NotNull String text2, PsiElement settingsAnchor) {
        if (format == null) {
            PyDocstringGenerator.a(11);
        }
        if (indentation == null) {
            PyDocstringGenerator.a(12);
        }
        if (text2 == null) {
            PyDocstringGenerator.a(13);
        }
        PyDocstringGenerator pyDocstringGenerator = new PyDocstringGenerator(null, text2, format, indentation, settingsAnchor);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(14);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withParam(@NotNull String name) {
        if (name == null) {
            PyDocstringGenerator.a(15);
        }
        PyDocstringGenerator pyDocstringGenerator = this.withParamTypedByName(name, null);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(16);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withParam(@NotNull PyNamedParameter param) {
        if (param == null) {
            PyDocstringGenerator.a(17);
        }
        PyDocstringGenerator pyDocstringGenerator = this.withParam(this.getPreferredParameterName(param));
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(18);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withParamTypedByName(@NotNull String name, @Nullable String type) {
        if (name == null) {
            PyDocstringGenerator.a(19);
        }
        this.k.add(new DocstringParam(name, type, false, null));
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(20);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withParamTypedByName(@NotNull PyNamedParameter name, @Nullable String type) {
        if (name == null) {
            PyDocstringGenerator.a(21);
        }
        PyDocstringGenerator pyDocstringGenerator = this.withParamTypedByName(this.getPreferredParameterName(name), type);
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(22);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withReturnValue(@Nullable String type) {
        this.k.add(new DocstringParam("", type, true, null));
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(23);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withoutParam(@NotNull String name) {
        if (name == null) {
            PyDocstringGenerator.a(24);
        }
        this.h.add(new DocstringParam(name, null, false, null));
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(25);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withQuotes(@NotNull String quotes) {
        if (quotes == null) {
            PyDocstringGenerator.a(26);
        }
        this.c = quotes;
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(27);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator useTypesFromDebuggerSignature(boolean use2) {
        this.e = use2;
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(28);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator addFirstEmptyLine() {
        this.f = true;
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(29);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator forceNewMode() {
        this.b = true;
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(30);
        }
        return pyDocstringGenerator;
    }

    @NotNull
    public PyDocstringGenerator withInferredParameters(boolean addReturn) {
        if (this.i instanceof PyFunction) {
            for (PyParameter pyParameter : ((PyFunction)this.i).getParameterList().getParameters()) {
                if (pyParameter.getAsNamed() == null) continue;
                String string = pyParameter.getName();
                StructuredDocString structuredDocString = this.a();
                if (StringUtil.isEmpty((String)string) || pyParameter.isSelf() || structuredDocString != null && structuredDocString.getParameters().contains(string)) continue;
                this.withParam((PyNamedParameter)pyParameter);
            }
            RaiseVisitor raiseVisitor = new RaiseVisitor(null);
            PyStatementList pyStatementList = ((PyFunction)this.i).getStatementList();
            pyStatementList.accept(raiseVisitor);
            if (!PyDocstringGenerator.a((PyFunction)this.i) && (raiseVisitor.a || addReturn)) {
                this.withReturnValue(null);
            }
        }
        PyDocstringGenerator pyDocstringGenerator = this;
        if (pyDocstringGenerator == null) {
            PyDocstringGenerator.a(31);
        }
        return pyDocstringGenerator;
    }

    private static boolean a(@NotNull PyFunction pyFunction) {
        String string;
        long l2 = m ^ 0x4263AEC4C056L;
        if (pyFunction == null) {
            PyDocstringGenerator.a(32);
        }
        return "__init__".equals(string = pyFunction.getName()) && pyFunction.getContainingClass() != null;
    }

    @NotNull
    public String getDocStringIndent() {
        String string = this.d;
        if (string == null) {
            PyDocstringGenerator.a(33);
        }
        return string;
    }

    @NotNull
    public DocStringFormat getDocStringFormat() {
        DocStringFormat docStringFormat = this.a;
        if (docStringFormat == null) {
            PyDocstringGenerator.a(34);
        }
        return docStringFormat;
    }

    public boolean isNewMode() {
        return this.b;
    }

    private void e() {
        if (this.l) {
            return;
        }
        HashSet hashSet = Sets.newHashSet();
        HashMap hashMap = Maps.newHashMap();
        for (DocstringParam object2 : this.k) {
            if (object2.getType() == null) {
                hashSet.add(Pair.create((Object)object2.getName(), (Object)object2.isReturnValue()));
                continue;
            }
            hashMap.put(Pair.create((Object)object2.getName(), (Object)object2.isReturnValue()), object2.getType());
        }
        PySignature pySignature = null;
        if (this.i instanceof PyFunction && this.e) {
            pySignature = PySignatureCacheManager.getInstance(this.i.getProject()).findSignature((PyFunction)this.i);
        }
        DocStringFormat docStringFormat = this.a;
        ArrayList arrayList = Lists.newArrayList();
        HashSet hashSet2 = Sets.newHashSet();
        for (DocstringParam docstringParam : this.k) {
            Pair pair = Pair.create((Object)docstringParam.getName(), (Object)docstringParam.isReturnValue());
            if (hashSet2.contains(pair)) continue;
            if (docstringParam.getType() == null) {
                String string = (String)hashMap.get(pair);
                if (string == null && PyCodeInsightSettings.getInstance().INSERT_TYPE_DOCSTUB) {
                    string = pySignature != null ? StringUtil.notNullize((String)(docstringParam.isReturnValue() ? pySignature.getReturnTypeQualifiedName() : pySignature.getArgTypeQualifiedName(docstringParam.getName()))) : "";
                }
                if (string != null) {
                    if (docStringFormat != DocStringFormat.GOOGLE && docStringFormat != DocStringFormat.NUMPY) {
                        arrayList.add(docstringParam);
                    }
                    arrayList.add(new DocstringParam(docstringParam.getName(), string, docstringParam.isReturnValue(), null));
                } else {
                    arrayList.add(docstringParam);
                }
            } else if (!hashSet.contains(pair)) {
                arrayList.add(docstringParam);
            }
            hashSet2.add(pair);
        }
        this.k.clear();
        this.k.addAll(arrayList);
        this.l = true;
    }

    public boolean hasParametersToAdd() {
        this.e();
        return !this.k.isEmpty();
    }

    @Nullable
    private PyStringLiteralExpression d() {
        long l2 = m ^ 0x3B385BB22F5L;
        Preconditions.checkNotNull((Object)this.i, (Object)"For this action docstring owner must be supplied");
        return this.i.getDocStringExpression();
    }

    @Nullable
    private StructuredDocString a() {
        return this.g == null ? null : DocStringUtil.parseDocString(this.a, this.g);
    }

    public void startTemplate() {
        String string;
        Substring substring;
        long l2 = m ^ 0x4255C8B8D544L;
        Preconditions.checkNotNull((Object)this.i, (Object)"For this action docstring owner must be supplied");
        PyStringLiteralExpression pyStringLiteralExpression = this.d();
        assert (pyStringLiteralExpression != null);
        TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)pyStringLiteralExpression);
        if (this.k.size() > 1) {
            throw new IllegalArgumentException("TemplateBuilder can be created only for one parameter");
        }
        DocstringParam docstringParam = this.f();
        DocStringFormat docStringFormat = this.a;
        if (docStringFormat == DocStringFormat.PLAIN) {
            return;
        }
        StructuredDocString structuredDocString = DocStringUtil.parseDocString(docStringFormat, pyStringLiteralExpression);
        if (docstringParam.isReturnValue()) {
            substring = structuredDocString.getReturnTypeSubstring();
        } else {
            string = docstringParam.getName();
            substring = structuredDocString.getParamTypeSubstring(string);
        }
        if (substring == null) {
            return;
        }
        templateBuilder.replaceRange(substring.getTextRange(), PyDocstringGenerator.c(this.f()));
        string = (Template)PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)this.i, document -> ((TemplateBuilderImpl)templateBuilder).buildInlineTemplate());
        VirtualFile virtualFile = this.i.getContainingFile().getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Project project = this.i.getProject();
        Editor editor2 = PsiUtilBase.findEditor((PsiElement)this.i);
        if (editor2 != null && string != null) {
            editor2.getCaretModel().moveToOffset(pyStringLiteralExpression.getTextOffset());
            TemplateManager.getInstance((Project)project).startTemplate(editor2, (Template)string);
        }
    }

    @NotNull
    public String getPreferredParameterName(@NotNull PyNamedParameter parameter) {
        if (parameter == null) {
            PyDocstringGenerator.a(35);
        }
        if (this.getDocStringFormat() == DocStringFormat.GOOGLE && parameter.getAsNamed() != null) {
            String string = parameter.getAsNamed().getRepr(false);
            if (string == null) {
                PyDocstringGenerator.a(36);
            }
            return string;
        }
        String string = StringUtil.notNullize((String)parameter.getName());
        if (string == null) {
            PyDocstringGenerator.a(37);
        }
        return string;
    }

    @NotNull
    private static String c(@NotNull DocstringParam docstringParam) {
        long l2 = m ^ 0x49CCDA864B16L;
        if (docstringParam == null) {
            PyDocstringGenerator.a(38);
        }
        if (StringUtil.isEmpty((String)docstringParam.getType())) {
            if ("object" == null) {
                PyDocstringGenerator.a(39);
            }
            return "object";
        }
        String string = docstringParam.getType();
        if (string == null) {
            PyDocstringGenerator.a(40);
        }
        return string;
    }

    @NotNull
    public String buildDocString() {
        this.e();
        if (this.b) {
            String string = this.b();
            if (string == null) {
                PyDocstringGenerator.a(41);
            }
            return string;
        }
        String string = this.c();
        if (string == null) {
            PyDocstringGenerator.a(42);
        }
        return string;
    }

    @NotNull
    private String b() {
        DocStringBuilder docStringBuilder = null;
        if (this.a == DocStringFormat.EPYTEXT || this.a == DocStringFormat.REST) {
            docStringBuilder = new TagBasedDocStringBuilder(this.a == DocStringFormat.EPYTEXT ? "@" : ":");
            TagBasedDocStringBuilder tagBasedDocStringBuilder = docStringBuilder;
            if (this.f) {
                tagBasedDocStringBuilder.addEmptyLine();
            }
            for (DocstringParam docstringParam2 : this.k) {
                if (docstringParam2.isReturnValue()) {
                    if (docstringParam2.getType() != null) {
                        tagBasedDocStringBuilder.addReturnValueType(docstringParam2.getType());
                        continue;
                    }
                    tagBasedDocStringBuilder.addReturnValueDescription("");
                    continue;
                }
                if (docstringParam2.getType() != null) {
                    tagBasedDocStringBuilder.addParameterType(docstringParam2.getName(), docstringParam2.getType());
                    continue;
                }
                tagBasedDocStringBuilder.addParameterDescription(docstringParam2.getName(), "");
            }
        } else if (this.a == DocStringFormat.GOOGLE || this.a == DocStringFormat.NUMPY) {
            Object object;
            List list2;
            docStringBuilder = this.a == DocStringFormat.GOOGLE ? GoogleCodeStyleDocStringBuilder.forSettings(this.j.getContainingFile()) : new NumpyDocStringBuilder();
            SectionBasedDocStringBuilder sectionBasedDocStringBuilder = (SectionBasedDocStringBuilder)docStringBuilder;
            if (this.f) {
                sectionBasedDocStringBuilder.addEmptyLine();
            }
            if (!(list2 = ContainerUtil.findAll(this.k, docstringParam -> !docstringParam.isReturnValue())).isEmpty()) {
                sectionBasedDocStringBuilder.startParametersSection();
                object = list2.iterator();
                while (object.hasNext()) {
                    DocstringParam docstringParam3 = (DocstringParam)object.next();
                    sectionBasedDocStringBuilder.addParameter(docstringParam3.getName(), docstringParam3.getType(), "");
                }
            }
            if (!(object = ContainerUtil.findAll(this.k, docstringParam -> docstringParam.isReturnValue())).isEmpty()) {
                sectionBasedDocStringBuilder.startReturnsSection();
                boolean bl2 = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    DocstringParam docstringParam4 = (DocstringParam)iterator.next();
                    if (!StringUtil.isNotEmpty((String)docstringParam4.getType())) continue;
                    sectionBasedDocStringBuilder.addReturnValue(null, docstringParam4.getType(), "");
                    bl2 = true;
                }
                if (!bl2) {
                    sectionBasedDocStringBuilder.addEmptyLine();
                }
            }
        }
        if (docStringBuilder != null && !docStringBuilder.getLines().isEmpty()) {
            String string = this.c + '\n' + docStringBuilder.buildContent(this.d, true) + '\n' + this.d + this.c;
            if (string == null) {
                PyDocstringGenerator.a(43);
            }
            return string;
        }
        String string = this.g();
        if (string == null) {
            PyDocstringGenerator.a(44);
        }
        return string;
    }

    @NotNull
    private String c() {
        DocStringUpdater docStringUpdater = null;
        if (this.a == DocStringFormat.EPYTEXT || this.a == DocStringFormat.REST) {
            Iterator<DocstringParam> iterator = this.a == DocStringFormat.EPYTEXT ? "@" : ":";
            docStringUpdater = new TagBasedDocStringUpdater((TagBasedDocString)this.a(), (String)((Object)iterator), this.d);
        } else if (this.a == DocStringFormat.GOOGLE) {
            docStringUpdater = GoogleCodeStyleDocStringUpdater.forSettings((GoogleCodeStyleDocString)this.a(), this.d, this.j.getContainingFile());
        } else if (this.a == DocStringFormat.NUMPY) {
            docStringUpdater = new NumpyDocStringUpdater((SectionBasedDocString)this.a(), this.d);
        } else if (this.g != null) {
            String string = this.g;
            if (string == null) {
                PyDocstringGenerator.a(45);
            }
            return string;
        }
        if (docStringUpdater != null) {
            for (DocstringParam docstringParam : this.k) {
                if (docstringParam.isReturnValue()) {
                    docStringUpdater.addReturnValue(docstringParam.getType());
                    continue;
                }
                docStringUpdater.addParameter(docstringParam.getName(), docstringParam.getType());
            }
            for (DocstringParam docstringParam : this.h) {
                if (docstringParam.isReturnValue()) continue;
                docStringUpdater.removeParameter(docstringParam.getName());
            }
            String string = docStringUpdater.getDocStringText();
            if (string == null) {
                PyDocstringGenerator.a(46);
            }
            return string;
        }
        String string = this.g();
        if (string == null) {
            PyDocstringGenerator.a(47);
        }
        return string;
    }

    @NotNull
    private String g() {
        String string = this.c + '\n' + this.d + this.c;
        if (string == null) {
            PyDocstringGenerator.a(48);
        }
        return string;
    }

    private DocstringParam f() {
        long l2 = m ^ 0xDB384724677L;
        if (this.k.size() == 0) {
            throw new IllegalStateException("We should have at least one param to edit");
        }
        return this.k.get(0);
    }

    @NotNull
    public PyDocStringOwner buildAndInsert() {
        long l2 = m ^ 0x4ED1BF126AFDL;
        Preconditions.checkNotNull((Object)this.i, (Object)"For this action docstring owner must be supplied");
        String string = this.buildDocString();
        Project project = this.i.getProject();
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(project);
        PyExpressionStatement pyExpressionStatement = pyElementGenerator.createDocstring(string);
        PyStringLiteralExpression pyStringLiteralExpression = this.d();
        if (pyStringLiteralExpression != null) {
            pyStringLiteralExpression.replace((PsiElement)pyExpressionStatement.getExpression());
        } else {
            PyStatementListContainer pyStatementListContainer = PyUtil.as(this.i, PyStatementListContainer.class);
            if (pyStatementListContainer == null) {
                throw new IllegalStateException("Should be a function or class");
            }
            PyStatementList pyStatementList = pyStatementListContainer.getStatementList();
            String string2 = PyIndentUtil.getElementIndent((PsiElement)pyStatementList);
            PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)this.i, (Consumer<? super Document>)((Consumer)document -> {
                PsiElement psiElement = pyStatementList.getPrevSibling();
                String string3 = "\n" + string2 + string;
                if (pyStatementList.getStatements().length > 0) {
                    string3 = string3 + "\n" + string2;
                }
                TextRange textRange = psiElement.getTextRange();
                if (!(psiElement instanceof PsiWhiteSpace)) {
                    document.insertString(textRange.getEndOffset(), (CharSequence)string3);
                } else if (pyStatementList.getStatements().length == 0 && psiElement.textContains('\n')) {
                    document.insertString(textRange.getStartOffset(), (CharSequence)string3);
                } else {
                    document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)string3);
                }
            }));
        }
        PyDocStringOwner pyDocStringOwner = this.i;
        if (pyDocStringOwner == null) {
            PyDocstringGenerator.a(49);
        }
        return pyDocStringOwner;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = m ^ 0x70AA52C6B8EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 1: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indentation";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsAnchor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docString";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 15: 
            case 19: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 17: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "param";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "quotes";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "forDocStringOwner";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 10: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "update";
                break;
            }
            case 16: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "withParam";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "withParamTypedByName";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "withReturnValue";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "withoutParam";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "withQuotes";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "useTypesFromDebuggerSignature";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "addFirstEmptyLine";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "forceNewMode";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "withInferredParameters";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocStringIndent";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocStringFormat";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreferredParameterName";
                break;
            }
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultType";
                break;
            }
            case 41: 
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDocString";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocString";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "updateDocString";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "createEmptyFallbackDocString";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAndInsert";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forDocStringOwner";
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 15: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "withParam";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "withParamTypedByName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "withoutParam";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "withQuotes";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "isConstructor";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getPreferredParameterName";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 8: 
            case 10: 
            case 14: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 33: 
            case 34: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RaiseVisitor
    extends PyRecursiveElementVisitor {
        private boolean c = false;
        private boolean a = false;
        @Nullable
        private PyExpression b = null;
        private static final long d = com.jetbrains.python.psi.c.a(-3640039917506441592L, -421222623442362685L, MethodHandles.lookup().lookupClass()).a(191318903914973L);

        private RaiseVisitor() {
        }

        @Override
        public void visitPyRaiseStatement(@NotNull PyRaiseStatement node) {
            if (node == null) {
                RaiseVisitor.a(0);
            }
            this.c = true;
            PyExpression[] pyExpressionArray = node.getExpressions();
            if (pyExpressionArray.length > 0) {
                this.b = pyExpressionArray[0];
            }
        }

        @Override
        public void visitPyReturnStatement(PyReturnStatement node) {
            this.a = true;
        }

        @NotNull
        public String getRaiseTargetText() {
            if (this.b != null) {
                PyExpression pyExpression;
                String string = this.b.getText();
                if (this.b instanceof PyCallExpression && (pyExpression = ((PyCallExpression)this.b).getCallee()) != null) {
                    string = pyExpression.getText();
                }
                String string2 = string;
                if (string2 == null) {
                    RaiseVisitor.a(1);
                }
                return string2;
            }
            if ("" == null) {
                RaiseVisitor.a(2);
            }
            return "";
        }

        /* synthetic */ RaiseVisitor(b x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = d ^ 0x36410C145D59L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator$RaiseVisitor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator$RaiseVisitor";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRaiseTargetText";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyRaiseStatement";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class DocstringParam {
        private final String a;
        private final String c;
        private final boolean b;
        private static final long d = com.jetbrains.python.psi.c.a(-6841639046855966930L, 2154076022245133696L, MethodHandles.lookup().lookupClass()).a(167378459934625L);

        private DocstringParam(@NotNull String name, @Nullable String type, boolean isReturn) {
            if (name == null) {
                DocstringParam.a(0);
            }
            this.a = name;
            this.c = type;
            this.b = isReturn;
        }

        @NotNull
        public String getName() {
            String string = this.a;
            if (string == null) {
                DocstringParam.a(1);
            }
            return string;
        }

        @Nullable
        public String getType() {
            return this.c;
        }

        public boolean isReturnValue() {
            return this.b;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            DocstringParam docstringParam = (DocstringParam)o2;
            if (this.b != docstringParam.b) {
                return false;
            }
            if (!this.a.equals(docstringParam.a)) {
                return false;
            }
            return !(this.c != null ? !this.c.equals(docstringParam.c) : docstringParam.c != null);
        }

        public int hashCode() {
            int n2 = this.a.hashCode();
            n2 = 31 * n2 + (this.c != null ? this.c.hashCode() : 0);
            n2 = 31 * n2 + (this.b ? 1 : 0);
            return n2;
        }

        public String toString() {
            long l2 = d ^ 0xB678C5B765BL;
            return "DocstringParam{myName='" + this.a + '\'' + ", myType='" + this.c + '\'' + ", myReturnValue=" + this.b + '}';
        }

        /* synthetic */ DocstringParam(String x0, String x1, boolean x2, b x3) {
            this(x0, x1, x2);
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = d ^ 0x5C33DFDD6773L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator$DocstringParam";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/docstrings/PyDocstringGenerator$DocstringParam";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

