/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation.docstrings;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.documentation.docstrings.DocStringLineParser;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.toolbox.Substring;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DocStringUpdater<T extends DocStringLineParser> {
    protected final T myOriginalDocString;
    private final StringBuilder b;
    private final List<Modification> a;
    protected final String myMinContentIndent;
    private static final long f = c.a(-4300145480028172084L, 7434796752337071165L, MethodHandles.lookup().lookupClass()).a(12189468074402L);

    public DocStringUpdater(@NotNull T docString, @NotNull String minContentIndent) {
        if (docString == null) {
            DocStringUpdater.a(0);
        }
        if (minContentIndent == null) {
            DocStringUpdater.a(1);
        }
        this.a = new ArrayList<Modification>();
        this.b = new StringBuilder(((DocStringLineParser)docString).getDocStringContent().getSuperString());
        this.myOriginalDocString = docString;
        this.myMinContentIndent = minContentIndent;
    }

    protected final void replace(@NotNull TextRange range, @NotNull String text2) {
        if (range == null) {
            DocStringUpdater.a(2);
        }
        if (text2 == null) {
            DocStringUpdater.a(3);
        }
        this.a.add(new Modification(range, text2));
    }

    protected final void replace(int startOffset, int endOffset, @NotNull String text2) {
        if (text2 == null) {
            DocStringUpdater.a(4);
        }
        this.replace(new TextRange(startOffset, endOffset), text2);
    }

    protected final void insert(int offset, @NotNull String text2) {
        if (text2 == null) {
            DocStringUpdater.a(5);
        }
        this.replace(offset, offset, text2);
    }

    protected final void insertAfterLine(int lineNumber, @NotNull String text2) {
        if (text2 == null) {
            DocStringUpdater.a(6);
        }
        Substring substring = ((DocStringLineParser)this.myOriginalDocString).getLines().get(lineNumber);
        this.insert(substring.getEndOffset(), '\n' + text2);
    }

    protected final void remove(int startOffset, int endOffset) {
        this.replace(startOffset, endOffset, "");
    }

    protected final void removeLines(int startLine, int endLine) {
        List<Substring> list2 = ((DocStringLineParser)this.myOriginalDocString).getLines();
        int n2 = list2.get(startLine).getStartOffset();
        int n3 = endLine < list2.size() ? list2.get(endLine).getStartOffset() : list2.get(endLine - 1).getEndOffset();
        this.remove(n2, n3);
    }

    protected final void removeLinesAndSpacesAfter(int startLine, int endLine) {
        this.removeLines(startLine, this.b(endLine));
    }

    private int b(int n2) {
        return Math.min(((DocStringLineParser)this.myOriginalDocString).consumeEmptyLines(n2), ((DocStringLineParser)this.myOriginalDocString).getLineCount() - 1);
    }

    protected final void removeLine(int line2) {
        this.removeLines(line2, line2 + 1);
    }

    protected final void insertBeforeLine(int lineNumber, @NotNull String text2) {
        if (text2 == null) {
            DocStringUpdater.a(7);
        }
        Substring substring = ((DocStringLineParser)this.myOriginalDocString).getLines().get(lineNumber);
        this.insert(substring.getStartOffset(), text2 + '\n');
    }

    @NotNull
    public final String getDocStringText() {
        this.beforeApplyingModifications();
        if (((DocStringLineParser)this.myOriginalDocString).getLineCount() == 1 && !this.a.isEmpty()) {
            this.insertAfterLine(0, this.myMinContentIndent);
        }
        Collections.reverse(this.a);
        Collections.sort(this.a, Collections.reverseOrder());
        for (Modification modification : this.a) {
            TextRange textRange = modification.range;
            if (textRange.getStartOffset() == textRange.getEndOffset()) {
                this.b.insert(textRange.getStartOffset(), modification.text);
                continue;
            }
            this.b.replace(textRange.getStartOffset(), textRange.getEndOffset(), modification.text);
        }
        String string = this.b.toString();
        if (string == null) {
            DocStringUpdater.a(8);
        }
        return string;
    }

    protected void beforeApplyingModifications() {
    }

    @NotNull
    public T getOriginalDocString() {
        T t2 = this.myOriginalDocString;
        if (t2 == null) {
            DocStringUpdater.a(9);
        }
        return t2;
    }

    @NotNull
    protected String getLineIndent(int lineNum) {
        String string = ((DocStringLineParser)this.myOriginalDocString).getLineIndent(lineNum);
        if (PyIndentUtil.getLineIndentSize(string) < PyIndentUtil.getLineIndentSize(this.myMinContentIndent)) {
            String string2 = this.myMinContentIndent;
            if (string2 == null) {
                DocStringUpdater.a(10);
            }
            return string2;
        }
        String string3 = string;
        if (string3 == null) {
            DocStringUpdater.a(11);
        }
        return string3;
    }

    protected int getLineIndentSize(int lineNum) {
        return PyIndentUtil.getLineIndentSize(this.getLineIndent(lineNum));
    }

    protected int findLastNonEmptyLine() {
        for (int i10 = ((DocStringLineParser)this.myOriginalDocString).getLineCount() - 1; i10 >= 0; --i10) {
            if (StringUtil.isEmptyOrSpaces((CharSequence)((DocStringLineParser)this.myOriginalDocString).getLine(i10))) continue;
            return i10;
        }
        return 0;
    }

    public abstract void addParameter(@NotNull String var1, @Nullable String var2);

    public abstract void addReturnValue(@Nullable String var1);

    public abstract void removeParameter(@NotNull String var1);

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x7D971196ACEBL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minContentIndent";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/documentation/docstrings/DocStringUpdater";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/documentation/docstrings/DocStringUpdater";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDocStringText";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOriginalDocString";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineIndent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insert";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "insertAfterLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "insertBeforeLine";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Modification
    implements Comparable<Modification> {
        @NotNull
        final TextRange range;
        @NotNull
        final String text;
        private static final long a = c.a(-1621829531933135114L, -8772609266616274707L, MethodHandles.lookup().lookupClass()).a(64551128969953L);

        Modification(@NotNull TextRange range, @NotNull String newText) {
            if (range == null) {
                Modification.a(0);
            }
            if (newText == null) {
                Modification.a(1);
            }
            this.range = range;
            this.text = newText;
        }

        @Override
        public int compareTo(Modification o2) {
            return this.range.getStartOffset() - o2.range.getStartOffset();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x31CA7B3D632EL;
            Object[] objectArray2 = new Object[3];
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "range";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "newText";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/python/documentation/docstrings/DocStringUpdater$Modification";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

