/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.documentation;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleType;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.documentation.DocumentationBuilderKit;
import com.jetbrains.python.documentation.PyDocumentationLink;
import com.jetbrains.python.documentation.b;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyBuiltinCache;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassLikeType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyDynamicallyEvaluatedType;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.PyTypedDictType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.toolbox.ChainIterable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeModelBuilder {
    private final Map<PyType, TypeModel> a = Maps.newHashMap();
    private final TypeEvalContext b;
    private static final long c = com.jetbrains.python.psi.c.a(-8520056154015173115L, -5094735484600449905L, MethodHandles.lookup().lookupClass()).a(24161702042436L);

    PyTypeModelBuilder(TypeEvalContext context) {
        this.b = context;
    }

    public TypeModel build(@Nullable PyType type, boolean allowUnions) {
        TypeModel typeModel = this.a.get(type);
        if (typeModel != null) {
            return typeModel;
        }
        if (this.a.containsKey(type)) {
            return NamedType.a(type);
        }
        this.a.put(type, null);
        TypeModel typeModel2 = null;
        if (type instanceof PyTypedDictType) {
            typeModel2 = ((PyTypedDictType)type).isInferred() ? new InferredTypedDictType(Collections.singletonList(this.build(((PyTypedDictType)type).getValuesType(), true))) : NamedType.a(type);
        } else if (type instanceof PyInstantiableType && ((PyInstantiableType)type).isDefinition()) {
            Object t2 = ((PyInstantiableType)type).toInstance();
            typeModel2 = type instanceof PyClassType && t2.equals(PyBuiltinCache.getInstance((PsiElement)((PyClassType)type).getPyClass()).getTypeType()) ? NamedType.a(type) : new ClassObjectType(this.build((PyType)t2, allowUnions));
        } else if (type instanceof PyNamedTupleType) {
            typeModel2 = NamedType.a(type);
        } else if (type instanceof PyTupleType) {
            PyTupleType pyTupleType = (PyTupleType)type;
            List<PyType> list2 = pyTupleType.isHomogeneous() ? Collections.singletonList(pyTupleType.getIteratedItemType()) : pyTupleType.getElementTypes();
            List list3 = ContainerUtil.map(list2, pyType -> this.build((PyType)pyType, true));
            typeModel2 = new TupleType(list3, pyTupleType.isHomogeneous());
        } else if (type instanceof PyCollectionType) {
            String string = type.getName();
            List<PyType> list4 = ((PyCollectionType)type).getElementTypes();
            ArrayList<TypeModel> arrayList = new ArrayList<TypeModel>();
            for (PyType pyType2 : list4) {
                arrayList.add(this.build(pyType2, true));
            }
            if (!arrayList.isEmpty()) {
                typeModel2 = new CollectionOf(string, arrayList, null);
            }
        } else if (type instanceof PyUnionType && allowUnions) {
            PyUnionType pyUnionType = (PyUnionType)type;
            Collection<PyType> collection = pyUnionType.getMembers();
            Ref<PyType> ref = PyTypeModelBuilder.a(pyUnionType);
            if (ref != null) {
                typeModel2 = new OptionalType(this.build((PyType)ref.get(), true), null);
            } else if (type instanceof PyDynamicallyEvaluatedType || PyTypeChecker.isUnknown(type, false, this.b)) {
                typeModel2 = new UnknownType(this.build(pyUnionType.excludeNull(this.b), true), null);
            } else if (collection.stream().allMatch(pyType -> pyType instanceof PyClassType && ((PyClassType)pyType).isDefinition())) {
                List list5 = ContainerUtil.map(collection, pyType -> this.build((PyType)((PyClassType)pyType).toInstance(), allowUnions));
                typeModel2 = new ClassObjectType(new OneOf(list5, null));
            } else {
                typeModel2 = new OneOf(Collections2.transform(collection, pyType -> this.build((PyType)pyType, false)), null);
            }
        } else if (type instanceof PyCallableType && !(type instanceof PyClassLikeType)) {
            typeModel2 = this.a((PyCallableType)type);
        } else if (type instanceof PyGenericType) {
            typeModel2 = new GenericType(type.getName());
        }
        if (typeModel2 == null) {
            typeModel2 = NamedType.a(type);
        }
        this.a.put(type, typeModel2);
        return typeModel2;
    }

    @Nullable
    private static Ref<PyType> a(@NotNull PyUnionType pyUnionType) {
        Collection<PyType> collection;
        if (pyUnionType == null) {
            PyTypeModelBuilder.a(0);
        }
        if ((collection = pyUnionType.getMembers()).size() == 2) {
            boolean bl2 = false;
            PyType pyType = null;
            for (PyType pyType2 : collection) {
                if (PyNoneType.INSTANCE.equals(pyType2)) {
                    bl2 = true;
                    continue;
                }
                if (pyType2 == null) continue;
                pyType = pyType2;
            }
            if (bl2) {
                return Ref.create(pyType);
            }
        }
        return null;
    }

    private TypeModel a(@NotNull PyCallableType pyCallableType) {
        if (pyCallableType == null) {
            PyTypeModelBuilder.a(1);
        }
        ArrayList<ParamType> arrayList = null;
        List<PyCallableParameter> list2 = pyCallableType.getParameters(this.b);
        if (list2 != null) {
            arrayList = new ArrayList<ParamType>();
            for (PyCallableParameter object2 : list2) {
                arrayList.add(new ParamType(object2.getName(), this.build(object2.getType(this.b), true), null));
            }
        }
        PyType pyType = pyCallableType.getReturnType(this.b);
        TypeModel typeModel = this.build(pyType, true);
        return new FunctionType(typeModel, arrayList, null);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = c ^ 0x3469D296DE5CL;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "type";
        objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getOptionalType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "buildCallable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static abstract class TypeNameVisitor
    implements TypeVisitor {
        private int a = 0;
        private static final int b = 6;
        private static final long e = com.jetbrains.python.psi.c.a(-8407500581942455882L, 7479193214250128544L, MethodHandles.lookup().lookupClass()).a(175414515230165L);

        private TypeNameVisitor() {
        }

        @Override
        public void oneOf(OneOf oneOf) {
            long l2 = e ^ 0x5BD2D5CBFF77L;
            ++this.a;
            if (this.maxDepthExceeded()) {
                this.add("...");
                return;
            }
            this.add("Union[");
            this.processList(oneOf.a);
            this.add("]");
            --this.a;
        }

        protected void processList(@NotNull Collection<TypeModel> list2) {
            long l2 = e ^ 0x2B7E06B17654L;
            if (list2 == null) {
                TypeNameVisitor.a(0);
            }
            boolean bl2 = true;
            for (TypeModel typeModel : list2) {
                if (!bl2) {
                    this.add(", ");
                } else {
                    bl2 = false;
                }
                typeModel.accept(this);
            }
        }

        protected abstract void add(String var1);

        @Override
        public void collectionOf(CollectionOf collectionOf) {
            long l2 = e ^ 0x25A1A14CCB0DL;
            ++this.a;
            if (this.maxDepthExceeded()) {
                this.add("...");
                return;
            }
            boolean bl2 = ContainerUtil.and((Iterable)collectionOf.a, typeModel -> typeModel == NamedType.a);
            if (bl2) {
                this.name(collectionOf.b);
            } else {
                this.typingGenericFormat(collectionOf);
            }
            --this.a;
        }

        protected void typingGenericFormat(CollectionOf collectionOf) {
            String string = collectionOf.b;
            this.addType((String)PyTypingTypeProvider.TYPING_COLLECTION_CLASSES.getOrDefault((Object)string, (Object)string));
            if (!collectionOf.a.isEmpty()) {
                this.add("[");
                this.processList(collectionOf.a);
                this.add("]");
            }
        }

        protected abstract void addType(String var1);

        @Override
        public void name(String name) {
            this.addType(name);
        }

        @Override
        public void function(FunctionType function) {
            long l2 = e ^ 0x58E0BB452A2AL;
            ++this.a;
            if (this.maxDepthExceeded()) {
                this.add("...");
                return;
            }
            this.add("(");
            Collection collection = function.b;
            if (collection != null) {
                this.processList(collection);
            } else {
                this.add("...");
            }
            this.add(") -> ");
            function.a.accept(this);
            --this.a;
        }

        protected boolean maxDepthExceeded() {
            return this.a > 6;
        }

        @Override
        public void param(ParamType param) {
            long l2 = e ^ 0x64355BA05058L;
            ++this.a;
            if (this.maxDepthExceeded()) {
                this.add("...");
                return;
            }
            if (param.a != null) {
                this.add(param.a);
            }
            if (param.b != null) {
                if (param.a != null) {
                    this.add(": ");
                }
                param.b.accept(this);
            }
            --this.a;
        }

        @Override
        public void unknown(UnknownType type) {
            type.a.accept(this);
        }

        @Override
        public void optional(OptionalType type) {
            long l2 = e ^ 0x6ADE3AB5AF1L;
            this.add("Optional[");
            type.a.accept(this);
            this.add("]");
        }

        @Override
        public void tuple(TupleType type) {
            long l2 = e ^ 0x5DA3E823FD4L;
            this.add("Tuple");
            if (!type.b.isEmpty()) {
                this.add("[");
                this.processList(type.b);
                if (type.a) {
                    this.add(", ...");
                }
                this.add("]");
            }
        }

        @Override
        public void typedDict(InferredTypedDictType type) {
            long l2 = e ^ 0x50E7415D415EL;
            this.add("Dict[str, ");
            boolean bl2 = true;
            if (!type.a.isEmpty()) {
                for (TypeModel typeModel : type.a) {
                    if (!bl2) {
                        this.add(", ");
                    } else {
                        bl2 = false;
                    }
                    typeModel.accept(this);
                }
                this.add("]");
            }
        }

        @Override
        public void classObject(ClassObjectType type) {
            long l2 = e ^ 0x26DE1168271DL;
            this.add("Type[");
            type.a.accept(this);
            this.add("]");
        }

        @Override
        public void genericType(GenericType type) {
            this.add(type.a);
        }

        /* synthetic */ TypeNameVisitor(b x0) {
            this();
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = e ^ 0x3DB0937371D7L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeNameVisitor", "processList"));
        }
    }

    private static class TypeToDescriptionVisitor
    extends TypeNameVisitor {
        @NotNull
        private final StringBuilder c = new StringBuilder();
        private static final long d = com.jetbrains.python.psi.c.a(-3660612282579733281L, 242276364838631209L, MethodHandles.lookup().lookupClass()).a(186017800626098L);

        private TypeToDescriptionVisitor() {
            super(null);
        }

        @Override
        protected void add(String s2) {
            this.c.append(s2);
        }

        @Override
        protected void addType(String name) {
            this.add(name);
        }

        @NotNull
        public String getDescription() {
            String string = this.c.toString();
            if (string == null) {
                TypeToDescriptionVisitor.b(0);
            }
            return string;
        }

        /* synthetic */ TypeToDescriptionVisitor(b x0) {
            this();
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = d ^ 0x18ED4B12C014L;
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeToDescriptionVisitor", "getDescription"));
        }
    }

    private static class TypeToBodyWithLinksVisitor
    extends TypeNameVisitor {
        private final ChainIterable<String> c;
        private final PsiElement d;

        TypeToBodyWithLinksVisitor(ChainIterable<String> body, PsiElement anchor) {
            super(null);
            this.c = body;
            this.d = anchor;
        }

        @Override
        protected void add(String s2) {
            this.c.addItem(DocumentationBuilderKit.combUp(s2));
        }

        @Override
        protected void addType(String name) {
            TypeEvalContext typeEvalContext = TypeEvalContext.userInitiated(this.d.getProject(), this.d.getContainingFile());
            this.c.addItem(PyDocumentationLink.toPossibleClass(name, this.d, typeEvalContext));
        }
    }

    private static class TypeToPep484TypeHintVisitor
    extends TypeToStringVisitor {
        private static final long d = com.jetbrains.python.psi.c.a(1495164825961549586L, 4677124121006922022L, MethodHandles.lookup().lookupClass()).a(17567536121279L);

        private TypeToPep484TypeHintVisitor() {
            super(null);
        }

        @Override
        protected boolean maxDepthExceeded() {
            return false;
        }

        @Override
        public void function(FunctionType function) {
            long l2 = d ^ 0x786DA86953EDL;
            this.add("Callable[");
            Collection collection = function.b;
            if (collection != null) {
                this.add("[");
                this.processList(collection);
                this.add("]");
            } else {
                this.add("...");
            }
            this.add(", ");
            function.a.accept(this);
            this.add("]");
        }

        @Override
        public void param(ParamType param) {
            long l2 = d ^ 0x44B8488C299FL;
            if (param.b != null) {
                param.b.accept(this);
            } else {
                this.add("Any");
            }
        }

        @Override
        public void collectionOf(CollectionOf collectionOf) {
            this.typingGenericFormat(collectionOf);
        }

        /* synthetic */ TypeToPep484TypeHintVisitor(b x0) {
            this();
        }
    }

    private static class TypeToStringVisitor
    extends TypeNameVisitor {
        private final StringBuilder c = new StringBuilder();
        private static final long f = com.jetbrains.python.psi.c.a(3263933341615648685L, -5184704644639937330L, MethodHandles.lookup().lookupClass()).a(86393816397791L);

        private TypeToStringVisitor() {
            super(null);
        }

        @Override
        protected void add(String s2) {
            this.c.append(s2);
        }

        @Override
        protected void addType(String name) {
            this.add(name);
        }

        public String getString() {
            return this.c.toString();
        }

        @Override
        public void unknown(UnknownType type) {
            long l2 = f ^ 0x652A21D8404DL;
            TypeModel typeModel = type.a;
            if (typeModel != null) {
                this.add("Union[");
                typeModel.accept(this);
                this.add(", Any");
                this.add("]");
            }
        }

        /* synthetic */ TypeToStringVisitor(b x0) {
            this();
        }
    }

    private static interface TypeVisitor {
        public void oneOf(OneOf var1);

        public void collectionOf(CollectionOf var1);

        public void name(String var1);

        public void function(FunctionType var1);

        public void param(ParamType var1);

        public void unknown(UnknownType var1);

        public void optional(OptionalType var1);

        public void tuple(TupleType var1);

        public void typedDict(InferredTypedDictType var1);

        public void classObject(ClassObjectType var1);

        public void genericType(GenericType var1);
    }

    static class GenericType
    extends TypeModel {
        private final String a;
        private static final long b = com.jetbrains.python.psi.c.a(-1723937399671869404L, 391847596333508666L, MethodHandles.lookup().lookupClass()).a(138183008000655L);

        GenericType(@Nullable String name) {
            this.a = name;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                GenericType.b(0);
            }
            visitor2.genericType(this);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = b ^ 0x387C34DA413DL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$GenericType", "accept"));
        }
    }

    static class ClassObjectType
    extends TypeModel {
        private final TypeModel a;
        private static final long b = com.jetbrains.python.psi.c.a(7493621110974001353L, 4202754459317294744L, MethodHandles.lookup().lookupClass()).a(12329264107797L);

        ClassObjectType(TypeModel classType) {
            this.a = classType;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                ClassObjectType.b(0);
            }
            visitor2.classObject(this);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = b ^ 0x18653F4DF9ABL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$ClassObjectType", "accept"));
        }
    }

    static class ParamType
    extends TypeModel {
        @Nullable
        private final String a;
        @Nullable
        private final TypeModel b;
        private static final long c = com.jetbrains.python.psi.c.a(6567373996585667337L, 8866490849637940229L, MethodHandles.lookup().lookupClass()).a(69235420237616L);

        private ParamType(@Nullable String name, @Nullable TypeModel type) {
            this.a = name;
            this.b = type;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                ParamType.b(0);
            }
            visitor2.param(this);
        }

        /* synthetic */ ParamType(String x0, TypeModel x1, b x2) {
            this(x0, x1);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = c ^ 0x1589F3610C01L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$ParamType", "accept"));
        }
    }

    static class FunctionType
    extends TypeModel {
        @NotNull
        private final TypeModel a;
        @Nullable
        private final Collection<TypeModel> b;
        private static final long c = com.jetbrains.python.psi.c.a(3883054600604616117L, -973533085980473333L, MethodHandles.lookup().lookupClass()).a(30729179261956L);

        private FunctionType(@Nullable TypeModel returnType, @Nullable Collection<TypeModel> parameters) {
            this.a = returnType != null ? returnType : NamedType.a;
            this.b = parameters;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                FunctionType.b(0);
            }
            visitor2.function(this);
        }

        /* synthetic */ FunctionType(TypeModel x0, Collection x1, b x2) {
            this(x0, x1);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = c ^ 0x6929C97A1993L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$FunctionType", "accept"));
        }
    }

    static class InferredTypedDictType
    extends TypeModel {
        private final List<TypeModel> a;
        private static final long b = com.jetbrains.python.psi.c.a(-2988739388389236785L, -2217441434800259166L, MethodHandles.lookup().lookupClass()).a(240430343329644L);

        InferredTypedDictType(List<TypeModel> members) {
            this.a = members;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                InferredTypedDictType.b(0);
            }
            visitor2.typedDict(this);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = b ^ 0x7CECC0E5F17EL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$InferredTypedDictType", "accept"));
        }
    }

    static class TupleType
    extends TypeModel {
        private final List<TypeModel> b;
        private final boolean a;
        private static final long c = com.jetbrains.python.psi.c.a(-8814748719527008428L, 6947382463147911278L, MethodHandles.lookup().lookupClass()).a(172207412248330L);

        TupleType(List<TypeModel> members, boolean homogeneous) {
            this.b = members;
            this.a = homogeneous;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                TupleType.b(0);
            }
            visitor2.tuple(this);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = c ^ 0xCC6215B7CA8L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$TupleType", "accept"));
        }
    }

    static class OptionalType
    extends TypeModel {
        private final TypeModel a;
        private static final long b = com.jetbrains.python.psi.c.a(8333377972547643193L, 8885972880997092447L, MethodHandles.lookup().lookupClass()).a(13820018404756L);

        private OptionalType(TypeModel type) {
            this.a = type;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                OptionalType.b(0);
            }
            visitor2.optional(this);
        }

        /* synthetic */ OptionalType(TypeModel x0, b x1) {
            this(x0);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = b ^ 0x7D4DE606CD7BL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$OptionalType", "accept"));
        }
    }

    static class UnknownType
    extends TypeModel {
        private final TypeModel a;
        private static final long b = com.jetbrains.python.psi.c.a(7315905969372307152L, 1291605350890117886L, MethodHandles.lookup().lookupClass()).a(270220288678949L);

        private UnknownType(TypeModel type) {
            this.a = type;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                UnknownType.b(0);
            }
            visitor2.unknown(this);
        }

        /* synthetic */ UnknownType(TypeModel x0, b x1) {
            this(x0);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = b ^ 0x164E5D3807DCL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$UnknownType", "accept"));
        }
    }

    static class NamedType
    extends TypeModel {
        @NotNull
        private static final NamedType a;
        @Nullable
        private final String b;
        private static final long c;

        private NamedType(@Nullable String name) {
            this.b = name;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                NamedType.b(0);
            }
            visitor2.name(this.b);
        }

        @NotNull
        private static NamedType a(@Nullable PyType pyType) {
            NamedType namedType = pyType == null ? a : new NamedType(pyType.getName());
            if (namedType == null) {
                NamedType.b(1);
            }
            return namedType;
        }

        static {
            c = com.jetbrains.python.psi.c.a(3369849289832916975L, -8311023144541987139L, MethodHandles.lookup().lookupClass()).a(206588575741029L);
            long l2 = c ^ 0x7CF1CB20DFEBL;
            a = new NamedType("Any");
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x64A6BDA5A294L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "visitor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeModelBuilder$NamedType";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder$NamedType";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nameOrAny";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "accept";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    static class CollectionOf
    extends TypeModel {
        private final String b;
        private final List<TypeModel> a;
        private static final long c = com.jetbrains.python.psi.c.a(-3449047128390452896L, 84232052572635394L, MethodHandles.lookup().lookupClass()).a(219973455902186L);

        private CollectionOf(String collectionName, List<TypeModel> elementTypes) {
            this.b = collectionName;
            this.a = elementTypes;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                CollectionOf.b(0);
            }
            visitor2.collectionOf(this);
        }

        /* synthetic */ CollectionOf(String x0, List x1, b x2) {
            this(x0, x1);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = c ^ 0x6449B18CEC5L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$CollectionOf", "accept"));
        }
    }

    static class OneOf
    extends TypeModel {
        private final Collection<TypeModel> a;
        private static final long b = com.jetbrains.python.psi.c.a(1714281947148493386L, 7611560913689083575L, MethodHandles.lookup().lookupClass()).a(59502509176465L);

        private OneOf(Collection<TypeModel> oneOfTypes) {
            this.a = oneOfTypes;
        }

        @Override
        void accept(@NotNull TypeVisitor visitor2) {
            if (visitor2 == null) {
                OneOf.b(0);
            }
            visitor2.oneOf(this);
        }

        /* synthetic */ OneOf(Collection x0, b x1) {
            this(x0);
        }

        private static /* synthetic */ void b(int n2) {
            long l2 = b ^ 0x4FC4E1BF17D7L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/jetbrains/python/documentation/PyTypeModelBuilder$OneOf", "accept"));
        }
    }

    static abstract class TypeModel {
        private static final long d = com.jetbrains.python.psi.c.a(-755165945076019544L, -2348716810865097219L, MethodHandles.lookup().lookupClass()).a(34792149315673L);

        TypeModel() {
        }

        abstract void accept(@NotNull TypeVisitor var1);

        @NotNull
        public String asString() {
            TypeToStringVisitor typeToStringVisitor = new TypeToStringVisitor(null);
            this.accept(typeToStringVisitor);
            String string = typeToStringVisitor.getString();
            if (string == null) {
                TypeModel.a(0);
            }
            return string;
        }

        public void toBodyWithLinks(@NotNull ChainIterable<String> body, @NotNull PsiElement anchor) {
            if (body == null) {
                TypeModel.a(1);
            }
            if (anchor == null) {
                TypeModel.a(2);
            }
            TypeToBodyWithLinksVisitor typeToBodyWithLinksVisitor = new TypeToBodyWithLinksVisitor(body, anchor);
            this.accept(typeToBodyWithLinksVisitor);
        }

        @NotNull
        public String asDescription() {
            TypeToDescriptionVisitor typeToDescriptionVisitor = new TypeToDescriptionVisitor(null);
            this.accept(typeToDescriptionVisitor);
            String string = typeToDescriptionVisitor.getDescription();
            if (string == null) {
                TypeModel.a(3);
            }
            return string;
        }

        @NotNull
        public String asPep484TypeHint() {
            TypeToPep484TypeHintVisitor typeToPep484TypeHintVisitor = new TypeToPep484TypeHintVisitor(null);
            this.accept(typeToPep484TypeHintVisitor);
            String string = typeToPep484TypeHintVisitor.getString();
            if (string == null) {
                TypeModel.a(4);
            }
            return string;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = d ^ 0x433DB5B40F6CL;
            switch (n2) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeModel";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "body";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asString";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/documentation/PyTypeModelBuilder$TypeModel";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asDescription";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "asPep484TypeHint";
                    break;
                }
            }
            switch (n2) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "toBodyWithLinks";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

