/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.remote.vfs;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathMappingSettings;
import com.intellij.util.PathUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.remote.ui.PyMappingSimpleResolveDialog;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.remote.PyRemotePathMapper;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public abstract class PyPathMapper {
    public static final Pattern WINDOWS_VOLUME_NAME;
    private static final long a;

    @NotNull
    public static String[] getPath(@NotNull String originalPath) {
        String string;
        long l2 = a ^ 0x70C51B20F6B6L;
        if (originalPath == null) {
            PyPathMapper.a(0);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Matcher matcher = WINDOWS_VOLUME_NAME.matcher(originalPath);
        if (matcher.matches()) {
            arrayList.add(matcher.group(1));
            string = matcher.group(2);
        } else {
            string = originalPath;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/\\");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        String[] stringArray = ArrayUtilRt.toStringArray(arrayList);
        if (stringArray == null) {
            PyPathMapper.a(1);
        }
        return stringArray;
    }

    @NotNull
    public static String[] intersectFromEnd(@NotNull String path1, @NotNull String path2, boolean caseSensitive) {
        if (path1 == null) {
            PyPathMapper.a(2);
        }
        if (path2 == null) {
            PyPathMapper.a(3);
        }
        String[] stringArray = PyPathMapper.intersectFromEnd(PyPathMapper.getPath(path1), PyPathMapper.getPath(path2), caseSensitive);
        if (stringArray == null) {
            PyPathMapper.a(4);
        }
        return stringArray;
    }

    @NotNull
    public static String[] intersectFromEnd(String[] arr1, String[] arr2, boolean caseSensitive) {
        int n2 = arr1.length - 1;
        for (int i10 = arr2.length - 1; n2 > -1 && i10 > -1 && (caseSensitive ? arr1[n2].equals(arr2[i10]) : arr1[n2].equalsIgnoreCase(arr2[i10])); --n2, --i10) {
        }
        String[] stringArray = Arrays.copyOfRange(arr1, n2 + 1, arr1.length);
        if (stringArray == null) {
            PyPathMapper.a(5);
        }
        return stringArray;
    }

    public static boolean detectLocalPath(@NotNull Project project, @NotNull String remoteFilePath, @NotNull PyRemotePathMapper pathMapper) {
        if (project == null) {
            PyPathMapper.a(6);
        }
        if (remoteFilePath == null) {
            PyPathMapper.a(7);
        }
        if (pathMapper == null) {
            PyPathMapper.a(8);
        }
        Collection collection = (Collection)ReadAction.compute(() -> FilenameIndex.getVirtualFilesByName((Project)project, (String)PathUtil.getFileName((String)remoteFilePath), (GlobalSearchScope)GlobalSearchScope.allScope((Project)project)));
        PyMappingSimpleResolveDialog pyMappingSimpleResolveDialog = new PyMappingSimpleResolveDialog(project, remoteFilePath, collection);
        UIUtil.invokeAndWaitIfNeeded(() -> pyMappingSimpleResolveDialog.show());
        if (pyMappingSimpleResolveDialog.isOK()) {
            VirtualFile virtualFile = pyMappingSimpleResolveDialog.getSelectedFile();
            PyPathMapper.updateMapping(virtualFile, remoteFilePath, pathMapper);
            return true;
        }
        return false;
    }

    public static void updateMapping(VirtualFile virtualFile, String remoteFilePath, PyRemotePathMapper pathMapper) {
        PathMappingSettings.PathMapping pathMapping = PyPathMapper.detectMapping(virtualFile.getPath(), remoteFilePath);
        pathMapper.addMapping(pathMapping.getLocalRoot(), pathMapping.getRemoteRoot(), PyRemotePathMapper.PyPathMappingType.USER_DEFINED);
    }

    @NotNull
    public static PathMappingSettings.PathMapping detectMapping(String localPath, String remotePath) {
        localPath = FileUtil.toSystemIndependentName((String)localPath);
        remotePath = FileUtil.toSystemIndependentName((String)remotePath);
        int n2 = 1;
        int n3 = 1;
        while (n2 < remotePath.length() && n2 < localPath.length() && localPath.charAt(localPath.length() - n2) == remotePath.charAt(remotePath.length() - n2)) {
            if (localPath.charAt(localPath.length() - ++n2) != '/' || remotePath.charAt(remotePath.length() - n2) != '/' || n2 == localPath.length() || n2 == remotePath.length()) continue;
            n3 = n2;
        }
        PathMappingSettings.PathMapping pathMapping = new PathMappingSettings.PathMapping(PyPathMapper.a(localPath, n3), PyPathMapper.a(remotePath, n3));
        if (pathMapping == null) {
            PyPathMapper.a(9);
        }
        return pathMapping;
    }

    private static String a(String string, int n2) {
        if (n2 < string.length()) {
            return string.substring(0, string.length() - n2 + 1);
        }
        return "";
    }

    static {
        a = c.a(8515563253746450544L, 4491784653786926692L, MethodHandles.lookup().lookupClass()).a(191924425156276L);
        long l2 = a ^ 0x537059935FBBL;
        WINDOWS_VOLUME_NAME = Pattern.compile("([A-Za-z]:)[/\\\\](.*)");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x4F0C0582743L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalPath";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/remote/vfs/PyPathMapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path1";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path2";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteFilePath";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathMapper";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/remote/vfs/PyPathMapper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "intersectFromEnd";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "detectMapping";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPath";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "intersectFromEnd";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "detectLocalPath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

