/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.array;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.python.debugger.containerview.ColoredCellRenderer;
import com.jetbrains.python.debugger.containerview.PyNumericViewUtil;
import com.jetbrains.python.psi.c;
import java.awt.Color;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import javax.swing.JTable;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.jetbrains.annotations.NotNull;

class ArrayTableCellRenderer
extends DefaultTableCellRenderer
implements ColoredCellRenderer {
    private static final Logger g;
    private double c = Double.MIN_VALUE;
    private double f = Double.MIN_VALUE;
    private String e;
    private String a;
    private boolean b = true;
    private final String d;
    private static final long h;

    ArrayTableCellRenderer(double min, double max, String type) {
        this.setHorizontalAlignment(2);
        this.setHorizontalTextPosition(2);
        this.setVerticalAlignment(0);
        this.c = min;
        this.f = max;
        this.d = type;
    }

    @Override
    public void setColored(boolean colored) {
        this.b = colored;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int col) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, col);
        if (value != null) {
            this.setText(value.toString());
        }
        if (hasFocus) {
            this.setBorder(new LineBorder((Color)JBColor.BLUE, 2));
        }
        if (this.f != this.c) {
            if (this.b && value != null) {
                try {
                    double d10 = PyNumericViewUtil.getRangedValue(value.toString(), this.d, this.c, this.f, this.a, this.e);
                    this.setBackground(PyNumericViewUtil.rangedValueToColor(d10));
                }
                catch (NumberFormatException numberFormatException) {}
            } else {
                this.setBackground(UIUtil.getBgFillColor((Component)table));
            }
        }
        return this;
    }

    public void setMin(double min) {
        this.c = min;
    }

    public void setMax(double max) {
        this.f = max;
    }

    public double getMin() {
        return this.c;
    }

    public double getMax() {
        return this.f;
    }

    public void fillColorRange(@NotNull String minValue, @NotNull String maxValue) {
        long l2 = h ^ 0x2D5E54911090L;
        if (minValue == null) {
            ArrayTableCellRenderer.a(0);
        }
        if (maxValue == null) {
            ArrayTableCellRenderer.a(1);
        }
        if ("c".equals(this.d)) {
            this.c = 0.0;
            this.f = 1.0;
            this.e = minValue;
            this.a = maxValue;
            return;
        }
        if ("b".equals(this.d)) {
            this.c = "True".equals(minValue) ? 1.0 : 0.0;
            this.f = "True".equals(maxValue) ? 1.0 : 0.0;
            return;
        }
        try {
            this.c = Double.parseDouble(minValue);
            this.f = Double.parseDouble(maxValue);
        }
        catch (NumberFormatException numberFormatException) {
            g.error(String.format("Wrong bounds for '%s' type: minValue = %s, maxValue = %s", this.d, minValue, maxValue));
        }
    }

    static {
        h = com.jetbrains.python.psi.c.a(-4443513682050389874L, 131929685270434411L, MethodHandles.lookup().lookupClass()).a(249180732630614L);
        g = Logger.getInstance(ArrayTableCellRenderer.class);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = h ^ 0x7AEB33C0C45BL;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "minValue";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "maxValue";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/debugger/array/ArrayTableCellRenderer";
        objectArray[2] = "fillColorRange";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

