/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ArrayUtilRt;
import com.jetbrains.python.debugger.PySignature;
import com.jetbrains.python.debugger.PySignatureCacheManager;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.c;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySignatureCacheManagerImpl
extends PySignatureCacheManager {
    protected static final Logger LOG;
    private static final boolean a = false;
    public static final FileAttribute CALL_SIGNATURES_ATTRIBUTE;
    private final Project b;
    private final LoadingCache<VirtualFile, String> c = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<VirtualFile, String>(){

        public String load(VirtualFile key) throws Exception {
            return PySignatureCacheManagerImpl.b(key);
        }
    });
    private static final long e;

    public PySignatureCacheManagerImpl(Project project) {
        this.b = project;
    }

    @Override
    public void recordSignature(@NotNull PySignature signature) {
        if (signature == null) {
            PySignatureCacheManagerImpl.a(0);
        }
        GlobalSearchScope globalSearchScope = ProjectScope.getProjectScope((Project)this.b);
        VirtualFile virtualFile = PySignatureCacheManagerImpl.a(signature);
        if (virtualFile != null && globalSearchScope.contains(virtualFile)) {
            this.a(virtualFile, signature);
        }
    }

    private void a(VirtualFile virtualFile, PySignature pySignature) {
        String string = this.a(virtualFile);
        String[] stringArray = string != null ? string.split("\n") : ArrayUtilRt.EMPTY_STRING_ARRAY;
        boolean bl2 = false;
        int n2 = 0;
        for (String string2 : stringArray) {
            String[] stringArray2 = string2.split("\t");
            if (stringArray2.length > 0 && stringArray2[0].equals(pySignature.getFunctionName())) {
                bl2 = true;
                stringArray[n2] = PySignatureCacheManagerImpl.changeSignatureString(virtualFile.getCanonicalPath(), pySignature, stringArray[n2]);
            }
            ++n2;
        }
        if (!bl2) {
            String[] stringArray3 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
            stringArray3[stringArray3.length - 1] = PySignatureCacheManagerImpl.signatureToString(pySignature);
            stringArray = stringArray3;
        }
        String string3 = StringUtil.join((String[])stringArray, (String)"\n");
        this.a(virtualFile, string3);
    }

    static String changeSignatureString(@NotNull String filePath, @NotNull PySignature signature, @NotNull String oldSignatureString) {
        if (filePath == null) {
            PySignatureCacheManagerImpl.a(1);
        }
        if (signature == null) {
            PySignatureCacheManagerImpl.a(2);
        }
        if (oldSignatureString == null) {
            PySignatureCacheManagerImpl.a(3);
        }
        return PySignatureCacheManagerImpl.signatureToString(PySignatureCacheManagerImpl.a(filePath, oldSignatureString).addAllArgs(signature).addReturnType(signature.getReturnTypeQualifiedName()));
    }

    private void a(@NotNull VirtualFile virtualFile, @NotNull String string) {
        String string2;
        if (virtualFile == null) {
            PySignatureCacheManagerImpl.a(4);
        }
        if (string == null) {
            PySignatureCacheManagerImpl.a(5);
        }
        if (!string.equals(string2 = (String)this.c.asMap().get(virtualFile))) {
            this.c.put((Object)virtualFile, (Object)string);
            PySignatureCacheManagerImpl.b(virtualFile, string);
        }
    }

    private static void b(@NotNull VirtualFile virtualFile, @NotNull String string) {
        long l2 = e ^ 0xEBCF6B83AAL;
        if (virtualFile == null) {
            PySignatureCacheManagerImpl.a(6);
        }
        if (string == null) {
            PySignatureCacheManagerImpl.a(7);
        }
        try {
            CALL_SIGNATURES_ATTRIBUTE.writeAttributeBytes(virtualFile, string.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            LOG.warn("Can't write attribute " + virtualFile.getCanonicalPath() + " " + string);
        }
    }

    @Override
    @Nullable
    public String findParameterType(@NotNull PyFunction function, @NotNull String name) {
        PySignature pySignature;
        if (function == null) {
            PySignatureCacheManagerImpl.a(8);
        }
        if (name == null) {
            PySignatureCacheManagerImpl.a(9);
        }
        if ((pySignature = this.findSignature(function)) != null) {
            return pySignature.getArgTypeQualifiedName(name);
        }
        return null;
    }

    @Override
    @Nullable
    public PySignature findSignature(@NotNull PyFunction function) {
        VirtualFile virtualFile;
        if (function == null) {
            PySignatureCacheManagerImpl.a(10);
        }
        if ((virtualFile = PySignatureCacheManagerImpl.b(function)) != null) {
            return this.c(virtualFile, PySignatureCacheManagerImpl.a(function));
        }
        return null;
    }

    private static String a(PyFunction pyFunction) {
        String string = pyFunction.getName();
        if (string == null) {
            return "";
        }
        PyClass pyClass = pyFunction.getContainingClass();
        if (pyClass != null) {
            string = pyClass.getName() + "." + string;
        }
        return string;
    }

    @Nullable
    private PySignature c(@NotNull VirtualFile virtualFile, @NotNull String string) {
        String string2;
        if (virtualFile == null) {
            PySignatureCacheManagerImpl.a(11);
        }
        if (string == null) {
            PySignatureCacheManagerImpl.a(12);
        }
        if ((string2 = this.a(virtualFile)) != null) {
            String[] stringArray;
            for (String string3 : stringArray = string2.split("\n")) {
                String[] stringArray2 = string3.split("\t");
                if (stringArray2.length <= 0 || !stringArray2[0].equals(string)) continue;
                return PySignatureCacheManagerImpl.a(virtualFile.getCanonicalPath(), string3);
            }
        }
        return null;
    }

    @Nullable
    private String a(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PySignatureCacheManagerImpl.a(13);
        }
        try {
            String string = (String)this.c.get((Object)virtualFile);
            if (!StringUtil.isEmpty((String)string)) {
                return string;
            }
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        return null;
    }

    @NotNull
    private static String b(@NotNull VirtualFile virtualFile) {
        byte[] byArray;
        if (virtualFile == null) {
            PySignatureCacheManagerImpl.a(14);
        }
        try {
            byArray = CALL_SIGNATURES_ATTRIBUTE.readAttributeBytes(virtualFile);
        }
        catch (Exception exception) {
            byArray = null;
        }
        String string = byArray != null && byArray.length > 0 ? new String(byArray, StandardCharsets.UTF_8) : null;
        String string2 = string != null ? string : "";
        if (string2 == null) {
            PySignatureCacheManagerImpl.a(15);
        }
        return string2;
    }

    @Nullable
    private static PySignature a(@NotNull String string, @NotNull String string2) {
        String[] stringArray;
        long l2 = e ^ 0x27AB07924A47L;
        if (string == null) {
            PySignatureCacheManagerImpl.a(16);
        }
        if (string2 == null) {
            PySignatureCacheManagerImpl.a(17);
        }
        if ((stringArray = string2.split("\t")).length > 0) {
            PySignature pySignature = new PySignature(string, stringArray[0]);
            for (int i10 = 1; i10 < stringArray.length; ++i10) {
                String string3 = stringArray[i10];
                if (string3.isEmpty()) continue;
                String[] stringArray2 = string3.split(":");
                if (stringArray2.length == 2) {
                    if ("<RETURN_TYPE>".equals(stringArray2[0])) {
                        pySignature = pySignature.addReturnType(stringArray2[1]);
                        continue;
                    }
                    pySignature = pySignature.addArgument(stringArray2[0], stringArray2[1]);
                    continue;
                }
                throw new IllegalStateException("Should be <name>:<type> format for arg or <RETURN_TYPE>:<type> for return type; '" + string3 + "' instead.");
            }
            return pySignature;
        }
        return null;
    }

    @Nullable
    private static VirtualFile a(@NotNull PySignature pySignature) {
        if (pySignature == null) {
            PySignatureCacheManagerImpl.a(18);
        }
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(pySignature.getFile());
    }

    @Nullable
    private static VirtualFile b(@NotNull PyFunction pyFunction) {
        PsiFile psiFile;
        if (pyFunction == null) {
            PySignatureCacheManagerImpl.a(19);
        }
        return (psiFile = pyFunction.getContainingFile()) != null ? psiFile.getOriginalFile().getVirtualFile() : null;
    }

    @Override
    public void clearCache() {
        long l2 = e ^ 0x5163A5B2DFDBL;
        Ref ref = Ref.create((Object)false);
        ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ProjectFileIndex.SERVICE.getInstance((Project)this.b).iterateContent(virtualFile -> {
            if (this.a(virtualFile) != null) {
                this.a(virtualFile, "");
                ref.set((Object)true);
            }
            return !ProgressManager.getInstance().getProgressIndicator().isCanceled();
        }), "Cleaning the Cache of Dynamically Collected Types", true, this.b);
        String string = (Boolean)ref.get() != false ? "Collected signatures were deleted" : "Nothing to delete";
        Messages.showInfoMessage((Project)this.b, (String)string, (String)"Delete Cache");
    }

    static {
        e = com.jetbrains.python.psi.c.a(4434226892564950231L, 8260342582042408770L, MethodHandles.lookup().lookupClass()).a(124974301388654L);
        long l2 = e ^ 0x306BA7D0167EL;
        LOG = Logger.getInstance((String)PySignatureCacheManagerImpl.class.getName());
        CALL_SIGNATURES_ATTRIBUTE = new FileAttribute("call.signatures.attribute", 1, true);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = e ^ 0x252A3115E491L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 15: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "signature";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldSignatureString";
                break;
            }
            case 4: 
            case 6: 
            case 11: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attrString";
                break;
            }
            case 8: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/PySignatureCacheManagerImpl";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/PySignatureCacheManagerImpl";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "readAttributeFromFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "recordSignature";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "changeSignatureString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "writeAttribute";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeAttributeToAFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findParameterType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findSignature";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readSignatureAttributeFromFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readAttribute";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "readAttributeFromFile";
                break;
            }
            case 15: {
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "stringToSignature";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

