/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.google.common.collect.Sets;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XLineBreakpointTypeBase;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.codeInsight.userSkeletons.PyUserSkeletonsUtil;
import com.jetbrains.python.debugger.PyDebugSupportUtils;
import com.jetbrains.python.debugger.PyDebuggerEditorsProvider;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PySdkUtil;
import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyLineBreakpointType
extends XLineBreakpointTypeBase {
    public static final String ID = "python-line";
    private static final String c = "Python Line Breakpoint";
    private static final Set<IElementType> a;
    private static final Class<? extends PsiElement>[] b;
    private static final long h;

    public PyLineBreakpointType() {
        long l2 = h ^ 0x616F1D3FD111L;
        super(ID, c, (XDebuggerEditorsProvider)new PyDebuggerEditorsProvider());
    }

    public PyLineBreakpointType(@NotNull String id2, @NotNull String title, @Nullable XDebuggerEditorsProvider editorsProvider) {
        if (id2 == null) {
            PyLineBreakpointType.a(0);
        }
        if (title == null) {
            PyLineBreakpointType.a(1);
        }
        super(id2, title, editorsProvider);
    }

    public boolean canPutAt(@NotNull VirtualFile file, int line2, @NotNull Project project) {
        if (file == null) {
            PyLineBreakpointType.a(2);
        }
        if (project == null) {
            PyLineBreakpointType.a(3);
        }
        Ref ref = Ref.create((Object)false);
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document != null && this.isSuitableFileType(project, file)) {
            this.lineHasStoppablePsi(project, file, line2, document, this.getUnstoppableElements(), this.getUnstoppableElementTypes(), (Ref<? super Boolean>)ref);
        }
        return (Boolean)ref.get();
    }

    protected boolean isSuitableFileType(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            PyLineBreakpointType.a(4);
        }
        if (file == null) {
            PyLineBreakpointType.a(5);
        }
        return file.getFileType() == this.getFileType() || ScratchUtil.isScratch((VirtualFile)file) && LanguageUtil.getLanguageForPsi((Project)project, (VirtualFile)file) == this.getFileLanguage();
    }

    protected FileType getFileType() {
        return PythonFileType.INSTANCE;
    }

    protected Language getFileLanguage() {
        return PythonLanguage.INSTANCE;
    }

    protected Set<IElementType> getUnstoppableElementTypes() {
        return a;
    }

    protected Class<? extends PsiElement>[] getUnstoppableElements() {
        return b;
    }

    protected boolean isPsiElementStoppable(PsiElement psiElement) {
        return psiElement.getLanguage() == PythonLanguage.INSTANCE;
    }

    protected void lineHasStoppablePsi(@NotNull Project project, @NotNull VirtualFile file, int line2, Document document, Class<? extends PsiElement>[] unstoppablePsiElements, Set<IElementType> unstoppableElementTypes, Ref<? super Boolean> stoppable) {
        if (project == null) {
            PyLineBreakpointType.a(6);
        }
        if (file == null) {
            PyLineBreakpointType.a(7);
        }
        if (!PyLineBreakpointType.a(project, file)) {
            XDebuggerUtil.getInstance().iterateLine(project, document, line2, psiElement -> {
                if (PsiTreeUtil.getNonStrictParentOfType((PsiElement)psiElement, (Class[])unstoppablePsiElements) != null) {
                    return true;
                }
                if (psiElement.getNode() != null && unstoppableElementTypes.contains(psiElement.getNode().getElementType())) {
                    return true;
                }
                if (this.isPsiElementStoppable((PsiElement)psiElement)) {
                    stoppable.set((Object)true);
                }
                return false;
            });
            if (PyDebugSupportUtils.isContinuationLine(document, line2 - 1)) {
                stoppable.set((Object)false);
            }
        }
    }

    public boolean isSuspendThreadSupported() {
        return true;
    }

    public SuspendPolicy getDefaultSuspendPolicy() {
        return SuspendPolicy.THREAD;
    }

    private static boolean a(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            PyLineBreakpointType.a(8);
        }
        if (virtualFile == null) {
            PyLineBreakpointType.a(9);
        }
        if (PyUserSkeletonsUtil.isUnderUserSkeletonsDirectory(virtualFile)) {
            return true;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        return psiFile != null && PySdkUtil.isElementInSkeletons((PsiElement)psiFile);
    }

    public String getBreakpointsDialogHelpTopic() {
        long l2 = h ^ 0x7350B500445CL;
        return "reference.dialogs.breakpoints";
    }

    static {
        h = com.jetbrains.python.psi.c.a(4889057973665573887L, 4277469910113922086L, MethodHandles.lookup().lookupClass()).a(96944938269459L);
        a = Sets.newHashSet((Object[])new IElementType[]{PyTokenTypes.TRIPLE_QUOTED_STRING, PyTokenTypes.SINGLE_QUOTED_STRING, PyTokenTypes.SINGLE_QUOTED_UNICODE, PyTokenTypes.DOCSTRING});
        b = new Class[]{PsiWhiteSpace.class, PsiComment.class};
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = h ^ 0x4D00B5174BA9L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/debugger/PyLineBreakpointType";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "canPutAt";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isSuitableFileType";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "lineHasStoppablePsi";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isSkeleton";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

