/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.console;

import com.google.common.collect.Maps;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.remote.RemoteProcessControl;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.python.console.PyConsoleDebugProcessHandler;
import com.jetbrains.python.console.PydevConsoleCommunication;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugRunner;
import com.jetbrains.python.debugger.PyDebuggerOptionsProvider;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.net.ServerSocket;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class PyConsoleDebugProcess
extends PyDebugProcess {
    private final int x;
    private final PyConsoleDebugProcessHandler w;
    private static final long y = c.a(87203269768591649L, 7444010735707201350L, MethodHandles.lookup().lookupClass()).a(106724555387616L);

    public PyConsoleDebugProcess(@NotNull XDebugSession session, @NotNull ServerSocket serverSocket, @NotNull ExecutionConsole executionConsole, @NotNull PyConsoleDebugProcessHandler consoleDebugProcessHandler) {
        if (session == null) {
            PyConsoleDebugProcess.b(0);
        }
        if (serverSocket == null) {
            PyConsoleDebugProcess.b(1);
        }
        if (executionConsole == null) {
            PyConsoleDebugProcess.b(2);
        }
        if (consoleDebugProcessHandler == null) {
            PyConsoleDebugProcess.b(3);
        }
        super(session, serverSocket, executionConsole, consoleDebugProcessHandler, false);
        this.x = serverSocket.getLocalPort();
        this.w = consoleDebugProcessHandler;
    }

    @Override
    public void sessionInitialized() {
    }

    @Override
    protected String getConnectionMessage() {
        long l2 = y ^ 0x5B2C018112C4L;
        return "Connecting to console...";
    }

    @Override
    protected String getConnectionTitle() {
        long l2 = y ^ 0xD8EE35F885L;
        return "Debugger connection";
    }

    @Override
    protected void detachDebuggedProcess() {
    }

    @Override
    protected void beforeConnect() {
        this.printToConsole(this.getCurrentStateMessage() + "\n", ConsoleViewContentType.SYSTEM_OUTPUT);
    }

    @Override
    protected void afterConnect() {
    }

    @Override
    public int getConnectTimeout() {
        return 0;
    }

    public void connect(PydevConsoleCommunication consoleCommunication) throws Exception {
        long l2 = y ^ 0x163036EF6F0BL;
        Pair<String, Integer> pair = this.w.getConsoleProcessHandler() instanceof RemoteProcessControl ? PyConsoleDebugProcess.getRemoteHostPortForDebuggerConnection(this.x, (RemoteProcessControl)this.w.getConsoleProcessHandler()) : Pair.create((Object)"localhost", (Object)this.x);
        Map<String, Boolean> map2 = PyConsoleDebugProcess.makeDebugOptionsMap(this.getSession());
        Map<String, String> map3 = PyConsoleDebugProcess.getDebuggerEnvs(this.getSession());
        consoleCommunication.connectToDebugger((Integer)pair.getSecond(), (String)pair.getFirst(), map2, map3);
    }

    public static Map<String, String> getDebuggerEnvs(XDebugSession session) {
        HashMap hashMap = Maps.newHashMap();
        PyDebugRunner.configureDebugEnvironment(session.getProject(), hashMap, session.getRunProfile());
        return hashMap;
    }

    public static Map<String, Boolean> makeDebugOptionsMap(XDebugSession session) {
        long l2 = y ^ 0x3DDB4C0461B4L;
        Project project = session.getProject();
        PyDebuggerOptionsProvider pyDebuggerOptionsProvider = PyDebuggerOptionsProvider.getInstance(project);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("save-signatures", pyDebuggerOptionsProvider.isSaveCallSignatures());
        hashMap.put("qt-support", pyDebuggerOptionsProvider.isSupportQtDebugging());
        return hashMap;
    }

    public void waitForNextConnection() {
        if (this.isConnected()) {
            this.disconnect();
        }
        if (this.getSession().isSuspended()) {
            this.getSession().resume();
        }
        if (!this.isWaitingForConnection()) {
            this.setWaitingForConnection(true);
            UIUtil.invokeLaterIfNeeded(() -> this.waitForConnection(this.getCurrentStateMessage(), this.getConnectionTitle()));
        }
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        long l2 = y ^ 0x2D779318F44BL;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "serverSocket";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "executionConsole";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "consoleDebugProcessHandler";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/console/PyConsoleDebugProcess";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

