/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.configuration;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.util.Comparing;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkAdditionalData;
import com.jetbrains.python.sdk.PythonSdkType;
import com.jetbrains.python.sdk.flavors.PythonSdkFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class PyConfigurableInterpreterList {
    private ProjectSdksModel a;

    public static PyConfigurableInterpreterList getInstance(@Nullable Project project) {
        Project project2 = project != null ? project : ProjectManager.getInstance().getDefaultProject();
        PyConfigurableInterpreterList pyConfigurableInterpreterList = (PyConfigurableInterpreterList)ServiceManager.getService((Project)project2, PyConfigurableInterpreterList.class);
        if (project2 != project) {
            pyConfigurableInterpreterList.disposeModel();
        }
        return pyConfigurableInterpreterList;
    }

    public ProjectSdksModel getModel() {
        if (this.a == null) {
            this.a = new ProjectSdksModel();
            this.a.reset(null);
        }
        return this.a;
    }

    public void disposeModel() {
        if (this.a != null) {
            this.a.disposeUIResources();
            this.a = null;
        }
    }

    public List<Sdk> getAllPythonSdks(@Nullable Project project) {
        ArrayList<Sdk> arrayList = new ArrayList<Sdk>();
        for (Sdk sdk : this.getModel().getSdks()) {
            if (!(sdk.getSdkType() instanceof PythonSdkType)) continue;
            arrayList.add(sdk);
        }
        Collections.sort(arrayList, new PyInterpreterComparator(project));
        return arrayList;
    }

    public List<Sdk> getAllPythonSdks() {
        return this.getAllPythonSdks(null);
    }

    private static class PyInterpreterComparator
    implements Comparator<Sdk> {
        @Nullable
        private final Project a;

        PyInterpreterComparator(@Nullable Project project) {
            this.a = project;
        }

        @Override
        public int compare(Sdk o1, Sdk o2) {
            if (!(o1.getSdkType() instanceof PythonSdkType) || !(o2.getSdkType() instanceof PythonSdkType)) {
                return -Comparing.compare((Comparable)((Object)o1.getName()), (Comparable)((Object)o2.getName()));
            }
            boolean bl2 = PythonSdkType.isVirtualEnv(o1);
            boolean bl3 = PythonSdkType.isVirtualEnv(o2);
            boolean bl4 = PySdkUtil.isRemote(o1);
            boolean bl5 = PySdkUtil.isRemote(o2);
            if (bl2) {
                if (bl3) {
                    if (this.a != null && PyInterpreterComparator.a(o1, this.a)) {
                        if (PyInterpreterComparator.a(o2, this.a)) {
                            return PyInterpreterComparator.a(o1, o2);
                        }
                        return -1;
                    }
                    return PyInterpreterComparator.a(o1, o2);
                }
                return -1;
            }
            if (bl3) {
                return 1;
            }
            if (bl4) {
                if (bl5) {
                    return PyInterpreterComparator.a(o1, o2);
                }
                return 1;
            }
            if (bl5) {
                return -1;
            }
            return PyInterpreterComparator.a(o1, o2);
        }

        private static int a(Sdk sdk, Sdk sdk2) {
            PythonSdkFlavor pythonSdkFlavor;
            LanguageLevel languageLevel;
            PythonSdkFlavor pythonSdkFlavor2 = PythonSdkFlavor.getFlavor(sdk);
            LanguageLevel languageLevel2 = pythonSdkFlavor2 != null ? pythonSdkFlavor2.getLanguageLevel(sdk) : LanguageLevel.getDefault();
            int n2 = Comparing.compare((Comparable)((Object)languageLevel2), (Comparable)((Object)(languageLevel = (pythonSdkFlavor = PythonSdkFlavor.getFlavor(sdk2)) != null ? pythonSdkFlavor.getLanguageLevel(sdk2) : LanguageLevel.getDefault())));
            if (n2 != 0) {
                return -n2;
            }
            return Comparing.compare((Comparable)((Object)sdk.getName()), (Comparable)((Object)sdk2.getName()));
        }

        private static boolean a(Sdk sdk, Project project) {
            PythonSdkAdditionalData pythonSdkAdditionalData = (PythonSdkAdditionalData)sdk.getSdkAdditionalData();
            if (pythonSdkAdditionalData != null) {
                String string = pythonSdkAdditionalData.getAssociatedModulePath();
                String string2 = project.getBasePath();
                if (string != null && string.equals(string2)) {
                    return true;
                }
            }
            return false;
        }
    }
}

