/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions.convertToFString;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.codeInsight.PySubstitutionChunkReference;
import com.jetbrains.python.inspections.PyStringFormatParser;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyKeyValueExpression;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyLambdaExpression;
import com.jetbrains.python.psi.PyStarArgument;
import com.jetbrains.python.psi.PyStarExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseConvertToFStringProcessor<T extends PyStringFormatParser.SubstitutionChunk> {
    protected final PyStringLiteralExpression myPyString;
    protected final PyUtil.StringNodeInfo myNodeInfo;
    private static final long a = c.a(6139326793852582467L, -3026217588841438104L, MethodHandles.lookup().lookupClass()).a(200417385134663L);

    protected BaseConvertToFStringProcessor(@NotNull PyStringLiteralExpression pyString) {
        if (pyString == null) {
            BaseConvertToFStringProcessor.a(0);
        }
        this.myPyString = pyString;
        this.myNodeInfo = new PyUtil.StringNodeInfo(pyString.getStringNodes().get(0));
    }

    public final boolean isRefactoringAvailable() {
        if (this.myPyString.getStringNodes().size() > 1 || this.myNodeInfo.isBytes() || this.myNodeInfo.isFormatted()) {
            return false;
        }
        PsiElement psiElement = this.getValuesSource();
        if (psiElement == null) {
            return false;
        }
        List<T> list2 = this.extractAllSubstitutionChunks();
        for (PyStringFormatParser.SubstitutionChunk substitutionChunk : list2) {
            if (!this.checkChunk(substitutionChunk)) {
                return false;
            }
            PySubstitutionChunkReference pySubstitutionChunkReference = this.createReference(substitutionChunk);
            PyExpression pyExpression = BaseConvertToFStringProcessor.adjustResolveResult(pySubstitutionChunkReference.resolve());
            if (pyExpression == null) {
                return false;
            }
            if (!PsiTreeUtil.isAncestor((PsiElement)psiElement, (PsiElement)pyExpression, (boolean)false)) {
                return false;
            }
            if (pyExpression instanceof PyStarExpression || pyExpression instanceof PyStarArgument) {
                return false;
            }
            if (this.checkReferencedExpression(list2, substitutionChunk, psiElement, pyExpression)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkReferencedExpression(@NotNull List<T> chunks, @NotNull T chunk, @NotNull PsiElement valueSource, @NotNull PyExpression expression) {
        if (chunks == null) {
            BaseConvertToFStringProcessor.a(1);
        }
        if (chunk == null) {
            BaseConvertToFStringProcessor.a(2);
        }
        if (valueSource == null) {
            BaseConvertToFStringProcessor.a(3);
        }
        if (expression == null) {
            BaseConvertToFStringProcessor.a(4);
        }
        if (expression.textContains('\\') || expression.textContains('\n')) {
            return false;
        }
        return this.adjustQuotesInsideInjectedExpression((PsiElement)expression) != null;
    }

    public final void doRefactoring() {
        Object object2;
        String string = this.myPyString.getText();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("f");
        stringBuilder.append(StringUtil.replaceIgnoreCase((String)this.myNodeInfo.getPrefix(), (String)"u", (String)""));
        stringBuilder.append(this.myNodeInfo.getQuote());
        TextRange textRange = this.myNodeInfo.getContentRange();
        int n2 = textRange.getStartOffset();
        for (Object object2 : this.extractTopLevelSubstitutionChunks()) {
            stringBuilder.append(string, n2, ((PyStringFormatParser.FormatStringChunk)object2).getStartIndex());
            n2 = ((PyStringFormatParser.FormatStringChunk)object2).getEndIndex();
            if (this.convertSubstitutionChunk(object2, stringBuilder)) continue;
            return;
        }
        if (n2 < textRange.getEndOffset()) {
            stringBuilder.append(string, n2, textRange.getEndOffset());
        }
        stringBuilder.append(this.myNodeInfo.getQuote());
        PyExpression pyExpression = this.getWholeExpressionToReplace();
        object2 = PyElementGenerator.getInstance(this.myPyString.getProject());
        PyExpression pyExpression2 = ((PyElementGenerator)object2).createExpressionFromText(LanguageLevel.forElement(this.myPyString), stringBuilder.toString());
        pyExpression.replace((PsiElement)pyExpression2);
    }

    @NotNull
    protected abstract List<T> extractAllSubstitutionChunks();

    @NotNull
    protected List<T> extractTopLevelSubstitutionChunks() {
        List<T> list2 = this.extractAllSubstitutionChunks();
        if (list2 == null) {
            BaseConvertToFStringProcessor.a(5);
        }
        return list2;
    }

    @NotNull
    protected abstract PySubstitutionChunkReference createReference(@NotNull T var1);

    protected abstract boolean checkChunk(@NotNull T var1);

    protected abstract boolean convertSubstitutionChunk(@NotNull T var1, @NotNull StringBuilder var2);

    @Nullable
    protected PsiElement adjustQuotesInsideInjectedExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            BaseConvertToFStringProcessor.a(6);
        }
        PsiElement psiElement = expression.copy();
        char c10 = this.myNodeInfo.getSingleQuote();
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(this.myPyString.getProject());
        Collection collection = PsiTreeUtil.collectElementsOfType((PsiElement)psiElement, (Class[])new Class[]{PyStringLiteralExpression.class});
        for (PyStringLiteralExpression pyStringLiteralExpression : collection) {
            List<ASTNode> list2 = pyStringLiteralExpression.getStringNodes();
            if (list2.size() > 1) {
                return psiElement;
            }
            PyUtil.StringNodeInfo stringNodeInfo = new PyUtil.StringNodeInfo(list2.get(0));
            String string = stringNodeInfo.getContent();
            if (string.indexOf(c10) >= 0) {
                return null;
            }
            if (!stringNodeInfo.isTerminated()) {
                return null;
            }
            if (!stringNodeInfo.getQuote().startsWith(this.myNodeInfo.getQuote())) continue;
            char c11 = PyStringLiteralUtil.flipQuote(c10);
            if (string.indexOf(c11) >= 0) {
                return null;
            }
            String string2 = stringNodeInfo.getQuote().replace(c10, c11);
            String string3 = stringNodeInfo.getPrefix() + string2 + string + string2;
            PsiElement psiElement2 = pyStringLiteralExpression.replace(pyElementGenerator.createStringLiteralAlreadyEscaped(string3));
            if (pyStringLiteralExpression != psiElement) continue;
            return psiElement2;
        }
        return psiElement;
    }

    @NotNull
    protected abstract PyExpression getWholeExpressionToReplace();

    @Nullable
    protected abstract PsiElement getValuesSource();

    @Nullable
    protected PsiElement prepareExpressionToInject(@NotNull PyExpression expression, @NotNull T chunk) {
        PsiElement psiElement;
        if (expression == null) {
            BaseConvertToFStringProcessor.a(7);
        }
        if (chunk == null) {
            BaseConvertToFStringProcessor.a(8);
        }
        if ((psiElement = this.adjustQuotesInsideInjectedExpression((PsiElement)expression)) == null) {
            return null;
        }
        if (psiElement instanceof PyLambdaExpression) {
            return this.wrapExpressionInParentheses(psiElement);
        }
        return psiElement;
    }

    @Nullable
    protected final PsiElement wrapExpressionInParentheses(@NotNull PsiElement expression) {
        if (expression == null) {
            BaseConvertToFStringProcessor.a(9);
        }
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(this.myPyString.getProject());
        return pyElementGenerator.createExpressionFromText(LanguageLevel.forElement(this.myPyString), "(" + expression.getText() + ")");
    }

    @Nullable
    protected static PyExpression adjustResolveResult(@Nullable PsiElement resolveResult) {
        if (resolveResult == null) {
            return null;
        }
        PyKeywordArgument pyKeywordArgument = PyUtil.as(resolveResult, PyKeywordArgument.class);
        if (pyKeywordArgument != null) {
            return pyKeywordArgument.getValueExpression();
        }
        PyKeyValueExpression pyKeyValueExpression = PyUtil.as(resolveResult.getParent(), PyKeyValueExpression.class);
        if (pyKeyValueExpression != null && pyKeyValueExpression.getKey() == resolveResult) {
            return pyKeyValueExpression.getValue();
        }
        return PyUtil.as(resolveResult, PyExpression.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x1E16CE643EFDL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyString";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunks";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "chunk";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueSource";
                break;
            }
            case 4: 
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/convertToFString/BaseConvertToFStringProcessor";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/convertToFString/BaseConvertToFStringProcessor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTopLevelSubstitutionChunks";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkReferencedExpression";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "adjustQuotesInsideInjectedExpression";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "prepareExpressionToInject";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "wrapExpressionInParentheses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

