/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.intentions;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.template.TemplateBuilder;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.stdlib.PyNamedTupleType;
import com.jetbrains.python.codeInsight.typing.PyTypingTypeProvider;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyAnnotationOwner;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpressionStatement;
import com.jetbrains.python.psi.PyForStatement;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.PyStatementListContainer;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyTypeDeclarationStatement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.PyWithStatement;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.PyCallableParameter;
import com.jetbrains.python.psi.types.PyCallableType;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyCollectionType;
import com.jetbrains.python.psi.types.PyCollectionTypeImpl;
import com.jetbrains.python.psi.types.PyGenericType;
import com.jetbrains.python.psi.types.PyInstantiableType;
import com.jetbrains.python.psi.types.PyNoneType;
import com.jetbrains.python.psi.types.PyTupleType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyUnionType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.refactoring.classes.PyClassRefactoringUtil;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyTypeHintGenerationUtil {
    public static final String TYPE_COMMENT_PREFIX = "# type: ";
    private static final long a = c.a(-3420604745494522325L, -4722152084468782552L, MethodHandles.lookup().lookupClass()).a(42939637890743L);

    private PyTypeHintGenerationUtil() {
    }

    public static void insertStandaloneAttributeTypeComment(@NotNull PyTargetExpression target, @NotNull TypeEvalContext context, AnnotationInfo info, boolean startTemplate) {
        PyClass pyClass;
        long l2 = a ^ 0x364352653908L;
        if (target == null) {
            PyTypeHintGenerationUtil.a(0);
        }
        if (context == null) {
            PyTypeHintGenerationUtil.a(1);
        }
        if ((pyClass = target.getContainingClass()) == null) {
            throw new IllegalArgumentException("Target '" + target.getText() + "' in not contained in a class definition");
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)target)) {
            return;
        }
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(target.getProject());
        LanguageLevel languageLevel = LanguageLevel.forElement(target);
        String string = languageLevel.isAtLeast(LanguageLevel.PYTHON30) ? "..." : "None";
        String string2 = target.getName() + " = " + string + " " + TYPE_COMMENT_PREFIX + info.getAnnotationText();
        PyAssignmentStatement pyAssignmentStatement = pyElementGenerator.createFromText(languageLevel, PyAssignmentStatement.class, string2);
        PsiElement psiElement = PyTypeHintGenerationUtil.a(pyClass);
        WriteAction.run(() -> {
            PyAssignmentStatement pyAssignmentStatement2 = (PyAssignmentStatement)pyClass.getStatementList().addAfter(pyAssignmentStatement, psiElement);
            PsiComment psiComment = PyUtil.as(pyAssignmentStatement2.getLastChild(), PsiComment.class);
            if (psiComment == null) {
                return;
            }
            PyTypeHintGenerationUtil.a(info.getTypes(), context, target.getContainingFile());
            psiComment = (PsiComment)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)psiComment);
            if (startTemplate && psiComment != null) {
                PyTypeHintGenerationUtil.a(psiComment, info.getAnnotationText(), info.getTypeRanges());
            }
        });
    }

    public static void insertStandaloneAttributeAnnotation(@NotNull PyTargetExpression target, @NotNull TypeEvalContext context, @NotNull AnnotationInfo info, boolean startTemplate) {
        LanguageLevel languageLevel;
        long l2 = a ^ 0x55718E374748L;
        if (target == null) {
            PyTypeHintGenerationUtil.a(2);
        }
        if (context == null) {
            PyTypeHintGenerationUtil.a(3);
        }
        if (info == null) {
            PyTypeHintGenerationUtil.a(4);
        }
        if ((languageLevel = LanguageLevel.forElement(target)).isOlderThan(LanguageLevel.PYTHON36)) {
            throw new IllegalArgumentException("Target '" + target.getText() + "' doesn't belong to Python 3.6+ project: " + (Object)((Object)languageLevel));
        }
        PyClass pyClass = target.getContainingClass();
        if (pyClass == null) {
            throw new IllegalArgumentException("Target '" + target.getText() + "' in not contained in a class definition");
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)target)) {
            return;
        }
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(target.getProject());
        String string = target.getName() + ": " + info.getAnnotationText();
        PyTypeDeclarationStatement pyTypeDeclarationStatement = pyElementGenerator.createFromText(languageLevel, PyTypeDeclarationStatement.class, string);
        PsiElement psiElement = PyTypeHintGenerationUtil.a(pyClass);
        WriteAction.run(() -> {
            PyTypeDeclarationStatement pyTypeDeclarationStatement2 = (PyTypeDeclarationStatement)pyClass.getStatementList().addAfter(pyTypeDeclarationStatement, psiElement);
            PyTypeHintGenerationUtil.a(info.getTypes(), context, target.getContainingFile());
            pyTypeDeclarationStatement2 = (PyTypeDeclarationStatement)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)pyTypeDeclarationStatement2);
            if (startTemplate && pyTypeDeclarationStatement2 != null) {
                PyTypeHintGenerationUtil.a(pyTypeDeclarationStatement2);
            }
        });
    }

    @Nullable
    private static PsiElement a(@NotNull PyClass pyClass) {
        if (pyClass == null) {
            PyTypeHintGenerationUtil.a(5);
        }
        PyStatement pyStatement = pyClass.getStatementList().getStatements()[0];
        PyStringLiteralExpression pyStringLiteralExpression = pyClass.getDocStringExpression();
        if (pyStatement instanceof PyExpressionStatement && pyStringLiteralExpression == ((PyExpressionStatement)pyStatement).getExpression()) {
            return pyStatement;
        }
        return null;
    }

    public static void insertVariableAnnotation(@NotNull PyTargetExpression target, @Nullable TypeEvalContext context, @NotNull AnnotationInfo info, boolean startTemplate) {
        ThrowableComputable throwableComputable;
        LanguageLevel languageLevel;
        long l2 = a ^ 0x10213031BE25L;
        if (target == null) {
            PyTypeHintGenerationUtil.a(6);
        }
        if (info == null) {
            PyTypeHintGenerationUtil.a(7);
        }
        if ((languageLevel = LanguageLevel.forElement(target)).isOlderThan(LanguageLevel.PYTHON36)) {
            throw new IllegalArgumentException("Target '" + target.getText() + "' doesn't belong to Python 3.6+ project: " + (Object)((Object)languageLevel));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)target)) {
            return;
        }
        Project project = target.getProject();
        if (PyTypeHintGenerationUtil.a(target)) {
            SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
            PyAssignmentStatement pyAssignmentStatement = (PyAssignmentStatement)target.getParent();
            SmartPsiElementPointer smartPsiElementPointer = smartPointerManager.createSmartPsiElementPointer((PsiElement)pyAssignmentStatement);
            throwableComputable = () -> {
                PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)target, (Consumer<? super Document>)((Consumer)document -> {
                    long l2 = a ^ 0x604862B284C6L;
                    document.insertString(target.getTextRange().getEndOffset(), (CharSequence)(": " + info.getAnnotationText()));
                }));
                return (PyAnnotationOwner)smartPsiElementPointer.getElement();
            };
        } else {
            PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(project);
            String string = target.getName() + ": " + info.getAnnotationText();
            PyTypeDeclarationStatement pyTypeDeclarationStatement = pyElementGenerator.createFromText(languageLevel, PyTypeDeclarationStatement.class, string);
            PyStatement pyStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)target, PyStatement.class);
            assert (pyStatement != null);
            throwableComputable = () -> (PyAnnotationOwner)pyStatement.getParent().addBefore((PsiElement)pyTypeDeclarationStatement, (PsiElement)pyStatement);
        }
        WriteAction.run(() -> {
            PyAnnotationOwner pyAnnotationOwner = (PyAnnotationOwner)throwableComputable.compute();
            if (pyAnnotationOwner == null) {
                return;
            }
            if (context != null) {
                PyTypeHintGenerationUtil.a(info.getTypes(), context, target.getContainingFile());
            }
            pyAnnotationOwner = (PyAnnotationOwner)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)pyAnnotationOwner);
            if (startTemplate && pyAnnotationOwner != null) {
                PyTypeHintGenerationUtil.a(pyAnnotationOwner);
            }
        });
    }

    private static void a(@NotNull PyAnnotationOwner pyAnnotationOwner) {
        if (pyAnnotationOwner == null) {
            PyTypeHintGenerationUtil.a(8);
        }
        assert (pyAnnotationOwner.isValid());
        assert (pyAnnotationOwner.getAnnotationValue() != null);
        Project project = pyAnnotationOwner.getProject();
        int n2 = pyAnnotationOwner.getTextRange().getStartOffset();
        VirtualFile virtualFile = pyAnnotationOwner.getContainingFile().getVirtualFile();
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, virtualFile, n2);
        Editor editor2 = FileEditorManager.getInstance((Project)project).openTextEditor(openFileDescriptor, true);
        if (editor2 != null) {
            editor2.getCaretModel().moveToOffset(n2);
            TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)pyAnnotationOwner);
            String string = pyAnnotationOwner.getAnnotationValue();
            String string2 = ApplicationManager.getApplication().isUnitTestMode() ? "[" + string + "]" : string;
            templateBuilder.replaceElement((PsiElement)pyAnnotationOwner.getAnnotation().getValue(), string2);
            templateBuilder.run(editor2, true);
        }
    }

    private static boolean a(@NotNull PyTargetExpression pyTargetExpression) {
        PyAssignmentStatement pyAssignmentStatement;
        if (pyTargetExpression == null) {
            PyTypeHintGenerationUtil.a(9);
        }
        return (pyAssignmentStatement = PyUtil.as(pyTargetExpression.getParent(), PyAssignmentStatement.class)) != null && pyAssignmentStatement.getRawTargets().length == 1 && pyAssignmentStatement.getLeftHandSideExpression() == pyTargetExpression;
    }

    public static void insertVariableTypeComment(@NotNull PyTargetExpression target, TypeEvalContext context, @NotNull AnnotationInfo info, boolean startTemplate) {
        ThrowableRunnable throwableRunnable;
        PsiElement psiElement;
        long l2 = a ^ 0x4184545CBE7EL;
        if (target == null) {
            PyTypeHintGenerationUtil.a(10);
        }
        if (info == null) {
            PyTypeHintGenerationUtil.a(11);
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)target)) {
            return;
        }
        String string = "  # type: " + info.getAnnotationText();
        PyStatement pyStatement = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)target, PyStatement.class);
        if (pyStatement instanceof PyAssignmentStatement) {
            psiElement = pyStatement.getLastChild();
        } else if (pyStatement instanceof PyWithStatement) {
            psiElement = PyUtil.getHeaderEndAnchor((PyStatementListContainer)((Object)pyStatement));
        } else if (pyStatement instanceof PyForStatement) {
            psiElement = PyUtil.getHeaderEndAnchor(((PyForStatement)pyStatement).getForPart());
        } else {
            throw new IllegalArgumentException("Target expression must belong to an assignment, \"with\" statement or \"for\" loop");
        }
        if (psiElement instanceof PsiComment) {
            String string2 = string + " " + psiElement.getText();
            PsiElement psiElement2 = PyPsiUtils.getPrevNonCommentSibling(psiElement, true);
            int n2 = psiElement2.getTextRange().getEndOffset();
            int n3 = psiElement.getTextRange().getEndOffset();
            throwableRunnable = () -> PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)target, (Consumer<? super Document>)((Consumer)document -> document.replaceString(n2, n3, (CharSequence)string2)));
        } else if (psiElement != null) {
            int n4 = psiElement.getTextRange().getEndOffset();
            throwableRunnable = () -> PyUtil.updateDocumentUnblockedAndCommitted((PsiElement)target, (Consumer<? super Document>)((Consumer)document -> document.insertString(n4, (CharSequence)string)));
        } else {
            return;
        }
        WriteAction.run(() -> {
            throwableRunnable.run();
            PsiComment psiComment = target.getTypeComment();
            if (psiComment == null) {
                return;
            }
            PyTypeHintGenerationUtil.a(info.getTypes(), context, target.getContainingFile());
            psiComment = (PsiComment)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement((PsiElement)psiComment);
            if (startTemplate && psiComment != null) {
                PyTypeHintGenerationUtil.a(psiComment, info.getAnnotationText(), info.getTypeRanges());
            }
        });
    }

    private static void a(@NotNull PsiComment psiComment, @NotNull String string, @NotNull List<TextRange> list2) {
        long l2 = a ^ 0x52B4898E40B8L;
        if (psiComment == null) {
            PyTypeHintGenerationUtil.a(12);
        }
        if (string == null) {
            PyTypeHintGenerationUtil.a(13);
        }
        if (list2 == null) {
            PyTypeHintGenerationUtil.a(14);
        }
        int n2 = psiComment.getTextRange().getStartOffset();
        VirtualFile virtualFile = psiComment.getContainingFile().getVirtualFile();
        Project project = psiComment.getProject();
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, virtualFile, n2);
        Editor editor2 = FileEditorManager.getInstance((Project)project).openTextEditor(openFileDescriptor, true);
        if (editor2 != null) {
            boolean bl2 = ApplicationManager.getApplication().isUnitTestMode();
            editor2.getCaretModel().moveToOffset(n2);
            TemplateBuilder templateBuilder = TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)psiComment);
            for (TextRange textRange : list2) {
                String string2 = textRange.substring(string);
                String string3 = bl2 ? "[" + string2 + "]" : string2;
                templateBuilder.replaceRange(textRange.shiftRight(TYPE_COMMENT_PREFIX.length()), string3);
            }
            templateBuilder.run(editor2, true);
        }
    }

    private static void a(@NotNull List<PyType> list2, @NotNull TypeEvalContext typeEvalContext, @NotNull PsiFile psiFile) {
        Object object22;
        long l2 = a ^ 0x10DC5A55737FL;
        if (list2 == null) {
            PyTypeHintGenerationUtil.a(15);
        }
        if (typeEvalContext == null) {
            PyTypeHintGenerationUtil.a(16);
        }
        if (psiFile == null) {
            PyTypeHintGenerationUtil.a(17);
        }
        HashSet<PsiNamedElement> hashSet = new HashSet<PsiNamedElement>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (Object object22 : list2) {
            PyTypeHintGenerationUtil.a(object22, typeEvalContext, hashSet, hashSet2);
        }
        boolean bl2 = LanguageLevel.forElement((PsiElement)psiFile).isAtLeast(LanguageLevel.PYTHON35);
        object22 = bl2 ? AddImportHelper.ImportPriority.BUILTIN : AddImportHelper.ImportPriority.THIRD_PARTY;
        for (String string : hashSet2) {
            AddImportHelper.addOrUpdateFromImportStatement(psiFile, "typing", string, null, (AddImportHelper.ImportPriority)((Object)object22), null);
        }
        for (PsiNamedElement psiNamedElement : hashSet) {
            PyClassRefactoringUtil.insertImport((PsiElement)psiFile, psiNamedElement, null, true);
        }
    }

    private static void a(@Nullable PyType pyType, @NotNull TypeEvalContext typeEvalContext, @NotNull Set<PsiNamedElement> set, @NotNull Set<String> set2) {
        PyTargetExpression pyTargetExpression;
        long l2 = a ^ 0xB7F8A64D005L;
        if (typeEvalContext == null) {
            PyTypeHintGenerationUtil.a(18);
        }
        if (set == null) {
            PyTypeHintGenerationUtil.a(19);
        }
        if (set2 == null) {
            PyTypeHintGenerationUtil.a(20);
        }
        if (pyType == null) {
            set2.add("Any");
        } else if (pyType instanceof PyUnionType) {
            Collection<PyType> collection = ((PyUnionType)pyType).getMembers();
            boolean bl2 = collection.size() == 2 && collection.contains(PyNoneType.INSTANCE);
            set2.add(bl2 ? "Optional" : "Union");
            for (PyType pyType2 : collection) {
                PyTypeHintGenerationUtil.a(pyType2, typeEvalContext, set, set2);
            }
        } else if (pyType instanceof PyNamedTupleType) {
            PyQualifiedNameOwner pyQualifiedNameOwner = pyType.getDeclarationElement();
            if (pyQualifiedNameOwner instanceof PsiNamedElement) {
                set.add((PsiNamedElement)pyQualifiedNameOwner);
            }
        } else if (pyType instanceof PyCollectionType) {
            if (pyType instanceof PyCollectionTypeImpl) {
                PyClass pyClass = ((PyCollectionTypeImpl)pyType).getPyClass();
                String object = (String)PyTypingTypeProvider.TYPING_COLLECTION_CLASSES.get((Object)pyClass.getQualifiedName());
                if (object != null && pyType.isBuiltin()) {
                    set2.add(object);
                } else {
                    set.add((PsiNamedElement)pyClass);
                }
            } else if (pyType instanceof PyTupleType) {
                set2.add("Tuple");
            }
            for (PyType pyType3 : ((PyCollectionType)pyType).getElementTypes()) {
                PyTypeHintGenerationUtil.a(pyType3, typeEvalContext, set, set2);
            }
        } else if (pyType instanceof PyClassType) {
            set.add((PsiNamedElement)((PyClassType)pyType).getPyClass());
        } else if (pyType instanceof PyCallableType) {
            set2.add("Callable");
            PyCallableType pyCallableType = (PyCallableType)pyType;
            for (PyCallableParameter pyCallableParameter : ContainerUtil.notNullize(pyCallableType.getParameters(typeEvalContext))) {
                PyTypeHintGenerationUtil.a(pyCallableParameter.getType(typeEvalContext), typeEvalContext, set, set2);
            }
            PyTypeHintGenerationUtil.a(pyCallableType.getReturnType(typeEvalContext), typeEvalContext, set, set2);
        } else if (pyType instanceof PyGenericType && (pyTargetExpression = PyUtil.as(pyType.getDeclarationElement(), PyTargetExpression.class)) != null) {
            set.add(pyTargetExpression);
        }
        if (pyType instanceof PyInstantiableType && ((PyInstantiableType)pyType).isDefinition()) {
            set2.add("Type");
        }
    }

    public static void checkPep484Compatibility(@Nullable PyType type, @NotNull TypeEvalContext context) {
        long l2 = a ^ 0xB3F579AE5E4L;
        if (context == null) {
            PyTypeHintGenerationUtil.a(21);
        }
        if (type == null || type instanceof PyNoneType || type instanceof PyGenericType) {
            return;
        }
        if (type instanceof PyUnionType) {
            for (PyType pyType : ((PyUnionType)type).getMembers()) {
                PyTypeHintGenerationUtil.checkPep484Compatibility(pyType, context);
            }
        } else if (type instanceof PyCollectionType) {
            for (PyType pyType : ((PyCollectionType)type).getElementTypes()) {
                PyTypeHintGenerationUtil.checkPep484Compatibility(pyType, context);
            }
        } else if (!(type instanceof PyClassType)) {
            if (type instanceof PyCallableType) {
                PyCallableType pyCallableType = (PyCallableType)type;
                for (PyCallableParameter pyCallableParameter : ContainerUtil.notNullize(pyCallableType.getParameters(context))) {
                    PyTypeHintGenerationUtil.checkPep484Compatibility(pyCallableParameter.getType(context), context);
                }
                PyTypeHintGenerationUtil.checkPep484Compatibility(pyCallableType.getReturnType(context), context);
            } else {
                throw new Pep484IncompatibleTypeException(PyBundle.message("INTN.add.type.hint.for.variable.PEP484.incompatible.type", type.getName()));
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x4A130BE87ECL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 1: 
            case 3: 
            case 16: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotated";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "insertedComment";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeRanges";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbols";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typingTypes";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyTypeHintGenerationUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "insertStandaloneAttributeTypeComment";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "insertStandaloneAttributeAnnotation";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findPrecedingAnchorForAttributeDeclaration";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "insertVariableAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "openEditorAndAddTemplateForAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "canUseInlineAnnotation";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "insertVariableTypeComment";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "openEditorAndAddTemplateForTypeComment";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "addImportsForTypeAnnotations";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[2] = "collectImportTargetsFromType";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "checkPep484Compatibility";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class AnnotationInfo {
        private final String c;
        private final List<PyType> b;
        private final List<TextRange> a;
        private static final long d = com.jetbrains.python.psi.c.a(3189520417440961903L, 4316480322086860637L, MethodHandles.lookup().lookupClass()).a(133473776485690L);

        public AnnotationInfo(@NotNull String annotationText) {
            if (annotationText == null) {
                AnnotationInfo.a(0);
            }
            this(annotationText, Collections.emptyList(), Collections.singletonList(TextRange.allOf((String)annotationText)));
        }

        public AnnotationInfo(@NotNull String annotationText, @Nullable PyType type) {
            if (annotationText == null) {
                AnnotationInfo.a(1);
            }
            this(annotationText, Collections.singletonList(type), Collections.singletonList(TextRange.allOf((String)annotationText)));
        }

        public AnnotationInfo(@NotNull String annotationText, @NotNull List<PyType> types, @NotNull List<TextRange> typeRanges) {
            if (annotationText == null) {
                AnnotationInfo.a(2);
            }
            if (types == null) {
                AnnotationInfo.a(3);
            }
            if (typeRanges == null) {
                AnnotationInfo.a(4);
            }
            this.c = annotationText;
            this.b = types;
            this.a = typeRanges;
        }

        @NotNull
        public String getAnnotationText() {
            String string = this.c;
            if (string == null) {
                AnnotationInfo.a(5);
            }
            return string;
        }

        @NotNull
        public List<PyType> getTypes() {
            List<PyType> list2 = this.b;
            if (list2 == null) {
                AnnotationInfo.a(6);
            }
            return list2;
        }

        @NotNull
        public List<TextRange> getTypeRanges() {
            List<TextRange> list2 = this.a;
            if (list2 == null) {
                AnnotationInfo.a(7);
            }
            return list2;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = d ^ 0x2EF2CA11561FL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "annotationText";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "types";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "typeRanges";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/intentions/PyTypeHintGenerationUtil$AnnotationInfo";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/intentions/PyTypeHintGenerationUtil$AnnotationInfo";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAnnotationText";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypes";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTypeRanges";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class Pep484IncompatibleTypeException
    extends RuntimeException {
        public Pep484IncompatibleTypeException(String message) {
            super(message);
        }
    }
}

