/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.google.common.collect.Ordering;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.formatter.PyCodeStyleSettings;
import com.jetbrains.python.inspections.unresolvedReference.PyUnresolvedReferencesInspection;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportStatement;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;

public class PyImportOptimizer
implements ImportOptimizer {
    private static final Logger a;
    private boolean b = true;
    private static final long c;

    @NotNull
    public static PyImportOptimizer onlyRemoveUnused() {
        PyImportOptimizer pyImportOptimizer = new PyImportOptimizer();
        pyImportOptimizer.b = false;
        PyImportOptimizer pyImportOptimizer2 = pyImportOptimizer;
        if (pyImportOptimizer2 == null) {
            PyImportOptimizer.a(0);
        }
        return pyImportOptimizer2;
    }

    public boolean supports(PsiFile file) {
        return true;
    }

    @NotNull
    public Runnable processFile(@NotNull PsiFile file) {
        if (file == null) {
            PyImportOptimizer.a(1);
        }
        LocalInspectionToolSession localInspectionToolSession = new LocalInspectionToolSession(file, 0, file.getTextLength());
        final PyUnresolvedReferencesInspection.Visitor visitor2 = new PyUnresolvedReferencesInspection.Visitor(null, localInspectionToolSession, Collections.emptyList());
        file.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitElement(PsiElement node) {
                super.visitElement(node);
                node.accept((PsiElementVisitor)visitor2);
            }
        });
        Runnable runnable = () -> {
            long l2 = c ^ 0x62697C74B5C3L;
            a.debug(String.format("----------------- OPTIMIZE IMPORTS STARTED (%s) -----------------", file.getVirtualFile()));
            visitor2.optimizeImports();
            if (this.b && file instanceof PyFile) {
                new ImportSorter((PyFile)file).run();
            }
            a.debug("----------------- OPTIMIZE IMPORTS FINISHED -----------------");
        };
        if (runnable == null) {
            PyImportOptimizer.a(2);
        }
        return runnable;
    }

    static {
        c = com.jetbrains.python.psi.c.a(8111964635754871126L, 3127877020001233194L, MethodHandles.lookup().lookupClass()).a(5094458517144L);
        a = Logger.getInstance(PyImportOptimizer.class);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x16C402190CEFL;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/codeInsight/imports/PyImportOptimizer";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "onlyRemoveUnused";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/codeInsight/imports/PyImportOptimizer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "processFile";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ImportSorter {
        private final PyFile a;
        private final PyCodeStyleSettings c;
        private final List<PyImportStatementBase> i;
        private final Map<AddImportHelper.ImportPriority, List<PyImportStatementBase>> j;
        private final MultiMap<PyImportStatementBase, PsiComment> e;
        private final MultiMap<PyImportStatementBase, PsiComment> l;
        private final MultiMap<String, PyFromImportStatement> f;
        private final MultiMap<PyImportStatementBase, PsiComment> d;
        private final MultiMap<PyImportStatementBase, PsiComment> b;
        private final List<PsiComment> g;
        private final PyElementGenerator h;
        private final LanguageLevel k;
        private static final long m = com.jetbrains.python.psi.c.a(-489261356344362277L, 7865850255281292877L, MethodHandles.lookup().lookupClass()).a(8106949588333L);

        private ImportSorter(@NotNull PyFile file) {
            if (file == null) {
                ImportSorter.a(0);
            }
            this.e = MultiMap.create();
            this.l = MultiMap.create();
            this.f = MultiMap.create();
            this.d = MultiMap.create();
            this.b = MultiMap.create();
            this.g = new ArrayList<PsiComment>();
            this.a = file;
            this.c = (PyCodeStyleSettings)CodeStyle.getCustomSettings((PsiFile)this.a, PyCodeStyleSettings.class);
            this.i = this.a.getImportBlock();
            this.j = new EnumMap<AddImportHelper.ImportPriority, List<PyImportStatementBase>>(AddImportHelper.ImportPriority.class);
            for (AddImportHelper.ImportPriority importPriority : AddImportHelper.ImportPriority.values()) {
                this.j.put(importPriority, new ArrayList());
            }
            this.h = PyElementGenerator.getInstance(this.a.getProject());
            this.k = LanguageLevel.forElement((PsiElement)this.a);
        }

        @NotNull
        private Comparator<PyImportElement> d() {
            Comparator comparator = this.c.OPTIMIZE_IMPORTS_CASE_INSENSITIVE_ORDER ? String.CASE_INSENSITIVE_ORDER : Comparator.naturalOrder();
            Comparator<QualifiedName> comparator2 = Comparator.comparing(QualifiedName::toString, comparator);
            Comparator<PyImportElement> comparator3 = Comparator.comparing(PyImportElement::getImportedQName, Comparator.nullsFirst(comparator2)).thenComparing(PyImportElement::getAsName, Comparator.nullsFirst(comparator));
            if (comparator3 == null) {
                ImportSorter.a(1);
            }
            return comparator3;
        }

        public void run() {
            long l2 = m ^ 0x138224D163C7L;
            if (this.i.isEmpty()) {
                return;
            }
            this.b(this.i);
            for (PyImportStatementBase importPriorityArray : this.i) {
                AddImportHelper.ImportPriorityChoice importPriorityChoice = AddImportHelper.getImportPriorityWithReason(importPriorityArray);
                a.debug(String.format("Import group for '%s' is %s: %s", new Object[]{importPriorityArray.getText(), importPriorityChoice.getPriority(), importPriorityChoice.getDescription()}));
                this.j.get((Object)importPriorityChoice.getPriority()).add(importPriorityArray);
            }
            boolean bl2 = false;
            for (AddImportHelper.ImportPriority importPriority : AddImportHelper.ImportPriority.values()) {
                List<PyImportStatementBase> list2;
                List<PyImportStatementBase> list3 = this.j.get((Object)importPriority);
                bl2 |= !list3.equals(list2 = this.a(list3));
                this.j.put(importPriority, list2);
            }
            if (bl2 || this.a() || this.c()) {
                this.b();
            }
        }

        private void b(@NotNull List<PyImportStatementBase> list2) {
            if (list2 == null) {
                ImportSorter.a(2);
            }
            for (PyImportStatementBase pyImportStatementBase : list2) {
                PyFromImportStatement pyFromImportStatement = PyUtil.as(pyImportStatementBase, PyFromImportStatement.class);
                if (pyFromImportStatement != null && !pyFromImportStatement.isStarImport()) {
                    this.f.putValue((Object)ImportSorter.getNormalizedFromImportSource(pyFromImportStatement), (Object)pyFromImportStatement);
                }
                Couple<List<PsiComment>> couple = ImportSorter.a(pyImportStatementBase);
                this.e.putValues((Object)pyImportStatementBase, (Collection)couple.getFirst());
                if (pyImportStatementBase != this.i.get(0)) {
                    this.g.addAll((Collection)couple.getSecond());
                }
                this.l.putValues((Object)pyImportStatementBase, PsiTreeUtil.collectElementsOfType((PsiElement)pyImportStatementBase, (Class[])new Class[]{PsiComment.class}));
            }
        }

        @NotNull
        private List<PyImportStatementBase> a(@NotNull List<PyImportStatementBase> list2) {
            if (list2 == null) {
                ImportSorter.a(3);
            }
            ArrayList<PyImportStatementBase> arrayList = new ArrayList<PyImportStatementBase>();
            for (PyImportStatementBase pyImportStatementBase : list2) {
                if (pyImportStatementBase instanceof PyImportStatement) {
                    this.a(arrayList, (PyImportStatement)pyImportStatementBase);
                    continue;
                }
                if (!(pyImportStatementBase instanceof PyFromImportStatement)) continue;
                this.a(arrayList, (PyFromImportStatement)pyImportStatementBase);
            }
            ArrayList<PyImportStatementBase> arrayList2 = arrayList;
            if (arrayList2 == null) {
                ImportSorter.a(4);
            }
            return arrayList2;
        }

        private void a(@NotNull List<PyImportStatementBase> list2, @NotNull PyImportStatement pyImportStatement) {
            Object[] objectArray;
            if (list2 == null) {
                ImportSorter.a(5);
            }
            if (pyImportStatement == null) {
                ImportSorter.a(6);
            }
            if ((objectArray = pyImportStatement.getImportElements()).length > 1) {
                List list3 = ContainerUtil.map((Object[])objectArray, pyImportElement -> this.h.createImportStatement(this.k, pyImportElement.getText(), null));
                this.a(list2, pyImportStatement, list3);
            } else {
                this.a(list2, (PyImportStatementBase)pyImportStatement);
            }
        }

        private void a(@NotNull List<PyImportStatementBase> list2, @NotNull PyFromImportStatement pyFromImportStatement) {
            boolean bl2;
            Object object2;
            boolean bl3;
            long l2 = m ^ 0x3D050FD15C83L;
            if (list2 == null) {
                ImportSorter.a(7);
            }
            if (pyFromImportStatement == null) {
                ImportSorter.a(8);
            }
            if (pyFromImportStatement.isStarImport()) {
                this.a(list2, (PyImportStatementBase)pyFromImportStatement);
                return;
            }
            String string = ImportSorter.getNormalizedFromImportSource(pyFromImportStatement);
            Object[] objectArray = pyFromImportStatement.getImportElements();
            ArrayList arrayList = new ArrayList();
            Comparator<PyImportElement> comparator = this.d();
            Collection collection = this.f.get((Object)string);
            if (collection.isEmpty()) {
                return;
            }
            boolean bl4 = collection.size() == 1 && pyFromImportStatement.getLeftParen() != null;
            boolean bl5 = this.c.OPTIMIZE_IMPORTS_JOIN_FROM_IMPORTS_WITH_SAME_SOURCE && collection.size() > 1;
            boolean bl6 = bl3 = this.c.OPTIMIZE_IMPORTS_ALWAYS_SPLIT_FROM_IMPORTS && objectArray.length > 1;
            if (bl5) {
                for (Object object2 : collection) {
                    ContainerUtil.addAll(arrayList, (Object[])object2.getImportElements());
                }
                this.f.remove((Object)string);
            } else if (!bl3 && this.c.OPTIMIZE_IMPORTS_SORT_NAMES_IN_FROM_IMPORTS && !Ordering.from(comparator).isOrdered(Arrays.asList(objectArray))) {
                ContainerUtil.addAll(arrayList, (Object[])objectArray);
            }
            boolean bl7 = bl2 = !arrayList.isEmpty();
            if (bl2) {
                if (this.c.OPTIMIZE_IMPORTS_SORT_NAMES_IN_FROM_IMPORTS) {
                    Collections.sort(arrayList, comparator);
                }
                object2 = StringUtil.join(arrayList, ImportSorter::a, (String)", ");
                if (bl4) {
                    object2 = "(" + (String)object2 + ")";
                }
                PyFromImportStatement pyFromImportStatement2 = this.h.createFromImportStatement(this.k, string, (String)object2, null);
                Set set = ContainerUtil.map2LinkedSet(arrayList, pyImportElement -> (PyImportStatementBase)pyImportElement.getParent());
                this.a(list2, set, pyFromImportStatement2);
            } else if (bl3) {
                object2 = ContainerUtil.map((Object[])objectArray, pyImportElement -> {
                    String string2 = Objects.toString(pyImportElement.getImportedQName(), "");
                    String string3 = pyImportElement.getAsName();
                    return this.h.createFromImportStatement(this.k, string, string2, string3);
                });
                this.a(list2, pyFromImportStatement, (Collection<? extends PyImportStatementBase>)object2);
            } else {
                this.a(list2, (PyImportStatementBase)pyFromImportStatement);
            }
        }

        private void a(@NotNull List<PyImportStatementBase> list2, @NotNull Collection<? extends PyImportStatementBase> collection, @NotNull PyFromImportStatement pyFromImportStatement) {
            if (list2 == null) {
                ImportSorter.a(9);
            }
            if (collection == null) {
                ImportSorter.a(10);
            }
            if (pyFromImportStatement == null) {
                ImportSorter.a(11);
            }
            for (PyImportStatementBase pyImportStatementBase : collection) {
                this.d.putValues((Object)pyFromImportStatement, this.e.get((Object)pyImportStatementBase));
                this.b.putValues((Object)pyFromImportStatement, this.l.get((Object)pyImportStatementBase));
            }
            list2.add(pyFromImportStatement);
        }

        private void a(@NotNull List<PyImportStatementBase> list2, @NotNull PyImportStatementBase pyImportStatementBase, @NotNull Collection<? extends PyImportStatementBase> collection) {
            if (list2 == null) {
                ImportSorter.a(12);
            }
            if (pyImportStatementBase == null) {
                ImportSorter.a(13);
            }
            if (collection == null) {
                ImportSorter.a(14);
            }
            PyImportStatementBase pyImportStatementBase2 = this.c.OPTIMIZE_IMPORTS_SORT_IMPORTS ? Collections.min(collection, AddImportHelper.getSameGroupImportsComparator(this.a)) : (PyImportStatementBase)ContainerUtil.getFirstItem(collection);
            this.d.putValues((Object)pyImportStatementBase2, this.e.get((Object)pyImportStatementBase));
            this.b.putValues((Object)pyImportStatementBase2, this.l.get((Object)pyImportStatementBase));
            list2.addAll(collection);
        }

        private void a(@NotNull List<PyImportStatementBase> list2, @NotNull PyImportStatementBase pyImportStatementBase) {
            if (list2 == null) {
                ImportSorter.a(15);
            }
            if (pyImportStatementBase == null) {
                ImportSorter.a(16);
            }
            this.d.putValues((Object)pyImportStatementBase, this.e.get((Object)pyImportStatementBase));
            list2.add(pyImportStatementBase);
        }

        @NotNull
        private static String a(@NotNull PyImportElement pyImportElement) {
            long l2 = m ^ 0x118B3350C994L;
            if (pyImportElement == null) {
                ImportSorter.a(17);
            }
            String string = pyImportElement.getText().replaceAll("#.*", "").replaceAll("[\\s\\\\]+", " ");
            if (string == null) {
                ImportSorter.a(18);
            }
            return string;
        }

        @NotNull
        private static Couple<List<PsiComment>> a(@NotNull PyImportStatementBase pyImportStatementBase) {
            List<PsiComment> list2;
            PsiComment psiComment;
            if (pyImportStatementBase == null) {
                ImportSorter.a(19);
            }
            if ((psiComment = (PsiComment)ContainerUtil.getFirstItem(list2 = PyPsiUtils.getPrecedingComments((PsiElement)pyImportStatementBase, true))) != null && ImportSorter.a((PsiElement)psiComment)) {
                Couple couple = Couple.of(Collections.emptyList(), list2);
                if (couple == null) {
                    ImportSorter.a(20);
                }
                return couple;
            }
            List<PsiComment> list3 = PyPsiUtils.getPrecedingComments((PsiElement)ObjectUtils.notNull((Object)psiComment, (Object)pyImportStatementBase), false);
            Couple couple = Couple.of(list2, list3);
            if (couple == null) {
                ImportSorter.a(21);
            }
            return couple;
        }

        private static boolean a(@NotNull PsiElement psiElement) {
            if (psiElement == null) {
                ImportSorter.a(22);
            }
            if (psiElement.getTextRange().getStartOffset() == 0) {
                return true;
            }
            PsiWhiteSpace psiWhiteSpace = PyUtil.as(PsiTreeUtil.prevLeaf((PsiElement)psiElement), PsiWhiteSpace.class);
            return psiWhiteSpace != null && psiWhiteSpace.getTextRange().getStartOffset() == 0;
        }

        @NotNull
        public static String getNormalizedFromImportSource(@NotNull PyFromImportStatement statement) {
            if (statement == null) {
                ImportSorter.a(23);
            }
            String string = StringUtil.repeatSymbol((char)'.', (int)statement.getRelativeLevel()) + Objects.toString(statement.getImportSourceQName(), "");
            if (string == null) {
                ImportSorter.a(24);
            }
            return string;
        }

        private boolean c() {
            if (!this.c.OPTIMIZE_IMPORTS_SORT_IMPORTS) {
                return false;
            }
            Ordering ordering = Ordering.from(AddImportHelper.getSameGroupImportsComparator(this.a));
            return ContainerUtil.exists(this.j.values(), list2 -> !ordering.isOrdered((Iterable)list2));
        }

        private boolean a() {
            return ((StreamEx)StreamEx.of(this.j.values()).remove(List::isEmpty)).count() > 1L;
        }

        private void b() {
            PsiElement psiElement;
            Object object;
            PsiElement psiElement2;
            if (this.c.OPTIMIZE_IMPORTS_SORT_IMPORTS) {
                psiElement2 = this.j.keySet().iterator();
                while (psiElement2.hasNext()) {
                    object = (AddImportHelper.ImportPriority)((Object)psiElement2.next());
                    psiElement = this.j.get(object);
                    Collections.sort(psiElement, AddImportHelper.getSameGroupImportsComparator(this.a));
                    this.j.put((AddImportHelper.ImportPriority)((Object)object), (List<PyImportStatementBase>)psiElement);
                }
            }
            psiElement = (object = (List)ImportSorter.a((PyImportStatementBase)(psiElement2 = this.i.get(0))).getFirst()).isEmpty() ? psiElement2 : (PsiElement)object.get(0);
            PyImportStatementBase pyImportStatementBase = (PyImportStatementBase)ContainerUtil.getLastItem(this.i);
            assert (pyImportStatementBase != null);
            this.b((PsiElement)pyImportStatementBase);
            ImportSorter.a(psiElement, PyPsiUtils.getNextNonWhitespaceSibling((PsiElement)pyImportStatementBase).getPrevSibling());
        }

        private void b(@NotNull PsiElement psiElement) {
            Object object2;
            long l2 = m ^ 0x7693A8C66D9FL;
            if (psiElement == null) {
                ImportSorter.a(25);
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (List<PyImportStatementBase> object32 : this.j.values()) {
                if (stringBuilder.length() > 0 && !object32.isEmpty()) {
                    stringBuilder.append("\n");
                }
                for (Object object2 : object32) {
                    for (Object object3 : this.d.get(object2)) {
                        stringBuilder.append(object3.getText()).append("\n");
                    }
                    stringBuilder.append(object2.getText());
                    Collection collection = this.b.get(object2);
                    if (!collection.isEmpty()) {
                        Object object3;
                        stringBuilder.append("  # ");
                        object3 = StringUtil.join((Collection)collection, psiComment -> psiComment.getText().substring(1).trim(), (String)"; ");
                        stringBuilder.append((String)object3).append("\n");
                        continue;
                    }
                    stringBuilder.append("\n");
                }
            }
            if (!this.g.isEmpty()) {
                stringBuilder.append("\n");
                for (PsiComment psiComment2 : this.g) {
                    stringBuilder.append(psiComment2.getText()).append("\n");
                }
            }
            Project project = psiElement.getProject();
            PyFile pyFile = (PyFile)this.h.createDummyFile(this.k, stringBuilder.toString());
            PyFile pyFile2 = (PyFile)CodeStyleManager.getInstance((Project)project).reformat((PsiElement)pyFile);
            object2 = pyFile2.getImportBlock();
            assert (object2 != null);
            this.a.addRangeAfter(pyFile2.getFirstChild(), pyFile2.getLastChild(), psiElement);
        }

        private static void a(@NotNull PsiElement psiElement, @NotNull PsiElement psiElement2) {
            if (psiElement == null) {
                ImportSorter.a(26);
            }
            if (psiElement2 == null) {
                ImportSorter.a(27);
            }
            PyUtil.updateDocumentUnblockedAndCommitted(psiElement, (Consumer<? super Document>)((Consumer)document -> document.deleteString(psiElement.getTextRange().getStartOffset(), psiElement2.getTextRange().getEndOffset())));
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = m ^ 0x5134E122A974L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 4: 
                case 18: 
                case 20: 
                case 21: 
                case 24: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 4: 
                case 18: 
                case 20: 
                case 21: 
                case 24: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: 
                case 4: 
                case 18: 
                case 20: 
                case 21: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/codeInsight/imports/PyImportOptimizer$ImportSorter";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "imports";
                    break;
                }
                case 5: 
                case 7: 
                case 9: 
                case 12: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importStatement";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fromImport";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldImports";
                    break;
                }
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newImport";
                    break;
                }
                case 13: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldImport";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newImports";
                    break;
                }
                case 17: 
                case 22: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 19: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "statement";
                    break;
                }
                case 25: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anchor";
                    break;
                }
                case 26: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "first";
                    break;
                }
                case 27: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "last";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/codeInsight/imports/PyImportOptimizer$ImportSorter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFromNamesComparator";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "transformImportsInGroup";
                    break;
                }
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNormalizedImportElementText";
                    break;
                }
                case 20: 
                case 21: {
                    objectArray = objectArray2;
                    objectArray2[1] = "collectPrecedingLineComments";
                    break;
                }
                case 24: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNormalizedFromImportSource";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 4: 
                case 18: 
                case 20: 
                case 21: 
                case 24: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "analyzeImports";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "transformImportsInGroup";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "transformPlainImport";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "transformFromImport";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceSeveralImportsWithOne";
                    break;
                }
                case 12: 
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "replaceOneImportWithSeveral";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportAsIs";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "getNormalizedImportElementText";
                    break;
                }
                case 19: {
                    objectArray = objectArray;
                    objectArray[2] = "collectPrecedingLineComments";
                    break;
                }
                case 22: {
                    objectArray = objectArray;
                    objectArray[2] = "isFirstInFile";
                    break;
                }
                case 23: {
                    objectArray = objectArray;
                    objectArray[2] = "getNormalizedFromImportSource";
                    break;
                }
                case 25: {
                    objectArray = objectArray;
                    objectArray[2] = "addImportsAfter";
                    break;
                }
                case 26: 
                case 27: {
                    objectArray = objectArray;
                    objectArray[2] = "deleteRangeThroughDocument";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 4: 
                case 18: 
                case 20: 
                case 21: 
                case 24: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

