/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.imports;

import com.intellij.codeInsight.hint.QuestionAction;
import com.intellij.ide.DataManager;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.imports.AddImportHelper;
import com.jetbrains.python.codeInsight.imports.ImportCandidateHolder;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFromImportStatement;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import java.awt.Component;
import java.awt.Font;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;

public class ImportFromExistingAction
implements QuestionAction {
    PsiElement myTarget;
    List<? extends ImportCandidateHolder> mySources;
    String myName;
    boolean myUseQualifiedImport;
    private Runnable b;
    private final boolean a;
    private static final long c = com.jetbrains.python.psi.c.a(8170478821295548714L, -7121822957903051076L, MethodHandles.lookup().lookupClass()).a(57749219707218L);

    public ImportFromExistingAction(@NotNull PsiElement target, @NotNull List<? extends ImportCandidateHolder> sources, @NotNull String name, boolean useQualified, boolean importLocally) {
        if (target == null) {
            ImportFromExistingAction.a(0);
        }
        if (sources == null) {
            ImportFromExistingAction.a(1);
        }
        if (name == null) {
            ImportFromExistingAction.a(2);
        }
        this.myTarget = target;
        this.mySources = sources;
        this.myName = name;
        this.myUseQualifiedImport = useQualified;
        this.a = importLocally;
    }

    public void onDone(Runnable callback) {
        assert (this.b == null);
        this.b = callback;
    }

    public boolean execute() {
        PsiDocumentManager.getInstance((Project)this.myTarget.getProject()).commitAllDocuments();
        PyPsiUtils.assertValid(this.myTarget);
        if (this.myTarget instanceof PyQualifiedExpression && ((PyQualifiedExpression)this.myTarget).isQualified()) {
            return false;
        }
        for (ImportCandidateHolder importCandidateHolder : this.mySources) {
            PyPsiUtils.assertValid(importCandidateHolder.getImportable());
            PyPsiUtils.assertValid((PsiElement)importCandidateHolder.getFile());
            PyImportElement pyImportElement = importCandidateHolder.getImportElement();
            if (pyImportElement == null) continue;
            PyPsiUtils.assertValid((PsiElement)pyImportElement);
        }
        if (this.mySources.isEmpty()) {
            return false;
        }
        if (this.mySources.size() == 1 || ApplicationManager.getApplication().isUnitTestMode()) {
            this.f(this.mySources.get(0));
        } else {
            this.a();
        }
        return true;
    }

    private void a() {
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(dataContext -> {
            long l2 = c ^ 0x310921352769L;
            JBPopupFactory.getInstance().createPopupChooserBuilder(this.mySources).setRenderer((ListCellRenderer)new CellRenderer(this.myName)).setTitle(this.myUseQualifiedImport ? PyBundle.message("ACT.qualify.with.module", new Object[0]) : PyBundle.message("ACT.from.some.module.import", new Object[0])).setItemChosenCallback(importCandidateHolder -> {
                PsiDocumentManager.getInstance((Project)this.myTarget.getProject()).commitAllDocuments();
                this.f((ImportCandidateHolder)importCandidateHolder);
            }).setNamerForFiltering(importCandidateHolder -> importCandidateHolder.getPresentableText(this.myName)).createPopup().showInBestPositionFor(dataContext);
        });
    }

    private void a(ImportCandidateHolder importCandidateHolder) {
        PyImportElement pyImportElement = importCandidateHolder.getImportElement();
        if (pyImportElement != null) {
            this.a(pyImportElement);
        } else {
            this.b(importCandidateHolder);
        }
    }

    private void b(ImportCandidateHolder importCandidateHolder) {
        Project project = this.myTarget.getProject();
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(project);
        PsiFileSystemItem psiFileSystemItem = (PsiFileSystemItem)ObjectUtils.chooseNotNull((Object)PyUtil.as(importCandidateHolder.getImportable(), PsiFileSystemItem.class), (Object)importCandidateHolder.getFile());
        if (psiFileSystemItem == null) {
            return;
        }
        AddImportHelper.ImportPriority importPriority = AddImportHelper.getImportPriority(this.myTarget, psiFileSystemItem);
        PsiFile psiFile = this.myTarget.getContainingFile();
        InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)project);
        if (injectedLanguageManager.isInjectedFragment(psiFile)) {
            psiFile = injectedLanguageManager.getTopLevelFile(this.myTarget);
        }
        if (ImportFromExistingAction.isRoot(importCandidateHolder.getFile())) {
            if (this.a) {
                AddImportHelper.addLocalImportStatement(this.myTarget, this.myName);
            } else {
                AddImportHelper.addImportStatement(psiFile, this.myName, importCandidateHolder.getAsName(), importPriority, null);
            }
        } else {
            String string;
            QualifiedName qualifiedName = importCandidateHolder.getPath();
            String string2 = string = qualifiedName != null ? qualifiedName.toString() : "";
            if (this.myUseQualifiedImport) {
                String string3 = string;
                if (importCandidateHolder.getImportable() instanceof PsiFileSystemItem) {
                    string3 = string3 + "." + this.myName;
                }
                if (this.a) {
                    AddImportHelper.addLocalImportStatement(this.myTarget, string3);
                } else {
                    AddImportHelper.addImportStatement(psiFile, string3, importCandidateHolder.getAsName(), importPriority, null);
                }
                this.myTarget.replace((PsiElement)pyElementGenerator.createExpressionFromText(LanguageLevel.forElement(this.myTarget), string + "." + this.myName));
            } else if (this.a) {
                AddImportHelper.addLocalFromImportStatement(this.myTarget, string, this.myName);
            } else {
                AddImportHelper.addOrUpdateFromImportStatement(psiFile, string, this.myName, importCandidateHolder.getAsName(), importPriority, null);
            }
        }
    }

    private void a(PyImportElement pyImportElement) {
        PyElementGenerator pyElementGenerator = PyElementGenerator.getInstance(this.myTarget.getProject());
        PsiElement psiElement = pyImportElement.getParent();
        if (psiElement instanceof PyFromImportStatement) {
            PyImportElement pyImportElement2 = pyElementGenerator.createImportElement(LanguageLevel.getDefault(), this.myName, null);
            psiElement.add((PsiElement)pyImportElement2);
            CodeStyleManager.getInstance((Project)this.myTarget.getProject()).reformat(psiElement);
        } else {
            this.myTarget.replace((PsiElement)pyElementGenerator.createExpressionFromText(LanguageLevel.forElement(this.myTarget), pyImportElement.getVisibleName() + "." + this.myName));
        }
    }

    private void f(ImportCandidateHolder importCandidateHolder) {
        long l2 = c ^ 0x697DA07FA252L;
        PsiElement psiElement = importCandidateHolder.getImportable();
        if (psiElement == null) {
            return;
        }
        WriteCommandAction.writeCommandAction((Project)psiElement.getProject(), (PsiFile[])new PsiFile[]{this.myTarget.getContainingFile()}).withName(PyBundle.message("ACT.CMD.use.import", new Object[0])).run(() -> this.a(importCandidateHolder));
        if (this.b != null) {
            this.b.run();
        }
    }

    public static boolean isRoot(PsiFileSystemItem directory2) {
        if (directory2 == null) {
            return true;
        }
        VirtualFile virtualFile = directory2.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        ProjectFileIndex projectFileIndex = ProjectFileIndex.SERVICE.getInstance((Project)directory2.getProject());
        return Comparing.equal((Object)projectFileIndex.getClassRootForFile(virtualFile), (Object)virtualFile) || Comparing.equal((Object)projectFileIndex.getContentRootForFile(virtualFile), (Object)virtualFile) || Comparing.equal((Object)projectFileIndex.getSourceRootForFile(virtualFile), (Object)virtualFile);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = c ^ 0x79F6DD664DE5L;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "target";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "sources";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/codeInsight/imports/ImportFromExistingAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CellRenderer
    extends SimpleColoredComponent
    implements ListCellRenderer {
        private final Font b;
        private final String a;

        CellRenderer(String name) {
            this.a = name;
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            this.b = new Font(editorColorsScheme.getEditorFontName(), 0, editorColorsScheme.getEditorFontSize());
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list2, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.clear();
            ImportCandidateHolder importCandidateHolder = (ImportCandidateHolder)value;
            PsiElement psiElement = ((ImportCandidateHolder)value).getImportable();
            if (psiElement != null) {
                this.setIcon(psiElement.getIcon(0));
            }
            String string = importCandidateHolder.getPresentableText(this.a);
            this.append(string, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            this.setFont(this.b);
            if (isSelected) {
                this.setBackground(list2.getSelectionBackground());
                this.setForeground(list2.getSelectionForeground());
            } else {
                this.setBackground(list2.getBackground());
                this.setForeground(list2.getForeground());
            }
            return this;
        }
    }
}

