/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.buildout;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.ParamsGroup;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.jetbrains.python.PythonHelper;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.buildout.BuildoutFacetConfiguration;
import com.jetbrains.python.buildout.BuildoutFacetType;
import com.jetbrains.python.buildout.config.BuildoutCfgLanguage;
import com.jetbrains.python.buildout.config.psi.impl.BuildoutCfgFile;
import com.jetbrains.python.facet.FacetLibraryConfigurator;
import com.jetbrains.python.facet.LibraryContributingFacet;
import com.jetbrains.python.facet.PythonPathContributingFacet;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.sdk.PythonEnvUtil;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildoutFacet
extends LibraryContributingFacet<BuildoutFacetConfiguration>
implements PythonPathContributingFacet {
    private static final Logger a;
    @NonNls
    public static final String BUILDOUT_CFG = "buildout.cfg";
    @NonNls
    public static final String SCRIPT_SUFFIX = "-script";
    private static final String b = "Buildout Eggs";
    private static final long c;

    public BuildoutFacet(@NotNull FacetType facetType, final @NotNull Module module2, @NotNull String name, @NotNull BuildoutFacetConfiguration configuration, Facet underlyingFacet) {
        if (facetType == null) {
            BuildoutFacet.b(0);
        }
        if (module2 == null) {
            BuildoutFacet.b(1);
        }
        if (name == null) {
            BuildoutFacet.b(2);
        }
        if (configuration == null) {
            BuildoutFacet.b(3);
        }
        super(facetType, module2, name, configuration, underlyingFacet);
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){
            private static final long a = com.jetbrains.python.psi.c.a(6837950244223295416L, -1153981569778156213L, MethodHandles.lookup().lookupClass()).a(25933240973490L);

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    1.a(0);
                }
                if (Comparing.equal((Object)event.getFile(), (Object)BuildoutFacet.this.getScript())) {
                    BuildoutFacet.this.updatePaths();
                    BuildoutFacet.attachLibrary(module2);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x334C7CD0327EL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/jetbrains/python/buildout/BuildoutFacet$1", "contentsChanged"));
            }
        }, (Disposable)this);
    }

    @Nullable
    public static VirtualFile getRunner(VirtualFile baseDir) {
        VirtualFile virtualFile;
        VirtualFile virtualFile2;
        long l2 = c ^ 0x661BD9DA7BBAL;
        if (baseDir == null) {
            return null;
        }
        VirtualFile virtualFile3 = baseDir.findChild(BUILDOUT_CFG);
        if (virtualFile3 != null && !virtualFile3.isDirectory() && (virtualFile2 = baseDir.findChild("eggs")) != null && virtualFile2.isDirectory() && (virtualFile = baseDir.findChild("bin")) != null && virtualFile.isDirectory()) {
            String string;
            VirtualFile virtualFile4;
            if (ApplicationManager.getApplication().isDispatchThread() || !ApplicationManager.getApplication().isReadAccessAllowed()) {
                virtualFile.refresh(false, false);
            }
            if ((virtualFile4 = virtualFile.findChild(string = SystemInfo.isWindows ? "buildout.exe" : "buildout")) != null && !virtualFile4.isDirectory()) {
                return virtualFile4;
            }
        }
        return null;
    }

    @NotNull
    public static List<VirtualFile> getExtraPathForAllOpenModules() {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
                List<String> list2;
                BuildoutFacet buildoutFacet = BuildoutFacet.getInstance(module2);
                if (buildoutFacet == null || (list2 = ((BuildoutFacetConfiguration)buildoutFacet.getConfiguration()).getPaths()) == null) continue;
                for (String string : list2) {
                    VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(string);
                    if (virtualFile == null) continue;
                    arrayList.add(virtualFile);
                }
            }
        }
        ArrayList<VirtualFile> arrayList2 = arrayList;
        if (arrayList2 == null) {
            BuildoutFacet.b(4);
        }
        return arrayList2;
    }

    @Nullable
    public String getPathPrependStatement(List<String> additionalPythonPath) {
        long l2 = c ^ 0x4C3DDC9B3D47L;
        StringBuilder stringBuilder = new StringBuilder("sys.path[0:0]=[");
        for (String string : additionalPythonPath) {
            stringBuilder.append("'").append(string).append("',");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public void initFacet() {
        this.updateLibrary();
    }

    @Override
    public void updateLibrary() {
        this.updatePaths();
        BuildoutFacet.attachLibrary(this.getModule());
    }

    @Override
    public void removeLibrary() {
        BuildoutFacet.detachLibrary(this.getModule());
    }

    public void updatePaths() {
        BuildoutFacetConfiguration buildoutFacetConfiguration = (BuildoutFacetConfiguration)this.getConfiguration();
        VirtualFile virtualFile = this.getScript();
        if (virtualFile != null) {
            buildoutFacetConfiguration.setPaths(BuildoutFacet.extractBuildoutPaths(virtualFile));
        }
    }

    @Nullable
    public VirtualFile getScript() {
        return LocalFileSystem.getInstance().findFileByPath(((BuildoutFacetConfiguration)this.getConfiguration()).getScriptName());
    }

    @Nullable
    public static List<String> extractBuildoutPaths(@NotNull VirtualFile script) {
        long l2 = c ^ 0x3C96F398310DL;
        if (script == null) {
            BuildoutFacet.b(5);
        }
        try {
            List<String> list2 = BuildoutFacet.extractFromScript(script);
            if (list2 == null) {
                VirtualFile virtualFile;
                VirtualFile virtualFile2 = script.getParent().getParent();
                String string = FileUtilRt.getNameWithoutExtension((String)script.getName());
                if (SystemInfo.isWindows && string.endsWith(SCRIPT_SUFFIX)) {
                    string = string.substring(0, string.length() - SCRIPT_SUFFIX.length());
                }
                if ((virtualFile = virtualFile2.findFileByRelativePath("parts/" + string + "/site.py")) != null) {
                    list2 = BuildoutFacet.extractFromSitePy(virtualFile);
                }
            }
            return list2;
        }
        catch (IOException iOException) {
            a.info((Throwable)iOException);
            return null;
        }
    }

    @Nullable
    public static List<String> extractFromScript(@NotNull VirtualFile script) throws IOException {
        long l2 = c ^ 0x277B743863E5L;
        if (script == null) {
            BuildoutFacet.b(6);
        }
        String string = VfsUtilCore.loadText((VirtualFile)script);
        Pattern pattern = Pattern.compile("(?:^\\s*(['\"])(.*)(\\1),\\s*$)|(\\])", 8);
        String string2 = "sys.path[0:0]";
        int n2 = string.indexOf("sys.path[0:0]");
        ArrayList<String> arrayList = null;
        if (n2 >= 0) {
            String string3;
            n2 += "sys.path[0:0]".length();
            Matcher matcher = pattern.matcher(string);
            while (matcher.find(n2) && (string3 = matcher.group(2)) != null) {
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string3);
                n2 = matcher.end();
            }
        }
        return arrayList;
    }

    public static List<String> extractFromSitePy(VirtualFile vFile) throws IOException {
        int n2;
        long l2 = c ^ 0x443AEAA6382EL;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = VfsUtilCore.loadText((VirtualFile)vFile);
        String[] stringArray = LineTokenizer.tokenize((CharSequence)string, (boolean)false);
        for (n2 = 0; n2 < stringArray.length && !stringArray[n2].startsWith("def addsitepackages("); ++n2) {
        }
        while (n2 < stringArray.length && !stringArray[n2].trim().startsWith("buildout_paths = [")) {
            ++n2;
        }
        ++n2;
        while (n2 < stringArray.length && !stringArray[n2].trim().equals("]")) {
            String string2 = stringArray[n2].trim();
            if ((string2 = StringUtil.trimEnd((String)string2, (String)",")).startsWith("'") && string2.endsWith("'")) {
                arrayList.add(StringUtil.unescapeStringCharacters((String)string2.substring(1, string2.length() - 1)));
            }
            ++n2;
        }
        return arrayList;
    }

    @Override
    public List<String> getAdditionalPythonPath() {
        BuildoutFacetConfiguration buildoutFacetConfiguration = (BuildoutFacetConfiguration)this.getConfiguration();
        return buildoutFacetConfiguration.getPaths();
    }

    @Override
    public boolean acceptRootAsTopLevelPackage() {
        return false;
    }

    @Nullable
    public static BuildoutFacet getInstance(Module module2) {
        return (BuildoutFacet)FacetManager.getInstance((Module)module2).getFacetByType(BuildoutFacetType.ID);
    }

    public void patchCommandLineForBuildout(GeneralCommandLine commandLine) {
        long l2 = c ^ 0x7CBAA65475B8L;
        Map map2 = commandLine.getEnvironment();
        ParametersList parametersList = commandLine.getParametersList();
        ParamsGroup paramsGroup = parametersList.getParamsGroup("Script");
        assert (paramsGroup != null);
        if (paramsGroup.getParameters().size() > 0) {
            String string = (String)paramsGroup.getParameters().get(0);
            PythonHelper pythonHelper = PythonHelper.BUILDOUT_ENGULFER;
            map2.put("PYCHARM_ENGULF_SCRIPT", ((BuildoutFacetConfiguration)this.getConfiguration()).getScriptName());
            paramsGroup.getParametersList().replaceOrPrepend(string, pythonHelper.asParamString());
        }
        PythonEnvUtil.addToPythonPath((Map<String, String>)map2, PythonHelpersLocator.getHelpersRoot().getAbsolutePath());
    }

    @Nullable
    public File getConfigFile() {
        long l2 = c ^ 0x21904C289684L;
        String string = ((BuildoutFacetConfiguration)this.getConfiguration()).getScriptName();
        if (!StringUtil.isEmpty((String)string)) {
            return new File(new File(string).getParentFile().getParentFile(), BUILDOUT_CFG);
        }
        return null;
    }

    @Nullable
    public BuildoutCfgFile getConfigPsiFile() {
        long l2 = c ^ 0x309F8000DC4L;
        File file = this.getConfigFile();
        if (file != null && file.exists()) {
            try {
                String string = FileUtil.loadFile((File)file);
                PsiFile psiFile = PsiFileFactory.getInstance((Project)this.getModule().getProject()).createFileFromText(BUILDOUT_CFG, (Language)BuildoutCfgLanguage.INSTANCE, (CharSequence)string);
                if (psiFile instanceof BuildoutCfgFile) {
                    return (BuildoutCfgFile)psiFile;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static List<File> getScripts(@Nullable BuildoutFacet buildoutFacet, VirtualFile baseDir) {
        File[] fileArray;
        long l2 = c ^ 0x386E34C7384BL;
        File file2 = null;
        if (buildoutFacet != null && (fileArray = buildoutFacet.getConfigFile()) != null) {
            file2 = fileArray.getParentFile();
        }
        if (!(file2 != null && file2.exists() || baseDir == null)) {
            file2 = new File(baseDir.getPath());
        }
        if (file2 != null && (fileArray = new File(file2, "bin").listFiles((file, string) -> {
            long l2 = c ^ 0x90794B5317L;
            if (SystemInfo.isWindows) {
                return string.endsWith("-script.py");
            }
            String string2 = FileUtilRt.getExtension((String)string);
            return string2.length() == 0 || FileUtil.namesEqual((String)string2, (String)"py");
        })) != null) {
            return Arrays.asList(fileArray);
        }
        return Collections.emptyList();
    }

    @Nullable
    public static File findScript(@Nullable BuildoutFacet buildoutFacet, String name, VirtualFile baseDir) {
        long l2 = c ^ 0x6C4FE92FB9E7L;
        String string = SystemInfo.isWindows ? name + SCRIPT_SUFFIX : name;
        List<File> list2 = BuildoutFacet.getScripts(buildoutFacet, baseDir);
        for (File file : list2) {
            if (!FileUtilRt.getNameWithoutExtension((String)file.getName()).equals(string)) continue;
            return file;
        }
        return null;
    }

    public static void attachLibrary(Module module2) {
        long l2 = c ^ 0x534C96A76F2AL;
        BuildoutFacet buildoutFacet = BuildoutFacet.getInstance(module2);
        if (buildoutFacet == null) {
            return;
        }
        List<String> list2 = ((BuildoutFacetConfiguration)buildoutFacet.getConfiguration()).getPaths();
        FacetLibraryConfigurator.attachPythonLibrary(module2, null, b, list2);
    }

    public static void detachLibrary(Module module2) {
        long l2 = c ^ 0x7D006704E956L;
        FacetLibraryConfigurator.detachPythonLibrary(module2, b);
    }

    static {
        c = com.jetbrains.python.psi.c.a(7839302330913240809L, 3735622304375431518L, MethodHandles.lookup().lookupClass()).a(164729853324480L);
        long l2 = c ^ 0x37B6B928869CL;
        a = Logger.getInstance((String)"#com.jetbrains.python.buildout.BuildoutFacet");
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = c ^ 0x626AF5272DCAL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facetType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/buildout/BuildoutFacet";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "script";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/buildout/BuildoutFacet";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtraPathForAllOpenModules";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "extractBuildoutPaths";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "extractFromScript";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

