/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.actions;

import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionHelper;
import com.intellij.execution.console.LanguageConsoleView;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.Consumer;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.python.console.PyCodeExecutor;
import com.jetbrains.python.console.PydevConsoleRunner;
import com.jetbrains.python.console.PythonConsoleRunnerFactory;
import com.jetbrains.python.console.PythonConsoleToolWindow;
import com.jetbrains.python.console.PythonConsoleView;
import com.jetbrains.python.console.PythonDebugLanguageConsoleView;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.run.PythonRunConfiguration;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyExecuteSelectionAction
extends AnAction {
    public static final String EXECUTE_SELECTION_IN_CONSOLE = "Execute Selection in Python Console";
    public static final String EXECUTE_LINE_IN_CONSOLE = "Execute Line in Python Console";
    private static final long a = c.a(4835914379707346622L, -6536686745861602760L, MethodHandles.lookup().lookupClass()).a(71542731198786L);

    public PyExecuteSelectionAction() {
        long l2 = a ^ 0x1780AAF8AD9CL;
        super(EXECUTE_SELECTION_IN_CONSOLE);
    }

    public void actionPerformed(@NotNull AnActionEvent e10) {
        Editor editor2;
        if (e10 == null) {
            PyExecuteSelectionAction.a(0);
        }
        if ((editor2 = (Editor)e10.getData(CommonDataKeys.EDITOR)) != null) {
            String string = PyExecuteSelectionAction.c(editor2);
            if (string != null) {
                PyExecuteSelectionAction.showConsoleAndExecuteCode(e10, string);
            } else {
                String string2 = PyExecuteSelectionAction.b(editor2);
                if (string2 != null) {
                    PyExecuteSelectionAction.showConsoleAndExecuteCode(e10, string2.trim());
                    PyExecuteSelectionAction.a(editor2);
                }
            }
        }
    }

    private static void a(Editor editor2) {
        VisualPosition visualPosition = editor2.getCaretModel().getVisualPosition();
        Pair pair = EditorUtil.calcSurroundingRange((Editor)editor2, (VisualPosition)visualPosition, (VisualPosition)visualPosition);
        int n2 = editor2.getCaretModel().getOffset();
        LogicalPosition logicalPosition = (LogicalPosition)pair.first;
        LogicalPosition logicalPosition2 = (LogicalPosition)pair.second;
        int n3 = editor2.logicalPositionToOffset(logicalPosition);
        int n4 = editor2.logicalPositionToOffset(logicalPosition2);
        Document document = editor2.getDocument();
        if (logicalPosition2.line < document.getLineCount()) {
            int n5 = n4 + n2 - n3;
            int n6 = document.getLineEndOffset(logicalPosition2.line);
            if (n5 >= n6) {
                n5 = n6;
            }
            editor2.getCaretModel().moveToOffset(n5);
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        }
    }

    public static void showConsoleAndExecuteCode(@NotNull AnActionEvent e10, @Nullable String selectionText) {
        if (e10 == null) {
            PyExecuteSelectionAction.a(1);
        }
        Editor editor2 = (Editor)e10.getData(CommonDataKeys.EDITOR);
        Project project = e10.getProject();
        boolean bl2 = selectionText == null;
        PyExecuteSelectionAction.findCodeExecutor(e10.getDataContext(), (Consumer<PyCodeExecutor>)((Consumer)pyCodeExecutor -> PyExecuteSelectionAction.executeInConsole(pyCodeExecutor, selectionText, editor2)), editor2, project, bl2);
    }

    public static void selectConsoleAndExecuteCode(@NotNull Project project, @Nullable String selectionText) {
        if (project == null) {
            PyExecuteSelectionAction.a(2);
        }
        DataContext dataContext = DataManager.getInstance().getDataContext();
        PyExecuteSelectionAction.a(dataContext, project, (Consumer<PyCodeExecutor>)((Consumer)pyCodeExecutor -> PyExecuteSelectionAction.executeInConsole(pyCodeExecutor, selectionText, null)), null, true);
    }

    private static String b(Editor editor2) {
        VisualPosition visualPosition = editor2.getCaretModel().getVisualPosition();
        Pair pair = EditorUtil.calcSurroundingRange((Editor)editor2, (VisualPosition)visualPosition, (VisualPosition)visualPosition);
        LogicalPosition logicalPosition = (LogicalPosition)pair.first;
        LogicalPosition logicalPosition2 = (LogicalPosition)pair.second;
        int n2 = editor2.logicalPositionToOffset(logicalPosition);
        int n3 = editor2.logicalPositionToOffset(logicalPosition2);
        if (n3 <= n2) {
            return null;
        }
        return editor2.getDocument().getCharsSequence().subSequence(n2, n3).toString();
    }

    @Nullable
    private static String c(@NotNull Editor editor2) {
        if (editor2 == null) {
            PyExecuteSelectionAction.a(3);
        }
        if (editor2.getSelectionModel().hasSelection()) {
            SelectionModel selectionModel = editor2.getSelectionModel();
            return selectionModel.getSelectedText();
        }
        return null;
    }

    public void update(@NotNull AnActionEvent e10) {
        long l2 = a ^ 0x1D2F8516602DL;
        if (e10 == null) {
            PyExecuteSelectionAction.a(4);
        }
        Editor editor2 = (Editor)e10.getData(CommonDataKeys.EDITOR);
        Presentation presentation = e10.getPresentation();
        boolean bl2 = false;
        if (PyExecuteSelectionAction.isPython(editor2)) {
            String string = PyExecuteSelectionAction.c(editor2);
            if (string != null) {
                presentation.setText(EXECUTE_SELECTION_IN_CONSOLE);
            } else {
                string = PyExecuteSelectionAction.b(editor2);
                if (string != null) {
                    presentation.setText(EXECUTE_LINE_IN_CONSOLE);
                }
            }
            bl2 = !StringUtil.isEmpty((String)string);
        }
        presentation.setEnabledAndVisible(bl2);
    }

    public static boolean isPython(Editor editor2) {
        if (editor2 == null) {
            return false;
        }
        Project project = editor2.getProject();
        if (project == null) {
            return false;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor2.getDocument());
        return psiFile instanceof PyFile;
    }

    private static void a(@NotNull DataContext dataContext, @NotNull Project project, @NotNull Consumer<PyCodeExecutor> consumer, @Nullable Editor editor2, boolean bl2) {
        long l2 = a ^ 0x74AD8913E2C4L;
        if (dataContext == null) {
            PyExecuteSelectionAction.a(5);
        }
        if (project == null) {
            PyExecuteSelectionAction.a(6);
        }
        if (consumer == null) {
            PyExecuteSelectionAction.a(7);
        }
        Collection<RunContentDescriptor> collection = PyExecuteSelectionAction.getConsoles(project);
        ExecutionHelper.selectContentDescriptor((DataContext)dataContext, (Project)project, collection, (String)"Select console to execute in", runContentDescriptor -> {
            long l2 = a ^ 0x7BF06ACA9BEDL;
            if (runContentDescriptor != null && runContentDescriptor.getExecutionConsole() instanceof PyCodeExecutor) {
                ExecutionConsole executionConsole = runContentDescriptor.getExecutionConsole();
                consumer.consume((Object)((PyCodeExecutor)executionConsole));
                if (executionConsole instanceof PythonDebugLanguageConsoleView) {
                    XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
                    if (xDebugSession != null) {
                        ContentManager contentManager = xDebugSession.getUI().getContentManager();
                        Content content2 = contentManager.findContent("Console");
                        contentManager.setSelectedContent(content2);
                        if (bl2) {
                            ((PythonDebugLanguageConsoleView)executionConsole).getPydevConsoleView().requestFocus();
                        } else if (editor2 != null) {
                            IdeFocusManager.findInstance().requestFocus((Component)editor2.getContentComponent(), true);
                        }
                    }
                } else {
                    ToolWindow toolWindow;
                    PythonConsoleToolWindow pythonConsoleToolWindow = PythonConsoleToolWindow.getInstance(project);
                    ToolWindow toolWindow2 = toolWindow = pythonConsoleToolWindow != null ? pythonConsoleToolWindow.getToolWindow() : null;
                    if (toolWindow != null && !toolWindow.isVisible()) {
                        toolWindow.show(null);
                        ContentManager contentManager = toolWindow.getContentManager();
                        Content content3 = contentManager.findContent(runContentDescriptor.getDisplayName());
                        if (content3 != null) {
                            contentManager.setSelectedContent(content3);
                        }
                    }
                }
            }
        });
    }

    public static Collection<RunContentDescriptor> getConsoles(Project project) {
        PythonConsoleToolWindow pythonConsoleToolWindow = PythonConsoleToolWindow.getInstance(project);
        if (pythonConsoleToolWindow != null && pythonConsoleToolWindow.getToolWindow().isVisible()) {
            RunContentDescriptor runContentDescriptor2 = pythonConsoleToolWindow.getSelectedContentDescriptor();
            return runContentDescriptor2 != null ? Lists.newArrayList((Object[])new RunContentDescriptor[]{runContentDescriptor2}) : Lists.newArrayList();
        }
        Collection collection = ExecutionHelper.findRunningConsole((Project)project, runContentDescriptor -> runContentDescriptor.getExecutionConsole() instanceof PyCodeExecutor && PyExecuteSelectionAction.b(runContentDescriptor));
        if (collection.isEmpty() && pythonConsoleToolWindow != null && pythonConsoleToolWindow.isInitialized()) {
            return pythonConsoleToolWindow.getConsoleContentDescriptors();
        }
        return collection;
    }

    private static boolean b(RunContentDescriptor runContentDescriptor) {
        ProcessHandler processHandler = runContentDescriptor.getProcessHandler();
        return processHandler != null && !processHandler.isProcessTerminated();
    }

    public static void findCodeExecutor(@NotNull DataContext dataContext, @NotNull Consumer<PyCodeExecutor> consumer, @Nullable Editor editor2, @Nullable Project project, boolean requestFocusToConsole) {
        if (dataContext == null) {
            PyExecuteSelectionAction.a(8);
        }
        if (consumer == null) {
            PyExecuteSelectionAction.a(9);
        }
        if (project != null) {
            if (PyExecuteSelectionAction.canFindConsole(project, null)) {
                PyExecuteSelectionAction.a(dataContext, project, consumer, editor2, requestFocusToConsole);
            } else {
                PyExecuteSelectionAction.a(project, consumer);
            }
        }
    }

    private static void a(Project project, Consumer<PyCodeExecutor> consumer) {
        PythonConsoleToolWindow pythonConsoleToolWindow = PythonConsoleToolWindow.getInstance(project);
        if (pythonConsoleToolWindow != null && pythonConsoleToolWindow.getConsoleContentDescriptors().size() > 0) {
            pythonConsoleToolWindow.activate(() -> {
                List<RunContentDescriptor> list2 = pythonConsoleToolWindow.getConsoleContentDescriptors();
                RunContentDescriptor runContentDescriptor = list2.get(0);
                if (runContentDescriptor != null && runContentDescriptor.getExecutionConsole() instanceof PyCodeExecutor) {
                    consumer.consume((Object)((PyCodeExecutor)runContentDescriptor.getExecutionConsole()));
                }
            });
        } else {
            PyExecuteSelectionAction.startNewConsoleInstance(project, consumer, null, null);
        }
    }

    public static void startNewConsoleInstance(@NotNull Project project, final @NotNull Consumer<? super PyCodeExecutor> consumer, @Nullable String runFileText, @Nullable PythonRunConfiguration config) {
        if (project == null) {
            PyExecuteSelectionAction.a(10);
        }
        if (consumer == null) {
            PyExecuteSelectionAction.a(11);
        }
        PythonConsoleRunnerFactory pythonConsoleRunnerFactory = PythonConsoleRunnerFactory.getInstance();
        PydevConsoleRunner pydevConsoleRunner = runFileText == null || config == null ? pythonConsoleRunnerFactory.createConsoleRunner(project, null) : pythonConsoleRunnerFactory.createConsoleRunnerWithFile(project, null, runFileText, config);
        final PythonConsoleToolWindow pythonConsoleToolWindow = PythonConsoleToolWindow.getInstance(project);
        pydevConsoleRunner.addConsoleListener(new PydevConsoleRunner.ConsoleListener(){
            private static final long a = c.a(7822533728793488394L, 1218797820942997192L, MethodHandles.lookup().lookupClass()).a(39343803075116L);

            @Override
            public void handleConsoleInitialized(@NotNull LanguageConsoleView consoleView) {
                if (consoleView == null) {
                    1.a(0);
                }
                if (consoleView instanceof PyCodeExecutor) {
                    consumer.consume((Object)((PyCodeExecutor)consoleView));
                    if (pythonConsoleToolWindow != null) {
                        pythonConsoleToolWindow.getToolWindow().show(null);
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x6C3A65CA54BBL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consoleView", "com/jetbrains/python/actions/PyExecuteSelectionAction$1", "handleConsoleInitialized"));
            }
        });
        pydevConsoleRunner.run(false);
    }

    public static boolean canFindConsole(@Nullable Project project, @Nullable String sdkHomePath) {
        if (project != null) {
            Collection<RunContentDescriptor> collection = PyExecuteSelectionAction.getConsoles(project);
            if (sdkHomePath == null) {
                return collection.size() > 0;
            }
            for (RunContentDescriptor runContentDescriptor : collection) {
                PythonConsoleView pythonConsoleView;
                ExecutionConsole executionConsole = runContentDescriptor.getExecutionConsole();
                if (!(executionConsole instanceof PythonConsoleView) || !sdkHomePath.equals((pythonConsoleView = (PythonConsoleView)executionConsole).getSdkHomePath())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static void executeInConsole(@NotNull PyCodeExecutor codeExecutor, @Nullable String text2, @Nullable Editor editor2) {
        if (codeExecutor == null) {
            PyExecuteSelectionAction.a(12);
        }
        codeExecutor.executeCode(text2, editor2);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x2C8C06471B69L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 7: 
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeExecutor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/actions/PyExecuteSelectionAction";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showConsoleAndExecuteCode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "selectConsoleAndExecuteCode";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getSelectionText";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "selectConsole";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "findCodeExecutor";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "startNewConsoleInstance";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "executeInConsole";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

