/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.codeInsight.folding.CodeFoldingSettings;
import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.PythonFoldingSettings;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFileElementType;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyStatementList;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PythonFoldingBuilder
extends CustomFoldingBuilder
implements DumbAware {
    public static final TokenSet FOLDABLE_COLLECTIONS_LITERALS;
    private static final long a;

    protected void buildLanguageFoldRegions(@NotNull List<FoldingDescriptor> descriptors, @NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (descriptors == null) {
            PythonFoldingBuilder.a(0);
        }
        if (root == null) {
            PythonFoldingBuilder.a(1);
        }
        if (document == null) {
            PythonFoldingBuilder.a(2);
        }
        PythonFoldingBuilder.e(root.getNode(), descriptors);
    }

    private static void e(ASTNode aSTNode, List<FoldingDescriptor> list2) {
        ASTNode aSTNode2;
        IElementType iElementType = aSTNode.getElementType();
        if (aSTNode.getPsi() instanceof PyFile) {
            aSTNode2 = ((PyFile)aSTNode.getPsi()).getImportBlock();
            if (aSTNode2.size() > 1) {
                PyImportStatementBase pyImportStatementBase = (PyImportStatementBase)aSTNode2.get(0);
                PyImportStatementBase pyImportStatementBase2 = (PyImportStatementBase)aSTNode2.get(aSTNode2.size() - 1);
                list2.add(new FoldingDescriptor((PsiElement)pyImportStatementBase, new TextRange(pyImportStatementBase.getTextRange().getStartOffset(), pyImportStatementBase2.getTextRange().getEndOffset())));
            }
        } else if (iElementType == PyElementTypes.STATEMENT_LIST) {
            PythonFoldingBuilder.d(aSTNode, list2);
        } else if (iElementType == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            PythonFoldingBuilder.a(aSTNode, list2);
        } else if (FOLDABLE_COLLECTIONS_LITERALS.contains(iElementType)) {
            PythonFoldingBuilder.b(aSTNode, list2);
        } else if (iElementType == PyTokenTypes.END_OF_LINE_COMMENT) {
            PythonFoldingBuilder.c(aSTNode, list2);
        }
        for (aSTNode2 = aSTNode.getFirstChildNode(); aSTNode2 != null; aSTNode2 = aSTNode2.getTreeNext()) {
            PythonFoldingBuilder.e(aSTNode2, list2);
        }
    }

    private static void c(ASTNode aSTNode, List<FoldingDescriptor> list2) {
        if (PythonFoldingBuilder.isCustomRegionElement((PsiElement)aSTNode.getPsi())) {
            return;
        }
        ASTNode aSTNode2 = aSTNode.getTreePrev();
        while (aSTNode2 != null) {
            if (aSTNode2.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT) {
                if (PythonFoldingBuilder.isCustomRegionElement((PsiElement)aSTNode2.getPsi())) break;
                return;
            }
            aSTNode2 = aSTNode2.getPsi() instanceof PsiWhiteSpace ? aSTNode2.getTreePrev() : null;
        }
        aSTNode2 = aSTNode.getTreeNext();
        ASTNode aSTNode3 = aSTNode;
        while (aSTNode2 != null) {
            if (aSTNode2.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT) {
                if (PythonFoldingBuilder.isCustomRegionElement((PsiElement)aSTNode2.getPsi())) break;
                aSTNode3 = aSTNode2;
                aSTNode2 = aSTNode2.getTreeNext();
                continue;
            }
            aSTNode2 = aSTNode2.getPsi() instanceof PsiWhiteSpace ? aSTNode2.getTreeNext() : null;
        }
        if (aSTNode3 != aSTNode) {
            list2.add(new FoldingDescriptor(aSTNode, TextRange.create((int)aSTNode.getStartOffset(), (int)aSTNode3.getTextRange().getEndOffset())));
        }
    }

    private static void b(ASTNode aSTNode, List<FoldingDescriptor> list2) {
        if (StringUtil.countNewLines((CharSequence)aSTNode.getChars()) > 0) {
            TextRange textRange = aSTNode.getTextRange();
            int n2 = aSTNode.getElementType() == PyElementTypes.TUPLE_EXPRESSION ? 0 : 1;
            list2.add(new FoldingDescriptor(aSTNode, TextRange.create((int)(textRange.getStartOffset() + n2), (int)(textRange.getEndOffset() - n2))));
        }
    }

    private static void d(ASTNode aSTNode, List<FoldingDescriptor> list2) {
        TextRange textRange = aSTNode.getTextRange();
        if (textRange.isEmpty()) {
            return;
        }
        IElementType iElementType = aSTNode.getTreeParent().getElementType();
        if (iElementType == PyElementTypes.FUNCTION_DECLARATION || iElementType == PyElementTypes.CLASS_DECLARATION || PythonFoldingBuilder.a(aSTNode, iElementType)) {
            ASTNode aSTNode2 = aSTNode.getTreeParent().findChildByType((IElementType)PyTokenTypes.COLON);
            int n2 = textRange.getEndOffset();
            if (aSTNode2 != null && n2 - (aSTNode2.getStartOffset() + 1) > 1) {
                int n3;
                CharSequence charSequence = aSTNode.getChars();
                int n4 = textRange.getStartOffset();
                int n5 = aSTNode2.getStartOffset() + 1;
                for (n3 = n2; n3 > Math.max(n4, n5 + 1) && Character.isWhitespace(charSequence.charAt(n3 - n4 - 1)); --n3) {
                }
                list2.add(new FoldingDescriptor(aSTNode, new TextRange(n5, n3)));
            } else if (textRange.getLength() > 1) {
                list2.add(new FoldingDescriptor(aSTNode, textRange));
            }
        }
    }

    private static boolean a(ASTNode aSTNode, IElementType iElementType) {
        if (!PyElementTypes.PARTS.contains(iElementType) && iElementType != PyElementTypes.WITH_STATEMENT) {
            return false;
        }
        PsiElement psiElement = aSTNode.getPsi();
        if (psiElement instanceof PyStatementList) {
            return StringUtil.countNewLines((CharSequence)psiElement.getText()) > 0;
        }
        return false;
    }

    private static void a(ASTNode aSTNode, List<FoldingDescriptor> list2) {
        boolean bl2;
        boolean bl3 = PythonFoldingBuilder.a(aSTNode) != null && StringUtil.countNewLines((CharSequence)aSTNode.getChars()) > 1;
        boolean bl4 = bl2 = PythonFoldingBuilder.a(aSTNode) == null && StringUtil.countNewLines((CharSequence)aSTNode.getChars()) > 0;
        if (bl3 || bl2) {
            list2.add(new FoldingDescriptor(aSTNode, aSTNode.getTextRange()));
        }
    }

    @Nullable
    private static IElementType a(ASTNode aSTNode) {
        ASTNode aSTNode2 = aSTNode.getTreeParent();
        IElementType iElementType = aSTNode2.getElementType();
        if (iElementType == PyElementTypes.EXPRESSION_STATEMENT && aSTNode2.getTreeParent() != null) {
            ASTNode aSTNode3 = aSTNode2.getTreeParent();
            if (aSTNode3.getElementType() == PyElementTypes.STATEMENT_LIST && aSTNode3.getTreeParent() != null && aSTNode2 == aSTNode3.getFirstChildNode()) {
                ASTNode aSTNode4 = aSTNode3.getTreeParent();
                if (aSTNode4.getElementType() == PyElementTypes.FUNCTION_DECLARATION || aSTNode4.getElementType() == PyElementTypes.CLASS_DECLARATION) {
                    return aSTNode4.getElementType();
                }
            } else if (aSTNode3.getElementType() instanceof PyFileElementType) {
                return aSTNode3.getElementType();
            }
        }
        return null;
    }

    protected String getLanguagePlaceholderText(@NotNull ASTNode node, @NotNull TextRange range) {
        long l2 = a ^ 0x726D46F6853L;
        if (node == null) {
            PythonFoldingBuilder.a(3);
        }
        if (range == null) {
            PythonFoldingBuilder.a(4);
        }
        if (PythonFoldingBuilder.b(node)) {
            return "import ...";
        }
        if (node.getElementType() == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            PyStringLiteralExpression pyStringLiteralExpression = (PyStringLiteralExpression)node.getPsi();
            if (pyStringLiteralExpression.isDocString()) {
                String string = pyStringLiteralExpression.getStringValue().trim();
                String[] stringArray = LineTokenizer.tokenize((CharSequence)string, (boolean)true);
                if (stringArray.length > 2 && stringArray[1].trim().length() == 0) {
                    return "\"\"\"" + stringArray[0].trim() + "...\"\"\"";
                }
                return "\"\"\"...\"\"\"";
            }
            return PythonFoldingBuilder.a(pyStringLiteralExpression);
        }
        return "...";
    }

    private static String a(PyStringLiteralExpression pyStringLiteralExpression) {
        long l2 = a ^ 0x7BAFE9A23802L;
        String string = pyStringLiteralExpression.getText();
        Pair<String, String> pair = PyStringLiteralUtil.getQuotes(string);
        if (pair != null) {
            return (String)pair.second + "..." + (String)pair.second;
        }
        return "...";
    }

    protected boolean isRegionCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            PythonFoldingBuilder.a(5);
        }
        if (PythonFoldingBuilder.b(node)) {
            return CodeFoldingSettings.getInstance().COLLAPSE_IMPORTS;
        }
        if (node.getElementType() == PyElementTypes.STRING_LITERAL_EXPRESSION) {
            if (PythonFoldingBuilder.a(node) == PyElementTypes.FUNCTION_DECLARATION && CodeFoldingSettings.getInstance().COLLAPSE_METHODS) {
                return false;
            }
            if (PythonFoldingBuilder.a(node) != null) {
                return CodeFoldingSettings.getInstance().COLLAPSE_DOC_COMMENTS;
            }
            return PythonFoldingSettings.getInstance().isCollapseLongStrings();
        }
        if (node.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT) {
            return PythonFoldingSettings.getInstance().isCollapseSequentialComments();
        }
        if (node.getElementType() == PyElementTypes.STATEMENT_LIST && node.getTreeParent().getElementType() == PyElementTypes.FUNCTION_DECLARATION) {
            return CodeFoldingSettings.getInstance().COLLAPSE_METHODS;
        }
        if (FOLDABLE_COLLECTIONS_LITERALS.contains(node.getElementType())) {
            return PythonFoldingSettings.getInstance().isCollapseLongCollections();
        }
        return false;
    }

    protected boolean isCustomFoldingCandidate(@NotNull ASTNode node) {
        if (node == null) {
            PythonFoldingBuilder.a(6);
        }
        return node.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT;
    }

    protected boolean isCustomFoldingRoot(@NotNull ASTNode node) {
        if (node == null) {
            PythonFoldingBuilder.a(7);
        }
        return node.getPsi() instanceof PyFile || node.getElementType() == PyElementTypes.STATEMENT_LIST;
    }

    private static boolean b(@NotNull ASTNode aSTNode) {
        if (aSTNode == null) {
            PythonFoldingBuilder.a(8);
        }
        return PyElementTypes.IMPORT_STATEMENTS.contains(aSTNode.getElementType());
    }

    static {
        a = c.a(-5828268200643336238L, 5890166845634034624L, MethodHandles.lookup().lookupClass()).a(147909755960963L);
        FOLDABLE_COLLECTIONS_LITERALS = TokenSet.create((IElementType[])new IElementType[]{PyElementTypes.SET_LITERAL_EXPRESSION, PyElementTypes.DICT_LITERAL_EXPRESSION, PyElementTypes.GENERATOR_EXPRESSION, PyElementTypes.SET_COMP_EXPRESSION, PyElementTypes.DICT_COMP_EXPRESSION, PyElementTypes.LIST_LITERAL_EXPRESSION, PyElementTypes.LIST_COMP_EXPRESSION, PyElementTypes.TUPLE_EXPRESSION});
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x1DB9030AC255L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/PythonFoldingBuilder";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "buildLanguageFoldRegions";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getLanguagePlaceholderText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isRegionCollapsedByDefault";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingCandidate";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomFoldingRoot";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

