/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python;

import com.intellij.lang.ASTNode;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.TokenSeparatorGenerator;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.lexer.PythonIndentingLexer;
import com.jetbrains.python.psi.PyStatement;
import com.jetbrains.python.psi.impl.PyPsiUtils;

public class PyTokenSeparatorGenerator
implements TokenSeparatorGenerator {
    public ASTNode generateWhitespaceBetweenTokens(ASTNode left, ASTNode right) {
        Object object;
        Object object2;
        PsiManager psiManager = right.getTreeParent().getPsi().getManager();
        if (left.getElementType() == PyTokenTypes.END_OF_LINE_COMMENT) {
            return PyTokenSeparatorGenerator.a(psiManager);
        }
        if (left.getPsi().isValid() && right.getPsi().isValid()) {
            object2 = PsiTreeUtil.findCommonParent((PsiElement)left.getPsi(), (PsiElement)right.getPsi());
            if (object2 == null) {
                return null;
            }
            object = PsiTreeUtil.findPrevParent((PsiElement)object2, (PsiElement)left.getPsi());
            PsiElement psiElement = PsiTreeUtil.findPrevParent((PsiElement)object2, (PsiElement)right.getPsi());
            if (PyTokenSeparatorGenerator.a(object) && PyTokenSeparatorGenerator.a(psiElement)) {
                int n2 = PyPsiUtils.getElementIndentation(object);
                int n3 = PyPsiUtils.getElementIndentation(psiElement);
                int n4 = Math.max(n2, n3);
                return PyTokenSeparatorGenerator.a(psiManager, "\n" + StringUtil.repeatSymbol((char)' ', (int)n4));
            }
        }
        if (right.getElementType() == PyTokenTypes.DEF_KEYWORD || right.getElementType() == PyTokenTypes.CLASS_KEYWORD) {
            return PyTokenSeparatorGenerator.a(psiManager);
        }
        if (left.getElementType() == TokenType.WHITE_SPACE || right.getElementType() == TokenType.WHITE_SPACE) {
            return null;
        }
        object2 = (PyStatement)PsiTreeUtil.getParentOfType((PsiElement)left.getPsi(), PyStatement.class);
        if (object2 != null && !PsiTreeUtil.isAncestor((PsiElement)object2, (PsiElement)right.getPsi(), (boolean)false)) {
            return PyTokenSeparatorGenerator.a(psiManager);
        }
        object = new PythonIndentingLexer();
        if (LanguageUtil.canStickTokensTogetherByLexer((ASTNode)left, (ASTNode)right, (Lexer)object) == ParserDefinition.SpaceRequirements.MUST) {
            return PyTokenSeparatorGenerator.b(psiManager);
        }
        return null;
    }

    private static boolean a(PsiElement psiElement) {
        return psiElement instanceof PyStatement;
    }

    private static ASTNode b(PsiManager psiManager) {
        return PyTokenSeparatorGenerator.a(psiManager, " ");
    }

    private static ASTNode a(PsiManager psiManager) {
        return PyTokenSeparatorGenerator.a(psiManager, "\n");
    }

    private static ASTNode a(PsiManager psiManager, String string) {
        return Factory.createSingleLeafElement((IElementType)TokenType.WHITE_SPACE, (CharSequence)string, (int)0, (int)string.length(), null, (PsiManager)psiManager);
    }
}

