/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.ui;

import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.ui.DjangoTemplateFileFactory;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.ui.IdeaDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class CreateTemplateDialog
extends IdeaDialog {
    private JCheckBox e;
    private JTextField k;
    private final DjangoTemplateFileFactory i;
    private final PsiElement d;
    private List<VirtualFile> h;
    private final Project b;
    private boolean f;
    private JPanel c;
    private JComboBox j;
    private TextFieldWithBrowseButton a;
    private JLabel l;
    private JLabel g;
    private static final long m = com.jetbrains.python.psi.c.a(-9172828228543154537L, 4209184029873460638L, MethodHandles.lookup().lookupClass()).a(223140556711689L);

    public static DjangoTemplateFileFactory createTemplateFileFactory() {
        return DjangoTemplateFileFactory.acceptsRelativePath();
    }

    public CreateTemplateDialog(Project project, PsiElement element) {
        long l2 = m ^ 0xC2101F93229L;
        super(project);
        this.c();
        this.i = CreateTemplateDialog.createTemplateFileFactory();
        this.b = project;
        this.d = element;
        this.setTitle("Create Template");
        this.b();
        if (this.h.isEmpty()) {
            FileChooserDescriptor fileChooserDescriptor = new FileChooserDescriptor(false, true, false, false, false, false);
            this.a.addActionListener((ActionListener)new ComponentWithBrowseButton.BrowseFolderActionListener(DjangoBundle.message("select-template-folder", new Object[0]), DjangoBundle.message("select-template-folder-text", new Object[0]), (ComponentWithBrowseButton)this.a, null, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT));
            this.a.setTextFieldPreferredWidth(50);
            this.g.setVisible(false);
            this.j.setVisible(false);
        } else {
            this.l.setVisible(false);
            this.a.setVisible(false);
        }
        this.e.setSelected(true);
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CreateTemplateDialog.this.a(CreateTemplateDialog.this.e.isSelected());
            }
        });
        this.addUpdater(this.k);
        this.addUpdater(this.e);
        this.addUpdater(this.a.getTextField());
        this.init();
        this.initValidation();
    }

    public void setTemplateNameEditable(boolean isEditable) {
        this.f = isEditable;
        this.k.setEditable(isEditable);
    }

    private void b() {
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.d);
        this.h = module2 != null ? DjangoTemplateManager.getInstance(module2).getTemplatesFolderList(true, this.d, true) : Lists.newArrayList();
        if (!this.h.isEmpty()) {
            int n2 = ((VirtualFile)new Ordering<VirtualFile>(){

                public int compare(@Nullable VirtualFile left, @Nullable VirtualFile right) {
                    Integer n2 = (left != null ? left.getPath() : "").length();
                    int n3 = (right != null ? right.getPath() : "").length();
                    return n2.compareTo(n3);
                }
            }.max(this.h)).getPath().length();
            Dimension dimension = GuiUtils.getSizeByChars((int)n2, (JComponent)this.j);
            this.j.setPreferredSize(new Dimension(dimension.width + 10, dimension.height));
        }
    }

    public void setShowCreateTemplateCheckBox(boolean showCreateTemplateCheckBox) {
        this.e.setVisible(showCreateTemplateCheckBox);
    }

    protected JComponent createCenterPanel() {
        return this.c;
    }

    public List<VirtualFile> getTemplateFolderList() {
        return this.h;
    }

    private void a(boolean bl2) {
        if (!this.f) {
            this.k.setEnabled(bl2);
        }
        this.a.setEnabled(bl2);
        this.j.setEnabled(bl2);
    }

    public void setTemplateName(String name) {
        this.k.setText(FileUtil.toSystemDependentName((String)name));
    }

    @Nullable
    public String getTemplateName() {
        return this.e.isSelected() ? this.k.getText() : null;
    }

    public boolean isCreateTemplate() {
        return this.e.isSelected();
    }

    public VirtualFile getSelectedTemplateRoot() {
        if (this.h.isEmpty()) {
            return VirtualFileUtil.findFile(this.a.getText());
        }
        return this.h.get(this.j.getSelectedIndex());
    }

    public void show() {
        long l2 = m ^ 0x7A04AEFD6E7AL;
        ArrayList arrayList = Lists.newArrayList();
        for (Object object : this.h) {
            arrayList.add(FileUtil.toSystemDependentName((String)object.getPath()));
        }
        for (Object object : arrayList) {
            this.j.addItem(object);
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Shouldn't be shown under write action as it uses file chooser");
        }
        super.show();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.k;
    }

    protected ValidationInfo doValidate() {
        long l2 = m ^ 0x5064575B5B67L;
        if (this.e.isSelected()) {
            if (!this.i.isValid(this.k.getText())) {
                return new ValidationInfo("Template name is not valid", (JComponent)this.k);
            }
            if (this.h.isEmpty()) {
                if (StringUtil.isEmpty((String)this.a.getText())) {
                    return new ValidationInfo("Templates root is not specified", (JComponent)this.a);
                }
                if (!new File(this.a.getText()).exists()) {
                    return new ValidationInfo("Templates root folder doesn't exists", (JComponent)this.a);
                }
            } else if (this.j.getSelectedIndex() < 0 || this.j.getSelectedIndex() >= this.h.size()) {
                return new ValidationInfo("Template root selection is invalid");
            }
            String string = this.getTemplateName();
            if (this.a(this.getTemplatesFolder(), string)) {
                return new ValidationInfo("Template " + string + " already exists", (JComponent)this.k);
            }
        }
        return super.doValidate();
    }

    private boolean a(PsiDirectory psiDirectory, String string) {
        if (psiDirectory != null && string != null) {
            return this.i.exists(psiDirectory, string);
        }
        return false;
    }

    public DjangoTemplateFileFactory getTemplateFileFactory() {
        return this.i;
    }

    public PsiDirectory getTemplatesFolder() {
        VirtualFile virtualFile = this.getSelectedTemplateRoot();
        if (virtualFile != null) {
            return PsiManager.getInstance((Project)this.b).findDirectory(virtualFile);
        }
        return null;
    }

    private /* synthetic */ void c() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JLabel jLabel;
        JLabel jLabel2;
        JTextField jTextField;
        JPanel jPanel;
        long l2 = m ^ 0x121CD56EB6A4L;
        this.c = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel3 = new JLabel();
        this.a(jLabel3, ResourceBundle.getBundle("com/jetbrains/django/ui/Django").getString("template.path"));
        jPanel.add((Component)jLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.k = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.g = jLabel2 = new JLabel();
        this.a(jLabel2, ResourceBundle.getBundle("com/jetbrains/django/ui/Django").getString("templates.root"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JBCheckBox jBCheckBox = new JBCheckBox();
        this.e = jBCheckBox;
        jBCheckBox.setText("Create template");
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        ComboBox comboBox = new ComboBox();
        this.j = comboBox;
        jPanel.add((Component)comboBox, new GridConstraints(2, 1, 1, 2, 0, 1, 2, 0, null, null, null));
        this.l = jLabel = new JLabel();
        this.a(jLabel, ResourceBundle.getBundle("com/jetbrains/django/ui/Django").getString("templates.root"));
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.a = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 1, 1, 2, 0, 1, 6, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.c;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c10 = '\u0000';
        int n2 = -1;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) == '&') {
                if (++i10 == string.length()) break;
                if (!bl2 && string.charAt(i10) != '&') {
                    bl2 = true;
                    c10 = string.charAt(i10);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i10));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c10);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }
}

