/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model.stubs.manager;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.io.StringRef;
import com.jetbrains.django.codeInsight.DjangoTypeProvider;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.stubs.manager.DjangoManagerIndex;
import com.jetbrains.django.model.stubs.manager.DjangoManagerStub;
import com.jetbrains.django.model.stubs.manager.a;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.stubs.CustomTargetExpressionStubType;
import com.jetbrains.python.psi.stubs.PyTargetExpressionStub;
import java.io.IOException;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public final class DjangoManagerStubType
extends CustomTargetExpressionStubType<DjangoManagerStub> {
    private static final Collection<String> a = Collections2.transform(DjangoTypeProvider.FIELD_INSTANCE_TYPES.keySet(), (Function)new MyFieldShortNamesObtainer(null));

    @Override
    @Nullable
    public DjangoManagerStub createStub(PyTargetExpression psi) {
        if (!DjangoFacet.isInProject(psi)) {
            return null;
        }
        PyClass pyClass = psi.getContainingClass();
        if (pyClass == null) {
            return null;
        }
        boolean bl2 = false;
        String string = null;
        for (PyTargetExpression pyTargetExpression : pyClass.getClassAttributes()) {
            PyExpression pyExpression;
            PyCallExpression pyCallExpression = PyUtil.as(pyTargetExpression.findAssignedValue(), PyCallExpression.class);
            if (pyCallExpression == null || (pyExpression = pyCallExpression.getCallee()) == null) continue;
            if (a.contains(pyExpression.getName())) {
                if (pyTargetExpression.equals(psi)) {
                    return null;
                }
                bl2 = true;
                continue;
            }
            if (!pyTargetExpression.equals(psi)) continue;
            string = pyExpression.getName();
        }
        if (!bl2 || string == null) {
            return null;
        }
        return new DjangoManagerStub(StringRef.fromString(string));
    }

    @Override
    @Nullable
    public DjangoManagerStub deserializeStub(StubInputStream stream2) throws IOException {
        return new DjangoManagerStub(stream2.readName());
    }

    @Override
    public void indexStub(PyTargetExpressionStub stub, IndexSink sink) {
        DjangoManagerStub djangoManagerStub = stub.getCustomStub(DjangoManagerStub.class);
        if (djangoManagerStub != null) {
            sink.occurrence(DjangoManagerIndex.KEY, (Object)djangoManagerStub.getManagerNameRef().getString());
        }
    }

    private static class MyFieldShortNamesObtainer
    implements Function<String, String> {
        private MyFieldShortNamesObtainer() {
        }

        public String apply(String input) {
            return QualifiedName.fromDottedString((String)input).getLastComponent();
        }

        /* synthetic */ MyFieldShortNamesObtainer(a x0) {
            this();
        }
    }
}

