/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleServiceManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.StubVirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileSystemEntry;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiCacheKey;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.model.TemplateParametersEvaluator;
import com.jetbrains.django.model.a;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.NoDjangoModuleException;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoAppTemplateLoader;
import com.jetbrains.django.model.modelApi.templateLoaders.DjangoFileSystemTemplateLoader;
import com.jetbrains.django.model.viewManagemenet.ViewManagementFacade;
import com.jetbrains.django.util.DjangoStringUtil;
import com.jetbrains.django.util.DjangoUtil;
import com.jetbrains.django.util.PythonDataflowUtil;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyKeywordArgument;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyPathEvaluator;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplateManager {
    private static final PsiCacheKey<Boolean, PyStringLiteralExpression> c;
    @NotNull
    private final PsiCacheKey<Collection<? extends NavigatablePsiElement>, PyFunction> b;
    @NotNull
    private final Module a;
    private static final long d;

    public DjangoTemplateManager(@NotNull Module module2) {
        long l2 = d ^ 0x5D4009F7663CL;
        if (module2 == null) {
            DjangoTemplateManager.a(0);
        }
        this.b = PsiCacheKey.create((String)(DjangoTemplateManager.class.getName() + "tempRef"), (Function)new TemplateReferencesObtainer(null), (Key)PsiModificationTracker.MODIFICATION_COUNT);
        this.a = module2;
    }

    @NotNull
    public List<PsiFile> getAllTemplates() {
        PsiManager psiManager = PsiManager.getInstance((Project)this.a.getProject());
        ArrayList<PsiFile> arrayList = new ArrayList<PsiFile>();
        for (VirtualFile virtualFile : this.getTemplatesFolderList(false, null, false)) {
            List list2 = VfsUtil.collectChildrenRecursively((VirtualFile)virtualFile);
            for (VirtualFile virtualFile2 : list2) {
                PsiFile psiFile = psiManager.findFile(virtualFile2);
                if (psiFile == null) continue;
                arrayList.add(psiFile);
            }
        }
        ArrayList<PsiFile> arrayList2 = arrayList;
        if (arrayList2 == null) {
            DjangoTemplateManager.a(1);
        }
        return arrayList2;
    }

    @Nullable
    public PsiFile getTemplate(@NotNull String name) {
        if (name == null) {
            DjangoTemplateManager.a(2);
        }
        List<VirtualFile> list2 = this.getTemplatesFolderList(false, null, false);
        for (VirtualFile virtualFile : list2) {
            VirtualFile virtualFile2 = virtualFile.findFileByRelativePath(name);
            if (virtualFile2 == null) continue;
            return PsiManager.getInstance((Project)this.a.getProject()).findFile(virtualFile2);
        }
        return null;
    }

    @NotNull
    public final List<VirtualFile> getTemplatesFolderList(boolean inProjectRootOnly, @Nullable PsiElement anchorToSort, boolean removeReadOnly) {
        DjangoFacet djangoFacet;
        Object object;
        ArrayList arrayList;
        block9: {
            arrayList = Lists.newArrayList();
            object = new DjangoModelApi(this.a);
            djangoFacet = DjangoFacet.getInstance(this.a);
            if (djangoFacet != null) break block9;
            List<VirtualFile> list2 = Collections.emptyList();
            if (list2 == null) {
                DjangoTemplateManager.a(3);
            }
            return list2;
        }
        try {
            VirtualFile virtualFile2;
            arrayList.addAll(((DjangoModelApi)object).getTemplateFolders());
            if (inProjectRootOnly && (virtualFile2 = ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootFolderFile()) != null) {
                DjangoTemplateManager.a(arrayList, virtualFile2);
            }
        }
        catch (NoDjangoModuleException noDjangoModuleException) {
            // empty catch block
        }
        object = this.getConfigurationTemplatesFolders().iterator();
        while (object.hasNext()) {
            djangoFacet = (VirtualFile)object.next();
            arrayList.add(Pair.create((Object)djangoFacet, null));
        }
        if (anchorToSort != null && (object = anchorToSort.getContainingFile()) != null) {
            Collections.sort(arrayList, new TemplateFolderComparator(object.getVirtualFile()));
        }
        object = ContainerUtil.filter((Collection)Lists.transform((List)arrayList, pair -> (VirtualFile)pair.first), virtualFile -> virtualFile != null);
        if (removeReadOnly) {
            djangoFacet = ProjectFileIndex.getInstance((Project)this.a.getProject());
            object.removeIf(arg_0 -> DjangoTemplateManager.a((ProjectFileIndex)djangoFacet, arg_0));
        }
        ContainerUtil.removeDuplicates((Collection)object);
        Object object2 = object;
        if (object2 == null) {
            DjangoTemplateManager.a(4);
        }
        return object2;
    }

    public final boolean isStaticFilesDirUnresolved() {
        CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)this.a.getProject());
        return (Boolean)cachedValuesManager.getCachedValue((UserDataHolder)this.a, () -> new CachedValueProvider.Result((Object)this.getStaticfilesDirs(true).contains(null), new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    private static void a(@NotNull Collection<Pair<VirtualFile, Class<?>>> collection, @NotNull VirtualFile virtualFile) {
        if (collection == null) {
            DjangoTemplateManager.a(5);
        }
        if (virtualFile == null) {
            DjangoTemplateManager.a(6);
        }
        Iterator<Pair<VirtualFile, Class<?>>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile2 = (VirtualFile)iterator.next().first;
            if (VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)true)) continue;
            iterator.remove();
        }
    }

    @NotNull
    public List<VirtualFile> getStaticFolderList() {
        ArrayList arrayList = Lists.newArrayList();
        arrayList.addAll(this.getStaticfilesDirs(false));
        VirtualFile virtualFile = this.getStaticRoot();
        if (virtualFile != null) {
            arrayList.add(virtualFile);
        }
        arrayList.addAll(this.getAppStaticFolders());
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            DjangoTemplateManager.a(7);
        }
        return arrayList2;
    }

    @NotNull
    public List<VirtualFile> getMediaFolderList() {
        ArrayList arrayList = Lists.newArrayList();
        VirtualFile virtualFile = this.getMediaRoot();
        if (virtualFile != null) {
            arrayList.add(virtualFile);
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            DjangoTemplateManager.a(8);
        }
        return arrayList2;
    }

    @NotNull
    public List<VirtualFile> getConfigurationTemplatesFolders() {
        List<VirtualFile> list2 = TemplatesService.getInstance(this.a).getTemplateFolders();
        if (list2 == null) {
            DjangoTemplateManager.a(9);
        }
        return list2;
    }

    public Collection<VirtualFile> getStaticfilesDirs(boolean unresolvedAsNulls) {
        ArrayList arrayList = Lists.newArrayList();
        for (PyExpression pyExpression : DjangoSettingsPy.getStaticfilesDirs(this.a)) {
            Object object;
            Object object2;
            List<PyExpression> list2;
            if (pyExpression instanceof PyParenthesizedExpression) {
                list2 = PyUtil.flattenedParensAndTuples(pyExpression);
                if (list2.size() == 2 && list2.get(0) instanceof PyStringLiteralExpression) {
                    object2 = DjangoStringUtil.getStringValue((PsiElement)list2.get(0));
                    object = this.resolveVirtualFile(PyPathEvaluator.evaluatePath((PyExpression)list2.get(1)), (PsiElement)pyExpression);
                    if (object instanceof VirtualFileSystemEntry) {
                        object = new PrefixedVirtualDirectory((VirtualFileSystemEntry)object, (String)object2, (PyStringLiteralExpression)list2.get(0));
                    }
                } else {
                    object = null;
                }
            } else {
                VirtualFile virtualFile;
                VirtualFile virtualFile2;
                list2 = PyPathEvaluator.evaluatePath(pyExpression);
                object2 = DjangoFacet.getInstance(this.a);
                if (object2 != null && list2 != null && (virtualFile2 = ((DjangoFacetConfiguration)object2.getConfiguration()).getProjectRootFolderFile()) != null && (virtualFile = virtualFile2.findFileByRelativePath((String)((Object)list2))) != null) {
                    arrayList.add(virtualFile);
                }
                object = this.resolveVirtualFile((String)((Object)list2), (PsiElement)pyExpression);
            }
            if (!unresolvedAsNulls && object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    @Nullable
    public VirtualFile getStaticRoot() {
        return this.resolveVirtualFile(DjangoSettingsPy.getStaticRoot(this.a), (PsiElement)DjangoSettingsPy.findSettingsFile(this.a));
    }

    @Nullable
    public VirtualFile getMediaRoot() {
        return this.resolveVirtualFile(DjangoSettingsPy.getMediaRoot(this.a), (PsiElement)DjangoSettingsPy.findSettingsFile(this.a));
    }

    @Nullable
    public String getMediaUrl() {
        return DjangoSettingsPy.getMediaUrl(this.a);
    }

    @Nullable
    public VirtualFile resolveVirtualFile(String dir, PsiElement element) {
        LocalFileSystem localFileSystem;
        if (StringUtil.isEmpty((String)dir)) {
            return null;
        }
        try {
            localFileSystem = element.getContainingFile().getVirtualFile().getFileSystem();
        }
        catch (Exception exception) {
            localFileSystem = LocalFileSystem.getInstance();
        }
        VirtualFile virtualFile = localFileSystem.findFileByPath(dir);
        if (virtualFile == null) {
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
            arrayList.add(this.a.getProject().getBaseDir());
            PyFile pyFile = DjangoSettingsPy.getSettingsFile(this.a);
            if (!StringUtil.isEmpty((String)dir) && pyFile != null && pyFile.getVirtualFile() != null) {
                arrayList.add(pyFile.getVirtualFile().getParent());
            }
            for (VirtualFile virtualFile2 : arrayList) {
                VirtualFile virtualFile3 = virtualFile2.findFileByRelativePath(dir);
                if (virtualFile3 == null) continue;
                return virtualFile3;
            }
        }
        return virtualFile;
    }

    public static DjangoTemplateManager getInstance(@NotNull Module module2) {
        if (module2 == null) {
            DjangoTemplateManager.a(10);
        }
        return (DjangoTemplateManager)ModuleServiceManager.getService((Module)module2, DjangoTemplateManager.class);
    }

    @NotNull
    public static Collection<? extends NavigatablePsiElement> getTemplateReferences(@NotNull PyFunction func) {
        Module module2;
        if (func == null) {
            DjangoTemplateManager.a(11);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)func)) == null) {
            List list2 = Collections.emptyList();
            if (list2 == null) {
                DjangoTemplateManager.a(12);
            }
            return list2;
        }
        Collection collection = (Collection)DjangoTemplateManager.getInstance((Module)module2).b.getValue((PsiElement)func);
        if (collection == null) {
            DjangoTemplateManager.a(13);
        }
        return collection;
    }

    public static boolean isTemplateReference(PyStringLiteralExpression strLiteral) {
        String string = strLiteral.getStringValue();
        return DjangoUtil.hasDjangoTemplateExtension(string) && DjangoTemplateManager.isTemplateReferenceExpected(strLiteral);
    }

    public static boolean isTemplateReferenceExpected(PyStringLiteralExpression strLiteral) {
        return (Boolean)c.getValue((PsiElement)strLiteral);
    }

    private Set<NavigatablePsiElement> a(@Nullable String string, @Nullable Class<?> clazz, @NotNull TypeEvalContext typeEvalContext) {
        if (typeEvalContext == null) {
            DjangoTemplateManager.a(14);
        }
        if (string == null) {
            return Collections.emptySet();
        }
        HashSet hashSet = Sets.newHashSet();
        Set<PyFile> set = this.a(typeEvalContext);
        ViewManagementFacade viewManagementFacade = new ViewManagementFacade(this.a);
        for (PyFile pyFile : set) {
            hashSet.addAll(viewManagementFacade.getTemplateReferences(pyFile, string, clazz, typeEvalContext).get((Object)string));
            if (clazz == null || hashSet.isEmpty()) continue;
            return hashSet;
        }
        return hashSet;
    }

    private Set<PyFile> a(@NotNull TypeEvalContext typeEvalContext) {
        DjangoModelApi djangoModelApi;
        long l2 = d ^ 0x53C6AB3DD709L;
        if (typeEvalContext == null) {
            DjangoTemplateManager.a(15);
        }
        if ((djangoModelApi = DjangoModelApi.create(this.a)) == null) {
            return Collections.emptySet();
        }
        HashSet hashSet = Sets.newHashSet();
        for (DjangoApplicationModel djangoApplicationModel : djangoModelApi.getApplications()) {
            PsiDirectory psiDirectory = djangoApplicationModel.getApplicationRootFolder();
            PyFile pyFile = PyUtil.as(psiDirectory.findFile("views.py"), PyFile.class);
            if (pyFile != null) {
                hashSet.add(pyFile);
                continue;
            }
            PsiDirectory psiDirectory2 = psiDirectory.findSubdirectory("views");
            if (psiDirectory2 == null) continue;
            for (PsiFile psiFile : psiDirectory2.getFiles()) {
                if (!(psiFile instanceof PyFile)) continue;
                hashSet.add((PyFile)psiFile);
            }
        }
        djangoModelApi.collectAllUrlsFromCache(hashSet);
        return hashSet;
    }

    public static Set<NavigatablePsiElement> getTemplateReferences(@NotNull PsiFile template, @Nullable Class<?> stopAtFirstClass, @NotNull TypeEvalContext context) {
        Module module2;
        if (template == null) {
            DjangoTemplateManager.a(16);
        }
        if (context == null) {
            DjangoTemplateManager.a(17);
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)template)) == null) {
            return Collections.emptySet();
        }
        String string = DjangoTemplateManager.getRelativeName(module2, template);
        if (string != null) {
            return DjangoTemplateManager.getInstance(module2).a(string, stopAtFirstClass, context);
        }
        return Collections.emptySet();
    }

    @Nullable
    public static String getRelativeName(@NotNull Module module2, @NotNull PsiFile template) {
        List<VirtualFile> list2;
        VirtualFile virtualFile;
        if (module2 == null) {
            DjangoTemplateManager.a(18);
        }
        if (template == null) {
            DjangoTemplateManager.a(19);
        }
        if ((virtualFile = DjangoTemplateManager.a(list2 = DjangoTemplateManager.getInstance(module2).getTemplatesFolderList(false, null, false), template)) != null) {
            return VirtualFileUtil.getRelativePath(virtualFile, template.getVirtualFile());
        }
        VirtualFile virtualFile2 = template.getVirtualFile();
        if (virtualFile2 != null) {
            return virtualFile2.getPath();
        }
        return null;
    }

    @Nullable
    private static VirtualFile a(List<VirtualFile> list2, PsiFile psiFile) {
        int n2 = -1;
        VirtualFile virtualFile = null;
        VirtualFile virtualFile2 = psiFile.getVirtualFile();
        assert (virtualFile2 != null);
        for (VirtualFile virtualFile3 : list2) {
            String string = virtualFile3.getPath();
            if (!string.endsWith("/")) {
                string = string + "/";
            }
            if (!virtualFile2.getPath().startsWith(string) || string.length() <= n2) continue;
            n2 = string.length();
            virtualFile = virtualFile3;
        }
        return virtualFile;
    }

    @NotNull
    public List<VirtualFile> getAppStaticFolders() {
        long l2 = d ^ 0x4E6EA58FB0D3L;
        List<VirtualFile> list2 = this.a("static");
        if (list2 == null) {
            DjangoTemplateManager.a(20);
        }
        return list2;
    }

    @NotNull
    private List<VirtualFile> a(@NotNull String string) {
        List<VirtualFile> list2;
        if (string == null) {
            DjangoTemplateManager.a(21);
        }
        try {
            list2 = DjangoApplicationModel.getFoldersUnderEachApp(string, new DjangoModelApi(this.a));
        }
        catch (NoDjangoModuleException noDjangoModuleException) {
            List<VirtualFile> list3 = Collections.emptyList();
            if (list3 == null) {
                DjangoTemplateManager.a(23);
            }
            return list3;
        }
        if (list2 == null) {
            DjangoTemplateManager.a(22);
        }
        return list2;
    }

    private static /* synthetic */ boolean a(ProjectFileIndex projectFileIndex, VirtualFile virtualFile) {
        return projectFileIndex.isExcluded(virtualFile) || projectFileIndex.isInLibrary(virtualFile);
    }

    static {
        d = com.jetbrains.python.psi.c.a(5425743484948940423L, -1272805208246552250L, MethodHandles.lookup().lookupClass()).a(53320293640575L);
        long l2 = d ^ 0x4D1D0563FF7CL;
        c = PsiCacheKey.create((String)(DjangoTemplateManager.class.getName() + "tempRefExpected"), (Function)new TemplateReferenceExpectedChecker(null), (Key)PsiModificationTracker.MODIFICATION_COUNT);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = d ^ 0x79ADC65B0A78L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 20: 
            case 22: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 20: 
            case 22: 
            case 23: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 20: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/DjangoTemplateManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderList";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoot";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "func";
                break;
            }
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "template";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "folderName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/DjangoTemplateManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllTemplates";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplatesFolderList";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStaticFolderList";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getMediaFolderList";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationTemplatesFolders";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTemplateReferences";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppStaticFolders";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppFolders";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 20: 
            case 22: 
            case 23: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getTemplate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeFoldersOutsideOfProjectRoot";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 11: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateReferences";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getViewToTemplateReferences";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFilesWithTemplateReferences";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeName";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getAppFolders";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 12: 
            case 13: 
            case 20: 
            case 22: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class TemplateFolderComparator
    implements Comparator<Pair<VirtualFile, Class<?>>> {
        @NotNull
        private static final List<Class<?>> a;
        @NotNull
        private final VirtualFile b;
        private static final long c;

        TemplateFolderComparator(@NotNull VirtualFile anchor) {
            if (anchor == null) {
                TemplateFolderComparator.a(0);
            }
            this.b = anchor;
        }

        @Override
        public int compare(Pair<VirtualFile, Class<?>> leftPair, Pair<VirtualFile, Class<?>> rightPair) {
            VirtualFile virtualFile;
            int n2;
            Integer n3 = a.indexOf(leftPair.second);
            if (!n3.equals(n2 = a.indexOf(rightPair.second))) {
                return n3.compareTo(n2) * -1;
            }
            VirtualFile virtualFile2 = (VirtualFile)leftPair.first;
            VirtualFile virtualFile3 = (VirtualFile)rightPair.first;
            VirtualFile virtualFile4 = virtualFile2 != null ? VfsUtilCore.getCommonAncestor((VirtualFile)virtualFile2, (VirtualFile)this.b) : null;
            VirtualFile virtualFile5 = virtualFile = virtualFile3 != null ? VfsUtilCore.getCommonAncestor((VirtualFile)virtualFile3, (VirtualFile)this.b) : null;
            if (virtualFile4 == null && virtualFile == null) {
                return 0;
            }
            if (virtualFile4 == null) {
                return 1;
            }
            if (virtualFile == null) {
                return -1;
            }
            Integer n4 = virtualFile4.getPath().length();
            int n5 = n4.compareTo(virtualFile.getPath().length()) * -1;
            if (n5 != 0) {
                return n5;
            }
            return StringUtil.compare((String)virtualFile4.getPath(), (String)virtualFile.getPath(), (boolean)true);
        }

        static {
            c = com.jetbrains.python.psi.c.a(958060047607008990L, 989898296421626935L, MethodHandles.lookup().lookupClass()).a(9916480340631L);
            a = Arrays.asList(DjangoFileSystemTemplateLoader.class, DjangoAppTemplateLoader.class);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = c ^ 0x622AB801C33CL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/jetbrains/django/model/DjangoTemplateManager$TemplateFolderComparator", "<init>"));
        }
    }

    private static class TemplateReferenceExpectedChecker
    implements Function<PyStringLiteralExpression, Boolean> {
        private static final long a = com.jetbrains.python.psi.c.a(7842372767897924439L, 6616067145714481861L, MethodHandles.lookup().lookupClass()).a(74012804570825L);

        private TemplateReferenceExpectedChecker() {
        }

        public Boolean fun(PyStringLiteralExpression strLiteral) {
            long l2 = a ^ 0x235835C68092L;
            String string = strLiteral.getText();
            if (string != null && string.contains("{")) {
                return false;
            }
            if (TemplateParametersEvaluator.isTemplateValueInPatternsCall(strLiteral) || TemplateParametersEvaluator.isTemplateValueInRenderDecorated(strLiteral) || TemplateParametersEvaluator.isTemplateNameArg(strLiteral) || TemplateParametersEvaluator.isTemplateNameInViewClass(strLiteral)) {
                return true;
            }
            Module[] moduleArray = ModuleManager.getInstance((Project)strLiteral.getProject()).getModules();
            TemplatesService templatesService = moduleArray.length == 0 ? null : TemplatesService.getInstance(moduleArray[0]);
            for (PyCallExpression pyCallExpression : PythonDataflowUtil.getCalls(strLiteral)) {
                int n2 = PyPsiUtils.findArgumentIndex(pyCallExpression, strLiteral);
                if (n2 == 0 && (TemplateParametersEvaluator.isRenderMethod(pyCallExpression) || TemplateParametersEvaluator.isGetTemplateMethod(pyCallExpression) || TemplateParametersEvaluator.isInclusionTag(pyCallExpression) || TemplateParametersEvaluator.isRenderDecorator(pyCallExpression))) {
                    return true;
                }
                if (n2 == 1 && (TemplateParametersEvaluator.isDirectMethod(pyCallExpression) || TemplateParametersEvaluator.isTemplateResponse(pyCallExpression) || TemplateParametersEvaluator.isShortcutsRender(pyCallExpression))) {
                    return true;
                }
                if (templatesService == null || !templatesService.getTemplateLanguage().equals("Mako") || !(strLiteral.getParent() instanceof PyKeywordArgument) || !"filename".equals(((PyKeywordArgument)strLiteral.getParent()).getKeyword()) || !TemplateParametersEvaluator.isMakoTemplateCall(pyCallExpression)) continue;
                return true;
            }
            return false;
        }

        /* synthetic */ TemplateReferenceExpectedChecker(a x0) {
            this();
        }
    }

    private static class TemplateReferencesObtainer
    implements Function<PyFunction, Collection<? extends NavigatablePsiElement>> {
        private TemplateReferencesObtainer() {
        }

        public Collection<? extends NavigatablePsiElement> fun(PyFunction function) {
            TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis(function.getProject(), function.getContainingFile());
            return new ViewManagementFacade(function).getTemplateReferences(function, null, null, typeEvalContext).values();
        }

        /* synthetic */ TemplateReferencesObtainer(a x0) {
            this();
        }
    }

    public static class PrefixedVirtualDirectory
    extends StubVirtualFile {
        private final VirtualFile b;
        private final String a;
        private final PyStringLiteralExpression c;

        public PrefixedVirtualDirectory(VirtualFileSystemEntry virtualFile, String prefix, PyStringLiteralExpression prefixElement) {
            this.b = virtualFile;
            this.a = prefix;
            this.c = prefixElement;
        }

        public VirtualFile getVirtualFile() {
            return this.b;
        }

        public String getPrefix() {
            return this.a;
        }

        public PyStringLiteralExpression getPrefixElement() {
            return this.c;
        }
    }
}

