/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.model;

import com.google.common.collect.Sets;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.facet.DjangoFacetConfiguration;
import com.jetbrains.django.facet.DjangoFacetType;
import com.jetbrains.django.facet.DjangoWizardSettingsHolder;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.templateFSLoader.PyDjangoTemplateFSLoader;
import com.jetbrains.django.ui.DjangoBundle;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.jinja2.Jinja2Language;
import com.jetbrains.mako.MakoLanguage;
import com.jetbrains.pyramid.templates.ChameleonLanguage;
import com.jetbrains.python.PythonFunctionParameters;
import com.jetbrains.python.PythonHelpersLocator;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyQualifiedNameOwner;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.c;
import com.jetbrains.python.psi.impl.PyEvaluator;
import com.jetbrains.python.psi.resolve.PyResolveImportUtil;
import com.jetbrains.python.run.PythonTask;
import com.jetbrains.python.sdk.PyRemoteSdkWithoutSudo;
import com.jetbrains.python.templateLanguages.PythonTemplateLanguage;
import com.jetbrains.python.templateLanguages.TemplatesService;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoProjectCreatorAndConfigurator {
    private static final Map<PythonTemplateLanguage, String> a;
    private static final long b;

    private DjangoProjectCreatorAndConfigurator() {
    }

    public static void createProject(@NotNull VirtualFile contentRoot, @Nullable Sdk sdk, @NotNull DjangoWizardSettingsHolder settings, @NotNull Module module2, @Nullable Consumer<Consumer<Boolean>> syncCallBack) throws ExecutionException {
        long l2 = b ^ 0x4F826A93553EL;
        if (contentRoot == null) {
            DjangoProjectCreatorAndConfigurator.a(0);
        }
        if (settings == null) {
            DjangoProjectCreatorAndConfigurator.a(1);
        }
        if (module2 == null) {
            DjangoProjectCreatorAndConfigurator.a(2);
        }
        Sdk sdk2 = PyRemoteSdkWithoutSudo.wrapNullable(sdk);
        PythonTask pythonTask = new PythonTask(module2, "Generate", sdk2);
        pythonTask.setRunnerScript(PythonHelpersLocator.getHelperPath("pycharm/_jb_django_project_creator.py"));
        String string = contentRoot.getCanonicalPath();
        List<String> list2 = Arrays.asList(settings.getProjectName(), string);
        assert (!list2.contains(null)) : "Null parameter";
        pythonTask.setParameters(list2);
        pythonTask.runNoConsole();
        contentRoot.refresh(false, true);
        String string2 = settings.getApplicationName();
        if (!StringUtil.isEmpty((String)string2)) {
            PythonTask pythonTask2 = new PythonTask(module2, "Creating application", sdk2);
            pythonTask2.setRunnerScript("manage.py");
            pythonTask2.setWorkingDirectory(string);
            pythonTask2.setParameters(Arrays.asList("startapp", string2));
            pythonTask2.runNoConsole();
            contentRoot.refresh(false, true);
        }
        if (sdk2 != null) {
            ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
                modifiableRootModel.setSdk(sdk2);
                modifiableRootModel.commit();
            }));
        }
        if (syncCallBack == null) {
            DumbService.getInstance((Project)module2.getProject()).runWhenSmart(() -> DjangoProjectCreatorAndConfigurator.b(module2, contentRoot, settings, string2));
            return;
        }
        syncCallBack.accept(bl2 -> {
            long l2 = b ^ 0x1D4424DEB7D4L;
            if (bl2.booleanValue()) {
                DumbService.getInstance((Project)module2.getProject()).runWhenSmart(() -> DjangoProjectCreatorAndConfigurator.b(module2, contentRoot, settings, string2));
            } else {
                Messages.showWarningDialog((Project)module2.getProject(), (String)"Remote project has not been synchronized with local version. PyCharm can't patch it according to your settings.Project may still be available on remote site. In this case you need to download it manually", (String)"Can't Patch Created Project");
            }
        });
    }

    private static void a(@NotNull Module module2, @NotNull VirtualFile virtualFile, @NotNull DjangoWizardSettingsHolder djangoWizardSettingsHolder, @NotNull VirtualFile virtualFile2) {
        Object object;
        FileDocumentManager fileDocumentManager;
        Object object2;
        long l2 = b ^ 0x511C5DD0992EL;
        if (module2 == null) {
            DjangoProjectCreatorAndConfigurator.a(3);
        }
        if (virtualFile == null) {
            DjangoProjectCreatorAndConfigurator.a(4);
        }
        if (djangoWizardSettingsHolder == null) {
            DjangoProjectCreatorAndConfigurator.a(5);
        }
        if (virtualFile2 == null) {
            DjangoProjectCreatorAndConfigurator.a(6);
        }
        TemplatesService templatesService = TemplatesService.getInstance(module2);
        templatesService.generateTemplates(djangoWizardSettingsHolder, virtualFile);
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string = djangoWizardSettingsHolder.getTemplatesFolder();
        try {
            if (!StringUtil.isEmptyOrSpaces((String)string)) {
                object2 = new File(string);
                if (!((File)object2).isAbsolute()) {
                    object2 = new File(virtualFile.getPath(), string);
                }
                if ((fileDocumentManager = VfsUtil.createDirectoryIfMissing((String)(string = ((File)object2).getAbsolutePath()))) == null) {
                    DjangoProjectCreatorAndConfigurator.a(string);
                    return;
                }
                DjangoProjectCreatorAndConfigurator.a(virtualFile.getPath(), module2.getProject(), (VirtualFile)fileDocumentManager, virtualFile2);
            }
        }
        catch (IOException iOException) {
            DjangoProjectCreatorAndConfigurator.a(string);
        }
        virtualFile.refresh(false, true);
        object2 = djangoWizardSettingsHolder.getTemplateLanguage();
        fileDocumentManager = FileDocumentManager.getInstance();
        PyFile pyFile = DjangoSettingsPy.getSettingsFile(module2);
        if (pyFile != null && object2 != null) {
            object = PyDjangoTemplateFSLoader.getForSettings(pyFile);
            PsiDocumentManager.getInstance((Project)module2.getProject()).commitAllDocuments();
            ((PyDjangoTemplateFSLoader)object).setLanguage((String)object2);
        }
        object = null;
        if ("Mako".equals(object2)) {
            object = "djangomako.middleware.MakoMiddleware";
        }
        virtualFile2.refresh(false, false);
        Document document = fileDocumentManager.getDocument(virtualFile2);
        if (document == null) {
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        for (int i10 = 0; i10 < document.getLineCount(); ++i10) {
            int n2 = document.getLineStartOffset(i10);
            int n3 = document.getLineEndOffset(i10);
            String string2 = document.getCharsSequence().subSequence(n2, n3).toString();
            if (string2.startsWith("MIDDLEWARE_CLASSES =")) {
                bl3 = true;
            }
            if (!bl3 || bl2 || !string2.startsWith("]") || StringUtil.isEmptyOrSpaces((String)object)) continue;
            document.insertString(n2, (CharSequence)("    '" + (String)object + "',\n"));
            bl2 = true;
        }
    }

    private static void b(@NotNull Module module2, @NotNull VirtualFile virtualFile, @NotNull DjangoWizardSettingsHolder djangoWizardSettingsHolder, @Nullable String string) {
        String string2;
        Object object;
        VirtualFile virtualFile2;
        long l2 = b ^ 0x1170837EAD19L;
        if (module2 == null) {
            DjangoProjectCreatorAndConfigurator.a(7);
        }
        if (virtualFile == null) {
            DjangoProjectCreatorAndConfigurator.a(8);
        }
        if (djangoWizardSettingsHolder == null) {
            DjangoProjectCreatorAndConfigurator.a(9);
        }
        Application application = ApplicationManager.getApplication();
        assert (application.isDispatchThread()) : "To be called on AWT only";
        assert (!DumbService.getInstance((Project)module2.getProject()).isDumb()) : "Can only be called under smart mode";
        boolean bl2 = djangoWizardSettingsHolder.isEnableAdmin();
        Project project = module2.getProject();
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        VirtualFile virtualFile3 = DjangoProjectCreatorAndConfigurator.a(virtualFile, project);
        if (virtualFile3 != null) {
            virtualFile3.refresh(false, true);
            virtualFile2 = fileDocumentManager.getDocument(virtualFile3);
            if (virtualFile2 != null) {
                object = new HashSet();
                if (string != null) {
                    string2 = DjangoProjectCreatorAndConfigurator.a(string, module2);
                    object.add(string2 != null ? string2 : string);
                }
                WriteCommandAction.writeCommandAction((Project)project).run(() -> DjangoProjectCreatorAndConfigurator.a((Document)virtualFile2, (Set)object, bl2));
                fileDocumentManager.saveDocument((Document)virtualFile2);
            }
        }
        if (!bl2 && (object = (virtualFile2 = virtualFile3 != null ? virtualFile3.getParent() : virtualFile).findChild("urls.py")) != null) {
            object.refresh(false, false);
            string2 = fileDocumentManager.getDocument((VirtualFile)object);
            if (string2 != null) {
                DjangoProjectCreatorAndConfigurator.a((Document)string2, project);
                fileDocumentManager.saveDocument((Document)string2);
            }
        }
        DjangoProjectCreatorAndConfigurator.configureDjangoFacet(module2, virtualFile);
        if (virtualFile3 != null) {
            DjangoProjectCreatorAndConfigurator.a(module2, virtualFile, djangoWizardSettingsHolder, virtualFile3);
        }
        fileDocumentManager.saveAllDocuments();
    }

    @Nullable
    private static String a(@NotNull String string, @NotNull Module module2) {
        List<PsiElement> list2;
        PyFile pyFile;
        long l2 = b ^ 0x37545712FA2L;
        if (string == null) {
            DjangoProjectCreatorAndConfigurator.a(10);
        }
        if (module2 == null) {
            DjangoProjectCreatorAndConfigurator.a(11);
        }
        if ((pyFile = PyUtil.as(ContainerUtil.getFirstItem(list2 = PyResolveImportUtil.resolveQualifiedName(QualifiedName.fromComponents((String[])new String[]{string, "apps"}), PyResolveImportUtil.fromModule(module2))), PyFile.class)) == null) {
            return null;
        }
        return pyFile.getTopLevelClasses().stream().findFirst().map(PyQualifiedNameOwner::getQualifiedName).orElse(null);
    }

    @Nullable
    private static VirtualFile a(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        VirtualFile virtualFile2;
        VirtualFile virtualFile3;
        long l2 = b ^ 0x5453A9BCF939L;
        if (virtualFile == null) {
            DjangoProjectCreatorAndConfigurator.a(12);
        }
        if (project == null) {
            DjangoProjectCreatorAndConfigurator.a(13);
        }
        if ((virtualFile3 = DjangoProjectCreatorAndConfigurator.a(project, virtualFile)) != null) {
            return virtualFile3;
        }
        virtualFile3 = virtualFile.findChild("settings.py");
        if (virtualFile3 == null && (virtualFile2 = virtualFile.findChild(virtualFile.getName())) != null) {
            virtualFile3 = virtualFile2.findChild("settings.py");
        }
        return virtualFile3;
    }

    public static void configureDjangoFacet(@NotNull Module module2, @NotNull VirtualFile baseDir) {
        PyFile pyFile;
        Object object;
        DjangoFacet djangoFacet;
        long l2 = b ^ 0x3C1B0743E565L;
        if (module2 == null) {
            DjangoProjectCreatorAndConfigurator.a(14);
        }
        if (baseDir == null) {
            DjangoProjectCreatorAndConfigurator.a(15);
        }
        if ((djangoFacet = DjangoFacet.getInstance(module2)) == null) {
            object = DjangoFacetType.createDefaultConfiguration(module2.getProject());
            DjangoFacetType.createDjangoFacet(module2, (DjangoFacetConfiguration)object);
        }
        if ((djangoFacet = DjangoFacet.getInstance(module2)) != null) {
            object = DjangoProjectCreatorAndConfigurator.a(baseDir, module2.getProject());
            if (object != null) {
                ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).setSettingsFilePath(VirtualFileUtil.getRelativePath(baseDir, (VirtualFile)object));
            }
            if (((DjangoFacetConfiguration)djangoFacet.getConfiguration()).getProjectRootPath() == null) {
                ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).setProjectRootFolderFile(baseDir);
            }
            if ((pyFile = baseDir.findChild("manage.py")) != null) {
                ((DjangoFacetConfiguration)djangoFacet.getConfiguration()).setManageFilePath(pyFile.getPath());
            }
        }
        object = TemplatesService.getInstance(module2);
        pyFile = DjangoSettingsPy.getSettingsFile(module2);
        if (pyFile != null) {
            ((TemplatesService)object).setTemplateLanguage(DjangoProjectCreatorAndConfigurator.a(pyFile).getTemplateLanguageName());
        }
    }

    @NotNull
    private static PythonTemplateLanguage a(@NotNull PyFile pyFile) {
        if (pyFile == null) {
            DjangoProjectCreatorAndConfigurator.a(16);
        }
        String string = pyFile.getText();
        for (Map.Entry<PythonTemplateLanguage, String> entry : a.entrySet()) {
            if (!string.contains(entry.getValue())) continue;
            PythonTemplateLanguage pythonTemplateLanguage = entry.getKey();
            if (pythonTemplateLanguage == null) {
                DjangoProjectCreatorAndConfigurator.a(17);
            }
            return pythonTemplateLanguage;
        }
        DjangoTemplateLanguage djangoTemplateLanguage = DjangoTemplateLanguage.INSTANCE;
        if (djangoTemplateLanguage == null) {
            DjangoProjectCreatorAndConfigurator.a(18);
        }
        return djangoTemplateLanguage;
    }

    private static void a(@NotNull Document document, Set<String> set, Set<String> set2) {
        long l2 = b ^ 0x77ED37944316L;
        if (document == null) {
            DjangoProjectCreatorAndConfigurator.a(19);
        }
        boolean bl2 = false;
        for (int i10 = 0; i10 < document.getLineCount(); ++i10) {
            int n2 = document.getLineStartOffset(i10);
            int n3 = document.getLineEndOffset(i10);
            String string = document.getCharsSequence().subSequence(n2, n3).toString();
            for (String string2 : set2) {
                if (StringUtil.isEmpty((String)string2) || !string.contains(string2)) continue;
                document.deleteString(n2, n3 + 1);
            }
            if (string.startsWith("INSTALLED_APPS =")) {
                bl2 = true;
                continue;
            }
            if (bl2 && string.startsWith(")") || string.startsWith("]")) {
                for (String string2 : set) {
                    if (StringUtil.isEmpty((String)string2)) continue;
                    document.insertString(n2, (CharSequence)("    '" + string2 + "',\n"));
                }
                break;
            }
            if (!bl2) continue;
            Iterator<String> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string2;
                string2 = iterator.next();
                if (StringUtil.isEmpty((String)string2) || !string.startsWith("    # '" + string2)) continue;
                document.replaceString(n2 + 4, n2 + 6, (CharSequence)"");
                iterator.remove();
            }
        }
    }

    private static void a(@NotNull Document document, @NotNull Project project) {
        if (document == null) {
            DjangoProjectCreatorAndConfigurator.a(20);
        }
        if (project == null) {
            DjangoProjectCreatorAndConfigurator.a(21);
        }
        Application application = ApplicationManager.getApplication();
        assert (application.isDispatchThread());
        WriteCommandAction.writeCommandAction((Project)project).run(() -> {
            long l2 = b ^ 0x7AB3221D6E9DL;
            for (int i10 = 0; i10 < document.getLineCount(); ++i10) {
                int n2 = document.getLineStartOffset(i10);
                String string = document.getCharsSequence().subSequence(n2, document.getLineEndOffset(i10)).toString();
                if (string.startsWith("from django.contrib import admin") || string.startsWith("admin.autodiscover")) {
                    document.insertString(n2, (CharSequence)"# ");
                    continue;
                }
                if (!string.contains("admin.site.urls")) continue;
                document.insertString(n2, (CharSequence)"    #");
            }
        });
    }

    private static void a(String string) {
        long l2 = b ^ 0x6F50067922C9L;
        Messages.showErrorDialog((String)DjangoBundle.message("create-folder-error", string), (String)DjangoBundle.message("project-create-error", new Object[0]));
    }

    private static void a(@NotNull String string, @NotNull Project project, @NotNull VirtualFile virtualFile, @NotNull VirtualFile virtualFile2) {
        VirtualFile virtualFile3;
        long l2 = b ^ 0x1A27BBD84A16L;
        if (string == null) {
            DjangoProjectCreatorAndConfigurator.a(22);
        }
        if (project == null) {
            DjangoProjectCreatorAndConfigurator.a(23);
        }
        if (virtualFile == null) {
            DjangoProjectCreatorAndConfigurator.a(24);
        }
        if (virtualFile2 == null) {
            DjangoProjectCreatorAndConfigurator.a(25);
        }
        if ((virtualFile3 = VirtualFileUtil.findFile(string)) == null) {
            return;
        }
        VirtualFile virtualFile4 = DjangoProjectCreatorAndConfigurator.a(virtualFile3, project);
        if (virtualFile4 == null) {
            return;
        }
        VirtualFile virtualFile5 = virtualFile4.getParent();
        String string2 = DjangoProjectCreatorAndConfigurator.a(virtualFile5, virtualFile);
        PsiManagerEx psiManagerEx = PsiManagerEx.getInstanceEx((Project)project);
        PyFile pyFile = PyUtil.as(psiManagerEx.getFileManager().findFile(virtualFile2), PyFile.class);
        if (pyFile == null) {
            return;
        }
        PyDjangoTemplateFSLoader pyDjangoTemplateFSLoader = PyDjangoTemplateFSLoader.getForSettings(pyFile);
        String string3 = "os.path.join(BASE_DIR,  '" + string2 + "')";
        pyDjangoTemplateFSLoader.setFolder(string3);
    }

    private static String a(VirtualFile virtualFile, VirtualFile virtualFile2) {
        long l2 = b ^ 0x521835C33234L;
        virtualFile = virtualFile.getParent();
        StringBuilder stringBuilder = new StringBuilder();
        while (VirtualFileUtil.getRelativePath(virtualFile, virtualFile2) == null) {
            virtualFile = virtualFile.getParent();
            stringBuilder.append("../");
        }
        String string = VirtualFileUtil.getRelativePath(virtualFile, virtualFile2);
        if (string != null) {
            return stringBuilder.append(string).toString();
        }
        return null;
    }

    @Nullable
    private static VirtualFile a(@NotNull Project project, final @NotNull VirtualFile virtualFile) {
        VirtualFile virtualFile2;
        long l2 = b ^ 0x2BF08E86B7E8L;
        if (project == null) {
            DjangoProjectCreatorAndConfigurator.a(26);
        }
        if (virtualFile == null) {
            DjangoProjectCreatorAndConfigurator.a(27);
        }
        if ((virtualFile2 = virtualFile.findChild("manage.py")) == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile2);
        if (psiFile == null) {
            return null;
        }
        final Ref ref = new Ref();
        psiFile.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){
            private static final long a = c.a(-3253155752872093544L, -2059534629408935522L, MethodHandles.lookup().lookupClass()).a(82425976767539L);

            @Override
            public void visitPyCallExpression(PyCallExpression node) {
                long l2 = a ^ 0x480AAFFE4D90L;
                if (node.isCalleeText("setdefault")) {
                    PyExpression pyExpression = node.getArgument(PythonFunctionParameters.ENV_SET_DEFAULT_KEY, PyExpression.class);
                    PyExpression pyExpression2 = node.getArgument(PythonFunctionParameters.ENV_SET_DEFAULT_FAILOBJ, PyExpression.class);
                    if (pyExpression == null || pyExpression2 == null) {
                        super.visitPyCallExpression(node);
                        return;
                    }
                    String string = PyEvaluator.evaluate(pyExpression, String.class);
                    String string2 = PyEvaluator.evaluate(pyExpression2, String.class);
                    if (string == null || string2 == null) {
                        super.visitPyCallExpression(node);
                        return;
                    }
                    if (string.equals("DJANGO_SETTINGS_MODULE")) {
                        ref.set((Object)virtualFile.findFileByRelativePath(String.format("%s.py", StringUtil.replace((String)string2, (String)".", (String)"/"))));
                    }
                }
                super.visitPyCallExpression(node);
            }
        });
        return (VirtualFile)ref.get();
    }

    private static /* synthetic */ void a(Document document, Set set, boolean bl2) throws RuntimeException {
        long l2 = b ^ 0x610194A08639L;
        DjangoProjectCreatorAndConfigurator.a(document, (Set<String>)set, Sets.newHashSet((Object[])new String[]{!bl2 ? "django.contrib.admin" : null}));
    }

    static {
        b = c.a(-7183894437002877043L, 1078432975864071605L, MethodHandles.lookup().lookupClass()).a(108051325604785L);
        long l2 = b ^ 0x2A2273F99F10L;
        a = new HashMap<PythonTemplateLanguage, String>();
        a.put(MakoLanguage.INSTANCE, "MakoMiddleware");
        a.put(ChameleonLanguage.INSTANCE, "chameleon.context_processors.theme");
        a.put(Jinja2Language.INSTANCE, "django_jinja");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x382E9A1C8118L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 17: 
            case 18: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoot";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 3: 
            case 7: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsFile";
                break;
            }
            case 8: 
            case 12: 
            case 22: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectRoot";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsHolder";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appName";
                break;
            }
            case 13: 
            case 21: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/model/DjangoProjectCreatorAndConfigurator";
                break;
            }
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templatesFolder";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsVirtualFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/model/DjangoProjectCreatorAndConfigurator";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseTemplateLanguage";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createProject";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "configureTemplates";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "configureSettingsAndFacet";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getFullAppName";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findSettings";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "configureDjangoFacet";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "chooseTemplateLanguage";
                break;
            }
            case 17: 
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "modifyInstalledApps";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "commentAdminUrls";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setTemplatesFolderInSettings";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "fetchSettingsFromManagePy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

