/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.django.lang.template.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.jetbrains.django.lang.template.DjangoTemplateLanguage;
import com.jetbrains.django.lang.template.parsing.DjangoTemplateTokenTypes;
import com.jetbrains.django.lang.template.psi.impl.DjangoOuterLanguageElement;
import com.jetbrains.django.lang.template.psi.impl.DjangoTagElementImpl;
import com.jetbrains.django.lang.template.psi.impl.DjangoVariableReferenceImpl;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoTemplatePsiUtil {
    private static final long a = c.a(8964899669377546409L, -5950837094311037525L, MethodHandles.lookup().lookupClass()).a(147203898461918L);

    private DjangoTemplatePsiUtil() {
    }

    public static boolean isTemplateCharacters(@NotNull ASTNode child) {
        if (child == null) {
            DjangoTemplatePsiUtil.a(0);
        }
        return child.getPsi() instanceof DjangoOuterLanguageElement && child.getElementType() == DjangoTemplateTokenTypes.TEMPLATE_CHARACTERS;
    }

    public static boolean containsButNotEqual(@NotNull TextRange biggerRange, @NotNull TextRange smallerRange) {
        if (biggerRange == null) {
            DjangoTemplatePsiUtil.a(1);
        }
        if (smallerRange == null) {
            DjangoTemplatePsiUtil.a(2);
        }
        return biggerRange.contains(smallerRange) && !biggerRange.equals((Object)smallerRange);
    }

    @NotNull
    public static PsiElement biggestElementInside(@NotNull PsiElement element, @NotNull PsiElement djangoElement) {
        if (element == null) {
            DjangoTemplatePsiUtil.a(3);
        }
        if (djangoElement == null) {
            DjangoTemplatePsiUtil.a(4);
        }
        while (djangoElement.getParent() != null && !(djangoElement.getParent() instanceof XmlDocument) && djangoElement.getParent().getTextRange() != null && !DjangoTemplatePsiUtil.containsButNotEqual(djangoElement.getParent().getTextRange(), element.getTextRange())) {
            djangoElement = djangoElement.getParent();
        }
        PsiElement psiElement = djangoElement;
        if (psiElement == null) {
            DjangoTemplatePsiUtil.a(5);
        }
        return psiElement;
    }

    public static List<PsiElement> findAllDjangoElementsInsideOuterLanguageElement(PsiElement outerLangElement, TemplateLanguageFileViewProvider vProvider) {
        PsiFile psiFile = vProvider.getPsi(vProvider.getBaseLanguage());
        if (psiFile == null) {
            return Lists.newArrayList();
        }
        PsiElement psiElement = psiFile.findElementAt(outerLangElement.getTextRange().getStartOffset());
        return DjangoTemplatePsiUtil.findAllDjangoElementsInsideOuterLanguageElementInner(outerLangElement, psiElement);
    }

    public static List<PsiElement> findAllDjangoElementsInsideOuterLanguageElement(PsiElement outerLangElement, PsiElement djangoElement) {
        djangoElement = djangoElement.findElementAt(outerLangElement.getTextOffset());
        return DjangoTemplatePsiUtil.findAllDjangoElementsInsideOuterLanguageElementInner(outerLangElement, djangoElement);
    }

    public static List<PsiElement> findAllDjangoElementsInsideOuterLanguageElementInner(PsiElement outerLangElement, PsiElement djangoElement) {
        ArrayList arrayList = Lists.newArrayList();
        for (djangoElement = DjangoTemplatePsiUtil.biggestElementInside(outerLangElement, djangoElement); djangoElement != null && djangoElement.getTextRange().getEndOffset() <= outerLangElement.getTextRange().getEndOffset(); djangoElement = djangoElement.getNextSibling()) {
            arrayList.add(djangoElement);
        }
        return arrayList;
    }

    @Nullable
    public static String getDjangoExpressionVariable(DjangoTagElementImpl element) {
        DjangoVariableReferenceImpl djangoVariableReferenceImpl = (DjangoVariableReferenceImpl)PsiTreeUtil.findChildOfType((PsiElement)element, DjangoVariableReferenceImpl.class);
        if (djangoVariableReferenceImpl != null) {
            return djangoVariableReferenceImpl.getName();
        }
        return null;
    }

    public static boolean isWhiteSpace(PsiElement element) {
        return element.getText().trim().length() == 0 || element instanceof PsiComment || element instanceof PsiWhiteSpace;
    }

    public static PsiElement getInjectedHostOrElement(@NotNull PsiElement element) {
        PsiLanguageInjectionHost psiLanguageInjectionHost;
        if (element == null) {
            DjangoTemplatePsiUtil.a(6);
        }
        return (psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element)) != null ? psiLanguageInjectionHost : element;
    }

    @NotNull
    public static PsiFile getContainingFile(@NotNull PsiElement element) {
        if (element == null) {
            DjangoTemplatePsiUtil.a(7);
        }
        PsiElement psiElement = DjangoTemplatePsiUtil.getInjectedHostOrElement(element);
        PsiFile psiFile = DjangoTemplateLanguage.getDjangoTemplateFile(psiElement.getContainingFile());
        if (psiFile == null) {
            DjangoTemplatePsiUtil.a(8);
        }
        return psiFile;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0xA21B438EC93L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 8: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "biggerRange";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smallerRange";
                break;
            }
            case 3: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "djangoElement";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/django/lang/template/psi/DjangoTemplatePsiUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/django/lang/template/psi/DjangoTemplatePsiUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "biggestElementInside";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isTemplateCharacters";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "containsButNotEqual";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "biggestElementInside";
                break;
            }
            case 5: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getInjectedHostOrElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

