/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.appengine.util;

import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.text.VersionComparatorUtil;
import com.jetbrains.appengine.facet.AppEngineFacet;
import com.jetbrains.appengine.facet.AppEngineFacetConfiguration;
import com.jetbrains.appengine.model.ModelManager;
import com.jetbrains.appengine.ui.AppEngineBundle;
import com.jetbrains.appengine.util.PythonUtil;
import com.jetbrains.appengine.util.YamlUtil;
import com.jetbrains.appengine.util.a;
import com.jetbrains.django.util.VirtualFileUtil;
import com.jetbrains.python.facet.FacetLibraryConfigurator;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.psi.YAMLFile;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLSequenceItem;

public class AppEngineUtil {
    private static final Logger f;
    public static final String INDEX_YAML = "index.yaml";
    public static final String DEV_APPSERVER = "dev_appserver.py";
    public static final String APP_SETTING_APPLICATION = "application";
    private static final String a = "gql";
    public static final String APPENGINE_LIBRARY_NAME;
    public static final String PYTHON_RUNTIME_25 = "python";
    public static final String PYTHON_RUNTIME_27 = "python27";
    private static final String b = "platform";
    private static final String e = "google_appengine";
    private static final String[] d;
    private static final String[] c;
    private static final long g;

    private AppEngineUtil() {
    }

    @Nullable
    public static String findRoot(Module module2) {
        for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module2).getContentRoots()) {
            ConfigFileFinder configFileFinder = new ConfigFileFinder(null);
            VfsUtilCore.processFilesRecursively((VirtualFile)virtualFile, (Processor)configFileFinder);
            VirtualFile virtualFile2 = configFileFinder.a;
            if (virtualFile2 == null) continue;
            return virtualFile2.getParent().getPresentableUrl();
        }
        return null;
    }

    public static boolean isGql(PyStringLiteralExpression value) {
        return AppEngineUtil.isGqlQuery(value) || AppEngineUtil.isEntityGql(value);
    }

    public static boolean isStandaloneAppEgineSdkFolder(@Nullable String path) {
        long l2 = g ^ 0x54E98B7FCB73L;
        return !StringUtil.isEmptyOrSpaces((String)path) && new File(path, DEV_APPSERVER).exists() && new File(path, "google").exists();
    }

    public static boolean isGoogleCloudSdkFolder(@Nullable String path) {
        long l2 = g ^ 0x2364F283B465L;
        return !StringUtil.isEmptyOrSpaces((String)path) && AppEngineUtil.isStandaloneAppEgineSdkFolder(FileUtil.join((String[])new String[]{path, b, e}));
    }

    public static String getAppEngineComponent(@NotNull String sdkPath) {
        long l2 = g ^ 0x1B429B9089F7L;
        if (sdkPath == null) {
            AppEngineUtil.a(0);
        }
        return FileUtil.join((String[])new String[]{sdkPath, b, e});
    }

    public static boolean isPython27Runtime(YAMLFile file) {
        long l2 = g ^ 0x23BC46AD3C6FL;
        Pair<PsiElement, String> pair = YAMLUtil.getValue(file, "runtime");
        return pair != null && ((String)pair.second).equals(PYTHON_RUNTIME_27);
    }

    public static ValidationResult validateSdk(@NotNull String path) {
        long l2 = g ^ 0x2E29FB30E650L;
        if (path == null) {
            AppEngineUtil.a(1);
        }
        if (AppEngineUtil.isStandaloneAppEgineSdkFolder(path) || AppEngineUtil.isGoogleCloudSdkFolder(path)) {
            return ValidationResult.OK;
        }
        if (new File(FileUtil.join((String[])new String[]{path, "bin", DEV_APPSERVER})).exists()) {
            return new ValidationResult(AppEngineBundle.message("facet-wizard-error.no-python-extensions-sdk", new Object[0]));
        }
        return new ValidationResult(AppEngineBundle.message("facet-wizard-error.no-appengine-sdk", new Object[0]));
    }

    @Nullable
    public static YAMLFile getAppYaml(Project project, String projectRoot) {
        VirtualFile virtualFile;
        long l2 = g ^ 0x74448DDB21DEL;
        VirtualFile virtualFile2 = VirtualFileUtil.findFile(projectRoot);
        if (virtualFile2 != null && (virtualFile = virtualFile2.findChild("app.yaml")) != null) {
            return (YAMLFile)ObjectUtils.tryCast((Object)PsiManager.getInstance((Project)project).findFile(virtualFile), YAMLFile.class);
        }
        return null;
    }

    @Nullable
    public static String getSetting(Project project, String projectRoot, String setting) {
        YAMLFile yAMLFile = AppEngineUtil.getAppYaml(project, projectRoot);
        if (yAMLFile == null) {
            return null;
        }
        Pair<PsiElement, String> pair = YAMLUtil.getValue(yAMLFile, setting);
        return (String)Pair.getSecond(pair);
    }

    private static List<String> a(String string, Project project, String string2) {
        Object object;
        Object object2;
        long l2 = g ^ 0x402ADC7502B9L;
        boolean bl2 = false;
        YAMLFile yAMLFile = AppEngineUtil.getAppYaml(project, string2);
        if (yAMLFile != null) {
            bl2 = AppEngineUtil.isPython27Runtime(yAMLFile);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        HashMap<String, VersionedLibrary> hashMap = new HashMap<String, VersionedLibrary>();
        if (string != null) {
            arrayList.add(string);
            object2 = new File(string, "lib");
            object = ((File)object2).listFiles();
            if (object != null) {
                for (File file : object) {
                    String string3 = file.getName();
                    if (string3.startsWith("webob") && bl2 ^ (string3.startsWith("webob_1") || string3.startsWith("webob-1")) || bl2 && AppEngineUtil.a(file, hashMap)) continue;
                    arrayList.add(file.getPath());
                }
            }
        }
        if (bl2) {
            AppEngineUtil.a(yAMLFile, hashMap, arrayList);
        } else {
            object2 = (VersionedLibrary)hashMap.get("django");
            if (object2 != null && (object = ((VersionedLibrary)object2).getPathForVersion("1.2")) != null) {
                arrayList.add((String)object);
            }
        }
        return arrayList;
    }

    private static void a(YAMLFile yAMLFile, Map<String, VersionedLibrary> map2, List<String> list2) {
        for (String string : d) {
            String string2;
            String string3 = AppEngineUtil.a(yAMLFile, string);
            VersionedLibrary versionedLibrary = map2.get(string);
            if (versionedLibrary == null || (string2 = versionedLibrary.getPathForVersion(string3)) == null) continue;
            list2.add(string2);
        }
    }

    private static boolean a(File file, Map<String, VersionedLibrary> map2) {
        for (String string : d) {
            if (!file.getName().startsWith(string)) continue;
            VersionedLibrary versionedLibrary = map2.get(string);
            if (versionedLibrary == null) {
                versionedLibrary = new VersionedLibrary(string);
                map2.put(string, versionedLibrary);
            }
            versionedLibrary.addPath(file);
            return true;
        }
        return false;
    }

    private static String a(YAMLFile yAMLFile, String string) {
        long l2 = g ^ 0xA5A000CE131L;
        YAMLKeyValue yAMLKeyValue = YAMLUtil.getQualifiedKeyInFile(yAMLFile, "libraries");
        if (yAMLKeyValue != null) {
            List<YAMLSequenceItem> list2 = YamlUtil.getSequenceValue(yAMLKeyValue);
            for (YAMLSequenceItem yAMLSequenceItem : list2) {
                YAMLKeyValue yAMLKeyValue2;
                YAMLKeyValue yAMLKeyValue3 = YAMLUtil.findKeyInProbablyMapping(yAMLSequenceItem.getValue(), "name");
                if (yAMLKeyValue3 == null || !yAMLKeyValue3.getValueText().equals(string) || (yAMLKeyValue2 = YAMLUtil.findKeyInProbablyMapping(yAMLSequenceItem.getValue(), "version")) == null) continue;
                return yAMLKeyValue2.getValueText();
            }
        }
        return null;
    }

    public static void initAppEngineModuleLibrary(Module module2, @Nullable ModifiableRootModel existingModel, String appEngineSdkFolder, String projectRoot) {
        List<String> list2 = AppEngineUtil.a(appEngineSdkFolder, module2.getProject(), projectRoot);
        FacetLibraryConfigurator.attachPythonLibrary(module2, existingModel, APPENGINE_LIBRARY_NAME, list2);
    }

    public static void detachAppEngineModuleLibrary(Module module2) {
        FacetLibraryConfigurator.detachPythonLibrary(module2, APPENGINE_LIBRARY_NAME);
    }

    @Nullable
    public static VirtualFile getDjangoBinFolder(String appEnginePath) {
        VirtualFile virtualFile;
        File file;
        long l2 = g ^ 0x13BBB067B97FL;
        if (!StringUtil.isEmpty((String)appEnginePath) && (file = AppEngineUtil.getDjangoFolder(appEnginePath)) != null && (virtualFile = LocalFileSystem.getInstance().findFileByIoFile(file)) != null) {
            virtualFile.refresh(false, true);
            return virtualFile.findFileByRelativePath("django/bin");
        }
        return null;
    }

    @Nullable
    public static File getDjangoFolder(String appEngineFolder) {
        long l2 = g ^ 0x30361AFEDE34L;
        if (appEngineFolder == null) {
            return null;
        }
        for (String string : c) {
            File file = new File(appEngineFolder, "lib/" + string);
            if (!file.exists()) continue;
            return file;
        }
        return null;
    }

    @Nullable
    public static YAMLFile getIndex(@NotNull Module module2, boolean createIfNotFound) {
        VirtualFile virtualFile;
        long l2 = g ^ 0x78F4A890557FL;
        if (module2 == null) {
            AppEngineUtil.a(2);
        }
        if ((virtualFile = AppEngineUtil.getProjectRootFile(module2)) != null) {
            PsiFile psiFile;
            VirtualFile virtualFile2 = null;
            try {
                virtualFile2 = createIfNotFound ? virtualFile.findOrCreateChildData((Object)module2, INDEX_YAML) : virtualFile.findChild(INDEX_YAML);
            }
            catch (IOException iOException) {
                f.error("Failed to create index.yaml", (Throwable)iOException);
            }
            if (virtualFile2 != null && (psiFile = PsiManager.getInstance((Project)module2.getProject()).findFile(virtualFile2)) instanceof YAMLFile) {
                return (YAMLFile)psiFile;
            }
        }
        return null;
    }

    @Nullable
    public static VirtualFile getProjectRootFile(@NotNull Module module2) {
        AppEngineFacetConfiguration appEngineFacetConfiguration;
        if (module2 == null) {
            AppEngineUtil.a(3);
        }
        if ((appEngineFacetConfiguration = AppEngineFacet.getConfig(module2)) == null) {
            return null;
        }
        VirtualFile virtualFile = appEngineFacetConfiguration.getProjectRootFolderFile();
        if (virtualFile == null) {
            return null;
        }
        return virtualFile;
    }

    public static boolean isGqlQuery(PyStringLiteralExpression str) {
        long l2 = g ^ 0x6CFA611047D8L;
        if (str != null) {
            PyCallExpression pyCallExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)str, PyCallExpression.class);
            return pyCallExpression != null && pyCallExpression.isCalleeText("GqlQuery") && AppEngineUtil.a(pyCallExpression, str, 0);
        }
        return false;
    }

    public static boolean isEntityGql(PyStringLiteralExpression str) {
        return AppEngineUtil.getEntityClass(str) != null;
    }

    @Nullable
    public static PyClass getEntityClass(PyStringLiteralExpression query) {
        PyCallExpression pyCallExpression;
        long l2 = g ^ 0x31BC5CBDDA8CL;
        if (query != null && (pyCallExpression = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)query, PyCallExpression.class)) != null && pyCallExpression.isCalleeText(a) && AppEngineUtil.a(pyCallExpression, query, 0)) {
            return AppEngineUtil.a(pyCallExpression);
        }
        return null;
    }

    private static boolean a(PyCallExpression pyCallExpression, PyExpression pyExpression, int n2) {
        PyArgumentList pyArgumentList = pyCallExpression.getArgumentList();
        if (pyArgumentList != null) {
            PyExpression[] pyExpressionArray = pyArgumentList.getArguments();
            return pyExpressionArray.length > n2 && pyExpression.equals(pyExpressionArray[n2]);
        }
        return false;
    }

    @Nullable
    private static PyClass a(PyCallExpression pyCallExpression) {
        Module module2;
        PyClass pyClass = PythonUtil.getStaticMethodClass(pyCallExpression);
        if (pyClass != null && (module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)pyClass)) != null && ModelManager.getInstance(module2).isModel(pyClass)) {
            return pyClass;
        }
        return null;
    }

    @Nullable
    public static String getAppEngineSdkVersion(String path) {
        long l2 = g ^ 0x58CF7D805C7AL;
        File file = new File(path, "VERSION");
        if (!file.exists()) {
            return null;
        }
        try {
            String string = FileUtil.loadFile((File)file);
            String[] stringArray = StringUtil.splitByLines((String)string);
            String string2 = "release:";
            for (String string3 : stringArray) {
                if (!string3.startsWith("release:")) continue;
                return StringUtil.stripQuotesAroundValue((String)string3.substring("release:".length()).trim());
            }
        }
        catch (IOException iOException) {
            f.info("Failed to load content from App Engine VERSION file", (Throwable)iOException);
        }
        return null;
    }

    @Nullable
    public static Module getAppEngineModule(@NotNull Project project) {
        if (project == null) {
            AppEngineUtil.a(4);
        }
        for (Module module2 : ModuleManager.getInstance((Project)project).getModules()) {
            if (!AppEngineFacet.isPresent(module2)) continue;
            return module2;
        }
        return null;
    }

    public static Map<String, String> getProperties(@NotNull PyClass pyClass) {
        long l2 = g ^ 0xF12282E1553L;
        if (pyClass == null) {
            AppEngineUtil.a(5);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        List<PyTargetExpression> list2 = pyClass.getClassAttributes();
        for (PyTargetExpression pyTargetExpression : list2) {
            String string = pyTargetExpression.getName();
            QualifiedName qualifiedName = pyTargetExpression.getCalleeName();
            if (string == null || qualifiedName == null || !qualifiedName.toString().endsWith("Property") || qualifiedName.endsWith("SelfReferenceProperty") || qualifiedName.endsWith("ReferenceProperty")) continue;
            String string2 = qualifiedName.getLastComponent();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    @Nullable
    public static Module getModule(@NotNull AnActionEvent e10) {
        Module module2;
        if (e10 == null) {
            AppEngineUtil.a(6);
        }
        if ((module2 = (Module)e10.getData(LangDataKeys.MODULE)) != null) {
            return module2;
        }
        Project project = (Project)e10.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return null;
        }
        Module[] moduleArray = ModuleManager.getInstance((Project)project).getModules();
        if (moduleArray.length == 0) {
            return null;
        }
        return moduleArray[0];
    }

    static {
        g = com.jetbrains.python.psi.c.a(5629468720262015862L, 7365496880381739963L, MethodHandles.lookup().lookupClass()).a(107959941827069L);
        long l2 = g ^ 0x4A988DB186E9L;
        f = Logger.getInstance((String)"#com.jetbrains.appengine.util.AppEngineUtil");
        APPENGINE_LIBRARY_NAME = AppEngineBundle.message("app-engine-sdk", new Object[0]);
        d = new String[]{"django", "webapp2", "webob", "yaml"};
        c = new String[]{"django-1.5", "django-1.4", "django_1_3", "django_1_2", "django"};
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = g ^ 0x59B97C99C2EL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkPath";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/appengine/util/AppEngineUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getAppEngineComponent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "validateSdk";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndex";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getProjectRootFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getAppEngineModule";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getProperties";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getModule";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class VersionedLibrary {
        final String myName;
        final TreeMap<String, File> myVersionPaths = new TreeMap(VersionComparatorUtil.COMPARATOR);
        private static final long a = com.jetbrains.python.psi.c.a(-6575987959825318926L, 2613115835708868394L, MethodHandles.lookup().lookupClass()).a(251059160041667L);

        VersionedLibrary(String name) {
            this.myName = name;
        }

        public void addPath(File directory2) {
            String string = directory2.getName().substring(this.myName.length());
            if (string.startsWith("-") || string.startsWith("_")) {
                string = string.substring(1);
            }
            this.myVersionPaths.put(string.replace("_", "."), directory2);
        }

        public String getPathForVersion(String version) {
            long l2 = a ^ 0x113F65810649L;
            if (this.myVersionPaths.isEmpty()) {
                return null;
            }
            if (version == null || version.equalsIgnoreCase("latest")) {
                return this.myVersionPaths.get(this.myVersionPaths.lastKey()).getPath();
            }
            File file = this.myVersionPaths.get(version);
            return file != null ? file.getPath() : null;
        }
    }

    private static class ConfigFileFinder
    implements Processor<VirtualFile> {
        private VirtualFile a;
        private static final long b = com.jetbrains.python.psi.c.a(-5524313883939123116L, -8474129387575507314L, MethodHandles.lookup().lookupClass()).a(170118827736162L);

        private ConfigFileFinder() {
        }

        public boolean process(VirtualFile file) {
            long l2 = b ^ 0x66058D2FD3BL;
            if (!file.isDirectory() && "app.yaml".equals(file.getName())) {
                this.a = file;
                return false;
            }
            return true;
        }

        /* synthetic */ ConfigFileFinder(a x0) {
            this();
        }
    }
}

