/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.jetbrains.python.psi.c;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditLibraryDialog
extends DialogWrapper {
    private static final int h = 0;
    private static final int d = 1;
    private final String l;
    private final String c;
    private static final Comparator<VirtualFilePointer> e;
    private JPanel x;
    private JTextField q;
    private final JBTable m;
    private final JBList<String> f;
    private JComboBox a;
    private JTextField o;
    private JRadioButton t;
    private JRadioButton k;
    private JPanel v;
    private JPanel s;
    private final Project b;
    private final FileTableModel g;
    private final LangScriptingContextProvider u;
    private final MyDocUrlListModel y;
    private ScriptingFrameworkDescriptor i;
    private final Icon r;
    private final Icon w;
    private final AnActionButton n;
    private final AnActionButton p;
    private final FileChooserDescriptor j;
    private static final long z;

    public EditLibraryDialog(String title, LangScriptingContextProvider provider, Project project) {
        long l2 = z ^ 0x54E04837F8A4L;
        super(true);
        this.h();
        this.j = new FileChooserDescriptor(this, true, true, false, true, false, true){
            final /* synthetic */ EditLibraryDialog this$0;
            private static final long a = com.jetbrains.python.psi.c.a(5339375299598685541L, 2270672388581545466L, MethodHandles.lookup().lookupClass()).a(268343622237804L);
            {
                long l2 = a ^ 0x23338C457F39L;
                this.this$0 = this$0;
                super(x0, x1, x2, x3, x4, x5);
                this.setTitle(WebCoreBundle.message((String)"edit.library.attach.files.dialog.title", (Object[])new Object[0]));
            }

            public boolean isFileSelectable(VirtualFile file) {
                if (!file.isDirectory() && !this.this$0.u.acceptsExtension(file.getExtension())) {
                    return false;
                }
                return super.isFileSelectable(file);
            }

            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                if (!file.isDirectory() && !this.this$0.u.acceptsExtension(file.getExtension())) {
                    return false;
                }
                return super.isFileVisible(file, showHiddenFiles);
            }
        };
        this.r = provider.getFileIcon();
        this.w = AllIcons.Nodes.Folder;
        this.u = provider;
        this.b = project;
        this.m = new JBTable();
        this.m.setStriped(true);
        this.m.setUpdateSelectionOnSort(true);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)this.m).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                List list2 = EditLibraryDialog.this.i();
                if (list2.isEmpty()) {
                    return;
                }
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup(list2.toArray(AnAction.EMPTY_ARRAY));
                ListPopup listPopup = JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)defaultActionGroup, DataManager.getInstance().getDataContext((Component)button.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
                RelativePoint relativePoint = button.getPreferredPopupPoint();
                if (relativePoint != null) {
                    listPopup.show(relativePoint);
                } else {
                    listPopup.showInBestPositionFor(button.getDataContext());
                }
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                EditLibraryDialog.this.a();
            }
        }).createPanel();
        this.v.add((Component)jPanel, "Center");
        this.setTitle(title);
        this.l = Objects.requireNonNull(provider.getLibraryTypeName(OrderRootType.SOURCES));
        this.c = Objects.requireNonNull(provider.getLibraryTypeName(OrderRootType.CLASSES));
        this.g = new FileTableModel();
        this.m.setRowHeight((int)((double)this.m.getRowHeight() * 1.2));
        this.m.setModel((TableModel)this.g);
        new TableSpeedSearch((JTable)this.m);
        this.y = new MyDocUrlListModel();
        this.f = new JBList((ListModel)this.y);
        this.y.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e10) {
                EditLibraryDialog.this.g();
            }

            @Override
            public void intervalRemoved(ListDataEvent e10) {
                Object object = e10.getSource();
                if (object instanceof MyDocUrlListModel && ((MyDocUrlListModel)object).getDocUrls().length == 0) {
                    EditLibraryDialog.this.g();
                }
            }

            @Override
            public void contentsChanged(ListDataEvent e10) {
            }
        });
        this.f.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e10) {
                EditLibraryDialog.this.p.setEnabled(EditLibraryDialog.this.f.getSelectedIndex() >= 0);
            }
        });
        this.n = new AnActionButton("Download", AllIcons.Actions.Download){
            private static final long a = com.jetbrains.python.psi.c.a(-7319528734463616340L, 9174572657270344760L, MethodHandles.lookup().lookupClass()).a(126409950473312L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    5.a(0);
                }
                EditLibraryDialog.this.c();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x7AD18642FBEDL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$5", "actionPerformed"));
            }
        };
        this.p = new AnActionButton("Edit", AllIcons.Actions.Edit){
            private static final long a = com.jetbrains.python.psi.c.a(8537500084851526266L, -1466835025695858282L, MethodHandles.lookup().lookupClass()).a(51941833723487L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    6.a(0);
                }
                EditLibraryDialog.this.d();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x66E1B29D7BB5L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$6", "actionPerformed"));
            }
        };
        this.s.add((Component)ToolbarDecorator.createDecorator(this.f).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditLibraryDialog.this.f();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                EditLibraryDialog.this.l();
            }
        }).addExtraAction(this.p).addExtraAction(this.n).createPanel(), "Center");
        this.n.setEnabled(false);
        this.p.setEnabled(false);
        this.e();
        this.o.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e10) {
                EditLibraryDialog.this.b();
            }
        });
        this.init();
        TableColumn tableColumn = this.m.getColumnModel().getColumn(1);
        tableColumn.setMaxWidth(80);
        tableColumn.setCellEditor((TableCellEditor)((Object)new TypeCellEditor()));
        tableColumn.setCellRenderer(new DefaultTableCellRenderer(){
            private final JBComboBoxLabel a = new JBComboBoxLabel();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                VirtualFilePointer virtualFilePointer = EditLibraryDialog.this.g.b(row);
                VirtualFile virtualFile = EditLibraryDialog.a(virtualFilePointer);
                if (virtualFile == null || virtualFile.isDirectory()) {
                    this.a.setText("");
                    this.a.setIcon(null);
                } else {
                    this.a.setText(String.valueOf(value));
                    if (isSelected) {
                        this.a.setSelectionIcon();
                    } else {
                        this.a.setRegularIcon();
                    }
                }
                this.a.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                this.a.setForeground(isSelected ? table.getSelectionForeground() : table.getForeground());
                return this.a;
            }
        });
        TableColumn tableColumn2 = this.m.getColumnModel().getColumn(0);
        tableColumn2.setCellRenderer(new FileNameTableCellRenderer());
    }

    @NotNull
    private List<AnAction> i() {
        long l2 = z ^ 0x655638A1E631L;
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new AnAction[]{new AnAction(WebCoreBundle.message((String)"edit.library.attach.files.popup.title", (Object[])new Object[0]), null, this.r){
            private static final long a = com.jetbrains.python.psi.c.a(-3494389438065222210L, 4051673102921097561L, MethodHandles.lookup().lookupClass()).a(158955227775039L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    11.a(0);
                }
                EditLibraryDialog.this.m();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x5B3D77902FE1L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$11", "actionPerformed"));
            }
        }, new AnAction(WebCoreBundle.message((String)"edit.library.attach.directories.popup.title", (Object[])new Object[0]), null, this.w){
            private static final long a = com.jetbrains.python.psi.c.a(4122676469939466448L, 8783105184197955148L, MethodHandles.lookup().lookupClass()).a(144841240624108L);

            public void actionPerformed(@NotNull AnActionEvent e10) {
                if (e10 == null) {
                    12.a(0);
                }
                EditLibraryDialog.this.k();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x67FF1DF5482L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$12", "actionPerformed"));
            }
        }});
        if (arrayList == null) {
            EditLibraryDialog.a(0);
        }
        return arrayList;
    }

    public EditLibraryDialog(String title, LangScriptingContextProvider provider, Project project, ScriptingLibraryModel lib) {
        this(title, provider, project);
        this.q.setText(lib.getName());
        this.g.setFiles(lib.getSourceFilePointers(), lib.getCompactFilePointers());
        Set set = lib.getDocUrls();
        this.y.setDocUrls(set);
        if (lib.getFrameworkDescriptor() != null) {
            this.a(lib.getFrameworkDescriptor());
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.t);
        buttonGroup.add(this.k);
        if (lib.getLibraryLevel() == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
            this.k.setSelected(true);
        } else {
            this.t.setSelected(true);
        }
        this.g();
    }

    private void a(ScriptingFrameworkDescriptor scriptingFrameworkDescriptor) {
        this.i = scriptingFrameworkDescriptor;
        this.o.setText(scriptingFrameworkDescriptor.getFrameworkVersion());
        for (int i10 = 0; i10 < this.a.getItemCount(); ++i10) {
            Object e10 = this.a.getItemAt(i10);
            if (!(e10 instanceof ScriptingFrameworkDescriptor) || !scriptingFrameworkDescriptor.getFrameworkName().equals(((ScriptingFrameworkDescriptor)e10).getFrameworkName())) continue;
            this.a.setSelectedItem(e10);
        }
    }

    private void g() {
        for (String string : this.getDocUrls()) {
            if (this.u.getOfflineDocUrl(string) == null) continue;
            this.n.setEnabled(true);
            return;
        }
        this.n.setEnabled(false);
    }

    private void e() {
        long l2 = z ^ 0x3C8E51DC42C6L;
        ArrayList<String> arrayList = new ArrayList<String>();
        ScriptingFrameworkDescriptor[] scriptingFrameworkDescriptorArray = this.u.getSupportedFrameworks(this.b);
        arrayList.add(new String("<Custom>"));
        if (scriptingFrameworkDescriptorArray != null) {
            arrayList.addAll(Arrays.asList(scriptingFrameworkDescriptorArray));
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(arrayList));
        this.a.setModel(defaultComboBoxModel);
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                Object object = EditLibraryDialog.this.a.getSelectedItem();
                if (object instanceof ScriptingFrameworkDescriptor) {
                    String string = ((ScriptingFrameworkDescriptor)object).getFrameworkName();
                    if (EditLibraryDialog.this.i == null || !string.equals(EditLibraryDialog.this.i.getFrameworkName())) {
                        EditLibraryDialog.this.i = new ScriptingFrameworkDescriptor(((ScriptingFrameworkDescriptor)object).getFrameworkName(), null);
                        EditLibraryDialog.this.o.setText("");
                    }
                } else {
                    EditLibraryDialog.this.i = null;
                    EditLibraryDialog.this.o.setText("");
                }
            }
        });
    }

    private void c() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (String string : this.getDocUrls()) {
            String string2 = this.u.getOfflineDocUrl(string);
            if (string2 == null) continue;
            linkedHashSet.add(string2);
        }
        this.a(new LinkedList<String>(linkedHashSet), this.getRootPane());
    }

    private void a(@NotNull Queue<String> queue2, @Nullable Component component) {
        if (queue2 == null) {
            EditLibraryDialog.a(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string = queue2.poll();
        if (string != null) {
            this.u.downloadOfflineDoc(this.b, string, component, (Consumer<? super File>)((Consumer)file -> {
                AtomicBoolean atomicBoolean = new AtomicBoolean(true);
                if (file != null) {
                    WriteAction.run(() -> {
                        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                        if (virtualFile != null) {
                            atomicBoolean.set(false);
                            this.y.addUrl(virtualFile.getUrl());
                        }
                    });
                }
                if (atomicBoolean.get()) {
                    this.a(queue2, component);
                }
            }));
        }
    }

    protected JComponent createCenterPanel() {
        return this.x;
    }

    public String getLibName() {
        return this.q.getText();
    }

    private void m() {
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)this.j, (Project)this.b, null);
        if (virtualFileArray.length == 0) {
            return;
        }
        VfsUtilCore.DistinctVFilesRootsCollection distinctVFilesRootsCollection = new VfsUtilCore.DistinctVFilesRootsCollection(virtualFileArray);
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : distinctVFilesRootsCollection) {
            if (!virtualFile.isValid()) continue;
            if (virtualFile.isDirectory()) {
                this.a(virtualFile, arrayList);
                continue;
            }
            arrayList.add(virtualFile);
        }
        this.a(arrayList);
    }

    private void k() {
        long l2 = z ^ 0x2E21D941BA18L;
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createMultipleFoldersDescriptor();
        fileChooserDescriptor.setTitle(WebCoreBundle.message((String)"edit.library.dialog.attach.directories.dialog.title", (Object[])new Object[0]));
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)this.b, null);
        if (virtualFileArray.length == 0) {
            return;
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : virtualFileArray) {
            if (!virtualFile.isValid()) continue;
            arrayList.add(virtualFile);
        }
        this.a(arrayList);
    }

    private void a(@NotNull List<VirtualFile> list2) {
        if (list2 == null) {
            EditLibraryDialog.a(2);
        }
        this.b(ContainerUtil.map(list2, virtualFile -> new LightFilePointer(virtualFile)));
    }

    private void b(@NotNull List<VirtualFilePointer> list2) {
        if (list2 == null) {
            EditLibraryDialog.a(3);
        }
        Collections.sort(list2, e);
        int n2 = 0;
        for (VirtualFilePointer virtualFilePointer2 : list2) {
            this.a(virtualFilePointer2, n2++ == list2.size() - 1);
        }
        this.j();
        if (this.q.getText().isEmpty() && !list2.isEmpty()) {
            list2.stream().map(virtualFilePointer -> virtualFilePointer.getFileName()).findFirst().ifPresent(string -> this.q.setText((String)string));
        }
    }

    private void a(VirtualFile virtualFile, final Collection<VirtualFile> collection) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){
            private static final long a = com.jetbrains.python.psi.c.a(-8783315746200604038L, -3168437354898756726L, MethodHandles.lookup().lookupClass()).a(238369382593785L);

            public boolean visitFile(@NotNull VirtualFile file) {
                if (file == null) {
                    14.a(0);
                }
                if (file.isValid() && !file.isDirectory() && EditLibraryDialog.this.u.acceptsExtension(file.getExtension())) {
                    collection.add(file);
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x20EEE092FCFBL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ui/EditLibraryDialog$14", "visitFile"));
            }
        });
    }

    private void a(@NotNull VirtualFilePointer virtualFilePointer, boolean bl2) {
        if (virtualFilePointer == null) {
            EditLibraryDialog.a(4);
        }
        int n2 = this.g.a(virtualFilePointer);
        this.m.setRowSelectionInterval(n2, n2);
        if (bl2) {
            TableUtil.scrollSelectionToVisible((JTable)this.m);
        }
    }

    @Nullable
    private static VirtualFile a(@Nullable VirtualFilePointer virtualFilePointer) {
        return virtualFilePointer != null ? virtualFilePointer.getFile() : null;
    }

    private void a() {
        int[] nArray = this.m.getSelectedRows();
        ArrayList<VirtualFilePointer> arrayList = new ArrayList<VirtualFilePointer>();
        for (int n2 : nArray) {
            arrayList.add(this.g.b(n2));
        }
        this.g.a(arrayList);
    }

    @NotNull
    public List<String> getSourceFileUrls() {
        List list2 = ContainerUtil.map((Collection)this.g.a(), VirtualFilePointer::getUrl);
        if (list2 == null) {
            EditLibraryDialog.a(5);
        }
        return list2;
    }

    @NotNull
    public List<String> getCompactFileUrls() {
        List list2 = ContainerUtil.map(this.g.getCompactFilePointers(), VirtualFilePointer::getUrl);
        if (list2 == null) {
            EditLibraryDialog.a(6);
        }
        return list2;
    }

    public String[] getDocUrls() {
        return this.y.getDocUrls();
    }

    protected void doOKAction() {
        long l2 = z ^ 0x5691BC4BC9FFL;
        if (!EditLibraryDialog.b(this.q.getText())) {
            Messages.showErrorDialog((Project)this.b, (String)IdeBundle.message((String)"scripting.lib.invalid.name", (Object[])new Object[0]), (String)"Error");
            return;
        }
        super.doOKAction();
    }

    private static boolean b(String string) {
        long l2 = z ^ 0x4A5361805132L;
        return string != null && string.matches("\\w[\\w\\d\\._\\-\\d ]*");
    }

    private void d() {
        String string = (String)this.f.getSelectedValue();
        int n2 = this.f.getSelectedIndex();
        VirtualFile virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.x, (String)string);
        if (virtualFile != null && virtualFile.isValid()) {
            String string2 = virtualFile.getUrl();
            this.y.replaceUrl(string, string2);
            this.f.ensureIndexIsVisible(n2);
            this.f.setSelectedIndex(n2);
            this.g();
        }
    }

    private void f() {
        VirtualFile virtualFile;
        String string = null;
        if (this.i == null) {
            this.j();
        }
        if (this.i != null) {
            string = this.n();
        }
        if ((virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.x, (String)(string != null ? string : ""))) != null && virtualFile.isValid()) {
            String string2 = virtualFile.getUrl();
            int n2 = this.y.addUrl(string2);
            this.f.ensureIndexIsVisible(n2);
            this.f.setSelectedIndex(n2);
            this.g();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.q;
    }

    @Nullable
    private String n() {
        String string = this.u.getDefaultDocUrl(this.i);
        if (string != null && !this.y.contains(string)) {
            return string;
        }
        return null;
    }

    private void l() {
        this.y.remove((String)this.f.getSelectedValue());
    }

    @Nullable
    public ScriptingFrameworkDescriptor getSelectedFramework() {
        return this.i;
    }

    private void j() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(ContainerUtil.map(this.g.getCompactFilePointers(), virtualFilePointer -> virtualFilePointer.getFile()));
        arrayList.addAll(ContainerUtil.map((Collection)this.g.a(), virtualFilePointer -> virtualFilePointer.getFile()));
        for (VirtualFile virtualFile : arrayList) {
            ScriptingFrameworkDescriptor scriptingFrameworkDescriptor = this.u.detectFramework(virtualFile);
            if (scriptingFrameworkDescriptor == null) continue;
            this.o.setText(scriptingFrameworkDescriptor.getFrameworkVersion());
            this.a(scriptingFrameworkDescriptor);
            if (this.q.getText().isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(scriptingFrameworkDescriptor.getFrameworkName());
                if (scriptingFrameworkDescriptor.getFrameworkVersion() != null) {
                    stringBuilder.append(' ').append(scriptingFrameworkDescriptor.getFrameworkVersion());
                }
                this.q.setText(stringBuilder.toString());
            }
            return;
        }
    }

    private void b() {
        if (this.i != null) {
            this.i.setFrameworkVersion(this.o.getText());
        }
    }

    @NotNull
    public ScriptingLibraryModel.LibraryLevel getLibraryLevel() {
        ScriptingLibraryModel.LibraryLevel libraryLevel = this.k.isSelected() ? ScriptingLibraryModel.LibraryLevel.GLOBAL : ScriptingLibraryModel.LibraryLevel.PROJECT;
        if (libraryLevel == null) {
            EditLibraryDialog.a(7);
        }
        return libraryLevel;
    }

    static /* synthetic */ Comparator access$2700() {
        return e;
    }

    static {
        z = com.jetbrains.python.psi.c.a(-1419939232398533991L, -7266730954626012766L, MethodHandles.lookup().lookupClass()).a(210012250756234L);
        e = (virtualFilePointer, virtualFilePointer2) -> virtualFilePointer.getUrl().compareToIgnoreCase(virtualFilePointer2.getUrl());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = z ^ 0x2D1CAA867AB9L;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ui/EditLibraryDialog";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToAdd";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePointer";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddFilesActions";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ui/EditLibraryDialog";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceFileUrls";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompactFileUrls";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryLevel";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processUrlQueue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFiles";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addFilePointers";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSingleFilePointer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void h() {
        JPanel jPanel;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextField jTextField;
        JComboBox jComboBox;
        JTextField jTextField2;
        JPanel jPanel3;
        long l2 = z ^ 0x29495766D269L;
        this.x = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.q = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.a(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("scripting.lib.name"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Framework type:");
        jLabel2.setDisplayedMnemonic('F');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.a = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Version:");
        jLabel3.setDisplayedMnemonic('V');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.o = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(55, -1), new Dimension(55, -1)));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Visibility:");
        jPanel4.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 1, 1, 4, 0, 3, 3, 3, null, null, null));
        this.t = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Project");
        jRadioButton2.setMnemonic('P');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.k = jRadioButton = new JRadioButton();
        jRadioButton.setText("Global");
        jRadioButton.setMnemonic('G');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.v = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 7, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 2, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/IdeBundle").getString("scripting.lib.docUrl.title"), (int)0, (int)0, null, null));
        this.s = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.x;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c10 = '\u0000';
        int n2 = -1;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) == '&') {
                if (++i10 == string.length()) break;
                if (!bl2 && string.charAt(i10) != '&') {
                    bl2 = true;
                    c10 = string.charAt(i10);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i10));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c10);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private static class MyDocUrlListModel
    extends AbstractListModel<String> {
        private final List<String> a = new ArrayList<String>();

        private MyDocUrlListModel() {
        }

        public void setDocUrls(Set<String> urls) {
            if (urls != null && urls.size() > 0) {
                this.a.addAll(urls);
            }
        }

        @Override
        public int getSize() {
            return this.a.size();
        }

        @Override
        public String getElementAt(int index) {
            return this.a.get(index);
        }

        public int addUrl(String url) {
            if (!this.a.contains(url)) {
                this.a.add(url);
                int n2 = this.a.indexOf(url);
                this.fireIntervalAdded(this, n2, n2);
                return n2;
            }
            return this.a.indexOf(url);
        }

        public void replaceUrl(String oldUrl, String newUrl) {
            if (oldUrl == null || !this.a.contains(oldUrl)) {
                return;
            }
            int n2 = this.a.indexOf(oldUrl);
            this.a.remove(oldUrl);
            this.a.add(n2, newUrl);
        }

        public int indexOf(String url) {
            return this.a.indexOf(url);
        }

        public void remove(String url) {
            if (url == null || !this.a.contains(url)) {
                return;
            }
            int n2 = this.a.indexOf(url);
            this.a.remove(url);
            this.fireIntervalRemoved(this, n2, n2);
        }

        public boolean contains(String url) {
            return this.a.contains(url);
        }

        public String[] getDocUrls() {
            return ArrayUtilRt.toStringArray(this.a);
        }
    }

    private class FileTableModel
    extends AbstractTableModel {
        private final SortedList<VirtualFilePointer> b = new SortedList(EditLibraryDialog.access$2700());
        private final Set<VirtualFilePointer> a = new HashSet<VirtualFilePointer>();
        private static final long c = com.jetbrains.python.psi.c.a(-7840731551894211651L, 1743538722109545240L, MethodHandles.lookup().lookupClass()).a(184292054128833L);

        private FileTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            long l2 = c ^ 0x9E86DA37209L;
            switch (column) {
                case 0: {
                    return IdeBundle.message((String)"scripting.lib.file.name", (Object[])new Object[0]);
                }
                case 1: {
                    return IdeBundle.message((String)"scripting.lib.file.type", (Object[])new Object[0]);
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            VirtualFilePointer virtualFilePointer;
            VirtualFile virtualFile;
            return columnIndex == 1 && (virtualFile = EditLibraryDialog.a(virtualFilePointer = this.b(rowIndex))) != null && !virtualFile.isDirectory();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            VirtualFilePointer virtualFilePointer;
            if (columnIndex == 1 && (virtualFilePointer = EditLibraryDialog.this.g.b(rowIndex)) != null && aValue instanceof String) {
                this.a(virtualFilePointer, EditLibraryDialog.this.c.equals(aValue));
            }
        }

        private int a(@NotNull VirtualFilePointer virtualFilePointer) {
            int n2;
            if (virtualFilePointer == null) {
                FileTableModel.a(0);
            }
            if ((n2 = this.b.indexOf((Object)virtualFilePointer)) == -1) {
                this.b.add((Object)virtualFilePointer);
                VirtualFile virtualFile = virtualFilePointer.getFile();
                if (virtualFile != null && !virtualFile.isDirectory() && EditLibraryDialog.this.u.isCompact(virtualFile)) {
                    this.a.add(virtualFilePointer);
                }
                this.fireTableDataChanged();
                n2 = this.b.indexOf((Object)virtualFilePointer);
            }
            return n2;
        }

        public void setFiles(@NotNull Set<VirtualFilePointer> sourceFilePointers, @NotNull Set<VirtualFilePointer> compactFilePointers) {
            if (sourceFilePointers == null) {
                FileTableModel.a(1);
            }
            if (compactFilePointers == null) {
                FileTableModel.a(2);
            }
            this.b.clear();
            this.b.addAll(sourceFilePointers);
            this.b.addAll(compactFilePointers);
            for (VirtualFilePointer virtualFilePointer : sourceFilePointers) {
                this.a(virtualFilePointer, false, false);
            }
            for (VirtualFilePointer virtualFilePointer : compactFilePointers) {
                this.a(virtualFilePointer, true, false);
            }
        }

        private void a(@NotNull VirtualFilePointer virtualFilePointer, boolean bl2) {
            if (virtualFilePointer == null) {
                FileTableModel.a(3);
            }
            this.a(virtualFilePointer, bl2, true);
        }

        private void a(@NotNull VirtualFilePointer virtualFilePointer, boolean bl2, boolean bl3) {
            if (virtualFilePointer == null) {
                FileTableModel.a(4);
            }
            boolean bl4 = false;
            VirtualFile virtualFile = virtualFilePointer.getFile();
            if (virtualFile != null && virtualFile.isValid() && virtualFile.isDirectory()) {
                bl2 = false;
            }
            if (bl2) {
                if (!this.a.contains(virtualFilePointer)) {
                    this.a.add(virtualFilePointer);
                    bl4 = true;
                }
            } else if (this.a.contains(virtualFilePointer)) {
                this.a.remove(virtualFilePointer);
                bl4 = true;
            }
            if (bl4 && bl3) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getRowCount() {
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            VirtualFilePointer virtualFilePointer = (VirtualFilePointer)this.b.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return virtualFilePointer.getFileName();
                }
                case 1: {
                    return this.a.contains(virtualFilePointer) ? EditLibraryDialog.this.c : EditLibraryDialog.this.l;
                }
            }
            return "";
        }

        @Nullable
        private VirtualFilePointer b(int n2) {
            if (n2 < 0 || n2 >= this.b.size()) {
                return null;
            }
            return (VirtualFilePointer)this.b.get(n2);
        }

        private void a(@NotNull List<VirtualFilePointer> list2) {
            if (list2 == null) {
                FileTableModel.a(5);
            }
            if (this.b.removeAll(list2)) {
                this.fireTableDataChanged();
            }
        }

        @NotNull
        private List<VirtualFilePointer> a(boolean bl2) {
            ArrayList<VirtualFilePointer> arrayList = new ArrayList<VirtualFilePointer>();
            for (VirtualFilePointer virtualFilePointer : this.b) {
                if (this.a.contains(virtualFilePointer) != bl2) continue;
                arrayList.add(virtualFilePointer);
            }
            ArrayList<VirtualFilePointer> arrayList2 = arrayList;
            if (arrayList2 == null) {
                FileTableModel.a(6);
            }
            return arrayList2;
        }

        @NotNull
        public List<VirtualFilePointer> getCompactFilePointers() {
            List<VirtualFilePointer> list2 = this.a(true);
            if (list2 == null) {
                FileTableModel.a(7);
            }
            return list2;
        }

        @NotNull
        private List<VirtualFilePointer> a() {
            List<VirtualFilePointer> list2 = this.a(false);
            if (list2 == null) {
                FileTableModel.a(8);
            }
            return list2;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = c ^ 0x7DCBD4B03053L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePointer";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sourceFilePointers";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "compactFilePointers";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePointers";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/libraries/ui/EditLibraryDialog$FileTableModel";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/libraries/ui/EditLibraryDialog$FileTableModel";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFilePointers";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompactFilePointers";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSourceFilePointers";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addFilePointer";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setFiles";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "setFileType";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeFilePointers";
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 8: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class TypeCellEditor
    extends AbstractTableCellEditor {
        private final JBComboBoxTableCellEditorComponent a = new JBComboBoxTableCellEditorComponent();

        TypeCellEditor() {
            this.a.setOptions(new Object[]{EditLibraryDialog.this.l, EditLibraryDialog.this.c});
            this.a.setToString(object -> (String)object);
        }

        public Object getCellEditorValue() {
            return this.a.getEditorValue();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            VirtualFilePointer virtualFilePointer = EditLibraryDialog.this.g.b(row);
            this.a.setCell(table, row, column);
            if (virtualFilePointer != null) {
                Object object = EditLibraryDialog.this.g.getValueAt(row, 1);
                this.a.setDefaultValue(object);
            }
            return this.a;
        }
    }

    private class FileNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private FileNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setForeground(null);
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            VirtualFilePointer virtualFilePointer = EditLibraryDialog.this.g.b(row);
            if (virtualFilePointer != null) {
                this.setToolTipText(virtualFilePointer.getPresentableUrl());
                VirtualFile virtualFile = EditLibraryDialog.a(virtualFilePointer);
                this.setIcon(virtualFile == null ? AllIcons.FileTypes.Unknown : (virtualFile.isDirectory() ? EditLibraryDialog.this.w : EditLibraryDialog.this.r));
                if (!(virtualFile != null && virtualFile.isValid() || isSelected)) {
                    this.setForeground((Color)JBColor.red);
                }
            }
            this.setBorder(null);
            return component;
        }
    }
}

