/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.ui.BaseModifiableControl;
import com.intellij.util.xml.ui.DomWrapper;
import com.jetbrains.python.psi.c;
import java.awt.Color;
import java.awt.Component;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public abstract class EditorTextFieldControl<T extends JComponent>
extends BaseModifiableControl<T, String> {
    private static final JTextField a;
    private final boolean b;
    private final DocumentListener c = new DocumentListener(){
        private static final long a = com.jetbrains.python.psi.c.a(2777051240441700375L, 4587064461796276679L, MethodHandles.lookup().lookupClass()).a(206079734154826L);

        public void documentChanged(@NotNull DocumentEvent e10) {
            if (e10 == null) {
                2.a(0);
            }
            EditorTextFieldControl.this.setModified();
            if (EditorTextFieldControl.this.b) {
                EditorTextFieldControl.this.commit();
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0xF8026F0FFF7L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/xml/ui/EditorTextFieldControl$2", "documentChanged"));
        }
    };
    private static final long d;

    protected EditorTextFieldControl(DomWrapper<String> domWrapper, boolean commitOnEveryChange) {
        super(domWrapper);
        this.b = commitOnEveryChange;
    }

    protected EditorTextFieldControl(DomWrapper<String> domWrapper) {
        this(domWrapper, false);
    }

    protected abstract EditorTextField getEditorTextField(@NotNull T var1);

    protected void doReset() {
        EditorTextField editorTextField = this.getEditorTextField(this.getComponent());
        editorTextField.getDocument().removeDocumentListener(this.c);
        super.doReset();
        editorTextField.getDocument().addDocumentListener(this.c);
    }

    protected JComponent getComponentToListenFocusLost(T component) {
        return this.getEditorTextField(this.getComponent());
    }

    protected JComponent getHighlightedComponent(T component) {
        return a;
    }

    protected T createMainComponent(T boundedComponent) {
        Project project = this.getProject();
        boundedComponent = this.createMainComponent(boundedComponent, project);
        EditorTextField editorTextField = this.getEditorTextField(boundedComponent);
        editorTextField.setSupplementary(true);
        editorTextField.getDocument().addDocumentListener(this.c);
        return boundedComponent;
    }

    protected abstract T createMainComponent(T var1, Project var2);

    @NotNull
    protected String getValue() {
        String string = this.getEditorTextField(this.getComponent()).getText();
        if (string == null) {
            EditorTextFieldControl.a(0);
        }
        return string;
    }

    protected void setValue(String value) {
        CommandProcessor.getInstance().runUndoTransparentAction(() -> WriteAction.run(() -> {
            JComponent jComponent = this.getComponent();
            Document document = this.getEditorTextField(jComponent).getDocument();
            document.replaceString(0, document.getTextLength(), (CharSequence)(value == null ? "" : value));
        }));
    }

    protected void updateComponent() {
        DomElement domElement = this.getDomElement();
        if (domElement == null || !domElement.isValid()) {
            return;
        }
        EditorTextField editorTextField = this.getEditorTextField(this.getComponent());
        Project project = this.getProject();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (!project.isOpen()) {
                return;
            }
            if (!this.getDomWrapper().isValid()) {
                return;
            }
            DomElement domElement = this.getDomElement();
            if (domElement == null || !domElement.isValid()) {
                return;
            }
            DomElementAnnotationsManager domElementAnnotationsManager = DomElementAnnotationsManager.getInstance((Project)project);
            DomElementsProblemsHolder domElementsProblemsHolder = domElementAnnotationsManager.getCachedProblemHolder(domElement);
            List list2 = domElementsProblemsHolder.getProblems(domElement);
            ArrayList arrayList = new ArrayList(domElementsProblemsHolder.getProblems(domElement, true, HighlightSeverity.WARNING));
            arrayList.removeAll(list2);
            Color color = this.getDefaultBackground();
            if (list2.size() > 0 && editorTextField.getText().trim().length() == 0) {
                color = this.getErrorBackground();
            } else if (arrayList.size() > 0) {
                color = this.getWarningBackground();
            }
            Editor editor2 = editorTextField.getEditor();
            if (editor2 != null) {
                MarkupModel markupModel = editor2.getMarkupModel();
                markupModel.removeAllHighlighters();
                if (!list2.isEmpty() && editor2.getDocument().getLineCount() > 0) {
                    TextAttributes textAttributes = SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes();
                    textAttributes.setEffectType(EffectType.WAVE_UNDERSCORE);
                    textAttributes.setEffectColor(textAttributes.getForegroundColor());
                    markupModel.addLineHighlighter(0, 0, textAttributes);
                    editor2.getContentComponent().setToolTipText(((DomElementProblemDescriptor)list2.get(0)).getDescriptionTemplate());
                }
            }
            editorTextField.setBackground(color);
        });
    }

    public boolean canNavigate(DomElement element) {
        return this.getDomElement().equals(element);
    }

    public void navigate(DomElement element) {
        EditorTextField editorTextField = this.getEditorTextField(this.getComponent());
        SwingUtilities.invokeLater(() -> {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)editorTextField, true));
            editorTextField.selectAll();
        });
    }

    static {
        d = com.jetbrains.python.psi.c.a(3041590231090088113L, 8192339677745108175L, MethodHandles.lookup().lookupClass()).a(121251181862767L);
        a = new JTextField(){
            private static final long a = com.jetbrains.python.psi.c.a(5629305795387176629L, -5574980487326612103L, MethodHandles.lookup().lookupClass()).a(229436588673437L);

            @Override
            public void addNotify() {
                long l2 = a ^ 0x2CA6E084B8C6L;
                throw new UnsupportedOperationException("Shouldn't be shown");
            }

            @Override
            public void setVisible(boolean aFlag) {
                long l2 = a ^ 0x20F3D25994AEL;
                throw new UnsupportedOperationException("Shouldn't be shown");
            }
        };
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = d ^ 0xA4558C471F3L;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/util/xml/ui/EditorTextFieldControl", "getValue"));
    }
}

