/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionAssignabilityCache;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import com.intellij.util.xml.impl.DomFileMetaData;
import com.intellij.util.xml.impl.DomImplementationClassEP;
import com.intellij.util.xml.impl.ImplementationClassCache;
import com.intellij.util.xml.impl.InvocationCache;
import com.intellij.util.xml.impl.StaticGenericInfo;
import com.intellij.util.xml.impl.VisitorDescription;
import gnu.trove.THashSet;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class DomApplicationComponent {
    private final MultiMap<String, DomFileMetaData> f = MultiMap.createSet();
    private final Set<DomFileMetaData> c = new THashSet();
    private final ImplementationClassCache g = new ImplementationClassCache(DomImplementationClassEP.EP_NAME);
    private final TypeChooserManager b = new TypeChooserManager();
    final ReflectionAssignabilityCache assignabilityCache = new ReflectionAssignabilityCache();
    private final Map<Class, DomElementsAnnotator> e = ConcurrentFactoryMap.createMap(clazz -> {
        DomFileDescription domFileDescription = this.a((Class)clazz);
        return domFileDescription == null ? null : domFileDescription.createAnnotator();
    });
    private final Map<Class, InvocationCache> d = ConcurrentFactoryMap.create(InvocationCache::new, ContainerUtil::createConcurrentSoftValueMap);
    private final Map<Class<? extends DomElementVisitor>, VisitorDescription> a = ConcurrentFactoryMap.createMap(VisitorDescription::new);

    public DomApplicationComponent() {
        for (Object object : DomFileDescription.EP_NAME.getExtensionList()) {
            this.registerFileDescription((DomFileDescription<?>)object);
        }
        for (Object object : DomFileMetaData.EP_NAME.getExtensionList()) {
            this.registerFileDescription((DomFileMetaData)((Object)object));
        }
    }

    public static DomApplicationComponent getInstance() {
        return (DomApplicationComponent)ServiceManager.getService(DomApplicationComponent.class);
    }

    public synchronized int getCumulativeVersion(boolean forStubs) {
        int n2 = 0;
        for (DomFileMetaData domFileMetaData : this.a()) {
            if (forStubs) {
                if (domFileMetaData.stubVersion == null) continue;
                n2 += domFileMetaData.stubVersion.intValue();
                n2 += StringUtil.notNullize((String)domFileMetaData.rootTagName).hashCode();
                continue;
            }
            n2 += domFileMetaData.domVersion;
            n2 += StringUtil.notNullize((String)domFileMetaData.rootTagName).hashCode();
        }
        return n2;
    }

    private Iterable<DomFileMetaData> a() {
        return ContainerUtil.concat((Iterable[])new Iterable[]{this.f.values(), this.c});
    }

    @Nullable
    public synchronized DomFileMetaData findMeta(DomFileDescription description) {
        return (DomFileMetaData)((Object)ContainerUtil.find(this.a(), domFileMetaData -> domFileMetaData.lazyInstance == description));
    }

    public synchronized Set<DomFileDescription> getFileDescriptions(String rootTagName) {
        return ContainerUtil.map2Set((Collection)this.f.get((Object)rootTagName), DomFileMetaData::getDescription);
    }

    public synchronized Set<DomFileDescription> getAcceptingOtherRootTagNameDescriptions() {
        return ContainerUtil.map2Set(this.c, DomFileMetaData::getDescription);
    }

    synchronized void registerFileDescription(DomFileDescription<?> description) {
        this.registerFileDescription(new DomFileMetaData(description));
        this.initDescription(description);
    }

    void registerFileDescription(DomFileMetaData meta) {
        if (StringUtil.isEmpty((String)meta.rootTagName)) {
            this.c.add(meta);
        } else {
            this.f.putValue((Object)meta.rootTagName, (Object)meta);
        }
    }

    void initDescription(DomFileDescription<?> description) {
        Map map2 = description.getImplementations();
        for (Map.Entry entry : map2.entrySet()) {
            this.registerImplementation((Class)entry.getKey(), (Class)entry.getValue(), null);
        }
        this.b.copyFrom(description.getTypeChooserManager());
    }

    synchronized void removeDescription(DomFileDescription<?> description) {
        DomFileMetaData domFileMetaData = this.findMeta(description);
        this.f.get((Object)description.getRootTagName()).remove((Object)domFileMetaData);
        this.c.remove((Object)domFileMetaData);
    }

    @Nullable
    private synchronized DomFileDescription a(Class clazz) {
        for (DomFileMetaData domFileMetaData : this.a()) {
            DomFileDescription domFileDescription = domFileMetaData.lazyInstance;
            if (domFileDescription == null || domFileDescription.getRootElementClass() != clazz) continue;
            return domFileDescription;
        }
        return null;
    }

    public DomElementsAnnotator getAnnotator(Class rootElementClass) {
        return this.e.get(rootElementClass);
    }

    @Nullable
    final Class<? extends DomElement> getImplementation(Class concreteInterface) {
        return this.g.get(concreteInterface);
    }

    public final void registerImplementation(Class<? extends DomElement> domElementClass, Class<? extends DomElement> implementationClass, @Nullable Disposable parentDisposable) {
        this.g.registerImplementation(domElementClass, implementationClass, parentDisposable);
    }

    TypeChooserManager getTypeChooserManager() {
        return this.b;
    }

    public final StaticGenericInfo getStaticGenericInfo(Type type) {
        return this.getInvocationCache((Class)ReflectionUtil.getRawType((Type)type)).genericInfo;
    }

    final InvocationCache getInvocationCache(Class type) {
        return this.d.get(type);
    }

    public final VisitorDescription getVisitorDescription(Class<? extends DomElementVisitor> aClass) {
        return this.a.get(aClass);
    }
}

