/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.replace.impl;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocCommentBase;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.structuralsearch.MalformedPatternException;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchResult;
import com.intellij.structuralsearch.MatchResultSink;
import com.intellij.structuralsearch.Matcher;
import com.intellij.structuralsearch.NamedScriptableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.MatcherImplUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;
import com.intellij.structuralsearch.impl.matcher.predicates.ScriptSupport;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ParameterInfo;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementBuilder;
import com.intellij.structuralsearch.plugin.replace.impl.ReplacementInfoImpl;
import com.intellij.structuralsearch.plugin.util.CollectingMatchResultSink;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class Replacer {
    private final Project b;
    private final ReplaceOptions d;
    private final StructuralReplaceHandler e;
    private final ReplacementBuilder c;
    private PsiElement a = null;
    private static final long f = com.jetbrains.python.psi.c.a(8066622524418338824L, 4223266536496144904L, MethodHandles.lookup().lookupClass()).a(140110477519277L);

    public Replacer(Project project, ReplaceOptions options) {
        this.b = project;
        this.d = options;
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(options.getMatchOptions().getFileType());
        assert (structuralSearchProfile != null);
        this.e = structuralSearchProfile.getReplaceHandler(project, options);
        assert (this.e != null);
        this.c = new ReplacementBuilder(this.b, this.d);
    }

    public static String stripTypedVariableDecoration(String type) {
        return type.substring(1, type.length() - 1);
    }

    public static int insertSubstitution(StringBuilder result, int offset, ParameterInfo info, String image) {
        if (!image.isEmpty()) {
            result.insert(offset + info.getStartIndex(), image);
            offset += image.length();
        }
        return offset;
    }

    public static String testReplace(String in2, String what, String by2, ReplaceOptions options, Project project) {
        return Replacer.testReplace(in2, what, by2, options, project, false);
    }

    public static String testReplace(String in2, String what, String by2, ReplaceOptions options, Project project, boolean sourceIsFile) {
        LanguageFileType languageFileType = options.getMatchOptions().getFileType();
        return Replacer.testReplace(in2, what, by2, options, project, sourceIsFile, false, languageFileType, null);
    }

    public static String testReplace(String in2, String what, String by2, ReplaceOptions replaceOptions, Project project, boolean sourceIsFile, boolean createPhysicalFile, LanguageFileType sourceFileType, Language sourceDialect) {
        replaceOptions.setReplacement(by2);
        MatchOptions matchOptions = replaceOptions.getMatchOptions();
        matchOptions.fillSearchCriteria(what);
        Matcher.validate(project, matchOptions);
        Replacer.checkReplacementPattern(project, replaceOptions);
        Replacer replacer = new Replacer(project, replaceOptions);
        Matcher matcher = new Matcher(project);
        try {
            PsiElement psiElement;
            PsiElement psiElement2;
            PsiElement psiElement3;
            PsiElement psiElement4;
            Object object;
            if (matchOptions.getScope() == null) {
                object = MatcherImplUtil.createTreeFromText(in2, sourceIsFile ? PatternTreeContext.File : PatternTreeContext.Block, sourceFileType, sourceDialect, null, project, createPhysicalFile);
                psiElement4 = object[0];
                psiElement3 = object[((PsiElement[])object).length - 1];
                psiElement2 = psiElement4.getParent();
                matchOptions.setScope((SearchScope)new LocalSearchScope((PsiElement[])object));
            } else {
                psiElement2 = ((LocalSearchScope)matchOptions.getScope()).getScope()[0];
                psiElement4 = psiElement2.getFirstChild();
                psiElement3 = psiElement2.getLastChild();
            }
            object = new CollectingMatchResultSink();
            matcher.testFindMatches((MatchResultSink)object, matchOptions);
            SmartList smartList = new SmartList();
            for (MatchResult matchResult : ((CollectingMatchResultSink)object).getMatches()) {
                smartList.add(replacer.buildReplacement(matchResult));
            }
            int n2 = psiElement4.getTextRange().getStartOffset();
            int n3 = sourceIsFile ? 0 : psiElement2.getTextLength() - psiElement3.getTextRange().getEndOffset();
            PsiElement psiElement5 = psiElement4.getPrevSibling();
            if (psiElement5 instanceof PsiWhiteSpace) {
                n2 -= psiElement5.getTextLength() - 1;
            }
            if ((psiElement = psiElement3.getNextSibling()) instanceof PsiWhiteSpace) {
                n3 -= psiElement.getTextLength() - 1;
            }
            replacer.replaceAll((List<? extends ReplacementInfo>)smartList);
            String string = psiElement2.getText();
            string = string.substring(n2);
            String string2 = string = string.substring(0, string.length() - n3);
            return string2;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new IncorrectOperationException((Throwable)exception);
        }
        finally {
            matchOptions.setScope(null);
        }
    }

    public void replaceAll(List<? extends ReplacementInfo> infos) {
        long l2 = f ^ 0x5A119AF171EFL;
        for (ReplacementInfo replacementInfo : infos) {
            this.e.prepare(replacementInfo);
        }
        ((ApplicationImpl)ApplicationManager.getApplication()).runWriteActionWithCancellableProgressInDispatchThread(SSRBundle.message("structural.replace.title", new Object[0]), this.b, null, progressIndicator -> {
            progressIndicator.setIndeterminate(false);
            try {
                int n2 = infos.size();
                VirtualFile virtualFile = null;
                for (int i10 = 0; i10 < n2; ++i10) {
                    progressIndicator.checkCanceled();
                    progressIndicator.setFraction((double)((float)(i10 + 1) / (float)n2));
                    ReplacementInfo replacementInfo = (ReplacementInfo)infos.get(i10);
                    PsiElement psiElement = replacementInfo.getMatch(0);
                    if (psiElement == null) continue;
                    VirtualFile virtualFile2 = psiElement.getContainingFile().getVirtualFile();
                    if (virtualFile2 != null && !virtualFile2.equals(virtualFile)) {
                        progressIndicator.setText2(virtualFile2.getPresentableUrl());
                        virtualFile = virtualFile2;
                    }
                    ProgressManager.getInstance().executeNonCancelableSection(() -> {
                        PsiElement psiElement = this.b(replacementInfo);
                        if (psiElement != this.a) {
                            if (this.a != null) {
                                this.a(this.a);
                            }
                            this.a = psiElement;
                        }
                    });
                }
            }
            finally {
                ProgressManager.getInstance().executeNonCancelableSection(() -> this.a(this.a));
            }
        });
    }

    public void replace(ReplacementInfo info) {
        this.e.prepare(info);
        this.a(this.b(info));
    }

    @Nullable
    private PsiElement b(ReplacementInfo replacementInfo) {
        PsiElement psiElement = replacementInfo.getMatch(0);
        if (psiElement == null || !psiElement.isWritable() || !psiElement.isValid()) {
            return null;
        }
        PsiElement psiElement2 = StructuralSearchUtil.getPresentableElement(psiElement).getParent();
        CodeStyleManager.getInstance((Project)this.b).performActionWithFormatterDisabled(() -> this.e.replace(replacementInfo, this.d));
        if (!psiElement2.isValid() || !psiElement2.isWritable()) {
            return null;
        }
        return psiElement2;
    }

    private void a(PsiElement psiElement) {
        if (psiElement == null || !psiElement.isValid()) {
            return;
        }
        PsiFile psiFile = psiElement.getContainingFile();
        if (psiFile != null && this.d.isToReformatAccordingToStyle()) {
            Document document;
            VirtualFile virtualFile = psiFile.getVirtualFile();
            if (virtualFile != null && (document = FileDocumentManager.getInstance().getDocument(virtualFile)) != null) {
                PsiDocumentManager.getInstance((Project)this.b).commitDocument(document);
            }
            int n2 = psiElement.getTextRange().getStartOffset();
            CodeStyleManager.getInstance((Project)this.b).reformatRange((PsiElement)psiFile, n2, n2 + psiElement.getTextLength(), true);
        }
        this.e.postProcess(psiElement, this.d);
    }

    public static void handleComments(PsiElement el2, PsiElement replacement, ReplacementInfo replacementInfo) {
        PsiElement psiElement;
        PsiElement psiElement2;
        PsiElement psiElement3 = el2.getLastChild();
        if (psiElement3 instanceof PsiComment && replacementInfo.getVariableName(psiElement3) == null && !(replacement.getLastChild() instanceof PsiComment)) {
            psiElement2 = psiElement3;
            for (psiElement = psiElement2.getPrevSibling(); psiElement != null && (psiElement instanceof PsiWhiteSpace || psiElement instanceof PsiComment); psiElement = psiElement.getPrevSibling()) {
                psiElement2 = psiElement;
            }
            replacement.addRangeAfter(psiElement2, psiElement3, replacement.getLastChild());
        }
        if ((psiElement2 = el2.getFirstChild()) instanceof PsiComment && !(psiElement2 instanceof PsiDocCommentBase) && replacementInfo.getVariableName(psiElement2) == null) {
            psiElement = psiElement2;
            for (PsiElement psiElement4 = psiElement.getNextSibling(); psiElement4 != null && (psiElement4 instanceof PsiWhiteSpace || psiElement4 instanceof PsiComment); psiElement4 = psiElement4.getNextSibling()) {
                psiElement = psiElement4;
            }
            replacement.addRangeBefore(psiElement2, psiElement, replacement.getFirstChild());
        }
    }

    public static void checkReplacementPattern(Project project, ReplaceOptions options) {
        long l2 = f ^ 0x63D7C311C4AFL;
        try {
            String string = options.getMatchOptions().getSearchPattern();
            String string2 = options.getReplacement();
            LanguageFileType languageFileType = options.getMatchOptions().getFileType();
            Template template = TemplateManager.getInstance((Project)project).createTemplate("", "", string);
            Template template2 = TemplateManager.getInstance((Project)project).createTemplate("", "", string2);
            int n2 = template2.getSegmentsCount();
            for (int i10 = 0; i10 < n2; ++i10) {
                Object object;
                int n3;
                String string3 = template2.getSegmentName(i10);
                int n4 = template.getSegmentsCount();
                for (n3 = 0; n3 < n4 && !string3.equals(object = template.getSegmentName(n3)); ++n3) {
                    if (!string3.startsWith((String)object) || string3.charAt(((String)object).length()) != '_') continue;
                    try {
                        Integer.parseInt(string3.substring(((String)object).length() + 1));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n3 != n4) continue;
                object = options.getVariableDefinition(string3);
                if (object == null || ((NamedScriptableDefinition)object).getScriptCodeConstraint().length() <= 2) {
                    throw new MalformedPatternException(SSRBundle.message("replacement.variable.is.not.defined.message", string3));
                }
                String string4 = ScriptSupport.checkValidScript(StringUtil.unquoteString((String)((NamedScriptableDefinition)object).getScriptCodeConstraint()), options.getMatchOptions());
                if (string4 == null) continue;
                throw new MalformedPatternException(SSRBundle.message("replacement.variable.is.not.valid", string3, string4));
            }
            StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByFileType(languageFileType);
            assert (structuralSearchProfile != null);
            ReadAction.run(() -> structuralSearchProfile.checkReplacementPattern(project, options));
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw new MalformedPatternException(SSRBundle.message("incorrect.pattern.message", new Object[0]));
        }
    }

    public ReplacementInfo buildReplacement(MatchResult result) {
        ReplacementInfoImpl replacementInfoImpl = new ReplacementInfoImpl(result, this.b);
        replacementInfoImpl.setReplacement(this.c.process(result, replacementInfoImpl, this.d.getMatchOptions().getFileType()));
        return replacementInfoImpl;
    }
}

