/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher.compiler;

import com.intellij.structuralsearch.impl.matcher.compiler.OptimizingSearchHelper;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;

abstract class OptimizingSearchHelperBase
implements OptimizingSearchHelper {
    private final THashSet<String> d = new THashSet();
    private final THashSet<String> a = new THashSet();
    private final THashSet<String> c = new THashSet();
    private final THashSet<String> b = new THashSet();
    protected int scanRequest = 0;

    OptimizingSearchHelperBase() {
    }

    @Override
    public void clear() {
        this.d.clear();
        this.a.clear();
        this.c.clear();
        this.b.clear();
    }

    @Override
    public void addWordToSearchInCode(String word) {
        if (word != null && this.doOptimizing() && this.d.add((Object)word)) {
            this.doAddSearchWordInCode(word);
        }
    }

    @Override
    public void addWordToSearchInText(String word) {
        if (word != null && this.doOptimizing() && this.a.add((Object)word)) {
            this.doAddSearchWordInText(word);
        }
    }

    @Override
    public void addWordToSearchInComments(String word) {
        if (word != null && this.doOptimizing() && this.c.add((Object)word)) {
            this.doAddSearchWordInComments(word);
        }
    }

    @Override
    public void addWordToSearchInLiterals(String word) {
        if (word != null && this.doOptimizing() && this.b.add((Object)word)) {
            this.doAddSearchWordInLiterals(word);
        }
    }

    protected abstract void doAddSearchWordInCode(@NotNull String var1);

    protected abstract void doAddSearchWordInText(@NotNull String var1);

    protected abstract void doAddSearchWordInComments(@NotNull String var1);

    protected abstract void doAddSearchWordInLiterals(@NotNull String var1);

    @Override
    public void endTransaction() {
        ++this.scanRequest;
    }

    @Override
    public boolean isScannedSomething() {
        return !this.d.isEmpty() || !this.a.isEmpty() || !this.c.isEmpty() || !this.b.isEmpty();
    }
}

