/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.impl.matcher;

import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.impl.matcher.PatternTreeContext;

public class MatcherImplUtil {
    public static PsiElement[] createTreeFromText(String text2, PatternTreeContext context, LanguageFileType fileType, Project project) {
        return MatcherImplUtil.createTreeFromText(text2, context, fileType, null, null, project, false);
    }

    public static PsiElement[] createSourceTreeFromText(String text2, PatternTreeContext context, LanguageFileType fileType, Project project, boolean physical) {
        StructuralSearchProfile structuralSearchProfile = StructuralSearchUtil.getProfileByLanguage(fileType.getLanguage());
        if (structuralSearchProfile != null) {
            return structuralSearchProfile.createPatternTree(text2, context, fileType, fileType.getLanguage(), null, project, physical);
        }
        return PsiElement.EMPTY_ARRAY;
    }

    public static PsiElement[] createTreeFromText(String text2, PatternTreeContext context, LanguageFileType fileType, Language language, PatternContext patternContext, Project project, boolean physical) {
        StructuralSearchProfile structuralSearchProfile;
        if (language == null) {
            language = fileType.getLanguage();
        }
        if ((structuralSearchProfile = StructuralSearchUtil.getProfileByLanguage(language)) != null) {
            String string = patternContext == null ? null : patternContext.getId();
            return structuralSearchProfile.createPatternTree(text2, context, fileType, language, string, project, physical);
        }
        return PsiElement.EMPTY_ARRAY;
    }
}

