/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.impl.scopes.ModuleWithDependenciesScope;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packageDependencies.ChangeListsScopesProvider;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.search.PredefinedSearchScopeProvider;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Scopes {
    private static final long a = c.a(7991017758658113822L, -279903281128731803L, MethodHandles.lookup().lookupClass()).a(156930415149379L);

    private Scopes() {
    }

    public static Type getType(@Nullable SearchScope scope) {
        if (scope instanceof ProjectScopeImpl || scope == null) {
            return Type.PROJECT;
        }
        if (scope instanceof ModuleWithDependenciesScope) {
            return Type.MODULE;
        }
        if (scope instanceof GlobalSearchScopesCore.DirectoryScope) {
            return Type.DIRECTORY;
        }
        return Type.NAMED;
    }

    public static String getDescriptor(SearchScope scope) {
        if (scope instanceof ProjectScopeImpl || scope == null) {
            return "";
        }
        if (scope instanceof ModuleWithDependenciesScope) {
            return ((ModuleWithDependenciesScope)scope).getModule().getName();
        }
        if (scope instanceof GlobalSearchScopesCore.DirectoryScope) {
            GlobalSearchScopesCore.DirectoryScope directoryScope = (GlobalSearchScopesCore.DirectoryScope)scope;
            String string = directoryScope.getDirectory().getPresentableUrl();
            return directoryScope.isWithSubdirectories() ? "*" + string : string;
        }
        return scope.getDisplayName();
    }

    public static SearchScope createScope(@NotNull Project project, @NotNull String descriptor2, @NotNull Type scopeType) {
        if (project == null) {
            Scopes.a(0);
        }
        if (descriptor2 == null) {
            Scopes.a(1);
        }
        if (scopeType == null) {
            Scopes.a(2);
        }
        if (scopeType == Type.PROJECT) {
            return GlobalSearchScope.projectScope((Project)project);
        }
        if (scopeType == Type.MODULE) {
            Module module2 = ModuleManager.getInstance((Project)project).findModuleByName(descriptor2);
            if (module2 != null) {
                return GlobalSearchScope.moduleScope((Module)module2);
            }
        } else {
            if (scopeType == Type.DIRECTORY) {
                boolean bl2 = StringUtil.startsWithChar((CharSequence)descriptor2, (char)'*');
                if (bl2) {
                    descriptor2 = descriptor2.substring(1);
                }
                String string = FileUtil.toSystemIndependentName((String)descriptor2.substring(1));
                VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
                if (virtualFile == null) {
                    return null;
                }
                return new GlobalSearchScopesCore.DirectoryScope(project, virtualFile, bl2);
            }
            if (scopeType == Type.NAMED) {
                return Scopes.findScopeByName(project, descriptor2);
            }
        }
        assert (false);
        return null;
    }

    @Nullable
    public static SearchScope findScopeByName(@NotNull Project project, @NotNull String scopeName) {
        if (project == null) {
            Scopes.a(3);
        }
        if (scopeName == null) {
            Scopes.a(4);
        }
        List list2 = PredefinedSearchScopeProvider.getInstance().getPredefinedScopes(project, null, true, false, true, true, true);
        for (SearchScope searchScope : list2) {
            if (!searchScope.getDisplayName().equals(scopeName)) continue;
            return searchScope;
        }
        for (SearchScope searchScope : ChangeListsScopesProvider.getInstance((Project)project).getFilteredScopes()) {
            if (!searchScope.getName().equals(scopeName)) continue;
            return GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)searchScope);
        }
        for (NamedScopesHolder namedScopesHolder : NamedScopesHolder.getAllNamedScopeHolders((Project)project)) {
            for (NamedScope namedScope : namedScopesHolder.getEditableScopes()) {
                if (!namedScope.getName().equals(scopeName)) continue;
                return GlobalSearchScopesCore.filterScope((Project)project, (NamedScope)namedScope);
            }
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = a ^ 0x6E41E96744CL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
        }
        objectArray2[1] = "com/intellij/structuralsearch/Scopes";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createScope";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findScopeByName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type PROJECT;
        public static final /* enum */ Type MODULE;
        public static final /* enum */ Type DIRECTORY;
        public static final /* enum */ Type NAMED;
        private static final /* synthetic */ Type[] a;

        public static Type[] values() {
            return (Type[])a.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        static {
            long l2 = c.a(4348752283272995941L, -1250161265520463415L, MethodHandles.lookup().lookupClass()).a(61501884054313L) ^ 0x4CCD3BCC824L;
            PROJECT = new Type();
            MODULE = new Type();
            DIRECTORY = new Type();
            NAMED = new Type();
            a = new Type[]{PROJECT, MODULE, DIRECTORY, NAMED};
        }
    }
}

