/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.structuralsearch.StructuralReplaceHandler;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.replace.ReplacementInfo;
import java.util.HashMap;
import java.util.Map;

public class DocumentBasedReplaceHandler
extends StructuralReplaceHandler {
    private final Project b;
    private final Map<ReplacementInfo, RangeMarker> a = new HashMap<ReplacementInfo, RangeMarker>();

    public DocumentBasedReplaceHandler(Project project) {
        this.b = project;
    }

    @Override
    public void replace(ReplacementInfo info, ReplaceOptions options) {
        RangeMarker rangeMarker = this.a.get(info);
        Document document = rangeMarker.getDocument();
        document.replaceString(rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), (CharSequence)info.getReplacement());
        PsiDocumentManager.getInstance((Project)this.b).commitDocument(document);
    }

    @Override
    public void prepare(ReplacementInfo info) {
        PsiElement psiElement = StructuralSearchUtil.getPresentableElement(info.getMatch(0));
        if (psiElement == null) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)this.b).getDocument(psiElement.getContainingFile());
        assert (document != null);
        TextRange textRange = psiElement.getTextRange();
        int n2 = textRange.getStartOffset();
        int n3 = textRange.getEndOffset();
        int n4 = info.getMatchesCount();
        for (int i10 = 1; i10 < n4; ++i10) {
            PsiElement psiElement2 = info.getMatch(i10);
            if (psiElement2 == null) continue;
            TextRange textRange2 = psiElement2.getTextRange();
            n2 = Math.min(n2, textRange2.getStartOffset());
            n3 = Math.max(n3, textRange2.getEndOffset());
        }
        RangeMarker rangeMarker = document.createRangeMarker(n2, n3);
        rangeMarker.setGreedyToLeft(true);
        rangeMarker.setGreedyToRight(true);
        this.a.put(info, rangeMarker);
    }
}

