/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.DuplicatesProfile;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptor;
import com.intellij.dupLocator.equivalence.EquivalenceDescriptorProvider;
import com.intellij.dupLocator.equivalence.MultiChildDescriptor;
import com.intellij.dupLocator.equivalence.SingleChildDescriptor;
import com.intellij.dupLocator.treeHash.AbstractTreeHasher;
import com.intellij.dupLocator.treeHash.DuplicatesProfileBase;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.NodeSpecificHasherBase;
import com.intellij.dupLocator.treeHash.TreeHashResult;
import com.intellij.dupLocator.treeHash.TreeHashingUtils;
import com.intellij.dupLocator.treeHash.TreePsiFragment;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.util.Couple;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class TreeHasherBase
extends AbstractTreeHasher {
    private final FragmentsCollector b;
    private final int c;
    private final DuplicatesProfile a;
    private static final long f = com.jetbrains.python.psi.c.a(490475177567287383L, -405253798177876814L, MethodHandles.lookup().lookupClass()).a(115613636320945L);

    TreeHasherBase(@Nullable FragmentsCollector callback, @NotNull DuplicatesProfile profile, int discardCost, boolean forIndexing) {
        if (profile == null) {
            TreeHasherBase.b(0);
        }
        super(callback, forIndexing);
        this.b = callback;
        this.c = discardCost;
        this.a = profile;
    }

    @Override
    protected int getDiscardCost(PsiElement root) {
        if (this.c >= 0) {
            return this.c;
        }
        return this.a.getDuplocatorState(this.a.getLanguage(root)).getDiscardCost();
    }

    @Override
    protected TreeHashResult hash(@NotNull PsiElement root, PsiFragment upper, @NotNull NodeSpecificHasher hasher) {
        if (root == null) {
            TreeHasherBase.b(1);
        }
        if (hasher == null) {
            TreeHasherBase.b(2);
        }
        TreeHashResult treeHashResult = this.a(root, upper, hasher);
        int n2 = this.getDiscardCost(root);
        if (treeHashResult.getCost() < n2) {
            return new TreeHashResult(0, treeHashResult.getCost(), treeHashResult.getFragment());
        }
        return treeHashResult;
    }

    private TreeHashResult a(PsiElement psiElement, PsiFragment psiFragment, NodeSpecificHasher nodeSpecificHasher) {
        Object object;
        EquivalenceDescriptorProvider equivalenceDescriptorProvider = EquivalenceDescriptorProvider.getInstance(psiElement);
        if (equivalenceDescriptorProvider != null && (object = equivalenceDescriptorProvider.buildDescriptor(psiElement)) != null) {
            return this.a(psiElement, psiFragment, (EquivalenceDescriptor)object, nodeSpecificHasher);
        }
        if (psiElement instanceof PsiFile && (object = nodeSpecificHasher.getNodeChildren(psiElement)).size() <= 20) {
            return this.hashCodeBlock((List<? extends PsiElement>)object, psiFragment, nodeSpecificHasher, true);
        }
        object = (NodeSpecificHasherBase)nodeSpecificHasher;
        if (TreeHasherBase.a(psiElement, object)) {
            return this.computeElementHash(psiElement, psiFragment, nodeSpecificHasher);
        }
        if (this.myForIndexing) {
            return this.computeElementHash(psiElement, psiFragment, nodeSpecificHasher);
        }
        PsiElement psiElement2 = DuplocatorUtil.getOnlyChild(psiElement, ((NodeSpecificHasherBase)object).getNodeFilter());
        if (psiElement2 != psiElement) {
            TreeHashResult treeHashResult = this.hash(psiElement2, psiFragment, nodeSpecificHasher);
            int n2 = nodeSpecificHasher.getNodeCost(psiElement);
            return new TreeHashResult(treeHashResult.getHash(), treeHashResult.getCost() + n2, treeHashResult.getFragment());
        }
        return this.computeElementHash(psiElement2, psiFragment, nodeSpecificHasher);
    }

    @Override
    public boolean shouldAnonymize(PsiElement root, NodeSpecificHasher hasher) {
        return TreeHasherBase.a(root, (NodeSpecificHasherBase)hasher);
    }

    @Override
    protected TreeHashResult computeElementHash(@NotNull PsiElement root, PsiFragment upper, NodeSpecificHasher hasher) {
        int n2;
        int n3;
        if (root == null) {
            TreeHasherBase.b(3);
        }
        if (this.myForIndexing) {
            return TreeHashingUtils.computeElementHashForIndexing(this, this.myCallBack, root, upper, hasher);
        }
        List<PsiElement> list2 = hasher.getNodeChildren(root);
        int n4 = list2.size();
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        TreePsiFragment treePsiFragment = this.buildFragment(hasher, root, this.getCost(root));
        if (upper != null) {
            treePsiFragment.setParent(upper);
        }
        if (n4 == 0 && !(root instanceof LeafElement)) {
            return new TreeHashResult(0, hasher.getNodeCost(root), treePsiFragment);
        }
        for (n3 = 0; n3 < n4; ++n3) {
            TreeHashResult treeHashResult = this.hash(list2.get(n3), treePsiFragment, hasher);
            nArray[n3] = treeHashResult.getHash();
            nArray2[n3] = treeHashResult.getCost();
        }
        n3 = hasher.getNodeCost(root) + AbstractTreeHasher.vector(nArray2);
        int n5 = hasher.getNodeHash(root);
        int n6 = this.getDiscardCost(root);
        for (n2 = 0; n2 < n4; ++n2) {
            if (nArray2[n2] > n6 || !this.ignoreChildHash(list2.get(n2))) continue;
            nArray[n2] = 0;
        }
        n2 = n5 + AbstractTreeHasher.vector(nArray);
        if (TreeHasherBase.a(root, (NodeSpecificHasherBase)hasher)) {
            n2 = 0;
        }
        if (this.myCallBack != null) {
            this.myCallBack.add(n2, n3, treePsiFragment);
        }
        return new TreeHashResult(n2, n3, treePsiFragment);
    }

    @Override
    protected TreeHashResult hashCodeBlock(List<? extends PsiElement> statements, PsiFragment upper, NodeSpecificHasher hasher, boolean forceHash) {
        if (!this.myForIndexing) {
            return super.hashCodeBlock(statements, upper, hasher, forceHash);
        }
        return TreeHashingUtils.hashCodeBlockForIndexing(this, this.myCallBack, statements, upper, hasher);
    }

    private TreeHashResult a(PsiElement psiElement, PsiFragment psiFragment, EquivalenceDescriptor equivalenceDescriptor, NodeSpecificHasher nodeSpecificHasher) {
        Couple<Integer> couple;
        NodeSpecificHasherBase nodeSpecificHasherBase = (NodeSpecificHasherBase)nodeSpecificHasher;
        PsiElement psiElement2 = DuplocatorUtil.skipNodeIfNeccessary(psiElement, equivalenceDescriptor, nodeSpecificHasherBase.getNodeFilter());
        boolean bl2 = psiElement2 != psiElement;
        TreePsiFragment treePsiFragment = this.buildFragment(nodeSpecificHasher, psiElement, 0);
        if (psiFragment != null) {
            treePsiFragment.setParent(psiFragment);
        }
        int n2 = bl2 ? 0 : nodeSpecificHasher.getNodeHash(psiElement);
        int n3 = nodeSpecificHasher.getNodeCost(psiElement);
        for (SingleChildDescriptor object : equivalenceDescriptor.getSingleChildDescriptors()) {
            couple = this.b(object, (PsiFragment)treePsiFragment, nodeSpecificHasher);
            n2 = n2 * 31 + (Integer)couple.first;
            n3 += ((Integer)couple.second).intValue();
        }
        for (MultiChildDescriptor multiChildDescriptor : equivalenceDescriptor.getMultiChildDescriptors()) {
            couple = this.a(multiChildDescriptor, (PsiFragment)treePsiFragment, nodeSpecificHasher);
            n2 = n2 * 31 + (Integer)couple.first;
            n3 += ((Integer)couple.second).intValue();
        }
        for (Object object : equivalenceDescriptor.getConstants()) {
            int n4 = object != null ? object.hashCode() : 0;
            n2 = n2 * 31 + n4;
        }
        for (PsiElement[] psiElementArray : equivalenceDescriptor.getCodeBlocks()) {
            List<PsiElement> list2 = TreeHasherBase.filter(psiElementArray, nodeSpecificHasherBase);
            TreeHashResult treeHashResult = this.hashCodeBlock(list2, treePsiFragment, nodeSpecificHasher);
            n2 = n2 * 31 + treeHashResult.getHash();
            n3 += treeHashResult.getCost();
        }
        if (this.b != null) {
            this.b.add(n2, n3, treePsiFragment);
        }
        return new TreeHashResult(n2, n3, treePsiFragment);
    }

    public static List<PsiElement> filter(PsiElement[] elements, NodeSpecificHasherBase hasher) {
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        for (PsiElement psiElement : elements) {
            if (hasher.getNodeFilter().accepts(psiElement)) continue;
            arrayList.add(psiElement);
        }
        return arrayList;
    }

    @NotNull
    private Couple<Integer> b(SingleChildDescriptor singleChildDescriptor, PsiFragment psiFragment, NodeSpecificHasher nodeSpecificHasher) {
        PsiElement psiElement = singleChildDescriptor.getElement();
        if (psiElement == null) {
            Couple couple = Couple.of((Object)0, (Object)0);
            if (couple == null) {
                TreeHasherBase.b(4);
            }
            return couple;
        }
        Couple<Integer> couple = this.a(singleChildDescriptor, psiFragment, nodeSpecificHasher);
        DuplicatesProfileBase duplicatesProfileBase = ((NodeSpecificHasherBase)nodeSpecificHasher).getDuplicatesProfile();
        PsiElementRole psiElementRole = duplicatesProfileBase.getRole(psiElement);
        if (psiElementRole != null && !duplicatesProfileBase.getDuplocatorState(duplicatesProfileBase.getLanguage(psiElement)).distinguishRole(psiElementRole)) {
            Couple couple2 = Couple.of((Object)0, (Object)couple.second);
            if (couple2 == null) {
                TreeHasherBase.b(5);
            }
            return couple2;
        }
        Couple<Integer> couple3 = couple;
        if (couple3 == null) {
            TreeHasherBase.b(6);
        }
        return couple3;
    }

    private static boolean a(PsiElement psiElement, NodeSpecificHasherBase nodeSpecificHasherBase) {
        DuplicatesProfileBase duplicatesProfileBase = nodeSpecificHasherBase.getDuplicatesProfile();
        PsiElementRole psiElementRole = duplicatesProfileBase.getRole(psiElement);
        return psiElementRole != null && !duplicatesProfileBase.getDuplocatorState(duplicatesProfileBase.getLanguage(psiElement)).distinguishRole(psiElementRole);
    }

    @NotNull
    private Couple<Integer> a(SingleChildDescriptor singleChildDescriptor, PsiFragment psiFragment, NodeSpecificHasher nodeSpecificHasher) {
        PsiElement psiElement = singleChildDescriptor.getElement();
        switch (singleChildDescriptor.getType()) {
            case OPTIONALLY_IN_PATTERN: 
            case DEFAULT: {
                TreeHashResult treeHashResult = this.hash(psiElement, psiFragment, nodeSpecificHasher);
                Couple couple = Couple.of((Object)treeHashResult.getHash(), (Object)treeHashResult.getCost());
                if (couple == null) {
                    TreeHasherBase.b(7);
                }
                return couple;
            }
            case CHILDREN_OPTIONALLY_IN_PATTERN: 
            case CHILDREN: {
                TreeHashResult[] treeHashResultArray = this.b(psiElement, psiFragment, nodeSpecificHasher);
                int[] nArray = TreeHasherBase.a(treeHashResultArray);
                int[] nArray2 = TreeHasherBase.b(treeHashResultArray);
                int n2 = AbstractTreeHasher.vector(nArray, 31);
                int n3 = AbstractTreeHasher.vector(nArray2);
                Couple couple = Couple.of((Object)n2, (Object)n3);
                if (couple == null) {
                    TreeHasherBase.b(8);
                }
                return couple;
            }
            case CHILDREN_IN_ANY_ORDER: {
                TreeHashResult[] treeHashResultArray = this.b(psiElement, psiFragment, nodeSpecificHasher);
                int[] nArray = TreeHasherBase.a(treeHashResultArray);
                int[] nArray3 = TreeHasherBase.b(treeHashResultArray);
                int n4 = AbstractTreeHasher.vector(nArray);
                int n5 = AbstractTreeHasher.vector(nArray3);
                Couple couple = Couple.of((Object)n4, (Object)n5);
                if (couple == null) {
                    TreeHasherBase.b(9);
                }
                return couple;
            }
        }
        Couple couple = Couple.of((Object)0, (Object)0);
        if (couple == null) {
            TreeHasherBase.b(10);
        }
        return couple;
    }

    @NotNull
    private Couple<Integer> a(MultiChildDescriptor multiChildDescriptor, PsiFragment psiFragment, NodeSpecificHasher nodeSpecificHasher) {
        PsiElement[] psiElementArray = multiChildDescriptor.getElements();
        if (psiElementArray == null) {
            Couple couple = Couple.of((Object)0, (Object)0);
            if (couple == null) {
                TreeHasherBase.b(11);
            }
            return couple;
        }
        switch (multiChildDescriptor.getType()) {
            case OPTIONALLY_IN_PATTERN: 
            case DEFAULT: {
                TreeHashResult[] treeHashResultArray = this.a(psiElementArray, psiFragment, nodeSpecificHasher);
                int[] nArray = TreeHasherBase.a(treeHashResultArray);
                int[] nArray2 = TreeHasherBase.b(treeHashResultArray);
                int n2 = AbstractTreeHasher.vector(nArray, 31);
                int n3 = AbstractTreeHasher.vector(nArray2);
                Couple couple = Couple.of((Object)n2, (Object)n3);
                if (couple == null) {
                    TreeHasherBase.b(12);
                }
                return couple;
            }
            case IN_ANY_ORDER: {
                TreeHashResult[] treeHashResultArray = this.a(psiElementArray, psiFragment, nodeSpecificHasher);
                int[] nArray = TreeHasherBase.a(treeHashResultArray);
                int[] nArray3 = TreeHasherBase.b(treeHashResultArray);
                int n4 = AbstractTreeHasher.vector(nArray);
                int n5 = AbstractTreeHasher.vector(nArray3);
                Couple couple = Couple.of((Object)n4, (Object)n5);
                if (couple == null) {
                    TreeHasherBase.b(13);
                }
                return couple;
            }
        }
        Couple couple = Couple.of((Object)0, (Object)0);
        if (couple == null) {
            TreeHasherBase.b(14);
        }
        return couple;
    }

    @NotNull
    private TreeHashResult[] b(PsiElement psiElement, PsiFragment psiFragment, NodeSpecificHasher nodeSpecificHasher) {
        ArrayList<TreeHashResult> arrayList = new ArrayList<TreeHashResult>();
        for (PsiElement psiElement2 = psiElement.getFirstChild(); psiElement2 != null; psiElement2 = psiElement2.getNextSibling()) {
            TreeHashResult treeHashResult = this.hash(psiElement, psiFragment, nodeSpecificHasher);
            arrayList.add(treeHashResult);
        }
        TreeHashResult[] treeHashResultArray = arrayList.toArray(new TreeHashResult[0]);
        if (treeHashResultArray == null) {
            TreeHasherBase.b(15);
        }
        return treeHashResultArray;
    }

    @NotNull
    private TreeHashResult[] a(PsiElement[] psiElementArray, PsiFragment psiFragment, NodeSpecificHasher nodeSpecificHasher) {
        TreeHashResult[] treeHashResultArray = new TreeHashResult[psiElementArray.length];
        for (int i10 = 0; i10 < psiElementArray.length; ++i10) {
            treeHashResultArray[i10] = this.hash(psiElementArray[i10], psiFragment, nodeSpecificHasher);
        }
        if (treeHashResultArray == null) {
            TreeHasherBase.b(16);
        }
        return treeHashResultArray;
    }

    private static int[] a(TreeHashResult[] treeHashResultArray) {
        int[] nArray = new int[treeHashResultArray.length];
        for (int i10 = 0; i10 < treeHashResultArray.length; ++i10) {
            nArray[i10] = treeHashResultArray[i10].getHash();
        }
        return nArray;
    }

    private static int[] b(TreeHashResult[] treeHashResultArray) {
        int[] nArray = new int[treeHashResultArray.length];
        for (int i10 = 0; i10 < treeHashResultArray.length; ++i10) {
            nArray[i10] = treeHashResultArray[i10].getCost();
        }
        return nArray;
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x9B6BFFC6A14L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hasher";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/treeHash/TreeHasherBase";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/treeHash/TreeHasherBase";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHash";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "doComputeHash";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHashesForChildren";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeHashes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "hash";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeElementHash";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

