/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.resultUI;

import com.intellij.dupLocator.DupInfo;
import com.intellij.dupLocator.DupLocatorBundle;
import com.intellij.dupLocator.DuplicatesPresentation;
import com.intellij.dupLocator.DuplicatesPresentationCache;
import com.intellij.dupLocator.resultUI.BasicTreeNode;
import com.intellij.dupLocator.resultUI.CodeNode;
import com.intellij.dupLocator.resultUI.DuplicatesModel;
import com.intellij.dupLocator.resultUI.DuplicatesRoot;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.usageView.UsageInfo;
import com.jetbrains.python.psi.c;
import java.lang.invoke.MethodHandles;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class GroupNode
extends BasicTreeNode {
    private CodeNode[] f;
    private final int e;
    private final DupInfo d;
    private final int c;
    private static final long g = com.jetbrains.python.psi.c.a(-2235505251529190917L, -7928706049043373934L, MethodHandles.lookup().lookupClass()).a(179445385464336L);

    public GroupNode(DuplicatesRoot duplicatesRoot, DupInfo duplicates, int index) {
        super(true, duplicatesRoot);
        this.d = duplicates;
        this.c = index;
        this.e = duplicates.getPatternCost(index);
    }

    protected CodeNode[] getChildren() {
        if (this.f == null) {
            UsageInfo[] usageInfoArray = this.d.getUsageOccurences(this.c);
            PsiFragment[] psiFragmentArray = this.d.getFragmentOccurences(this.c);
            CodeNode[] codeNodeArray = new CodeNode[usageInfoArray.length];
            for (int i10 = 0; i10 < codeNodeArray.length; ++i10) {
                codeNodeArray[i10] = new CodeNode(this, psiFragmentArray[i10], usageInfoArray[i10], i10 + 1);
            }
            this.f = codeNodeArray;
        }
        return this.f;
    }

    @Override
    public CodeNode getChildAt(int childIndex) {
        return (CodeNode)super.getChildAt(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.d.getPatternDensity(this.c);
    }

    @Override
    public DuplicatesRoot getParent() {
        return (DuplicatesRoot)super.getParent();
    }

    @Override
    public boolean isLeaf() {
        return this.d.getPatternDensity(this.c) == 0;
    }

    public CellAppearanceEx getTitle(boolean sel) {
        int n2;
        long l2 = g ^ 0x11A74EF26CBBL;
        int n3 = this.getChildCount();
        if (this.f != null) {
            for (CodeNode codeNode : this.f) {
                if (codeNode.isValid()) continue;
                return CompositeAppearance.single((String)DupLocatorBundle.message("duplicates.partially.valid.group.node", n3), (SimpleTextAttributes)BasicTreeNode.getTextAttributes(sel));
            }
        }
        if ((n2 = this.d.getFileCount(this.c)) == 1) {
            CompositeAppearance.DequeEnd dequeEnd = new CompositeAppearance().getEnding();
            dequeEnd.addText(DupLocatorBundle.message("duplicates.single.file.group.node", n3, this.e, this.d.getTitle(this.c)), BasicTreeNode.getTextAttributes(sel));
            dequeEnd.addComment(this.d.getComment(this.c), BasicTreeNode.getCommentAttributes(sel));
            return dequeEnd.getAppearance();
        }
        return CompositeAppearance.single((String)DupLocatorBundle.message("duplicates.multiple.files.group.node", n3, this.e, n2), (SimpleTextAttributes)BasicTreeNode.getTextAttributes(sel));
    }

    @Override
    public DuplicatesModel getModel() {
        return this.getParent().getModel();
    }

    public int getIndexOf(CodeNode codeNode) {
        for (int i10 = 0; i10 < this.f.length; ++i10) {
            CodeNode codeNode2 = this.f[i10];
            if (!Comparing.equal((Object)codeNode2, (Object)codeNode)) continue;
            return i10;
        }
        return -1;
    }

    public Set<VirtualFile> getAffectedFiles() {
        PsiFragment[] psiFragmentArray;
        HashSet<VirtualFile> hashSet = new HashSet<VirtualFile>();
        for (PsiFragment psiFragment : psiFragmentArray = this.d.getFragmentOccurences(this.c)) {
            PsiFile psiFile = psiFragment.getFile();
            if (psiFile == null) continue;
            hashSet.add(psiFile.getVirtualFile());
        }
        return hashSet;
    }

    @Nullable
    public DuplicatesPresentation getPresentation() {
        return DuplicatesPresentationCache.getPresentation(this.d, this.c);
    }
}

