/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage.view;

import com.intellij.CommonBundle;
import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageSuitesBundle;
import com.intellij.coverage.view.CoverageListNode;
import com.intellij.coverage.view.CoverageTableModel;
import com.intellij.coverage.view.CoverageViewBuilder;
import com.intellij.coverage.view.CoverageViewManager;
import com.intellij.coverage.view.CoverageViewTreeStructure;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.impl.RunDialog;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.AutoScrollFromSourceHandler;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBList;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.python.psi.c;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CoverageView
extends BorderLayoutPanel
implements DataProvider,
Disposable {
    @NonNls
    private static final String e = "DrillDown";
    @NonNls
    private static final String d = "GoUp";
    @NonNls
    public static final String HELP_ID = "reference.toolWindows.Coverage";
    private final CoverageTableModel b;
    private final JBTable c;
    private final CoverageViewBuilder g;
    private final Project f;
    private final CoverageViewManager.StateBean a;
    private static final long h = com.jetbrains.python.psi.c.a(-5945321938169985340L, 7495443335994152853L, MethodHandles.lookup().lookupClass()).a(223113277343231L);

    public CoverageView(final Project project, CoverageDataManager dataManager, CoverageViewManager.StateBean stateBean) {
        long l2 = h ^ 0x2106A599494FL;
        this.f = project;
        this.a = stateBean;
        JLabel jLabel = new JLabel();
        jLabel.setBorder((Border)JBUI.Borders.empty((int)2, (int)0));
        CoverageSuitesBundle coverageSuitesBundle = dataManager.getCurrentSuitesBundle();
        this.b = new CoverageTableModel(coverageSuitesBundle, stateBean, project);
        this.c = new JBTable((TableModel)this.b);
        StatusText statusText = this.c.getEmptyText();
        statusText.setText("No coverage results.");
        final RunConfigurationBase runConfigurationBase = coverageSuitesBundle.getRunConfiguration();
        if (runConfigurationBase != null) {
            statusText.appendText(" Click ");
            statusText.appendText("Edit", SimpleTextAttributes.LINK_ATTRIBUTES, new ActionListener(){
                private static final long a = com.jetbrains.python.psi.c.a(-7024920436703065320L, 6542250182436002225L, MethodHandles.lookup().lookupClass()).a(144640763348644L);

                @Override
                public void actionPerformed(ActionEvent e10) {
                    long l2 = a ^ 0x41B457AABDE3L;
                    RunnerAndConfigurationSettings runnerAndConfigurationSettings = RunManager.getInstance((Project)project).findSettings((RunConfiguration)runConfigurationBase);
                    if (runnerAndConfigurationSettings != null) {
                        RunDialog.editConfiguration((Project)project, (RunnerAndConfigurationSettings)runnerAndConfigurationSettings, (String)"Edit Run Configuration");
                    } else {
                        Messages.showErrorDialog((Project)project, (String)("Configuration '" + runConfigurationBase.getName() + "' was not found"), (String)CommonBundle.getErrorTitle());
                    }
                }
            });
            statusText.appendText(" to fix configuration settings.");
        }
        TableColumnModel tableColumnModel = this.c.getColumnModel();
        TableColumn tableColumn = tableColumnModel.getColumn(0);
        tableColumn.setCellRenderer(new NodeDescriptorTableCellRenderer());
        tableColumn.setPreferredWidth(this.a.myElementSize);
        this.c.getTableHeader().setReorderingAllowed(false);
        BorderLayoutPanel borderLayoutPanel = JBUI.Panels.simplePanel().addToCenter((Component)ScrollPaneFactory.createScrollPane((Component)this.c)).addToTop((Component)jLabel);
        this.addToCenter((Component)borderLayoutPanel);
        final CoverageViewTreeStructure coverageViewTreeStructure = new CoverageViewTreeStructure(project, coverageSuitesBundle, stateBean);
        this.g = new CoverageViewBuilder(project, (JList)new JBList(), this.b, coverageViewTreeStructure, this.c);
        this.g.setParentTitle(jLabel);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e10) {
                CoverageView.this.c(coverageViewTreeStructure);
                return true;
            }
        }.installOn((Component)this.c);
        TableSpeedSearch tableSpeedSearch = new TableSpeedSearch((JTable)this.c);
        tableSpeedSearch.setClearSearchOnNavigateNoMatch(true);
        PopupHandler.installUnknownPopupHandler((JComponent)this.c, (ActionGroup)CoverageView.a(), (ActionManager)ActionManager.getInstance());
        ScrollingUtil.installActions((JTable)this.c);
        this.c.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                if (CoverageView.this.g == null) {
                    return;
                }
                CoverageView.this.g.buildRoot();
            }
        }, KeyStroke.getKeyStroke(92, SystemInfo.isMac ? 4 : 2), 0);
        this.c.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), e);
        this.c.getInputMap(0).put(KeyStroke.getKeyStroke(34, SystemInfo.isMac ? 4 : 2), e);
        this.c.getActionMap().put(e, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                CoverageView.this.c(coverageViewTreeStructure);
            }
        });
        this.c.getInputMap(0).put(KeyStroke.getKeyStroke(33, SystemInfo.isMac ? 4 : 2), d);
        this.c.getInputMap(0).put(KeyStroke.getKeyStroke(8, 0), d);
        this.c.getActionMap().put(d, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                CoverageView.this.goUp();
            }
        });
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("CoverageView", this.b(coverageViewTreeStructure), false).getComponent();
        this.addToLeft(jComponent);
    }

    public void dispose() {
        if (!this.f.isDisposed()) {
            CoverageDataManager.getInstance(this.f).chooseSuitesBundle(null);
        }
    }

    public void saveSize() {
        this.a.myElementSize = this.c.getColumnModel().getColumn(0).getWidth();
    }

    private static ActionGroup a() {
        long l2 = h ^ 0x4679F337F47FL;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add(ActionManager.getInstance().getAction("EditSource"));
        return defaultActionGroup;
    }

    private ActionGroup b(CoverageViewTreeStructure coverageViewTreeStructure) {
        long l2 = h ^ 0xCF21742CAC5L;
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add((AnAction)new GoUpAction(this, coverageViewTreeStructure));
        if (coverageViewTreeStructure.supportFlattenPackages()) {
            defaultActionGroup.add((AnAction)new FlattenPackagesAction(this));
        }
        this.b(defaultActionGroup);
        this.a(defaultActionGroup);
        defaultActionGroup.add(ActionManager.getInstance().getAction("GenerateCoverageReport"));
        return defaultActionGroup;
    }

    private void a(DefaultActionGroup defaultActionGroup) {
        MyAutoScrollFromSourceHandler myAutoScrollFromSourceHandler = new MyAutoScrollFromSourceHandler();
        myAutoScrollFromSourceHandler.install();
        defaultActionGroup.add((AnAction)myAutoScrollFromSourceHandler.createToggleAction());
    }

    private void b(DefaultActionGroup defaultActionGroup) {
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return ((CoverageView)CoverageView.this).a.myAutoScrollToSource;
            }

            protected void setAutoScrollMode(boolean state2) {
                ((CoverageView)CoverageView.this).a.myAutoScrollToSource = state2;
            }
        };
        autoScrollToSourceHandler.install((JTable)this.c);
        defaultActionGroup.add((AnAction)autoScrollToSourceHandler.createToggleAction());
    }

    public void goUp() {
        if (this.g == null) {
            return;
        }
        this.g.goUp();
    }

    private void c(CoverageViewTreeStructure coverageViewTreeStructure) {
        AbstractTreeNode abstractTreeNode = this.b();
        if (abstractTreeNode == null) {
            return;
        }
        if (coverageViewTreeStructure.getChildElements(abstractTreeNode).length == 0) {
            if (abstractTreeNode.canNavigate()) {
                abstractTreeNode.navigate(true);
            }
            return;
        }
        this.g.drillDown();
    }

    public void updateParentTitle() {
        this.g.updateParentTitle();
    }

    private AbstractTreeNode b() {
        return (AbstractTreeNode)this.g.getSelectedValue();
    }

    private boolean a(CoverageViewTreeStructure coverageViewTreeStructure) {
        if (this.c == null) {
            return false;
        }
        if (this.b.getSize() >= 1) {
            AbstractTreeNode abstractTreeNode = (AbstractTreeNode)coverageViewTreeStructure.getRootElement();
            AbstractTreeNode abstractTreeNode2 = (AbstractTreeNode)this.b.getElementAt(0);
            if (abstractTreeNode2.getParent() == abstractTreeNode) {
                return true;
            }
        }
        return false;
    }

    public boolean canSelect(VirtualFile file) {
        return this.g.canSelect(file);
    }

    public void select(VirtualFile file) {
        this.g.select(file);
    }

    public Object getData(@NotNull @NonNls String dataId) {
        long l2 = h ^ 0x470CF56BDCD8L;
        if (dataId == null) {
            CoverageView.a(0);
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.b();
        }
        if (PlatformDataKeys.HELP_ID.is(dataId)) {
            return HELP_ID;
        }
        return null;
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = h ^ 0x1A566F5A1612L;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataId", "com/intellij/coverage/view/CoverageView", "getData"));
    }

    private class MyAutoScrollFromSourceHandler
    extends AutoScrollFromSourceHandler {
        private static final long a = com.jetbrains.python.psi.c.a(-1686371107059284248L, -8286171128974449322L, MethodHandles.lookup().lookupClass()).a(234334527683053L);

        MyAutoScrollFromSourceHandler() {
            super(CoverageView.this.f, (JComponent)((Object)CoverageView.this), (Disposable)CoverageView.this);
        }

        protected boolean isAutoScrollEnabled() {
            return ((CoverageView)CoverageView.this).a.myAutoScrollFromSource;
        }

        protected void setAutoScrollEnabled(boolean state2) {
            ((CoverageView)CoverageView.this).a.myAutoScrollFromSource = state2;
        }

        protected void selectElementFromEditor(@NotNull FileEditor editor2) {
            VirtualFile virtualFile;
            if (editor2 == null) {
                MyAutoScrollFromSourceHandler.a(0);
            }
            if (this.myProject.isDisposed() || !CoverageView.this.isShowing()) {
                return;
            }
            if (((CoverageView)CoverageView.this).a.myAutoScrollFromSource && (virtualFile = FileEditorManagerEx.getInstanceEx((Project)this.myProject).getFile(editor2)) != null && CoverageView.this.canSelect(virtualFile)) {
                VirtualFile virtualFile2 = null;
                if (editor2 instanceof TextEditor) {
                    int n2 = ((TextEditor)editor2).getEditor().getCaretModel().getOffset();
                    PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
                    PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(virtualFile);
                    if (psiFile != null) {
                        virtualFile2 = psiFile.findElementAt(n2);
                    }
                }
                CoverageView.this.g.select(virtualFile2 != null ? virtualFile2 : virtualFile);
            }
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x2AE69D2889BFL;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/coverage/view/CoverageView$MyAutoScrollFromSourceHandler", "selectElementFromEditor"));
        }
    }

    private class GoUpAction
    extends DumbAwareAction {
        private final CoverageViewTreeStructure a;
        final /* synthetic */ CoverageView this$0;
        private static final long b = com.jetbrains.python.psi.c.a(1994586904609895329L, -4609936900790657184L, MethodHandles.lookup().lookupClass()).a(208627784644914L);

        GoUpAction(CoverageView coverageView, CoverageViewTreeStructure treeStructure) {
            long l2 = b ^ 0x103D64BE27C4L;
            this.this$0 = coverageView;
            super("Go Up", "Go to Upper Level", AllIcons.Nodes.UpLevel);
            this.a = treeStructure;
            this.registerCustomShortcutSet(8, 0, (JComponent)coverageView.c);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                GoUpAction.a(0);
            }
            this.this$0.goUp();
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                GoUpAction.a(1);
            }
            e10.getPresentation().setEnabled(!this.this$0.a(this.a));
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = b ^ 0x6823FC296F40L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/view/CoverageView$GoUpAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FlattenPackagesAction
    extends ToggleAction {
        final /* synthetic */ CoverageView this$0;
        private static final long a = com.jetbrains.python.psi.c.a(-4680436344784693171L, 4714441195900783979L, MethodHandles.lookup().lookupClass()).a(245091290881692L);

        private FlattenPackagesAction(CoverageView coverageView) {
            long l2 = a ^ 0x656A0BFFBBFAL;
            this.this$0 = coverageView;
            super("Flatten Packages", "Flatten Packages", AllIcons.ObjectBrowser.FlattenPackages);
        }

        public boolean isSelected(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                FlattenPackagesAction.a(0);
            }
            return ((CoverageView)this.this$0).a.myFlattenPackages;
        }

        public void setSelected(@NotNull AnActionEvent e10, boolean state2) {
            if (e10 == null) {
                FlattenPackagesAction.a(1);
            }
            ((CoverageView)this.this$0).a.myFlattenPackages = state2;
            Object object = this.this$0.g.getSelectedValue();
            this.this$0.g.buildRoot();
            if (object != null) {
                this.this$0.g.select(((CoverageListNode)((Object)object)).getValue());
            }
            this.this$0.g.ensureSelectionExist();
            this.this$0.g.updateParentTitle();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x34EA802F839FL;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/coverage/view/CoverageView$FlattenPackagesAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isSelected";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSelected";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class NodeDescriptorTableCellRenderer
    extends DefaultTableCellRenderer {
        private NodeDescriptorTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof NodeDescriptor) {
                NodeDescriptor nodeDescriptor = (NodeDescriptor)value;
                this.setIcon(nodeDescriptor.getIcon());
                this.setText(nodeDescriptor.toString());
                if (!isSelected) {
                    this.setForeground(((CoverageListNode)nodeDescriptor).getFileStatus().getColor());
                }
            }
            return component;
        }
    }
}

