/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.CoverageDataManager;
import com.intellij.coverage.CoverageFileProvider;
import com.intellij.coverage.CoverageRunner;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.DefaultCoverageFileProvider;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.rt.coverage.data.ProjectData;
import com.jetbrains.python.psi.c;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.lang.ref.SoftReference;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseCoverageSuite
implements CoverageSuite,
JDOMExternalizable {
    private static final Logger q;
    @NonNls
    private static final String k = "FILE_PATH";
    @NonNls
    private static final String p = "SOURCE_PROVIDER";
    @NonNls
    private static final String c = "MODIFIED";
    @NonNls
    private static final String r = "NAME";
    @NonNls
    private static final String a = "RUNNER";
    @NonNls
    private static final String l = "COVERAGE_BY_TEST_ENABLED";
    @NonNls
    private static final String e = "COVERAGE_TRACING_ENABLED";
    private SoftReference<ProjectData> n = new SoftReference<Object>(null);
    private String o;
    private long g;
    private boolean f;
    private CoverageRunner b;
    private CoverageFileProvider m;
    private boolean d;
    private boolean i;
    private Project h;
    private RunConfigurationBase j;
    private static final long v;

    protected BaseCoverageSuite() {
    }

    public BaseCoverageSuite(String name, @Nullable CoverageFileProvider fileProvider, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, CoverageRunner coverageRunner) {
        this(name, fileProvider, lastCoverageTimeStamp, coverageByTestEnabled, tracingEnabled, trackTestFolders, coverageRunner, null);
    }

    public BaseCoverageSuite(String name, @Nullable CoverageFileProvider fileProvider, long lastCoverageTimeStamp, boolean coverageByTestEnabled, boolean tracingEnabled, boolean trackTestFolders, CoverageRunner coverageRunner, Project project) {
        this.m = fileProvider;
        this.o = name;
        this.g = lastCoverageTimeStamp;
        this.f = coverageByTestEnabled;
        this.d = trackTestFolders;
        this.i = tracingEnabled;
        this.b = coverageRunner;
        this.h = project;
    }

    @Nullable
    public static CoverageRunner readRunnerAttribute(Element element) {
        long l2 = v ^ 0x5AA65D616A67L;
        String string = element.getAttributeValue(a);
        if (string != null) {
            for (CoverageRunner coverageRunner : CoverageRunner.EP_NAME.getExtensionList()) {
                if (!Comparing.strEqual((String)coverageRunner.getId(), (String)string)) continue;
                return coverageRunner;
            }
        }
        return null;
    }

    public static CoverageFileProvider readDataFileProviderAttribute(Element element) {
        long l2 = v ^ 0x1662692E2061L;
        String string = element.getAttributeValue(p);
        String string2 = FileUtil.toSystemDependentName((String)element.getAttributeValue(k));
        File file = new File(string2);
        return new DefaultCoverageFileProvider(file.exists() ? file : new File(PathManager.getSystemPath(), string2), string != null ? string : DefaultCoverageFileProvider.class.getName());
    }

    @Override
    public boolean isValid() {
        return this.m.isValid();
    }

    @Override
    @NotNull
    public String getCoverageDataFileName() {
        String string = this.m.getCoverageDataFilePath();
        if (string == null) {
            BaseCoverageSuite.a(0);
        }
        return string;
    }

    @Override
    @NotNull
    public CoverageFileProvider getCoverageDataFileProvider() {
        CoverageFileProvider coverageFileProvider = this.m;
        if (coverageFileProvider == null) {
            BaseCoverageSuite.a(1);
        }
        return coverageFileProvider;
    }

    @Override
    public String getPresentableName() {
        return this.o;
    }

    @Override
    public long getLastCoverageTimeStamp() {
        return this.g;
    }

    @Override
    public boolean isTrackTestFolders() {
        return this.d;
    }

    @Override
    public boolean isTracingEnabled() {
        return this.i;
    }

    public void readExternal(Element element) throws InvalidDataException {
        long l2 = v ^ 0x657F1D22377EL;
        this.m = BaseCoverageSuite.readDataFileProviderAttribute(element);
        this.o = element.getAttributeValue(r);
        if (this.o == null) {
            this.o = this.a();
        }
        this.g = Long.parseLong(element.getAttributeValue(c));
        this.b = BaseCoverageSuite.readRunnerAttribute(element);
        String string = element.getAttributeValue(l);
        this.f = string != null && Boolean.valueOf(string) != false;
        String string2 = element.getAttributeValue(e);
        this.i = string2 != null && Boolean.valueOf(string2) != false;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        long l2 = v ^ 0x299FC176517BL;
        String string = FileUtil.getRelativePath((File)new File(PathManager.getSystemPath()), (File)new File(this.m.getCoverageDataFilePath()));
        element.setAttribute(k, string != null ? FileUtil.toSystemIndependentName((String)string) : this.m.getCoverageDataFilePath());
        element.setAttribute(r, this.o);
        element.setAttribute(c, String.valueOf(this.g));
        element.setAttribute(p, this.m instanceof DefaultCoverageFileProvider ? ((DefaultCoverageFileProvider)this.m).getSourceProvider() : this.m.getClass().getName());
        if (this.getRunner() != null) {
            element.setAttribute(a, this.b.getId());
        }
        element.setAttribute(l, String.valueOf(this.f));
        element.setAttribute(e, String.valueOf(this.i));
    }

    @Override
    public void setCoverageData(ProjectData projectData) {
        this.n = new SoftReference<ProjectData>(projectData);
    }

    public ProjectData getCoverageData() {
        return this.n.get();
    }

    @Override
    public void restoreCoverageData() {
        this.setCoverageData(this.loadProjectInfo());
    }

    @Override
    public boolean isCoverageByTestApplicable() {
        return this.getRunner().isCoverageByTestApplicable();
    }

    @Override
    public boolean isCoverageByTestEnabled() {
        return this.f;
    }

    @Override
    @Nullable
    public ProjectData getCoverageData(CoverageDataManager coverageDataManager) {
        ProjectData projectData = this.getCoverageData();
        if (projectData != null) {
            return projectData;
        }
        ProjectData projectData2 = this.loadProjectInfo();
        this.setCoverageData(projectData2);
        return projectData2;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        String string = this.m.getCoverageDataFilePath();
        String string2 = ((BaseCoverageSuite)o2).m.getCoverageDataFilePath();
        return string.equals(string2);
    }

    public int hashCode() {
        return this.m.getCoverageDataFilePath().hashCode();
    }

    @Nullable
    protected ProjectData loadProjectInfo() {
        long l2 = v ^ 0x5E6B94D85B41L;
        String string = this.getCoverageDataFileName();
        File file = new File(string);
        if (!file.exists()) {
            if (q.isDebugEnabled()) {
                q.debug("Nonexistent file given +" + string);
            }
            return null;
        }
        return this.b.loadCoverageData(file, this);
    }

    @Override
    public CoverageRunner getRunner() {
        return this.b;
    }

    protected void setRunner(CoverageRunner runner) {
        this.b = runner;
    }

    private String a() {
        String string = this.m.getCoverageDataFilePath();
        int n2 = string.lastIndexOf(File.separatorChar);
        if (n2 >= 0) {
            string = string.substring(n2 + 1);
        }
        if ((n2 = string.lastIndexOf(46)) >= 0) {
            string = string.substring(0, n2);
        }
        return string;
    }

    @Override
    public Project getProject() {
        return this.h;
    }

    public void setProject(Project project) {
        this.h = project;
    }

    public void setConfiguration(RunConfigurationBase configuration) {
        this.j = configuration;
    }

    @Nullable
    public RunConfigurationBase getConfiguration() {
        return this.j;
    }

    static {
        v = com.jetbrains.python.psi.c.a(-2410727958216060177L, 5776688244525444068L, MethodHandles.lookup().lookupClass()).a(57355584159931L);
        q = Logger.getInstance((String)BaseCoverageSuite.class.getName());
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        long l2 = v ^ 0x688377C21035L;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/coverage/BaseCoverageSuite";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageDataFileName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCoverageDataFileProvider";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

