/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.view;

import com.intellij.docker.vfs.DockerFileSystem;
import com.intellij.ide.navigationToolbar.AbstractNavBarModelExtension;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import icons.DockerIcons;
import java.util.function.BiFunction;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DockerNavBarModelExtension
extends AbstractNavBarModelExtension {
    @Nullable
    public String getPresentableText(Object object) {
        return DockerNavBarModelExtension.processContainerRoot(object, (dockerFileSystem, file2) -> dockerFileSystem.getSanitizedContainerName());
    }

    @Nullable
    public Icon getIcon(Object object) {
        return DockerNavBarModelExtension.processContainerRoot(object, (dockerFileSystem, file2) -> DockerIcons.SingleRunningContainer);
    }

    @Nullable
    private static <T> T processContainerRoot(@Nullable Object object, @NotNull BiFunction<DockerFileSystem, VirtualFile, T> getter) {
        if (getter == null) {
            DockerNavBarModelExtension.$$$reportNull$$$0(0);
        }
        if (!(object instanceof PsiDirectory)) {
            return null;
        }
        VirtualFile file2 = PsiUtilCore.getVirtualFile((PsiElement)((PsiElement)object));
        if (file2 == null || !file2.isValid()) {
            return null;
        }
        VirtualFileSystem fileSystem = file2.getFileSystem();
        if (!(fileSystem instanceof DockerFileSystem)) {
            return null;
        }
        DockerFileSystem dockerFileSystem = (DockerFileSystem)fileSystem;
        if (!"/".equals(dockerFileSystem.getPathInsideContainer(file2))) {
            return null;
        }
        return getter.apply(dockerFileSystem, file2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "getter", "com/intellij/docker/view/DockerNavBarModelExtension", "processContainerRoot"));
    }
}

